/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessActivityLogEvent
extends APINode {
    @SerializedName(value="acted_upon_business_id")
    private String mActedUponBusinessId = null;
    @SerializedName(value="acted_upon_business_name")
    private String mActedUponBusinessName = null;
    @SerializedName(value="acted_upon_business_object_id")
    private String mActedUponBusinessObjectId = null;
    @SerializedName(value="acted_upon_business_object_name")
    private String mActedUponBusinessObjectName = null;
    @SerializedName(value="acted_upon_business_object_type")
    private String mActedUponBusinessObjectType = null;
    @SerializedName(value="acted_upon_user_id")
    private String mActedUponUserId = null;
    @SerializedName(value="acted_upon_user_name")
    private String mActedUponUserName = null;
    @SerializedName(value="acting_business_id")
    private String mActingBusinessId = null;
    @SerializedName(value="acting_business_name")
    private String mActingBusinessName = null;
    @SerializedName(value="acting_user_id")
    private String mActingUserId = null;
    @SerializedName(value="acting_user_name")
    private String mActingUserName = null;
    @SerializedName(value="event_time")
    private Long mEventTime = null;
    @SerializedName(value="event_type")
    private String mEventType = null;
    @SerializedName(value="extra_data")
    private List<Object> mExtraData = null;
    @SerializedName(value="target_business_id")
    private String mTargetBusinessId = null;
    @SerializedName(value="target_business_name")
    private String mTargetBusinessName = null;
    @SerializedName(value="target_business_object_id")
    private String mTargetBusinessObjectId = null;
    @SerializedName(value="target_business_object_name")
    private String mTargetBusinessObjectName = null;
    @SerializedName(value="target_business_object_type")
    private String mTargetBusinessObjectType = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    BusinessActivityLogEvent() {
    }

    public BusinessActivityLogEvent(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessActivityLogEvent(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessActivityLogEvent fetch() throws APIException {
        BusinessActivityLogEvent newInstance = BusinessActivityLogEvent.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessActivityLogEvent fetchById(Long id, APIContext context) throws APIException {
        return BusinessActivityLogEvent.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessActivityLogEvent> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessActivityLogEvent.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessActivityLogEvent fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BusinessActivityLogEvent> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BusinessActivityLogEvent> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessActivityLogEvent>(context, "", "/", "GET", BusinessActivityLogEvent.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessActivityLogEvent>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BusinessActivityLogEvent>(context, "", "/", "GET", BusinessActivityLogEvent.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessActivityLogEvent loadJSON(String json, APIContext context) {
        BusinessActivityLogEvent businessActivityLogEvent = (BusinessActivityLogEvent)BusinessActivityLogEvent.getGson().fromJson(json, BusinessActivityLogEvent.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessActivityLogEvent.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessActivityLogEvent.context = context;
        businessActivityLogEvent.rawValue = json;
        return businessActivityLogEvent;
    }

    public static APINodeList<BusinessActivityLogEvent> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessActivityLogEvent> businessActivityLogEvents = new APINodeList<BusinessActivityLogEvent>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return businessActivityLogEvents;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessActivityLogEvents.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessActivityLogEvents.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessActivityLogEvents.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(obj.toString(), context));
                        }
                    }
                    return businessActivityLogEvents;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return businessActivityLogEvents;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessActivityLogEvents;
                }
                businessActivityLogEvents.clear();
                businessActivityLogEvents.add(BusinessActivityLogEvent.loadJSON(json, context));
                return businessActivityLogEvents;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessActivityLogEvent.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldActedUponBusinessId() {
        return this.mActedUponBusinessId;
    }

    public String getFieldActedUponBusinessName() {
        return this.mActedUponBusinessName;
    }

    public String getFieldActedUponBusinessObjectId() {
        return this.mActedUponBusinessObjectId;
    }

    public String getFieldActedUponBusinessObjectName() {
        return this.mActedUponBusinessObjectName;
    }

    public String getFieldActedUponBusinessObjectType() {
        return this.mActedUponBusinessObjectType;
    }

    public String getFieldActedUponUserId() {
        return this.mActedUponUserId;
    }

    public String getFieldActedUponUserName() {
        return this.mActedUponUserName;
    }

    public String getFieldActingBusinessId() {
        return this.mActingBusinessId;
    }

    public String getFieldActingBusinessName() {
        return this.mActingBusinessName;
    }

    public String getFieldActingUserId() {
        return this.mActingUserId;
    }

    public String getFieldActingUserName() {
        return this.mActingUserName;
    }

    public Long getFieldEventTime() {
        return this.mEventTime;
    }

    public String getFieldEventType() {
        return this.mEventType;
    }

    public List<Object> getFieldExtraData() {
        return this.mExtraData;
    }

    public String getFieldTargetBusinessId() {
        return this.mTargetBusinessId;
    }

    public String getFieldTargetBusinessName() {
        return this.mTargetBusinessName;
    }

    public String getFieldTargetBusinessObjectId() {
        return this.mTargetBusinessObjectId;
    }

    public String getFieldTargetBusinessObjectName() {
        return this.mTargetBusinessObjectName;
    }

    public String getFieldTargetBusinessObjectType() {
        return this.mTargetBusinessObjectType;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessActivityLogEvent copyFrom(BusinessActivityLogEvent instance) {
        this.mActedUponBusinessId = instance.mActedUponBusinessId;
        this.mActedUponBusinessName = instance.mActedUponBusinessName;
        this.mActedUponBusinessObjectId = instance.mActedUponBusinessObjectId;
        this.mActedUponBusinessObjectName = instance.mActedUponBusinessObjectName;
        this.mActedUponBusinessObjectType = instance.mActedUponBusinessObjectType;
        this.mActedUponUserId = instance.mActedUponUserId;
        this.mActedUponUserName = instance.mActedUponUserName;
        this.mActingBusinessId = instance.mActingBusinessId;
        this.mActingBusinessName = instance.mActingBusinessName;
        this.mActingUserId = instance.mActingUserId;
        this.mActingUserName = instance.mActingUserName;
        this.mEventTime = instance.mEventTime;
        this.mEventType = instance.mEventType;
        this.mExtraData = instance.mExtraData;
        this.mTargetBusinessId = instance.mTargetBusinessId;
        this.mTargetBusinessName = instance.mTargetBusinessName;
        this.mTargetBusinessObjectId = instance.mTargetBusinessObjectId;
        this.mTargetBusinessObjectName = instance.mTargetBusinessObjectName;
        this.mTargetBusinessObjectType = instance.mTargetBusinessObjectType;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessActivityLogEvent> getParser() {
        return new APIRequest.ResponseParser<BusinessActivityLogEvent>(){

            @Override
            public APINodeList<BusinessActivityLogEvent> parseResponse(String response, APIContext context, APIRequest<BusinessActivityLogEvent> request) throws APIException.MalformedResponseException {
                return BusinessActivityLogEvent.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<BusinessActivityLogEvent> {
        BusinessActivityLogEvent lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"acted_upon_business_id", "acted_upon_business_name", "acted_upon_business_object_id", "acted_upon_business_object_name", "acted_upon_business_object_type", "acted_upon_user_id", "acted_upon_user_name", "acting_business_id", "acting_business_name", "acting_user_id", "acting_user_name", "event_time", "event_type", "extra_data", "target_business_id", "target_business_name", "target_business_object_id", "target_business_object_name", "target_business_object_type", "id"};

        @Override
        public BusinessActivityLogEvent getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessActivityLogEvent parseResponse(String response) throws APIException {
            return BusinessActivityLogEvent.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public BusinessActivityLogEvent execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessActivityLogEvent execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<BusinessActivityLogEvent> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessActivityLogEvent> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, BusinessActivityLogEvent>(){

                public BusinessActivityLogEvent apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestActedUponBusinessIdField() {
            return this.requestActedUponBusinessIdField(true);
        }

        public APIRequestGet requestActedUponBusinessIdField(boolean value) {
            this.requestField("acted_upon_business_id", value);
            return this;
        }

        public APIRequestGet requestActedUponBusinessNameField() {
            return this.requestActedUponBusinessNameField(true);
        }

        public APIRequestGet requestActedUponBusinessNameField(boolean value) {
            this.requestField("acted_upon_business_name", value);
            return this;
        }

        public APIRequestGet requestActedUponBusinessObjectIdField() {
            return this.requestActedUponBusinessObjectIdField(true);
        }

        public APIRequestGet requestActedUponBusinessObjectIdField(boolean value) {
            this.requestField("acted_upon_business_object_id", value);
            return this;
        }

        public APIRequestGet requestActedUponBusinessObjectNameField() {
            return this.requestActedUponBusinessObjectNameField(true);
        }

        public APIRequestGet requestActedUponBusinessObjectNameField(boolean value) {
            this.requestField("acted_upon_business_object_name", value);
            return this;
        }

        public APIRequestGet requestActedUponBusinessObjectTypeField() {
            return this.requestActedUponBusinessObjectTypeField(true);
        }

        public APIRequestGet requestActedUponBusinessObjectTypeField(boolean value) {
            this.requestField("acted_upon_business_object_type", value);
            return this;
        }

        public APIRequestGet requestActedUponUserIdField() {
            return this.requestActedUponUserIdField(true);
        }

        public APIRequestGet requestActedUponUserIdField(boolean value) {
            this.requestField("acted_upon_user_id", value);
            return this;
        }

        public APIRequestGet requestActedUponUserNameField() {
            return this.requestActedUponUserNameField(true);
        }

        public APIRequestGet requestActedUponUserNameField(boolean value) {
            this.requestField("acted_upon_user_name", value);
            return this;
        }

        public APIRequestGet requestActingBusinessIdField() {
            return this.requestActingBusinessIdField(true);
        }

        public APIRequestGet requestActingBusinessIdField(boolean value) {
            this.requestField("acting_business_id", value);
            return this;
        }

        public APIRequestGet requestActingBusinessNameField() {
            return this.requestActingBusinessNameField(true);
        }

        public APIRequestGet requestActingBusinessNameField(boolean value) {
            this.requestField("acting_business_name", value);
            return this;
        }

        public APIRequestGet requestActingUserIdField() {
            return this.requestActingUserIdField(true);
        }

        public APIRequestGet requestActingUserIdField(boolean value) {
            this.requestField("acting_user_id", value);
            return this;
        }

        public APIRequestGet requestActingUserNameField() {
            return this.requestActingUserNameField(true);
        }

        public APIRequestGet requestActingUserNameField(boolean value) {
            this.requestField("acting_user_name", value);
            return this;
        }

        public APIRequestGet requestEventTimeField() {
            return this.requestEventTimeField(true);
        }

        public APIRequestGet requestEventTimeField(boolean value) {
            this.requestField("event_time", value);
            return this;
        }

        public APIRequestGet requestEventTypeField() {
            return this.requestEventTypeField(true);
        }

        public APIRequestGet requestEventTypeField(boolean value) {
            this.requestField("event_type", value);
            return this;
        }

        public APIRequestGet requestExtraDataField() {
            return this.requestExtraDataField(true);
        }

        public APIRequestGet requestExtraDataField(boolean value) {
            this.requestField("extra_data", value);
            return this;
        }

        public APIRequestGet requestTargetBusinessIdField() {
            return this.requestTargetBusinessIdField(true);
        }

        public APIRequestGet requestTargetBusinessIdField(boolean value) {
            this.requestField("target_business_id", value);
            return this;
        }

        public APIRequestGet requestTargetBusinessNameField() {
            return this.requestTargetBusinessNameField(true);
        }

        public APIRequestGet requestTargetBusinessNameField(boolean value) {
            this.requestField("target_business_name", value);
            return this;
        }

        public APIRequestGet requestTargetBusinessObjectIdField() {
            return this.requestTargetBusinessObjectIdField(true);
        }

        public APIRequestGet requestTargetBusinessObjectIdField(boolean value) {
            this.requestField("target_business_object_id", value);
            return this;
        }

        public APIRequestGet requestTargetBusinessObjectNameField() {
            return this.requestTargetBusinessObjectNameField(true);
        }

        public APIRequestGet requestTargetBusinessObjectNameField(boolean value) {
            this.requestField("target_business_object_name", value);
            return this;
        }

        public APIRequestGet requestTargetBusinessObjectTypeField() {
            return this.requestTargetBusinessObjectTypeField(true);
        }

        public APIRequestGet requestTargetBusinessObjectTypeField(boolean value) {
            this.requestField("target_business_object_type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

