/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsSegments
extends APINode {
    @SerializedName(value="daily_audience_size")
    private Long mDailyAudienceSize = null;
    @SerializedName(value="daily_impressions")
    private Long mDailyImpressions = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="path")
    private List<String> mPath = null;
    @SerializedName(value="popularity")
    private Double mPopularity = null;
    @SerializedName(value="projected_cpm")
    private Long mProjectedCpm = null;
    @SerializedName(value="projected_daily_revenue")
    private Long mProjectedDailyRevenue = null;
    protected static Gson gson = null;

    AdsSegments() {
    }

    public AdsSegments(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsSegments(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsSegments fetch() throws APIException {
        AdsSegments newInstance = AdsSegments.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsSegments fetchById(Long id, APIContext context) throws APIException {
        return AdsSegments.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsSegments> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsSegments.fetchByIdAsync(id.toString(), context);
    }

    public static AdsSegments fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsSegments> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsSegments> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsSegments>(context, "", "/", "GET", AdsSegments.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsSegments>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsSegments>(context, "", "/", "GET", AdsSegments.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsSegments loadJSON(String json, APIContext context) {
        AdsSegments adsSegments = (AdsSegments)AdsSegments.getGson().fromJson(json, AdsSegments.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsSegments.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsSegments.context = context;
        adsSegments.rawValue = json;
        return adsSegments;
    }

    public static APINodeList<AdsSegments> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsSegments> adsSegmentss = new APINodeList<AdsSegments>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsSegmentss.add(AdsSegments.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adsSegmentss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsSegmentss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsSegmentss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsSegmentss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsSegmentss.add(AdsSegments.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsSegmentss.add(AdsSegments.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsSegmentss.add(AdsSegments.loadJSON(obj.toString(), context));
                        }
                    }
                    return adsSegmentss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsSegmentss.add(AdsSegments.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adsSegmentss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsSegmentss.add(AdsSegments.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsSegmentss;
                }
                adsSegmentss.clear();
                adsSegmentss.add(AdsSegments.loadJSON(json, context));
                return adsSegmentss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsSegments.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldDailyAudienceSize() {
        return this.mDailyAudienceSize;
    }

    public Long getFieldDailyImpressions() {
        return this.mDailyImpressions;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public List<String> getFieldPath() {
        return this.mPath;
    }

    public Double getFieldPopularity() {
        return this.mPopularity;
    }

    public Long getFieldProjectedCpm() {
        return this.mProjectedCpm;
    }

    public Long getFieldProjectedDailyRevenue() {
        return this.mProjectedDailyRevenue;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsSegments copyFrom(AdsSegments instance) {
        this.mDailyAudienceSize = instance.mDailyAudienceSize;
        this.mDailyImpressions = instance.mDailyImpressions;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPath = instance.mPath;
        this.mPopularity = instance.mPopularity;
        this.mProjectedCpm = instance.mProjectedCpm;
        this.mProjectedDailyRevenue = instance.mProjectedDailyRevenue;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsSegments> getParser() {
        return new APIRequest.ResponseParser<AdsSegments>(){

            @Override
            public APINodeList<AdsSegments> parseResponse(String response, APIContext context, APIRequest<AdsSegments> request) throws APIException.MalformedResponseException {
                return AdsSegments.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdsSegments> {
        AdsSegments lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"daily_audience_size", "daily_impressions", "description", "id", "name", "path", "popularity", "projected_cpm", "projected_daily_revenue"};

        @Override
        public AdsSegments getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsSegments parseResponse(String response) throws APIException {
            return AdsSegments.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdsSegments execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsSegments execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdsSegments> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsSegments> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdsSegments>(){

                public AdsSegments apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDailyAudienceSizeField() {
            return this.requestDailyAudienceSizeField(true);
        }

        public APIRequestGet requestDailyAudienceSizeField(boolean value) {
            this.requestField("daily_audience_size", value);
            return this;
        }

        public APIRequestGet requestDailyImpressionsField() {
            return this.requestDailyImpressionsField(true);
        }

        public APIRequestGet requestDailyImpressionsField(boolean value) {
            this.requestField("daily_impressions", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPathField() {
            return this.requestPathField(true);
        }

        public APIRequestGet requestPathField(boolean value) {
            this.requestField("path", value);
            return this;
        }

        public APIRequestGet requestPopularityField() {
            return this.requestPopularityField(true);
        }

        public APIRequestGet requestPopularityField(boolean value) {
            this.requestField("popularity", value);
            return this;
        }

        public APIRequestGet requestProjectedCpmField() {
            return this.requestProjectedCpmField(true);
        }

        public APIRequestGet requestProjectedCpmField(boolean value) {
            this.requestField("projected_cpm", value);
            return this;
        }

        public APIRequestGet requestProjectedDailyRevenueField() {
            return this.requestProjectedDailyRevenueField(true);
        }

        public APIRequestGet requestProjectedDailyRevenueField(boolean value) {
            this.requestField("projected_daily_revenue", value);
            return this;
        }
    }
}

