/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdsPixelStats;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsPixelStatsResult
extends APINode {
    @SerializedName(value="aggregation")
    private String mAggregation = null;
    @SerializedName(value="data")
    private List<AdsPixelStats> mData = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdsPixelStatsResult() {
    }

    public AdsPixelStatsResult(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsPixelStatsResult(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsPixelStatsResult fetch() throws APIException {
        AdsPixelStatsResult newInstance = AdsPixelStatsResult.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsPixelStatsResult fetchById(Long id, APIContext context) throws APIException {
        return AdsPixelStatsResult.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsPixelStatsResult> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsPixelStatsResult.fetchByIdAsync(id.toString(), context);
    }

    public static AdsPixelStatsResult fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsPixelStatsResult> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsPixelStatsResult> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsPixelStatsResult>(context, "", "/", "GET", AdsPixelStatsResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsPixelStatsResult>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsPixelStatsResult>(context, "", "/", "GET", AdsPixelStatsResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsPixelStatsResult loadJSON(String json, APIContext context) {
        AdsPixelStatsResult adsPixelStatsResult = (AdsPixelStatsResult)AdsPixelStatsResult.getGson().fromJson(json, AdsPixelStatsResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsPixelStatsResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsPixelStatsResult.context = context;
        adsPixelStatsResult.rawValue = json;
        return adsPixelStatsResult;
    }

    public static APINodeList<AdsPixelStatsResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsPixelStatsResult> adsPixelStatsResults = new APINodeList<AdsPixelStatsResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsPixelStatsResults.add(AdsPixelStatsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adsPixelStatsResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsPixelStatsResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsPixelStatsResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsPixelStatsResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsPixelStatsResults.add(AdsPixelStatsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsPixelStatsResults.add(AdsPixelStatsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsPixelStatsResults.add(AdsPixelStatsResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return adsPixelStatsResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsPixelStatsResults.add(AdsPixelStatsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adsPixelStatsResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsPixelStatsResults.add(AdsPixelStatsResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsPixelStatsResults;
                }
                adsPixelStatsResults.clear();
                adsPixelStatsResults.add(AdsPixelStatsResult.loadJSON(json, context));
                return adsPixelStatsResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsPixelStatsResult.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAggregation() {
        return this.mAggregation;
    }

    public List<AdsPixelStats> getFieldData() {
        return this.mData;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsPixelStatsResult copyFrom(AdsPixelStatsResult instance) {
        this.mAggregation = instance.mAggregation;
        this.mData = instance.mData;
        this.mStartTime = instance.mStartTime;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsPixelStatsResult> getParser() {
        return new APIRequest.ResponseParser<AdsPixelStatsResult>(){

            @Override
            public APINodeList<AdsPixelStatsResult> parseResponse(String response, APIContext context, APIRequest<AdsPixelStatsResult> request) throws APIException.MalformedResponseException {
                return AdsPixelStatsResult.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAggregation {
        VALUE_BROWSER_TYPE("browser_type"),
        VALUE_CUSTOM_DATA_FIELD("custom_data_field"),
        VALUE_DEVICE_OS("device_os"),
        VALUE_DEVICE_TYPE("device_type"),
        VALUE_EVENT("event"),
        VALUE_HOST("host"),
        VALUE_PEOPLE_REACHED("people_reached"),
        VALUE_PII_KEYS("pii_keys"),
        VALUE_PII_LIFT("pii_lift"),
        VALUE_PIXEL_FIRE("pixel_fire"),
        VALUE_EVENT_DETECTION_METHOD("event_detection_method"),
        VALUE_URL("url"),
        VALUE_EVENT_VALUE_COUNT("event_value_count"),
        VALUE_URL_BY_RULE("url_by_rule"),
        VALUE_EVENT_TOTAL_COUNTS("event_total_counts"),
        VALUE_EVENT_SOURCE("event_source"),
        NULL(null);

        private String value;

        private EnumAggregation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdsPixelStatsResult> {
        AdsPixelStatsResult lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"aggregation", "data", "start_time", "id"};

        @Override
        public AdsPixelStatsResult getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixelStatsResult parseResponse(String response) throws APIException {
            return AdsPixelStatsResult.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdsPixelStatsResult execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixelStatsResult execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixelStatsResult> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixelStatsResult> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdsPixelStatsResult>(){

                public AdsPixelStatsResult apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAggregationField() {
            return this.requestAggregationField(true);
        }

        public APIRequestGet requestAggregationField(boolean value) {
            this.requestField("aggregation", value);
            return this;
        }

        public APIRequestGet requestDataField() {
            return this.requestDataField(true);
        }

        public APIRequestGet requestDataField(boolean value) {
            this.requestField("data", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

