/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdRuleExecutionOptions;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdRuleExecutionSpec
extends APINode {
    @SerializedName(value="execution_options")
    private List<AdRuleExecutionOptions> mExecutionOptions = null;
    @SerializedName(value="execution_type")
    private EnumExecutionType mExecutionType = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdRuleExecutionSpec() {
    }

    public AdRuleExecutionSpec(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdRuleExecutionSpec(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdRuleExecutionSpec fetch() throws APIException {
        AdRuleExecutionSpec newInstance = AdRuleExecutionSpec.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdRuleExecutionSpec fetchById(Long id, APIContext context) throws APIException {
        return AdRuleExecutionSpec.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdRuleExecutionSpec> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdRuleExecutionSpec.fetchByIdAsync(id.toString(), context);
    }

    public static AdRuleExecutionSpec fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdRuleExecutionSpec> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdRuleExecutionSpec> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdRuleExecutionSpec>(context, "", "/", "GET", AdRuleExecutionSpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdRuleExecutionSpec>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdRuleExecutionSpec>(context, "", "/", "GET", AdRuleExecutionSpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdRuleExecutionSpec loadJSON(String json, APIContext context) {
        AdRuleExecutionSpec adRuleExecutionSpec = (AdRuleExecutionSpec)AdRuleExecutionSpec.getGson().fromJson(json, AdRuleExecutionSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRuleExecutionSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRuleExecutionSpec.context = context;
        adRuleExecutionSpec.rawValue = json;
        return adRuleExecutionSpec;
    }

    public static APINodeList<AdRuleExecutionSpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdRuleExecutionSpec> adRuleExecutionSpecs = new APINodeList<AdRuleExecutionSpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adRuleExecutionSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adRuleExecutionSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adRuleExecutionSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adRuleExecutionSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adRuleExecutionSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adRuleExecutionSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRuleExecutionSpecs;
                }
                adRuleExecutionSpecs.clear();
                adRuleExecutionSpecs.add(AdRuleExecutionSpec.loadJSON(json, context));
                return adRuleExecutionSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRuleExecutionSpec.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<AdRuleExecutionOptions> getFieldExecutionOptions() {
        return this.mExecutionOptions;
    }

    public EnumExecutionType getFieldExecutionType() {
        return this.mExecutionType;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRuleExecutionSpec copyFrom(AdRuleExecutionSpec instance) {
        this.mExecutionOptions = instance.mExecutionOptions;
        this.mExecutionType = instance.mExecutionType;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRuleExecutionSpec> getParser() {
        return new APIRequest.ResponseParser<AdRuleExecutionSpec>(){

            @Override
            public APINodeList<AdRuleExecutionSpec> parseResponse(String response, APIContext context, APIRequest<AdRuleExecutionSpec> request) throws APIException.MalformedResponseException {
                return AdRuleExecutionSpec.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumExecutionType {
        VALUE_PING_ENDPOINT("PING_ENDPOINT"),
        VALUE_NOTIFICATION("NOTIFICATION"),
        VALUE_PAUSE("PAUSE"),
        VALUE_REBALANCE_BUDGET("REBALANCE_BUDGET"),
        VALUE_CHANGE_BUDGET("CHANGE_BUDGET"),
        VALUE_CHANGE_BID("CHANGE_BID"),
        VALUE_ROTATE("ROTATE"),
        VALUE_UNPAUSE("UNPAUSE"),
        NULL(null);

        private String value;

        private EnumExecutionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdRuleExecutionSpec> {
        AdRuleExecutionSpec lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"execution_options", "execution_type", "id"};

        @Override
        public AdRuleExecutionSpec getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdRuleExecutionSpec parseResponse(String response) throws APIException {
            return AdRuleExecutionSpec.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdRuleExecutionSpec execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdRuleExecutionSpec execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdRuleExecutionSpec> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdRuleExecutionSpec> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdRuleExecutionSpec>(){

                public AdRuleExecutionSpec apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestExecutionOptionsField() {
            return this.requestExecutionOptionsField(true);
        }

        public APIRequestGet requestExecutionOptionsField(boolean value) {
            this.requestField("execution_options", value);
            return this;
        }

        public APIRequestGet requestExecutionTypeField() {
            return this.requestExecutionTypeField(true);
        }

        public APIRequestGet requestExecutionTypeField(boolean value) {
            this.requestField("execution_type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

