/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeLinkData;
import com.facebook.ads.sdk.AdCreativePhotoData;
import com.facebook.ads.sdk.AdCreativeTextData;
import com.facebook.ads.sdk.AdCreativeVideoData;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeObjectStorySpec
extends APINode {
    @SerializedName(value="instagram_actor_id")
    private String mInstagramActorId = null;
    @SerializedName(value="link_data")
    private AdCreativeLinkData mLinkData = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="photo_data")
    private AdCreativePhotoData mPhotoData = null;
    @SerializedName(value="template_data")
    private AdCreativeLinkData mTemplateData = null;
    @SerializedName(value="text_data")
    private AdCreativeTextData mTextData = null;
    @SerializedName(value="video_data")
    private AdCreativeVideoData mVideoData = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    public AdCreativeObjectStorySpec() {
    }

    public AdCreativeObjectStorySpec(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativeObjectStorySpec(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativeObjectStorySpec fetch() throws APIException {
        AdCreativeObjectStorySpec newInstance = AdCreativeObjectStorySpec.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativeObjectStorySpec fetchById(Long id, APIContext context) throws APIException {
        return AdCreativeObjectStorySpec.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativeObjectStorySpec> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativeObjectStorySpec.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativeObjectStorySpec fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativeObjectStorySpec> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativeObjectStorySpec> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativeObjectStorySpec>(context, "", "/", "GET", AdCreativeObjectStorySpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativeObjectStorySpec>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativeObjectStorySpec>(context, "", "/", "GET", AdCreativeObjectStorySpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeObjectStorySpec loadJSON(String json, APIContext context) {
        AdCreativeObjectStorySpec adCreativeObjectStorySpec = (AdCreativeObjectStorySpec)AdCreativeObjectStorySpec.getGson().fromJson(json, AdCreativeObjectStorySpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeObjectStorySpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeObjectStorySpec.context = context;
        adCreativeObjectStorySpec.rawValue = json;
        return adCreativeObjectStorySpec;
    }

    public static APINodeList<AdCreativeObjectStorySpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeObjectStorySpec> adCreativeObjectStorySpecs = new APINodeList<AdCreativeObjectStorySpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeObjectStorySpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeObjectStorySpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeObjectStorySpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeObjectStorySpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeObjectStorySpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeObjectStorySpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeObjectStorySpecs;
                }
                adCreativeObjectStorySpecs.clear();
                adCreativeObjectStorySpecs.add(AdCreativeObjectStorySpec.loadJSON(json, context));
                return adCreativeObjectStorySpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeObjectStorySpec.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldInstagramActorId() {
        return this.mInstagramActorId;
    }

    public AdCreativeObjectStorySpec setFieldInstagramActorId(String value) {
        this.mInstagramActorId = value;
        return this;
    }

    public AdCreativeLinkData getFieldLinkData() {
        if (this.mLinkData != null) {
            this.mLinkData.context = this.getContext();
        }
        return this.mLinkData;
    }

    public AdCreativeObjectStorySpec setFieldLinkData(AdCreativeLinkData value) {
        this.mLinkData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldLinkData(String value) {
        Type type = new TypeToken<AdCreativeLinkData>(){}.getType();
        this.mLinkData = (AdCreativeLinkData)AdCreativeLinkData.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public AdCreativeObjectStorySpec setFieldPageId(String value) {
        this.mPageId = value;
        return this;
    }

    public AdCreativePhotoData getFieldPhotoData() {
        if (this.mPhotoData != null) {
            this.mPhotoData.context = this.getContext();
        }
        return this.mPhotoData;
    }

    public AdCreativeObjectStorySpec setFieldPhotoData(AdCreativePhotoData value) {
        this.mPhotoData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldPhotoData(String value) {
        Type type = new TypeToken<AdCreativePhotoData>(){}.getType();
        this.mPhotoData = (AdCreativePhotoData)AdCreativePhotoData.getGson().fromJson(value, type);
        return this;
    }

    public AdCreativeLinkData getFieldTemplateData() {
        if (this.mTemplateData != null) {
            this.mTemplateData.context = this.getContext();
        }
        return this.mTemplateData;
    }

    public AdCreativeObjectStorySpec setFieldTemplateData(AdCreativeLinkData value) {
        this.mTemplateData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldTemplateData(String value) {
        Type type = new TypeToken<AdCreativeLinkData>(){}.getType();
        this.mTemplateData = (AdCreativeLinkData)AdCreativeLinkData.getGson().fromJson(value, type);
        return this;
    }

    public AdCreativeTextData getFieldTextData() {
        if (this.mTextData != null) {
            this.mTextData.context = this.getContext();
        }
        return this.mTextData;
    }

    public AdCreativeObjectStorySpec setFieldTextData(AdCreativeTextData value) {
        this.mTextData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldTextData(String value) {
        Type type = new TypeToken<AdCreativeTextData>(){}.getType();
        this.mTextData = (AdCreativeTextData)AdCreativeTextData.getGson().fromJson(value, type);
        return this;
    }

    public AdCreativeVideoData getFieldVideoData() {
        if (this.mVideoData != null) {
            this.mVideoData.context = this.getContext();
        }
        return this.mVideoData;
    }

    public AdCreativeObjectStorySpec setFieldVideoData(AdCreativeVideoData value) {
        this.mVideoData = value;
        return this;
    }

    public AdCreativeObjectStorySpec setFieldVideoData(String value) {
        Type type = new TypeToken<AdCreativeVideoData>(){}.getType();
        this.mVideoData = (AdCreativeVideoData)AdCreativeVideoData.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdCreativeObjectStorySpec setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeObjectStorySpec copyFrom(AdCreativeObjectStorySpec instance) {
        this.mInstagramActorId = instance.mInstagramActorId;
        this.mLinkData = instance.mLinkData;
        this.mPageId = instance.mPageId;
        this.mPhotoData = instance.mPhotoData;
        this.mTemplateData = instance.mTemplateData;
        this.mTextData = instance.mTextData;
        this.mVideoData = instance.mVideoData;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeObjectStorySpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeObjectStorySpec>(){

            @Override
            public APINodeList<AdCreativeObjectStorySpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeObjectStorySpec> request) throws APIException.MalformedResponseException {
                return AdCreativeObjectStorySpec.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativeObjectStorySpec> {
        AdCreativeObjectStorySpec lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"instagram_actor_id", "link_data", "page_id", "photo_data", "template_data", "text_data", "video_data", "id"};

        @Override
        public AdCreativeObjectStorySpec getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativeObjectStorySpec parseResponse(String response) throws APIException {
            return AdCreativeObjectStorySpec.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativeObjectStorySpec execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativeObjectStorySpec execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativeObjectStorySpec> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativeObjectStorySpec> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativeObjectStorySpec>(){

                public AdCreativeObjectStorySpec apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestInstagramActorIdField() {
            return this.requestInstagramActorIdField(true);
        }

        public APIRequestGet requestInstagramActorIdField(boolean value) {
            this.requestField("instagram_actor_id", value);
            return this;
        }

        public APIRequestGet requestLinkDataField() {
            return this.requestLinkDataField(true);
        }

        public APIRequestGet requestLinkDataField(boolean value) {
            this.requestField("link_data", value);
            return this;
        }

        public APIRequestGet requestPageIdField() {
            return this.requestPageIdField(true);
        }

        public APIRequestGet requestPageIdField(boolean value) {
            this.requestField("page_id", value);
            return this;
        }

        public APIRequestGet requestPhotoDataField() {
            return this.requestPhotoDataField(true);
        }

        public APIRequestGet requestPhotoDataField(boolean value) {
            this.requestField("photo_data", value);
            return this;
        }

        public APIRequestGet requestTemplateDataField() {
            return this.requestTemplateDataField(true);
        }

        public APIRequestGet requestTemplateDataField(boolean value) {
            this.requestField("template_data", value);
            return this;
        }

        public APIRequestGet requestTextDataField() {
            return this.requestTextDataField(true);
        }

        public APIRequestGet requestTextDataField(boolean value) {
            this.requestField("text_data", value);
            return this;
        }

        public APIRequestGet requestVideoDataField() {
            return this.requestVideoDataField(true);
        }

        public APIRequestGet requestVideoDataField(boolean value) {
            this.requestField("video_data", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

