/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdsImageCrops;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeCollectionThumbnailInfo
extends APINode {
    @SerializedName(value="element_child_index")
    private Long mElementChildIndex = null;
    @SerializedName(value="element_crops")
    private AdsImageCrops mElementCrops = null;
    @SerializedName(value="element_id")
    private String mElementId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCreativeCollectionThumbnailInfo() {
    }

    public AdCreativeCollectionThumbnailInfo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativeCollectionThumbnailInfo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativeCollectionThumbnailInfo fetch() throws APIException {
        AdCreativeCollectionThumbnailInfo newInstance = AdCreativeCollectionThumbnailInfo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativeCollectionThumbnailInfo fetchById(Long id, APIContext context) throws APIException {
        return AdCreativeCollectionThumbnailInfo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativeCollectionThumbnailInfo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativeCollectionThumbnailInfo.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativeCollectionThumbnailInfo fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativeCollectionThumbnailInfo> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativeCollectionThumbnailInfo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativeCollectionThumbnailInfo>(context, "", "/", "GET", AdCreativeCollectionThumbnailInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativeCollectionThumbnailInfo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativeCollectionThumbnailInfo>(context, "", "/", "GET", AdCreativeCollectionThumbnailInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeCollectionThumbnailInfo loadJSON(String json, APIContext context) {
        AdCreativeCollectionThumbnailInfo adCreativeCollectionThumbnailInfo = (AdCreativeCollectionThumbnailInfo)AdCreativeCollectionThumbnailInfo.getGson().fromJson(json, AdCreativeCollectionThumbnailInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeCollectionThumbnailInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeCollectionThumbnailInfo.context = context;
        adCreativeCollectionThumbnailInfo.rawValue = json;
        return adCreativeCollectionThumbnailInfo;
    }

    public static APINodeList<AdCreativeCollectionThumbnailInfo> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeCollectionThumbnailInfo> adCreativeCollectionThumbnailInfos = new APINodeList<AdCreativeCollectionThumbnailInfo>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeCollectionThumbnailInfos.add(AdCreativeCollectionThumbnailInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeCollectionThumbnailInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeCollectionThumbnailInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeCollectionThumbnailInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeCollectionThumbnailInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeCollectionThumbnailInfos.add(AdCreativeCollectionThumbnailInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeCollectionThumbnailInfos.add(AdCreativeCollectionThumbnailInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeCollectionThumbnailInfos.add(AdCreativeCollectionThumbnailInfo.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeCollectionThumbnailInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeCollectionThumbnailInfos.add(AdCreativeCollectionThumbnailInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeCollectionThumbnailInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeCollectionThumbnailInfos.add(AdCreativeCollectionThumbnailInfo.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeCollectionThumbnailInfos;
                }
                adCreativeCollectionThumbnailInfos.clear();
                adCreativeCollectionThumbnailInfos.add(AdCreativeCollectionThumbnailInfo.loadJSON(json, context));
                return adCreativeCollectionThumbnailInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeCollectionThumbnailInfo.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldElementChildIndex() {
        return this.mElementChildIndex;
    }

    public AdsImageCrops getFieldElementCrops() {
        if (this.mElementCrops != null) {
            this.mElementCrops.context = this.getContext();
        }
        return this.mElementCrops;
    }

    public String getFieldElementId() {
        return this.mElementId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeCollectionThumbnailInfo copyFrom(AdCreativeCollectionThumbnailInfo instance) {
        this.mElementChildIndex = instance.mElementChildIndex;
        this.mElementCrops = instance.mElementCrops;
        this.mElementId = instance.mElementId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeCollectionThumbnailInfo> getParser() {
        return new APIRequest.ResponseParser<AdCreativeCollectionThumbnailInfo>(){

            @Override
            public APINodeList<AdCreativeCollectionThumbnailInfo> parseResponse(String response, APIContext context, APIRequest<AdCreativeCollectionThumbnailInfo> request) throws APIException.MalformedResponseException {
                return AdCreativeCollectionThumbnailInfo.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativeCollectionThumbnailInfo> {
        AdCreativeCollectionThumbnailInfo lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"element_child_index", "element_crops", "element_id", "id"};

        @Override
        public AdCreativeCollectionThumbnailInfo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativeCollectionThumbnailInfo parseResponse(String response) throws APIException {
            return AdCreativeCollectionThumbnailInfo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativeCollectionThumbnailInfo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativeCollectionThumbnailInfo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativeCollectionThumbnailInfo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativeCollectionThumbnailInfo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativeCollectionThumbnailInfo>(){

                public AdCreativeCollectionThumbnailInfo apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestElementChildIndexField() {
            return this.requestElementChildIndexField(true);
        }

        public APIRequestGet requestElementChildIndexField(boolean value) {
            this.requestField("element_child_index", value);
            return this;
        }

        public APIRequestGet requestElementCropsField() {
            return this.requestElementCropsField(true);
        }

        public APIRequestGet requestElementCropsField(boolean value) {
            this.requestField("element_crops", value);
            return this;
        }

        public APIRequestGet requestElementIdField() {
            return this.requestElementIdField(true);
        }

        public APIRequestGet requestElementIdField(boolean value) {
            this.requestField("element_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

