/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdContract
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="account_mgr_fbid")
    private String mAccountMgrFbid = null;
    @SerializedName(value="account_mgr_name")
    private String mAccountMgrName = null;
    @SerializedName(value="adops_person_name")
    private String mAdopsPersonName = null;
    @SerializedName(value="advertiser_address_fbid")
    private String mAdvertiserAddressFbid = null;
    @SerializedName(value="advertiser_fbid")
    private String mAdvertiserFbid = null;
    @SerializedName(value="advertiser_name")
    private String mAdvertiserName = null;
    @SerializedName(value="agency_discount")
    private Double mAgencyDiscount = null;
    @SerializedName(value="agency_name")
    private String mAgencyName = null;
    @SerializedName(value="bill_to_address_fbid")
    private String mBillToAddressFbid = null;
    @SerializedName(value="bill_to_fbid")
    private String mBillToFbid = null;
    @SerializedName(value="campaign_name")
    private String mCampaignName = null;
    @SerializedName(value="created_by")
    private String mCreatedBy = null;
    @SerializedName(value="created_date")
    private Long mCreatedDate = null;
    @SerializedName(value="customer_io")
    private String mCustomerIo = null;
    @SerializedName(value="io_number")
    private Long mIoNumber = null;
    @SerializedName(value="io_terms")
    private String mIoTerms = null;
    @SerializedName(value="io_type")
    private String mIoType = null;
    @SerializedName(value="last_updated_by")
    private String mLastUpdatedBy = null;
    @SerializedName(value="last_updated_date")
    private Long mLastUpdatedDate = null;
    @SerializedName(value="max_end_date")
    private Long mMaxEndDate = null;
    @SerializedName(value="mdc_fbid")
    private String mMdcFbid = null;
    @SerializedName(value="media_plan_number")
    private String mMediaPlanNumber = null;
    @SerializedName(value="min_start_date")
    private Long mMinStartDate = null;
    @SerializedName(value="msa_contract")
    private String mMsaContract = null;
    @SerializedName(value="payment_terms")
    private String mPaymentTerms = null;
    @SerializedName(value="rev_hold_flag")
    private Boolean mRevHoldFlag = null;
    @SerializedName(value="rev_hold_released_by")
    private Long mRevHoldReleasedBy = null;
    @SerializedName(value="rev_hold_released_on")
    private Long mRevHoldReleasedOn = null;
    @SerializedName(value="salesrep_fbid")
    private String mSalesrepFbid = null;
    @SerializedName(value="salesrep_name")
    private String mSalesrepName = null;
    @SerializedName(value="sold_to_address_fbid")
    private String mSoldToAddressFbid = null;
    @SerializedName(value="sold_to_fbid")
    private String mSoldToFbid = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="subvertical")
    private String mSubvertical = null;
    @SerializedName(value="thirdparty_billed")
    private Long mThirdpartyBilled = null;
    @SerializedName(value="thirdparty_password")
    private String mThirdpartyPassword = null;
    @SerializedName(value="thirdparty_uid")
    private String mThirdpartyUid = null;
    @SerializedName(value="thirdparty_url")
    private String mThirdpartyUrl = null;
    @SerializedName(value="vat_country")
    private String mVatCountry = null;
    @SerializedName(value="version")
    private Long mVersion = null;
    @SerializedName(value="vertical")
    private String mVertical = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdContract() {
    }

    public AdContract(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdContract(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdContract fetch() throws APIException {
        AdContract newInstance = AdContract.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdContract fetchById(Long id, APIContext context) throws APIException {
        return AdContract.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdContract> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdContract.fetchByIdAsync(id.toString(), context);
    }

    public static AdContract fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdContract> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdContract> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdContract>(context, "", "/", "GET", AdContract.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdContract>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdContract>(context, "", "/", "GET", AdContract.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdContract loadJSON(String json, APIContext context) {
        AdContract adContract = (AdContract)AdContract.getGson().fromJson(json, AdContract.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adContract.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adContract.context = context;
        adContract.rawValue = json;
        return adContract;
    }

    public static APINodeList<AdContract> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdContract> adContracts = new APINodeList<AdContract>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adContracts.add(AdContract.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adContracts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adContracts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adContracts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adContracts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adContracts.add(AdContract.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adContracts.add(AdContract.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adContracts.add(AdContract.loadJSON(obj.toString(), context));
                        }
                    }
                    return adContracts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adContracts.add(AdContract.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adContracts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adContracts.add(AdContract.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adContracts;
                }
                adContracts.clear();
                adContracts.add(AdContract.loadJSON(json, context));
                return adContracts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdContract.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public String getFieldAccountMgrFbid() {
        return this.mAccountMgrFbid;
    }

    public String getFieldAccountMgrName() {
        return this.mAccountMgrName;
    }

    public String getFieldAdopsPersonName() {
        return this.mAdopsPersonName;
    }

    public String getFieldAdvertiserAddressFbid() {
        return this.mAdvertiserAddressFbid;
    }

    public String getFieldAdvertiserFbid() {
        return this.mAdvertiserFbid;
    }

    public String getFieldAdvertiserName() {
        return this.mAdvertiserName;
    }

    public Double getFieldAgencyDiscount() {
        return this.mAgencyDiscount;
    }

    public String getFieldAgencyName() {
        return this.mAgencyName;
    }

    public String getFieldBillToAddressFbid() {
        return this.mBillToAddressFbid;
    }

    public String getFieldBillToFbid() {
        return this.mBillToFbid;
    }

    public String getFieldCampaignName() {
        return this.mCampaignName;
    }

    public String getFieldCreatedBy() {
        return this.mCreatedBy;
    }

    public Long getFieldCreatedDate() {
        return this.mCreatedDate;
    }

    public String getFieldCustomerIo() {
        return this.mCustomerIo;
    }

    public Long getFieldIoNumber() {
        return this.mIoNumber;
    }

    public String getFieldIoTerms() {
        return this.mIoTerms;
    }

    public String getFieldIoType() {
        return this.mIoType;
    }

    public String getFieldLastUpdatedBy() {
        return this.mLastUpdatedBy;
    }

    public Long getFieldLastUpdatedDate() {
        return this.mLastUpdatedDate;
    }

    public Long getFieldMaxEndDate() {
        return this.mMaxEndDate;
    }

    public String getFieldMdcFbid() {
        return this.mMdcFbid;
    }

    public String getFieldMediaPlanNumber() {
        return this.mMediaPlanNumber;
    }

    public Long getFieldMinStartDate() {
        return this.mMinStartDate;
    }

    public String getFieldMsaContract() {
        return this.mMsaContract;
    }

    public String getFieldPaymentTerms() {
        return this.mPaymentTerms;
    }

    public Boolean getFieldRevHoldFlag() {
        return this.mRevHoldFlag;
    }

    public Long getFieldRevHoldReleasedBy() {
        return this.mRevHoldReleasedBy;
    }

    public Long getFieldRevHoldReleasedOn() {
        return this.mRevHoldReleasedOn;
    }

    public String getFieldSalesrepFbid() {
        return this.mSalesrepFbid;
    }

    public String getFieldSalesrepName() {
        return this.mSalesrepName;
    }

    public String getFieldSoldToAddressFbid() {
        return this.mSoldToAddressFbid;
    }

    public String getFieldSoldToFbid() {
        return this.mSoldToFbid;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldSubvertical() {
        return this.mSubvertical;
    }

    public Long getFieldThirdpartyBilled() {
        return this.mThirdpartyBilled;
    }

    public String getFieldThirdpartyPassword() {
        return this.mThirdpartyPassword;
    }

    public String getFieldThirdpartyUid() {
        return this.mThirdpartyUid;
    }

    public String getFieldThirdpartyUrl() {
        return this.mThirdpartyUrl;
    }

    public String getFieldVatCountry() {
        return this.mVatCountry;
    }

    public Long getFieldVersion() {
        return this.mVersion;
    }

    public String getFieldVertical() {
        return this.mVertical;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdContract copyFrom(AdContract instance) {
        this.mAccountId = instance.mAccountId;
        this.mAccountMgrFbid = instance.mAccountMgrFbid;
        this.mAccountMgrName = instance.mAccountMgrName;
        this.mAdopsPersonName = instance.mAdopsPersonName;
        this.mAdvertiserAddressFbid = instance.mAdvertiserAddressFbid;
        this.mAdvertiserFbid = instance.mAdvertiserFbid;
        this.mAdvertiserName = instance.mAdvertiserName;
        this.mAgencyDiscount = instance.mAgencyDiscount;
        this.mAgencyName = instance.mAgencyName;
        this.mBillToAddressFbid = instance.mBillToAddressFbid;
        this.mBillToFbid = instance.mBillToFbid;
        this.mCampaignName = instance.mCampaignName;
        this.mCreatedBy = instance.mCreatedBy;
        this.mCreatedDate = instance.mCreatedDate;
        this.mCustomerIo = instance.mCustomerIo;
        this.mIoNumber = instance.mIoNumber;
        this.mIoTerms = instance.mIoTerms;
        this.mIoType = instance.mIoType;
        this.mLastUpdatedBy = instance.mLastUpdatedBy;
        this.mLastUpdatedDate = instance.mLastUpdatedDate;
        this.mMaxEndDate = instance.mMaxEndDate;
        this.mMdcFbid = instance.mMdcFbid;
        this.mMediaPlanNumber = instance.mMediaPlanNumber;
        this.mMinStartDate = instance.mMinStartDate;
        this.mMsaContract = instance.mMsaContract;
        this.mPaymentTerms = instance.mPaymentTerms;
        this.mRevHoldFlag = instance.mRevHoldFlag;
        this.mRevHoldReleasedBy = instance.mRevHoldReleasedBy;
        this.mRevHoldReleasedOn = instance.mRevHoldReleasedOn;
        this.mSalesrepFbid = instance.mSalesrepFbid;
        this.mSalesrepName = instance.mSalesrepName;
        this.mSoldToAddressFbid = instance.mSoldToAddressFbid;
        this.mSoldToFbid = instance.mSoldToFbid;
        this.mStatus = instance.mStatus;
        this.mSubvertical = instance.mSubvertical;
        this.mThirdpartyBilled = instance.mThirdpartyBilled;
        this.mThirdpartyPassword = instance.mThirdpartyPassword;
        this.mThirdpartyUid = instance.mThirdpartyUid;
        this.mThirdpartyUrl = instance.mThirdpartyUrl;
        this.mVatCountry = instance.mVatCountry;
        this.mVersion = instance.mVersion;
        this.mVertical = instance.mVertical;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdContract> getParser() {
        return new APIRequest.ResponseParser<AdContract>(){

            @Override
            public APINodeList<AdContract> parseResponse(String response, APIContext context, APIRequest<AdContract> request) throws APIException.MalformedResponseException {
                return AdContract.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdContract> {
        AdContract lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_mgr_fbid", "account_mgr_name", "adops_person_name", "advertiser_address_fbid", "advertiser_fbid", "advertiser_name", "agency_discount", "agency_name", "bill_to_address_fbid", "bill_to_fbid", "campaign_name", "created_by", "created_date", "customer_io", "io_number", "io_terms", "io_type", "last_updated_by", "last_updated_date", "max_end_date", "mdc_fbid", "media_plan_number", "min_start_date", "msa_contract", "payment_terms", "rev_hold_flag", "rev_hold_released_by", "rev_hold_released_on", "salesrep_fbid", "salesrep_name", "sold_to_address_fbid", "sold_to_fbid", "status", "subvertical", "thirdparty_billed", "thirdparty_password", "thirdparty_uid", "thirdparty_url", "vat_country", "version", "vertical", "id"};

        @Override
        public AdContract getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdContract parseResponse(String response) throws APIException {
            return AdContract.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdContract execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdContract execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdContract> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdContract> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdContract>(){

                public AdContract apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestAccountMgrFbidField() {
            return this.requestAccountMgrFbidField(true);
        }

        public APIRequestGet requestAccountMgrFbidField(boolean value) {
            this.requestField("account_mgr_fbid", value);
            return this;
        }

        public APIRequestGet requestAccountMgrNameField() {
            return this.requestAccountMgrNameField(true);
        }

        public APIRequestGet requestAccountMgrNameField(boolean value) {
            this.requestField("account_mgr_name", value);
            return this;
        }

        public APIRequestGet requestAdopsPersonNameField() {
            return this.requestAdopsPersonNameField(true);
        }

        public APIRequestGet requestAdopsPersonNameField(boolean value) {
            this.requestField("adops_person_name", value);
            return this;
        }

        public APIRequestGet requestAdvertiserAddressFbidField() {
            return this.requestAdvertiserAddressFbidField(true);
        }

        public APIRequestGet requestAdvertiserAddressFbidField(boolean value) {
            this.requestField("advertiser_address_fbid", value);
            return this;
        }

        public APIRequestGet requestAdvertiserFbidField() {
            return this.requestAdvertiserFbidField(true);
        }

        public APIRequestGet requestAdvertiserFbidField(boolean value) {
            this.requestField("advertiser_fbid", value);
            return this;
        }

        public APIRequestGet requestAdvertiserNameField() {
            return this.requestAdvertiserNameField(true);
        }

        public APIRequestGet requestAdvertiserNameField(boolean value) {
            this.requestField("advertiser_name", value);
            return this;
        }

        public APIRequestGet requestAgencyDiscountField() {
            return this.requestAgencyDiscountField(true);
        }

        public APIRequestGet requestAgencyDiscountField(boolean value) {
            this.requestField("agency_discount", value);
            return this;
        }

        public APIRequestGet requestAgencyNameField() {
            return this.requestAgencyNameField(true);
        }

        public APIRequestGet requestAgencyNameField(boolean value) {
            this.requestField("agency_name", value);
            return this;
        }

        public APIRequestGet requestBillToAddressFbidField() {
            return this.requestBillToAddressFbidField(true);
        }

        public APIRequestGet requestBillToAddressFbidField(boolean value) {
            this.requestField("bill_to_address_fbid", value);
            return this;
        }

        public APIRequestGet requestBillToFbidField() {
            return this.requestBillToFbidField(true);
        }

        public APIRequestGet requestBillToFbidField(boolean value) {
            this.requestField("bill_to_fbid", value);
            return this;
        }

        public APIRequestGet requestCampaignNameField() {
            return this.requestCampaignNameField(true);
        }

        public APIRequestGet requestCampaignNameField(boolean value) {
            this.requestField("campaign_name", value);
            return this;
        }

        public APIRequestGet requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGet requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGet requestCreatedDateField() {
            return this.requestCreatedDateField(true);
        }

        public APIRequestGet requestCreatedDateField(boolean value) {
            this.requestField("created_date", value);
            return this;
        }

        public APIRequestGet requestCustomerIoField() {
            return this.requestCustomerIoField(true);
        }

        public APIRequestGet requestCustomerIoField(boolean value) {
            this.requestField("customer_io", value);
            return this;
        }

        public APIRequestGet requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGet requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGet requestIoTermsField() {
            return this.requestIoTermsField(true);
        }

        public APIRequestGet requestIoTermsField(boolean value) {
            this.requestField("io_terms", value);
            return this;
        }

        public APIRequestGet requestIoTypeField() {
            return this.requestIoTypeField(true);
        }

        public APIRequestGet requestIoTypeField(boolean value) {
            this.requestField("io_type", value);
            return this;
        }

        public APIRequestGet requestLastUpdatedByField() {
            return this.requestLastUpdatedByField(true);
        }

        public APIRequestGet requestLastUpdatedByField(boolean value) {
            this.requestField("last_updated_by", value);
            return this;
        }

        public APIRequestGet requestLastUpdatedDateField() {
            return this.requestLastUpdatedDateField(true);
        }

        public APIRequestGet requestLastUpdatedDateField(boolean value) {
            this.requestField("last_updated_date", value);
            return this;
        }

        public APIRequestGet requestMaxEndDateField() {
            return this.requestMaxEndDateField(true);
        }

        public APIRequestGet requestMaxEndDateField(boolean value) {
            this.requestField("max_end_date", value);
            return this;
        }

        public APIRequestGet requestMdcFbidField() {
            return this.requestMdcFbidField(true);
        }

        public APIRequestGet requestMdcFbidField(boolean value) {
            this.requestField("mdc_fbid", value);
            return this;
        }

        public APIRequestGet requestMediaPlanNumberField() {
            return this.requestMediaPlanNumberField(true);
        }

        public APIRequestGet requestMediaPlanNumberField(boolean value) {
            this.requestField("media_plan_number", value);
            return this;
        }

        public APIRequestGet requestMinStartDateField() {
            return this.requestMinStartDateField(true);
        }

        public APIRequestGet requestMinStartDateField(boolean value) {
            this.requestField("min_start_date", value);
            return this;
        }

        public APIRequestGet requestMsaContractField() {
            return this.requestMsaContractField(true);
        }

        public APIRequestGet requestMsaContractField(boolean value) {
            this.requestField("msa_contract", value);
            return this;
        }

        public APIRequestGet requestPaymentTermsField() {
            return this.requestPaymentTermsField(true);
        }

        public APIRequestGet requestPaymentTermsField(boolean value) {
            this.requestField("payment_terms", value);
            return this;
        }

        public APIRequestGet requestRevHoldFlagField() {
            return this.requestRevHoldFlagField(true);
        }

        public APIRequestGet requestRevHoldFlagField(boolean value) {
            this.requestField("rev_hold_flag", value);
            return this;
        }

        public APIRequestGet requestRevHoldReleasedByField() {
            return this.requestRevHoldReleasedByField(true);
        }

        public APIRequestGet requestRevHoldReleasedByField(boolean value) {
            this.requestField("rev_hold_released_by", value);
            return this;
        }

        public APIRequestGet requestRevHoldReleasedOnField() {
            return this.requestRevHoldReleasedOnField(true);
        }

        public APIRequestGet requestRevHoldReleasedOnField(boolean value) {
            this.requestField("rev_hold_released_on", value);
            return this;
        }

        public APIRequestGet requestSalesrepFbidField() {
            return this.requestSalesrepFbidField(true);
        }

        public APIRequestGet requestSalesrepFbidField(boolean value) {
            this.requestField("salesrep_fbid", value);
            return this;
        }

        public APIRequestGet requestSalesrepNameField() {
            return this.requestSalesrepNameField(true);
        }

        public APIRequestGet requestSalesrepNameField(boolean value) {
            this.requestField("salesrep_name", value);
            return this;
        }

        public APIRequestGet requestSoldToAddressFbidField() {
            return this.requestSoldToAddressFbidField(true);
        }

        public APIRequestGet requestSoldToAddressFbidField(boolean value) {
            this.requestField("sold_to_address_fbid", value);
            return this;
        }

        public APIRequestGet requestSoldToFbidField() {
            return this.requestSoldToFbidField(true);
        }

        public APIRequestGet requestSoldToFbidField(boolean value) {
            this.requestField("sold_to_fbid", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestSubverticalField() {
            return this.requestSubverticalField(true);
        }

        public APIRequestGet requestSubverticalField(boolean value) {
            this.requestField("subvertical", value);
            return this;
        }

        public APIRequestGet requestThirdpartyBilledField() {
            return this.requestThirdpartyBilledField(true);
        }

        public APIRequestGet requestThirdpartyBilledField(boolean value) {
            this.requestField("thirdparty_billed", value);
            return this;
        }

        public APIRequestGet requestThirdpartyPasswordField() {
            return this.requestThirdpartyPasswordField(true);
        }

        public APIRequestGet requestThirdpartyPasswordField(boolean value) {
            this.requestField("thirdparty_password", value);
            return this;
        }

        public APIRequestGet requestThirdpartyUidField() {
            return this.requestThirdpartyUidField(true);
        }

        public APIRequestGet requestThirdpartyUidField(boolean value) {
            this.requestField("thirdparty_uid", value);
            return this;
        }

        public APIRequestGet requestThirdpartyUrlField() {
            return this.requestThirdpartyUrlField(true);
        }

        public APIRequestGet requestThirdpartyUrlField(boolean value) {
            this.requestField("thirdparty_url", value);
            return this;
        }

        public APIRequestGet requestVatCountryField() {
            return this.requestVatCountryField(true);
        }

        public APIRequestGet requestVatCountryField(boolean value) {
            this.requestField("vat_country", value);
            return this;
        }

        public APIRequestGet requestVersionField() {
            return this.requestVersionField(true);
        }

        public APIRequestGet requestVersionField(boolean value) {
            this.requestField("version", value);
            return this;
        }

        public APIRequestGet requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGet requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

