/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPaymentMethodsInfo
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="available_card_types")
    private List<String> mAvailableCardTypes = null;
    @SerializedName(value="available_payment_methods")
    private List<String> mAvailablePaymentMethods = null;
    @SerializedName(value="available_payment_methods_details")
    private List<Object> mAvailablePaymentMethodsDetails = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="existing_payment_methods")
    private List<Object> mExistingPaymentMethods = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    UserPaymentMethodsInfo() {
    }

    public UserPaymentMethodsInfo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public UserPaymentMethodsInfo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public UserPaymentMethodsInfo fetch() throws APIException {
        UserPaymentMethodsInfo newInstance = UserPaymentMethodsInfo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static UserPaymentMethodsInfo fetchById(Long id, APIContext context) throws APIException {
        return UserPaymentMethodsInfo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<UserPaymentMethodsInfo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return UserPaymentMethodsInfo.fetchByIdAsync(id.toString(), context);
    }

    public static UserPaymentMethodsInfo fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<UserPaymentMethodsInfo> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<UserPaymentMethodsInfo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<UserPaymentMethodsInfo>(context, "", "/", "GET", UserPaymentMethodsInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<UserPaymentMethodsInfo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<UserPaymentMethodsInfo>(context, "", "/", "GET", UserPaymentMethodsInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static UserPaymentMethodsInfo loadJSON(String json, APIContext context) {
        UserPaymentMethodsInfo userPaymentMethodsInfo = (UserPaymentMethodsInfo)UserPaymentMethodsInfo.getGson().fromJson(json, UserPaymentMethodsInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(userPaymentMethodsInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        userPaymentMethodsInfo.context = context;
        userPaymentMethodsInfo.rawValue = json;
        return userPaymentMethodsInfo;
    }

    public static APINodeList<UserPaymentMethodsInfo> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<UserPaymentMethodsInfo> userPaymentMethodsInfos = new APINodeList<UserPaymentMethodsInfo>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        userPaymentMethodsInfos.add(UserPaymentMethodsInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return userPaymentMethodsInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            userPaymentMethodsInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        userPaymentMethodsInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            userPaymentMethodsInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            userPaymentMethodsInfos.add(UserPaymentMethodsInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                userPaymentMethodsInfos.add(UserPaymentMethodsInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            userPaymentMethodsInfos.add(UserPaymentMethodsInfo.loadJSON(obj.toString(), context));
                        }
                    }
                    return userPaymentMethodsInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        userPaymentMethodsInfos.add(UserPaymentMethodsInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return userPaymentMethodsInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        userPaymentMethodsInfos.add(UserPaymentMethodsInfo.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return userPaymentMethodsInfos;
                }
                userPaymentMethodsInfos.clear();
                userPaymentMethodsInfos.add(UserPaymentMethodsInfo.loadJSON(json, context));
                return userPaymentMethodsInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return UserPaymentMethodsInfo.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public List<String> getFieldAvailableCardTypes() {
        return this.mAvailableCardTypes;
    }

    public List<String> getFieldAvailablePaymentMethods() {
        return this.mAvailablePaymentMethods;
    }

    public List<Object> getFieldAvailablePaymentMethodsDetails() {
        return this.mAvailablePaymentMethodsDetails;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public List<Object> getFieldExistingPaymentMethods() {
        return this.mExistingPaymentMethods;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public UserPaymentMethodsInfo copyFrom(UserPaymentMethodsInfo instance) {
        this.mAccountId = instance.mAccountId;
        this.mAvailableCardTypes = instance.mAvailableCardTypes;
        this.mAvailablePaymentMethods = instance.mAvailablePaymentMethods;
        this.mAvailablePaymentMethodsDetails = instance.mAvailablePaymentMethodsDetails;
        this.mCountry = instance.mCountry;
        this.mCurrency = instance.mCurrency;
        this.mExistingPaymentMethods = instance.mExistingPaymentMethods;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<UserPaymentMethodsInfo> getParser() {
        return new APIRequest.ResponseParser<UserPaymentMethodsInfo>(){

            @Override
            public APINodeList<UserPaymentMethodsInfo> parseResponse(String response, APIContext context, APIRequest<UserPaymentMethodsInfo> request) throws APIException.MalformedResponseException {
                return UserPaymentMethodsInfo.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPaymentType {
        VALUE_NONE("none"),
        VALUE_ADS_INVOICE("ads_invoice"),
        VALUE_DONATIONS("donations"),
        VALUE_DONATIONS_MATCHING_CONFIRMATION("donations_matching_confirmation"),
        VALUE_DONATIONS_MATCHING_PLEDGE("donations_matching_pledge"),
        VALUE_FACEBOOK_SHOP("facebook_shop"),
        VALUE_FAN_FUNDING("fan_funding"),
        VALUE_GROUP_SUBSCRIPTION("group_subscription"),
        VALUE_GAME_TIPPING_TOKEN("game_tipping_token"),
        VALUE_INSTANT_GAMES("instant_games"),
        VALUE_OCULUS_CV1("oculus_cv1"),
        VALUE_OCULUS_LAUNCH_V1("oculus_launch_v1"),
        VALUE_OCULUS_LAUNCH_V2("oculus_launch_v2"),
        VALUE_OZONE("ozone"),
        VALUE_OPEN_GRAPH_PRODUCT("open_graph_product"),
        VALUE_MESSENGER_COMMERCE("messenger_commerce"),
        VALUE_P2P_TRANSFER("p2p_transfer"),
        VALUE_DUMMY_FIRST_PARTY("dummy_first_party"),
        VALUE_DUMMY_THIRD_PARTY("dummy_third_party"),
        VALUE_GIFTS("gifts"),
        VALUE_BILL("bill"),
        VALUE_AIRMAIL("airmail"),
        VALUE_EVENT_TICKETING("event_ticketing"),
        VALUE_PAYMENT_LITE("payment_lite"),
        VALUE_MESSENGER_API_FEE("messenger_api_fee"),
        VALUE_WORKPLACE("workplace"),
        VALUE_NMOR_PAGES_COMMERCE("nmor_pages_commerce"),
        VALUE_STORED_BALANCE("stored_balance"),
        VALUE_THIRD_PARTY_BUNDLE("third_party_bundle"),
        NULL(null);

        private String value;

        private EnumPaymentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumNmorOrderType {
        VALUE_UNKNOWN("unknown"),
        VALUE_NONE("none"),
        VALUE_PAGES_COMMERCE("pages_commerce"),
        VALUE_NMOR_PAGES_COMMERCE("nmor_pages_commerce"),
        VALUE_COMPONENT_FLOW("component_flow"),
        VALUE_BUSINESS_PLATFORM_COMMERCE("business_platform_commerce"),
        VALUE_SYNCHRONOUS_COMPONENT_FLOW("synchronous_component_flow"),
        VALUE_EVENT_TICKETING("event_ticketing"),
        VALUE_PLATFORM_SELF_SERVE("platform_self_serve"),
        VALUE_MESSENGER_PLATFORM("messenger_platform"),
        VALUE_MESSENGER_OMNIM("messenger_omnim"),
        VALUE_BILLING_ENGINE("billing_engine"),
        VALUE_TIP_JAR("tip_jar"),
        VALUE_INSTANT_EXPERIENCES("instant_experiences"),
        VALUE_CHECKOUT_EXPERIENCES("checkout_experiences"),
        VALUE_BUY_ON_FACEBOOK("buy_on_facebook"),
        VALUE_PAYMENT_APP("payment_app"),
        VALUE_DONATION_P4P("donation_p4p"),
        VALUE_WHATSAPP_P2P("whatsapp_p2p"),
        VALUE_P2P("p2p"),
        VALUE_MOBILE_TOP_UP("mobile_top_up"),
        VALUE_SHIPPING_LABEL("shipping_label"),
        VALUE_MARKETPLACE_DROPOFF("marketplace_dropoff"),
        VALUE_PAGES_SOLUTION("pages_solution"),
        VALUE_BLACKBAUD_RWR_DONATION("blackbaud_rwr_donation"),
        VALUE_INSTAGRAM_P2B("instagram_p2b"),
        VALUE_MARKETPLACE_SHIPPING("marketplace_shipping"),
        VALUE_FACEBOOK_INCENTIVE_SELLER("facebook_incentive_seller"),
        VALUE_FACEBOOK_INCENTIVE_BUYER("facebook_incentive_buyer"),
        VALUE_DUMMY("dummy"),
        VALUE_PPGF_DONATION("ppgf_donation"),
        VALUE_ADVERTISER_SUBSCRIPTION("advertiser_subscription"),
        VALUE_WHATSAPP_P2M("whatsapp_p2m"),
        VALUE_MOVIE_TICKETING("movie_ticketing"),
        NULL(null);

        private String value;

        private EnumNmorOrderType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<UserPaymentMethodsInfo> {
        UserPaymentMethodsInfo lastResponse = null;
        public static final String[] PARAMS = new String[]{"account_id", "country_code", "extra_data", "nmor_order_type", "payment_type"};
        public static final String[] FIELDS = new String[]{"account_id", "available_card_types", "available_payment_methods", "available_payment_methods_details", "country", "currency", "existing_payment_methods", "id"};

        @Override
        public UserPaymentMethodsInfo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public UserPaymentMethodsInfo parseResponse(String response) throws APIException {
            return UserPaymentMethodsInfo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public UserPaymentMethodsInfo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public UserPaymentMethodsInfo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<UserPaymentMethodsInfo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<UserPaymentMethodsInfo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, UserPaymentMethodsInfo>(){

                public UserPaymentMethodsInfo apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setAccountId(Long accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestGet setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestGet setCountryCode(String countryCode) {
            this.setParam("country_code", countryCode);
            return this;
        }

        public APIRequestGet setExtraData(String extraData) {
            this.setParam("extra_data", extraData);
            return this;
        }

        public APIRequestGet setNmorOrderType(EnumNmorOrderType nmorOrderType) {
            this.setParam("nmor_order_type", (Object)nmorOrderType);
            return this;
        }

        public APIRequestGet setNmorOrderType(String nmorOrderType) {
            this.setParam("nmor_order_type", nmorOrderType);
            return this;
        }

        public APIRequestGet setPaymentType(EnumPaymentType paymentType) {
            this.setParam("payment_type", (Object)paymentType);
            return this;
        }

        public APIRequestGet setPaymentType(String paymentType) {
            this.setParam("payment_type", paymentType);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestAvailableCardTypesField() {
            return this.requestAvailableCardTypesField(true);
        }

        public APIRequestGet requestAvailableCardTypesField(boolean value) {
            this.requestField("available_card_types", value);
            return this;
        }

        public APIRequestGet requestAvailablePaymentMethodsField() {
            return this.requestAvailablePaymentMethodsField(true);
        }

        public APIRequestGet requestAvailablePaymentMethodsField(boolean value) {
            this.requestField("available_payment_methods", value);
            return this;
        }

        public APIRequestGet requestAvailablePaymentMethodsDetailsField() {
            return this.requestAvailablePaymentMethodsDetailsField(true);
        }

        public APIRequestGet requestAvailablePaymentMethodsDetailsField(boolean value) {
            this.requestField("available_payment_methods_details", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestExistingPaymentMethodsField() {
            return this.requestExistingPaymentMethodsField(true);
        }

        public APIRequestGet requestExistingPaymentMethodsField(boolean value) {
            this.requestField("existing_payment_methods", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

