/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingDynamicRule
extends APINode {
    @SerializedName(value="action.type")
    private String mActionType = null;
    @SerializedName(value="ad_group_id")
    private String mAdGroupId = null;
    @SerializedName(value="campaign_group_id")
    private String mCampaignGroupId = null;
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="impression_count")
    private String mImpressionCount = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="post")
    private String mPost = null;
    @SerializedName(value="retention_seconds")
    private String mRetentionSeconds = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    TargetingDynamicRule() {
    }

    public TargetingDynamicRule(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public TargetingDynamicRule(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public TargetingDynamicRule fetch() throws APIException {
        TargetingDynamicRule newInstance = TargetingDynamicRule.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static TargetingDynamicRule fetchById(Long id, APIContext context) throws APIException {
        return TargetingDynamicRule.fetchById(id.toString(), context);
    }

    public static ListenableFuture<TargetingDynamicRule> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return TargetingDynamicRule.fetchByIdAsync(id.toString(), context);
    }

    public static TargetingDynamicRule fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<TargetingDynamicRule> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<TargetingDynamicRule> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<TargetingDynamicRule>(context, "", "/", "GET", TargetingDynamicRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<TargetingDynamicRule>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<TargetingDynamicRule>(context, "", "/", "GET", TargetingDynamicRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static TargetingDynamicRule loadJSON(String json, APIContext context) {
        TargetingDynamicRule targetingDynamicRule = (TargetingDynamicRule)TargetingDynamicRule.getGson().fromJson(json, TargetingDynamicRule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingDynamicRule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingDynamicRule.context = context;
        targetingDynamicRule.rawValue = json;
        return targetingDynamicRule;
    }

    public static APINodeList<TargetingDynamicRule> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<TargetingDynamicRule> targetingDynamicRules = new APINodeList<TargetingDynamicRule>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingDynamicRules.add(TargetingDynamicRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return targetingDynamicRules;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            targetingDynamicRules.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        targetingDynamicRules.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            targetingDynamicRules.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingDynamicRules.add(TargetingDynamicRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingDynamicRules.add(TargetingDynamicRule.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingDynamicRules.add(TargetingDynamicRule.loadJSON(obj.toString(), context));
                        }
                    }
                    return targetingDynamicRules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingDynamicRules.add(TargetingDynamicRule.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return targetingDynamicRules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingDynamicRules.add(TargetingDynamicRule.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingDynamicRules;
                }
                targetingDynamicRules.clear();
                targetingDynamicRules.add(TargetingDynamicRule.loadJSON(json, context));
                return targetingDynamicRules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingDynamicRule.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldActionType() {
        return this.mActionType;
    }

    public String getFieldAdGroupId() {
        return this.mAdGroupId;
    }

    public String getFieldCampaignGroupId() {
        return this.mCampaignGroupId;
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public String getFieldImpressionCount() {
        return this.mImpressionCount;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public String getFieldPost() {
        return this.mPost;
    }

    public String getFieldRetentionSeconds() {
        return this.mRetentionSeconds;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingDynamicRule copyFrom(TargetingDynamicRule instance) {
        this.mActionType = instance.mActionType;
        this.mAdGroupId = instance.mAdGroupId;
        this.mCampaignGroupId = instance.mCampaignGroupId;
        this.mCampaignId = instance.mCampaignId;
        this.mImpressionCount = instance.mImpressionCount;
        this.mPageId = instance.mPageId;
        this.mPost = instance.mPost;
        this.mRetentionSeconds = instance.mRetentionSeconds;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingDynamicRule> getParser() {
        return new APIRequest.ResponseParser<TargetingDynamicRule>(){

            @Override
            public APINodeList<TargetingDynamicRule> parseResponse(String response, APIContext context, APIRequest<TargetingDynamicRule> request) throws APIException.MalformedResponseException {
                return TargetingDynamicRule.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<TargetingDynamicRule> {
        TargetingDynamicRule lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"action.type", "ad_group_id", "campaign_group_id", "campaign_id", "impression_count", "page_id", "post", "retention_seconds", "id"};

        @Override
        public TargetingDynamicRule getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public TargetingDynamicRule parseResponse(String response) throws APIException {
            return TargetingDynamicRule.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public TargetingDynamicRule execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public TargetingDynamicRule execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<TargetingDynamicRule> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<TargetingDynamicRule> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, TargetingDynamicRule>(){

                public TargetingDynamicRule apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestActionTypeField() {
            return this.requestActionTypeField(true);
        }

        public APIRequestGet requestActionTypeField(boolean value) {
            this.requestField("action.type", value);
            return this;
        }

        public APIRequestGet requestAdGroupIdField() {
            return this.requestAdGroupIdField(true);
        }

        public APIRequestGet requestAdGroupIdField(boolean value) {
            this.requestField("ad_group_id", value);
            return this;
        }

        public APIRequestGet requestCampaignGroupIdField() {
            return this.requestCampaignGroupIdField(true);
        }

        public APIRequestGet requestCampaignGroupIdField(boolean value) {
            this.requestField("campaign_group_id", value);
            return this;
        }

        public APIRequestGet requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGet requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGet requestImpressionCountField() {
            return this.requestImpressionCountField(true);
        }

        public APIRequestGet requestImpressionCountField(boolean value) {
            this.requestField("impression_count", value);
            return this;
        }

        public APIRequestGet requestPageIdField() {
            return this.requestPageIdField(true);
        }

        public APIRequestGet requestPageIdField(boolean value) {
            this.requestField("page_id", value);
            return this;
        }

        public APIRequestGet requestPostField() {
            return this.requestPostField(true);
        }

        public APIRequestGet requestPostField(boolean value) {
            this.requestField("post", value);
            return this;
        }

        public APIRequestGet requestRetentionSecondsField() {
            return this.requestRetentionSecondsField(true);
        }

        public APIRequestGet requestRetentionSecondsField(boolean value) {
            this.requestField("retention_seconds", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

