/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Place;
import com.facebook.ads.sdk.Targeting;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledPost
extends APINode {
    @SerializedName(value="admin_creator")
    private User mAdminCreator = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="feed_audience_description")
    private String mFeedAudienceDescription = null;
    @SerializedName(value="feed_targeting")
    private Targeting mFeedTargeting = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="modified_time")
    private String mModifiedTime = null;
    @SerializedName(value="og_action_summary")
    private String mOgActionSummary = null;
    @SerializedName(value="permalink_url")
    private String mPermalinkUrl = null;
    @SerializedName(value="place")
    private Place mPlace = null;
    @SerializedName(value="privacy_description")
    private String mPrivacyDescription = null;
    @SerializedName(value="promotion_info")
    private Object mPromotionInfo = null;
    @SerializedName(value="scheduled_publish_time")
    private String mScheduledPublishTime = null;
    @SerializedName(value="story_token")
    private String mStoryToken = null;
    @SerializedName(value="thumbnail")
    private String mThumbnail = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    protected static Gson gson = null;

    ScheduledPost() {
    }

    public ScheduledPost(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ScheduledPost(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ScheduledPost fetch() throws APIException {
        ScheduledPost newInstance = ScheduledPost.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ScheduledPost fetchById(Long id, APIContext context) throws APIException {
        return ScheduledPost.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ScheduledPost> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ScheduledPost.fetchByIdAsync(id.toString(), context);
    }

    public static ScheduledPost fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ScheduledPost> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ScheduledPost> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ScheduledPost>(context, "", "/", "GET", ScheduledPost.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ScheduledPost>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ScheduledPost>(context, "", "/", "GET", ScheduledPost.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ScheduledPost loadJSON(String json, APIContext context) {
        ScheduledPost scheduledPost = (ScheduledPost)ScheduledPost.getGson().fromJson(json, ScheduledPost.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(scheduledPost.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        scheduledPost.context = context;
        scheduledPost.rawValue = json;
        return scheduledPost;
    }

    public static APINodeList<ScheduledPost> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ScheduledPost> scheduledPosts = new APINodeList<ScheduledPost>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        scheduledPosts.add(ScheduledPost.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return scheduledPosts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            scheduledPosts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        scheduledPosts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            scheduledPosts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            scheduledPosts.add(ScheduledPost.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                scheduledPosts.add(ScheduledPost.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            scheduledPosts.add(ScheduledPost.loadJSON(obj.toString(), context));
                        }
                    }
                    return scheduledPosts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        scheduledPosts.add(ScheduledPost.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return scheduledPosts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        scheduledPosts.add(ScheduledPost.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return scheduledPosts;
                }
                scheduledPosts.clear();
                scheduledPosts.add(ScheduledPost.loadJSON(json, context));
                return scheduledPosts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ScheduledPost.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public User getFieldAdminCreator() {
        if (this.mAdminCreator != null) {
            this.mAdminCreator.context = this.getContext();
        }
        return this.mAdminCreator;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldFeedAudienceDescription() {
        return this.mFeedAudienceDescription;
    }

    public Targeting getFieldFeedTargeting() {
        if (this.mFeedTargeting != null) {
            this.mFeedTargeting.context = this.getContext();
        }
        return this.mFeedTargeting;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public String getFieldModifiedTime() {
        return this.mModifiedTime;
    }

    public String getFieldOgActionSummary() {
        return this.mOgActionSummary;
    }

    public String getFieldPermalinkUrl() {
        return this.mPermalinkUrl;
    }

    public Place getFieldPlace() {
        if (this.mPlace != null) {
            this.mPlace.context = this.getContext();
        }
        return this.mPlace;
    }

    public String getFieldPrivacyDescription() {
        return this.mPrivacyDescription;
    }

    public Object getFieldPromotionInfo() {
        return this.mPromotionInfo;
    }

    public String getFieldScheduledPublishTime() {
        return this.mScheduledPublishTime;
    }

    public String getFieldStoryToken() {
        return this.mStoryToken;
    }

    public String getFieldThumbnail() {
        return this.mThumbnail;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ScheduledPost copyFrom(ScheduledPost instance) {
        this.mAdminCreator = instance.mAdminCreator;
        this.mCreationTime = instance.mCreationTime;
        this.mFeedAudienceDescription = instance.mFeedAudienceDescription;
        this.mFeedTargeting = instance.mFeedTargeting;
        this.mId = instance.mId;
        this.mMessage = instance.mMessage;
        this.mModifiedTime = instance.mModifiedTime;
        this.mOgActionSummary = instance.mOgActionSummary;
        this.mPermalinkUrl = instance.mPermalinkUrl;
        this.mPlace = instance.mPlace;
        this.mPrivacyDescription = instance.mPrivacyDescription;
        this.mPromotionInfo = instance.mPromotionInfo;
        this.mScheduledPublishTime = instance.mScheduledPublishTime;
        this.mStoryToken = instance.mStoryToken;
        this.mThumbnail = instance.mThumbnail;
        this.mVideoId = instance.mVideoId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ScheduledPost> getParser() {
        return new APIRequest.ResponseParser<ScheduledPost>(){

            @Override
            public APINodeList<ScheduledPost> parseResponse(String response, APIContext context, APIRequest<ScheduledPost> request) throws APIException.MalformedResponseException {
                return ScheduledPost.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ScheduledPost> {
        ScheduledPost lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"admin_creator", "creation_time", "feed_audience_description", "feed_targeting", "id", "message", "modified_time", "og_action_summary", "permalink_url", "place", "privacy_description", "promotion_info", "scheduled_publish_time", "story_token", "thumbnail", "video_id"};

        @Override
        public ScheduledPost getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ScheduledPost parseResponse(String response) throws APIException {
            return ScheduledPost.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ScheduledPost execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ScheduledPost execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ScheduledPost> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ScheduledPost> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ScheduledPost>(){

                public ScheduledPost apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdminCreatorField() {
            return this.requestAdminCreatorField(true);
        }

        public APIRequestGet requestAdminCreatorField(boolean value) {
            this.requestField("admin_creator", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestFeedAudienceDescriptionField() {
            return this.requestFeedAudienceDescriptionField(true);
        }

        public APIRequestGet requestFeedAudienceDescriptionField(boolean value) {
            this.requestField("feed_audience_description", value);
            return this;
        }

        public APIRequestGet requestFeedTargetingField() {
            return this.requestFeedTargetingField(true);
        }

        public APIRequestGet requestFeedTargetingField(boolean value) {
            this.requestField("feed_targeting", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGet requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGet requestModifiedTimeField() {
            return this.requestModifiedTimeField(true);
        }

        public APIRequestGet requestModifiedTimeField(boolean value) {
            this.requestField("modified_time", value);
            return this;
        }

        public APIRequestGet requestOgActionSummaryField() {
            return this.requestOgActionSummaryField(true);
        }

        public APIRequestGet requestOgActionSummaryField(boolean value) {
            this.requestField("og_action_summary", value);
            return this;
        }

        public APIRequestGet requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGet requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGet requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGet requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGet requestPrivacyDescriptionField() {
            return this.requestPrivacyDescriptionField(true);
        }

        public APIRequestGet requestPrivacyDescriptionField(boolean value) {
            this.requestField("privacy_description", value);
            return this;
        }

        public APIRequestGet requestPromotionInfoField() {
            return this.requestPromotionInfoField(true);
        }

        public APIRequestGet requestPromotionInfoField(boolean value) {
            this.requestField("promotion_info", value);
            return this;
        }

        public APIRequestGet requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGet requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGet requestStoryTokenField() {
            return this.requestStoryTokenField(true);
        }

        public APIRequestGet requestStoryTokenField(boolean value) {
            this.requestField("story_token", value);
            return this;
        }

        public APIRequestGet requestThumbnailField() {
            return this.requestThumbnailField(true);
        }

        public APIRequestGet requestThumbnailField(boolean value) {
            this.requestField("thumbnail", value);
            return this;
        }

        public APIRequestGet requestVideoIdField() {
            return this.requestVideoIdField(true);
        }

        public APIRequestGet requestVideoIdField(boolean value) {
            this.requestField("video_id", value);
            return this;
        }
    }
}

