/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ExternalEventSource;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductEventStat
extends APINode {
    @SerializedName(value="date_start")
    private String mDateStart = null;
    @SerializedName(value="date_stop")
    private String mDateStop = null;
    @SerializedName(value="device_type")
    private EnumDeviceType mDeviceType = null;
    @SerializedName(value="event")
    private EnumEvent mEvent = null;
    @SerializedName(value="event_source")
    private ExternalEventSource mEventSource = null;
    @SerializedName(value="total_content_ids_matched_other_catalogs")
    private Long mTotalContentIdsMatchedOtherCatalogs = null;
    @SerializedName(value="total_matched_content_ids")
    private Long mTotalMatchedContentIds = null;
    @SerializedName(value="total_unmatched_content_ids")
    private Long mTotalUnmatchedContentIds = null;
    @SerializedName(value="unique_content_ids_matched_other_catalogs")
    private Long mUniqueContentIdsMatchedOtherCatalogs = null;
    @SerializedName(value="unique_matched_content_ids")
    private Long mUniqueMatchedContentIds = null;
    @SerializedName(value="unique_unmatched_content_ids")
    private Long mUniqueUnmatchedContentIds = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    ProductEventStat() {
    }

    public ProductEventStat(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductEventStat(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductEventStat fetch() throws APIException {
        ProductEventStat newInstance = ProductEventStat.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductEventStat fetchById(Long id, APIContext context) throws APIException {
        return ProductEventStat.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductEventStat> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductEventStat.fetchByIdAsync(id.toString(), context);
    }

    public static ProductEventStat fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProductEventStat> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProductEventStat> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductEventStat>(context, "", "/", "GET", ProductEventStat.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductEventStat>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProductEventStat>(context, "", "/", "GET", ProductEventStat.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductEventStat loadJSON(String json, APIContext context) {
        ProductEventStat productEventStat = (ProductEventStat)ProductEventStat.getGson().fromJson(json, ProductEventStat.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productEventStat.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productEventStat.context = context;
        productEventStat.rawValue = json;
        return productEventStat;
    }

    public static APINodeList<ProductEventStat> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductEventStat> productEventStats = new APINodeList<ProductEventStat>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productEventStats.add(ProductEventStat.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productEventStats;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productEventStats.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productEventStats.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productEventStats.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productEventStats.add(ProductEventStat.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productEventStats.add(ProductEventStat.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productEventStats.add(ProductEventStat.loadJSON(obj.toString(), context));
                        }
                    }
                    return productEventStats;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productEventStats.add(ProductEventStat.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productEventStats;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productEventStats.add(ProductEventStat.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productEventStats;
                }
                productEventStats.clear();
                productEventStats.add(ProductEventStat.loadJSON(json, context));
                return productEventStats;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductEventStat.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDateStart() {
        return this.mDateStart;
    }

    public String getFieldDateStop() {
        return this.mDateStop;
    }

    public EnumDeviceType getFieldDeviceType() {
        return this.mDeviceType;
    }

    public EnumEvent getFieldEvent() {
        return this.mEvent;
    }

    public ExternalEventSource getFieldEventSource() {
        if (this.mEventSource != null) {
            this.mEventSource.context = this.getContext();
        }
        return this.mEventSource;
    }

    public Long getFieldTotalContentIdsMatchedOtherCatalogs() {
        return this.mTotalContentIdsMatchedOtherCatalogs;
    }

    public Long getFieldTotalMatchedContentIds() {
        return this.mTotalMatchedContentIds;
    }

    public Long getFieldTotalUnmatchedContentIds() {
        return this.mTotalUnmatchedContentIds;
    }

    public Long getFieldUniqueContentIdsMatchedOtherCatalogs() {
        return this.mUniqueContentIdsMatchedOtherCatalogs;
    }

    public Long getFieldUniqueMatchedContentIds() {
        return this.mUniqueMatchedContentIds;
    }

    public Long getFieldUniqueUnmatchedContentIds() {
        return this.mUniqueUnmatchedContentIds;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductEventStat copyFrom(ProductEventStat instance) {
        this.mDateStart = instance.mDateStart;
        this.mDateStop = instance.mDateStop;
        this.mDeviceType = instance.mDeviceType;
        this.mEvent = instance.mEvent;
        this.mEventSource = instance.mEventSource;
        this.mTotalContentIdsMatchedOtherCatalogs = instance.mTotalContentIdsMatchedOtherCatalogs;
        this.mTotalMatchedContentIds = instance.mTotalMatchedContentIds;
        this.mTotalUnmatchedContentIds = instance.mTotalUnmatchedContentIds;
        this.mUniqueContentIdsMatchedOtherCatalogs = instance.mUniqueContentIdsMatchedOtherCatalogs;
        this.mUniqueMatchedContentIds = instance.mUniqueMatchedContentIds;
        this.mUniqueUnmatchedContentIds = instance.mUniqueUnmatchedContentIds;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductEventStat> getParser() {
        return new APIRequest.ResponseParser<ProductEventStat>(){

            @Override
            public APINodeList<ProductEventStat> parseResponse(String response, APIContext context, APIRequest<ProductEventStat> request) throws APIException.MalformedResponseException {
                return ProductEventStat.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBreakdowns {
        VALUE_DEVICE_TYPE("DEVICE_TYPE"),
        NULL(null);

        private String value;

        private EnumBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumEvent {
        VALUE_VIEWCONTENT("ViewContent"),
        VALUE_ADDTOCART("AddToCart"),
        VALUE_PURCHASE("Purchase"),
        VALUE_INITIATECHECKOUT("InitiateCheckout"),
        VALUE_SEARCH("Search"),
        VALUE_LEAD("Lead"),
        VALUE_ADDTOWISHLIST("AddToWishlist"),
        NULL(null);

        private String value;

        private EnumEvent(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDeviceType {
        VALUE_DESKTOP("desktop"),
        VALUE_MOBILE_ANDROID_PHONE("mobile_android_phone"),
        VALUE_MOBILE_ANDROID_TABLET("mobile_android_tablet"),
        VALUE_MOBILE_IPAD("mobile_ipad"),
        VALUE_MOBILE_IPHONE("mobile_iphone"),
        VALUE_MOBILE_IPOD("mobile_ipod"),
        VALUE_MOBILE_PHONE("mobile_phone"),
        VALUE_MOBILE_TABLET("mobile_tablet"),
        VALUE_MOBILE_WINDOWS_PHONE("mobile_windows_phone"),
        VALUE_UNKNOWN("unknown"),
        NULL(null);

        private String value;

        private EnumDeviceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ProductEventStat> {
        ProductEventStat lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"date_start", "date_stop", "device_type", "event", "event_source", "total_content_ids_matched_other_catalogs", "total_matched_content_ids", "total_unmatched_content_ids", "unique_content_ids_matched_other_catalogs", "unique_matched_content_ids", "unique_unmatched_content_ids", "id"};

        @Override
        public ProductEventStat getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductEventStat parseResponse(String response) throws APIException {
            return ProductEventStat.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ProductEventStat execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductEventStat execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ProductEventStat> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductEventStat> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ProductEventStat>(){

                public ProductEventStat apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDateStartField() {
            return this.requestDateStartField(true);
        }

        public APIRequestGet requestDateStartField(boolean value) {
            this.requestField("date_start", value);
            return this;
        }

        public APIRequestGet requestDateStopField() {
            return this.requestDateStopField(true);
        }

        public APIRequestGet requestDateStopField(boolean value) {
            this.requestField("date_stop", value);
            return this;
        }

        public APIRequestGet requestDeviceTypeField() {
            return this.requestDeviceTypeField(true);
        }

        public APIRequestGet requestDeviceTypeField(boolean value) {
            this.requestField("device_type", value);
            return this;
        }

        public APIRequestGet requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGet requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGet requestEventSourceField() {
            return this.requestEventSourceField(true);
        }

        public APIRequestGet requestEventSourceField(boolean value) {
            this.requestField("event_source", value);
            return this;
        }

        public APIRequestGet requestTotalContentIdsMatchedOtherCatalogsField() {
            return this.requestTotalContentIdsMatchedOtherCatalogsField(true);
        }

        public APIRequestGet requestTotalContentIdsMatchedOtherCatalogsField(boolean value) {
            this.requestField("total_content_ids_matched_other_catalogs", value);
            return this;
        }

        public APIRequestGet requestTotalMatchedContentIdsField() {
            return this.requestTotalMatchedContentIdsField(true);
        }

        public APIRequestGet requestTotalMatchedContentIdsField(boolean value) {
            this.requestField("total_matched_content_ids", value);
            return this;
        }

        public APIRequestGet requestTotalUnmatchedContentIdsField() {
            return this.requestTotalUnmatchedContentIdsField(true);
        }

        public APIRequestGet requestTotalUnmatchedContentIdsField(boolean value) {
            this.requestField("total_unmatched_content_ids", value);
            return this;
        }

        public APIRequestGet requestUniqueContentIdsMatchedOtherCatalogsField() {
            return this.requestUniqueContentIdsMatchedOtherCatalogsField(true);
        }

        public APIRequestGet requestUniqueContentIdsMatchedOtherCatalogsField(boolean value) {
            this.requestField("unique_content_ids_matched_other_catalogs", value);
            return this;
        }

        public APIRequestGet requestUniqueMatchedContentIdsField() {
            return this.requestUniqueMatchedContentIdsField(true);
        }

        public APIRequestGet requestUniqueMatchedContentIdsField(boolean value) {
            this.requestField("unique_matched_content_ids", value);
            return this;
        }

        public APIRequestGet requestUniqueUnmatchedContentIdsField() {
            return this.requestUniqueUnmatchedContentIdsField(true);
        }

        public APIRequestGet requestUniqueUnmatchedContentIdsField(boolean value) {
            this.requestField("unique_unmatched_content_ids", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

