/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRestaurantSpecialties
extends APINode {
    @SerializedName(value="breakfast")
    private Long mBreakfast = null;
    @SerializedName(value="coffee")
    private Long mCoffee = null;
    @SerializedName(value="dinner")
    private Long mDinner = null;
    @SerializedName(value="drinks")
    private Long mDrinks = null;
    @SerializedName(value="lunch")
    private Long mLunch = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    PageRestaurantSpecialties() {
    }

    public PageRestaurantSpecialties(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PageRestaurantSpecialties(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PageRestaurantSpecialties fetch() throws APIException {
        PageRestaurantSpecialties newInstance = PageRestaurantSpecialties.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PageRestaurantSpecialties fetchById(Long id, APIContext context) throws APIException {
        return PageRestaurantSpecialties.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PageRestaurantSpecialties> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PageRestaurantSpecialties.fetchByIdAsync(id.toString(), context);
    }

    public static PageRestaurantSpecialties fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PageRestaurantSpecialties> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PageRestaurantSpecialties> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PageRestaurantSpecialties>(context, "", "/", "GET", PageRestaurantSpecialties.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PageRestaurantSpecialties>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PageRestaurantSpecialties>(context, "", "/", "GET", PageRestaurantSpecialties.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageRestaurantSpecialties loadJSON(String json, APIContext context) {
        PageRestaurantSpecialties pageRestaurantSpecialties = (PageRestaurantSpecialties)PageRestaurantSpecialties.getGson().fromJson(json, PageRestaurantSpecialties.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageRestaurantSpecialties.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageRestaurantSpecialties.context = context;
        pageRestaurantSpecialties.rawValue = json;
        return pageRestaurantSpecialties;
    }

    public static APINodeList<PageRestaurantSpecialties> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageRestaurantSpecialties> pageRestaurantSpecialtiess = new APINodeList<PageRestaurantSpecialties>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageRestaurantSpecialtiess.add(PageRestaurantSpecialties.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return pageRestaurantSpecialtiess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageRestaurantSpecialtiess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageRestaurantSpecialtiess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageRestaurantSpecialtiess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageRestaurantSpecialtiess.add(PageRestaurantSpecialties.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageRestaurantSpecialtiess.add(PageRestaurantSpecialties.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageRestaurantSpecialtiess.add(PageRestaurantSpecialties.loadJSON(obj.toString(), context));
                        }
                    }
                    return pageRestaurantSpecialtiess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageRestaurantSpecialtiess.add(PageRestaurantSpecialties.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return pageRestaurantSpecialtiess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageRestaurantSpecialtiess.add(PageRestaurantSpecialties.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageRestaurantSpecialtiess;
                }
                pageRestaurantSpecialtiess.clear();
                pageRestaurantSpecialtiess.add(PageRestaurantSpecialties.loadJSON(json, context));
                return pageRestaurantSpecialtiess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageRestaurantSpecialties.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldBreakfast() {
        return this.mBreakfast;
    }

    public Long getFieldCoffee() {
        return this.mCoffee;
    }

    public Long getFieldDinner() {
        return this.mDinner;
    }

    public Long getFieldDrinks() {
        return this.mDrinks;
    }

    public Long getFieldLunch() {
        return this.mLunch;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageRestaurantSpecialties copyFrom(PageRestaurantSpecialties instance) {
        this.mBreakfast = instance.mBreakfast;
        this.mCoffee = instance.mCoffee;
        this.mDinner = instance.mDinner;
        this.mDrinks = instance.mDrinks;
        this.mLunch = instance.mLunch;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageRestaurantSpecialties> getParser() {
        return new APIRequest.ResponseParser<PageRestaurantSpecialties>(){

            @Override
            public APINodeList<PageRestaurantSpecialties> parseResponse(String response, APIContext context, APIRequest<PageRestaurantSpecialties> request) throws APIException.MalformedResponseException {
                return PageRestaurantSpecialties.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PageRestaurantSpecialties> {
        PageRestaurantSpecialties lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"breakfast", "coffee", "dinner", "drinks", "lunch", "id"};

        @Override
        public PageRestaurantSpecialties getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageRestaurantSpecialties parseResponse(String response) throws APIException {
            return PageRestaurantSpecialties.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PageRestaurantSpecialties execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageRestaurantSpecialties execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PageRestaurantSpecialties> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageRestaurantSpecialties> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PageRestaurantSpecialties>(){

                public PageRestaurantSpecialties apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBreakfastField() {
            return this.requestBreakfastField(true);
        }

        public APIRequestGet requestBreakfastField(boolean value) {
            this.requestField("breakfast", value);
            return this;
        }

        public APIRequestGet requestCoffeeField() {
            return this.requestCoffeeField(true);
        }

        public APIRequestGet requestCoffeeField(boolean value) {
            this.requestField("coffee", value);
            return this;
        }

        public APIRequestGet requestDinnerField() {
            return this.requestDinnerField(true);
        }

        public APIRequestGet requestDinnerField(boolean value) {
            this.requestField("dinner", value);
            return this;
        }

        public APIRequestGet requestDrinksField() {
            return this.requestDrinksField(true);
        }

        public APIRequestGet requestDrinksField(boolean value) {
            this.requestField("drinks", value);
            return this;
        }

        public APIRequestGet requestLunchField() {
            return this.requestLunchField(true);
        }

        public APIRequestGet requestLunchField(boolean value) {
            this.requestField("lunch", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

