/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.BilledAmountDetails;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvoiceCampaign
extends APINode {
    @SerializedName(value="ad_account_id")
    private String mAdAccountId = null;
    @SerializedName(value="billed_amount_details")
    private BilledAmountDetails mBilledAmountDetails = null;
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="campaign_name")
    private String mCampaignName = null;
    @SerializedName(value="clicks")
    private Long mClicks = null;
    @SerializedName(value="conversions")
    private Long mConversions = null;
    @SerializedName(value="impressions")
    private Long mImpressions = null;
    @SerializedName(value="tags")
    private List<String> mTags = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    InvoiceCampaign() {
    }

    public InvoiceCampaign(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public InvoiceCampaign(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public InvoiceCampaign fetch() throws APIException {
        InvoiceCampaign newInstance = InvoiceCampaign.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static InvoiceCampaign fetchById(Long id, APIContext context) throws APIException {
        return InvoiceCampaign.fetchById(id.toString(), context);
    }

    public static ListenableFuture<InvoiceCampaign> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return InvoiceCampaign.fetchByIdAsync(id.toString(), context);
    }

    public static InvoiceCampaign fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<InvoiceCampaign> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<InvoiceCampaign> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<InvoiceCampaign>(context, "", "/", "GET", InvoiceCampaign.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<InvoiceCampaign>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<InvoiceCampaign>(context, "", "/", "GET", InvoiceCampaign.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InvoiceCampaign loadJSON(String json, APIContext context) {
        InvoiceCampaign invoiceCampaign = (InvoiceCampaign)InvoiceCampaign.getGson().fromJson(json, InvoiceCampaign.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(invoiceCampaign.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        invoiceCampaign.context = context;
        invoiceCampaign.rawValue = json;
        return invoiceCampaign;
    }

    public static APINodeList<InvoiceCampaign> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InvoiceCampaign> invoiceCampaigns = new APINodeList<InvoiceCampaign>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        invoiceCampaigns.add(InvoiceCampaign.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return invoiceCampaigns;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            invoiceCampaigns.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        invoiceCampaigns.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            invoiceCampaigns.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            invoiceCampaigns.add(InvoiceCampaign.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                invoiceCampaigns.add(InvoiceCampaign.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            invoiceCampaigns.add(InvoiceCampaign.loadJSON(obj.toString(), context));
                        }
                    }
                    return invoiceCampaigns;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        invoiceCampaigns.add(InvoiceCampaign.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return invoiceCampaigns;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        invoiceCampaigns.add(InvoiceCampaign.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return invoiceCampaigns;
                }
                invoiceCampaigns.clear();
                invoiceCampaigns.add(InvoiceCampaign.loadJSON(json, context));
                return invoiceCampaigns;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InvoiceCampaign.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdAccountId() {
        return this.mAdAccountId;
    }

    public BilledAmountDetails getFieldBilledAmountDetails() {
        if (this.mBilledAmountDetails != null) {
            this.mBilledAmountDetails.context = this.getContext();
        }
        return this.mBilledAmountDetails;
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public String getFieldCampaignName() {
        return this.mCampaignName;
    }

    public Long getFieldClicks() {
        return this.mClicks;
    }

    public Long getFieldConversions() {
        return this.mConversions;
    }

    public Long getFieldImpressions() {
        return this.mImpressions;
    }

    public List<String> getFieldTags() {
        return this.mTags;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InvoiceCampaign copyFrom(InvoiceCampaign instance) {
        this.mAdAccountId = instance.mAdAccountId;
        this.mBilledAmountDetails = instance.mBilledAmountDetails;
        this.mCampaignId = instance.mCampaignId;
        this.mCampaignName = instance.mCampaignName;
        this.mClicks = instance.mClicks;
        this.mConversions = instance.mConversions;
        this.mImpressions = instance.mImpressions;
        this.mTags = instance.mTags;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InvoiceCampaign> getParser() {
        return new APIRequest.ResponseParser<InvoiceCampaign>(){

            @Override
            public APINodeList<InvoiceCampaign> parseResponse(String response, APIContext context, APIRequest<InvoiceCampaign> request) throws APIException.MalformedResponseException {
                return InvoiceCampaign.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<InvoiceCampaign> {
        InvoiceCampaign lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account_id", "billed_amount_details", "campaign_id", "campaign_name", "clicks", "conversions", "impressions", "tags", "id"};

        @Override
        public InvoiceCampaign getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InvoiceCampaign parseResponse(String response) throws APIException {
            return InvoiceCampaign.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public InvoiceCampaign execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InvoiceCampaign execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<InvoiceCampaign> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InvoiceCampaign> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, InvoiceCampaign>(){

                public InvoiceCampaign apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdAccountIdField() {
            return this.requestAdAccountIdField(true);
        }

        public APIRequestGet requestAdAccountIdField(boolean value) {
            this.requestField("ad_account_id", value);
            return this;
        }

        public APIRequestGet requestBilledAmountDetailsField() {
            return this.requestBilledAmountDetailsField(true);
        }

        public APIRequestGet requestBilledAmountDetailsField(boolean value) {
            this.requestField("billed_amount_details", value);
            return this;
        }

        public APIRequestGet requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGet requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGet requestCampaignNameField() {
            return this.requestCampaignNameField(true);
        }

        public APIRequestGet requestCampaignNameField(boolean value) {
            this.requestField("campaign_name", value);
            return this;
        }

        public APIRequestGet requestClicksField() {
            return this.requestClicksField(true);
        }

        public APIRequestGet requestClicksField(boolean value) {
            this.requestField("clicks", value);
            return this;
        }

        public APIRequestGet requestConversionsField() {
            return this.requestConversionsField(true);
        }

        public APIRequestGet requestConversionsField(boolean value) {
            this.requestField("conversions", value);
            return this;
        }

        public APIRequestGet requestImpressionsField() {
            return this.requestImpressionsField(true);
        }

        public APIRequestGet requestImpressionsField(boolean value) {
            this.requestField("impressions", value);
            return this;
        }

        public APIRequestGet requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGet requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

