/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantArticleTrafficLift
extends APINode {
    @SerializedName(value="android_confidence")
    private Double mAndroidConfidence = null;
    @SerializedName(value="android_lift")
    private Double mAndroidLift = null;
    @SerializedName(value="iphone_confidence")
    private Double mIphoneConfidence = null;
    @SerializedName(value="iphone_lift")
    private Double mIphoneLift = null;
    @SerializedName(value="overall_confidence")
    private Double mOverallConfidence = null;
    @SerializedName(value="overall_lift")
    private Double mOverallLift = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    InstantArticleTrafficLift() {
    }

    public InstantArticleTrafficLift(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public InstantArticleTrafficLift(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public InstantArticleTrafficLift fetch() throws APIException {
        InstantArticleTrafficLift newInstance = InstantArticleTrafficLift.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static InstantArticleTrafficLift fetchById(Long id, APIContext context) throws APIException {
        return InstantArticleTrafficLift.fetchById(id.toString(), context);
    }

    public static ListenableFuture<InstantArticleTrafficLift> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return InstantArticleTrafficLift.fetchByIdAsync(id.toString(), context);
    }

    public static InstantArticleTrafficLift fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<InstantArticleTrafficLift> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<InstantArticleTrafficLift> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<InstantArticleTrafficLift>(context, "", "/", "GET", InstantArticleTrafficLift.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<InstantArticleTrafficLift>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<InstantArticleTrafficLift>(context, "", "/", "GET", InstantArticleTrafficLift.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InstantArticleTrafficLift loadJSON(String json, APIContext context) {
        InstantArticleTrafficLift instantArticleTrafficLift = (InstantArticleTrafficLift)InstantArticleTrafficLift.getGson().fromJson(json, InstantArticleTrafficLift.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(instantArticleTrafficLift.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        instantArticleTrafficLift.context = context;
        instantArticleTrafficLift.rawValue = json;
        return instantArticleTrafficLift;
    }

    public static APINodeList<InstantArticleTrafficLift> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InstantArticleTrafficLift> instantArticleTrafficLifts = new APINodeList<InstantArticleTrafficLift>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        instantArticleTrafficLifts.add(InstantArticleTrafficLift.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return instantArticleTrafficLifts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            instantArticleTrafficLifts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        instantArticleTrafficLifts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            instantArticleTrafficLifts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            instantArticleTrafficLifts.add(InstantArticleTrafficLift.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                instantArticleTrafficLifts.add(InstantArticleTrafficLift.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            instantArticleTrafficLifts.add(InstantArticleTrafficLift.loadJSON(obj.toString(), context));
                        }
                    }
                    return instantArticleTrafficLifts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        instantArticleTrafficLifts.add(InstantArticleTrafficLift.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return instantArticleTrafficLifts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        instantArticleTrafficLifts.add(InstantArticleTrafficLift.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return instantArticleTrafficLifts;
                }
                instantArticleTrafficLifts.clear();
                instantArticleTrafficLifts.add(InstantArticleTrafficLift.loadJSON(json, context));
                return instantArticleTrafficLifts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InstantArticleTrafficLift.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Double getFieldAndroidConfidence() {
        return this.mAndroidConfidence;
    }

    public Double getFieldAndroidLift() {
        return this.mAndroidLift;
    }

    public Double getFieldIphoneConfidence() {
        return this.mIphoneConfidence;
    }

    public Double getFieldIphoneLift() {
        return this.mIphoneLift;
    }

    public Double getFieldOverallConfidence() {
        return this.mOverallConfidence;
    }

    public Double getFieldOverallLift() {
        return this.mOverallLift;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InstantArticleTrafficLift copyFrom(InstantArticleTrafficLift instance) {
        this.mAndroidConfidence = instance.mAndroidConfidence;
        this.mAndroidLift = instance.mAndroidLift;
        this.mIphoneConfidence = instance.mIphoneConfidence;
        this.mIphoneLift = instance.mIphoneLift;
        this.mOverallConfidence = instance.mOverallConfidence;
        this.mOverallLift = instance.mOverallLift;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InstantArticleTrafficLift> getParser() {
        return new APIRequest.ResponseParser<InstantArticleTrafficLift>(){

            @Override
            public APINodeList<InstantArticleTrafficLift> parseResponse(String response, APIContext context, APIRequest<InstantArticleTrafficLift> request) throws APIException.MalformedResponseException {
                return InstantArticleTrafficLift.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<InstantArticleTrafficLift> {
        InstantArticleTrafficLift lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"android_confidence", "android_lift", "iphone_confidence", "iphone_lift", "overall_confidence", "overall_lift", "id"};

        @Override
        public InstantArticleTrafficLift getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InstantArticleTrafficLift parseResponse(String response) throws APIException {
            return InstantArticleTrafficLift.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public InstantArticleTrafficLift execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InstantArticleTrafficLift execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<InstantArticleTrafficLift> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InstantArticleTrafficLift> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, InstantArticleTrafficLift>(){

                public InstantArticleTrafficLift apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAndroidConfidenceField() {
            return this.requestAndroidConfidenceField(true);
        }

        public APIRequestGet requestAndroidConfidenceField(boolean value) {
            this.requestField("android_confidence", value);
            return this;
        }

        public APIRequestGet requestAndroidLiftField() {
            return this.requestAndroidLiftField(true);
        }

        public APIRequestGet requestAndroidLiftField(boolean value) {
            this.requestField("android_lift", value);
            return this;
        }

        public APIRequestGet requestIphoneConfidenceField() {
            return this.requestIphoneConfidenceField(true);
        }

        public APIRequestGet requestIphoneConfidenceField(boolean value) {
            this.requestField("iphone_confidence", value);
            return this;
        }

        public APIRequestGet requestIphoneLiftField() {
            return this.requestIphoneLiftField(true);
        }

        public APIRequestGet requestIphoneLiftField(boolean value) {
            this.requestField("iphone_lift", value);
            return this;
        }

        public APIRequestGet requestOverallConfidenceField() {
            return this.requestOverallConfidenceField(true);
        }

        public APIRequestGet requestOverallConfidenceField(boolean value) {
            this.requestField("overall_confidence", value);
            return this;
        }

        public APIRequestGet requestOverallLiftField() {
            return this.requestOverallLiftField(true);
        }

        public APIRequestGet requestOverallLiftField(boolean value) {
            this.requestField("overall_lift", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

