/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InstagramInsightsValue;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstagramInsightsResult
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="period")
    private String mPeriod = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="values")
    private List<InstagramInsightsValue> mValues = null;
    protected static Gson gson = null;

    InstagramInsightsResult() {
    }

    public InstagramInsightsResult(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public InstagramInsightsResult(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public InstagramInsightsResult fetch() throws APIException {
        InstagramInsightsResult newInstance = InstagramInsightsResult.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static InstagramInsightsResult fetchById(Long id, APIContext context) throws APIException {
        return InstagramInsightsResult.fetchById(id.toString(), context);
    }

    public static ListenableFuture<InstagramInsightsResult> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return InstagramInsightsResult.fetchByIdAsync(id.toString(), context);
    }

    public static InstagramInsightsResult fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<InstagramInsightsResult> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<InstagramInsightsResult> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<InstagramInsightsResult>(context, "", "/", "GET", InstagramInsightsResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<InstagramInsightsResult>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<InstagramInsightsResult>(context, "", "/", "GET", InstagramInsightsResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InstagramInsightsResult loadJSON(String json, APIContext context) {
        InstagramInsightsResult instagramInsightsResult = (InstagramInsightsResult)InstagramInsightsResult.getGson().fromJson(json, InstagramInsightsResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(instagramInsightsResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        instagramInsightsResult.context = context;
        instagramInsightsResult.rawValue = json;
        return instagramInsightsResult;
    }

    public static APINodeList<InstagramInsightsResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InstagramInsightsResult> instagramInsightsResults = new APINodeList<InstagramInsightsResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        instagramInsightsResults.add(InstagramInsightsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return instagramInsightsResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            instagramInsightsResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        instagramInsightsResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            instagramInsightsResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            instagramInsightsResults.add(InstagramInsightsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                instagramInsightsResults.add(InstagramInsightsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            instagramInsightsResults.add(InstagramInsightsResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return instagramInsightsResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        instagramInsightsResults.add(InstagramInsightsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return instagramInsightsResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        instagramInsightsResults.add(InstagramInsightsResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return instagramInsightsResults;
                }
                instagramInsightsResults.clear();
                instagramInsightsResults.add(InstagramInsightsResult.loadJSON(json, context));
                return instagramInsightsResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InstagramInsightsResult.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPeriod() {
        return this.mPeriod;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public List<InstagramInsightsValue> getFieldValues() {
        return this.mValues;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InstagramInsightsResult copyFrom(InstagramInsightsResult instance) {
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPeriod = instance.mPeriod;
        this.mTitle = instance.mTitle;
        this.mValues = instance.mValues;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InstagramInsightsResult> getParser() {
        return new APIRequest.ResponseParser<InstagramInsightsResult>(){

            @Override
            public APINodeList<InstagramInsightsResult> parseResponse(String response, APIContext context, APIRequest<InstagramInsightsResult> request) throws APIException.MalformedResponseException {
                return InstagramInsightsResult.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPeriod {
        VALUE_DAY("day"),
        VALUE_WEEK("week"),
        VALUE_DAYS_28("days_28"),
        VALUE_MONTH("month"),
        VALUE_LIFETIME("lifetime"),
        NULL(null);

        private String value;

        private EnumPeriod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumMetric {
        VALUE_IMPRESSIONS("impressions"),
        VALUE_REACH("reach"),
        VALUE_CAROUSEL_ALBUM_IMPRESSIONS("carousel_album_impressions"),
        VALUE_CAROUSEL_ALBUM_REACH("carousel_album_reach"),
        VALUE_CAROUSEL_ALBUM_ENGAGEMENT("carousel_album_engagement"),
        VALUE_CAROUSEL_ALBUM_SAVED("carousel_album_saved"),
        VALUE_CAROUSEL_ALBUM_VIDEO_VIEWS("carousel_album_video_views"),
        VALUE_TAPS_FORWARD("taps_forward"),
        VALUE_TAPS_BACK("taps_back"),
        VALUE_EXITS("exits"),
        VALUE_REPLIES("replies"),
        VALUE_ENGAGEMENT("engagement"),
        VALUE_SAVED("saved"),
        VALUE_VIDEO_VIEWS("video_views"),
        NULL(null);

        private String value;

        private EnumMetric(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<InstagramInsightsResult> {
        InstagramInsightsResult lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"description", "id", "name", "period", "title", "values"};

        @Override
        public InstagramInsightsResult getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InstagramInsightsResult parseResponse(String response) throws APIException {
            return InstagramInsightsResult.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public InstagramInsightsResult execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InstagramInsightsResult execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<InstagramInsightsResult> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InstagramInsightsResult> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, InstagramInsightsResult>(){

                public InstagramInsightsResult apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPeriodField() {
            return this.requestPeriodField(true);
        }

        public APIRequestGet requestPeriodField(boolean value) {
            this.requestField("period", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGet requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }
    }
}

