/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalEventSourceDAStatsResult
extends APINode {
    @SerializedName(value="count_content_ids")
    private Long mCountContentIds = null;
    @SerializedName(value="count_content_ids_match_any_catalog")
    private Long mCountContentIdsMatchAnyCatalog = null;
    @SerializedName(value="count_fires")
    private Long mCountFires = null;
    @SerializedName(value="count_fires_match_any_catalog")
    private Long mCountFiresMatchAnyCatalog = null;
    @SerializedName(value="date")
    private String mDate = null;
    @SerializedName(value="percentage_missed_users")
    private Double mPercentageMissedUsers = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    ExternalEventSourceDAStatsResult() {
    }

    public ExternalEventSourceDAStatsResult(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ExternalEventSourceDAStatsResult(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ExternalEventSourceDAStatsResult fetch() throws APIException {
        ExternalEventSourceDAStatsResult newInstance = ExternalEventSourceDAStatsResult.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ExternalEventSourceDAStatsResult fetchById(Long id, APIContext context) throws APIException {
        return ExternalEventSourceDAStatsResult.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ExternalEventSourceDAStatsResult> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ExternalEventSourceDAStatsResult.fetchByIdAsync(id.toString(), context);
    }

    public static ExternalEventSourceDAStatsResult fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ExternalEventSourceDAStatsResult> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ExternalEventSourceDAStatsResult> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ExternalEventSourceDAStatsResult>(context, "", "/", "GET", ExternalEventSourceDAStatsResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ExternalEventSourceDAStatsResult>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ExternalEventSourceDAStatsResult>(context, "", "/", "GET", ExternalEventSourceDAStatsResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ExternalEventSourceDAStatsResult loadJSON(String json, APIContext context) {
        ExternalEventSourceDAStatsResult externalEventSourceDAStatsResult = (ExternalEventSourceDAStatsResult)ExternalEventSourceDAStatsResult.getGson().fromJson(json, ExternalEventSourceDAStatsResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(externalEventSourceDAStatsResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        externalEventSourceDAStatsResult.context = context;
        externalEventSourceDAStatsResult.rawValue = json;
        return externalEventSourceDAStatsResult;
    }

    public static APINodeList<ExternalEventSourceDAStatsResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ExternalEventSourceDAStatsResult> externalEventSourceDAStatsResults = new APINodeList<ExternalEventSourceDAStatsResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return externalEventSourceDAStatsResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            externalEventSourceDAStatsResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        externalEventSourceDAStatsResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            externalEventSourceDAStatsResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return externalEventSourceDAStatsResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return externalEventSourceDAStatsResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return externalEventSourceDAStatsResults;
                }
                externalEventSourceDAStatsResults.clear();
                externalEventSourceDAStatsResults.add(ExternalEventSourceDAStatsResult.loadJSON(json, context));
                return externalEventSourceDAStatsResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ExternalEventSourceDAStatsResult.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldCountContentIds() {
        return this.mCountContentIds;
    }

    public Long getFieldCountContentIdsMatchAnyCatalog() {
        return this.mCountContentIdsMatchAnyCatalog;
    }

    public Long getFieldCountFires() {
        return this.mCountFires;
    }

    public Long getFieldCountFiresMatchAnyCatalog() {
        return this.mCountFiresMatchAnyCatalog;
    }

    public String getFieldDate() {
        return this.mDate;
    }

    public Double getFieldPercentageMissedUsers() {
        return this.mPercentageMissedUsers;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ExternalEventSourceDAStatsResult copyFrom(ExternalEventSourceDAStatsResult instance) {
        this.mCountContentIds = instance.mCountContentIds;
        this.mCountContentIdsMatchAnyCatalog = instance.mCountContentIdsMatchAnyCatalog;
        this.mCountFires = instance.mCountFires;
        this.mCountFiresMatchAnyCatalog = instance.mCountFiresMatchAnyCatalog;
        this.mDate = instance.mDate;
        this.mPercentageMissedUsers = instance.mPercentageMissedUsers;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ExternalEventSourceDAStatsResult> getParser() {
        return new APIRequest.ResponseParser<ExternalEventSourceDAStatsResult>(){

            @Override
            public APINodeList<ExternalEventSourceDAStatsResult> parseResponse(String response, APIContext context, APIRequest<ExternalEventSourceDAStatsResult> request) throws APIException.MalformedResponseException {
                return ExternalEventSourceDAStatsResult.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ExternalEventSourceDAStatsResult> {
        ExternalEventSourceDAStatsResult lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"count_content_ids", "count_content_ids_match_any_catalog", "count_fires", "count_fires_match_any_catalog", "date", "percentage_missed_users", "id"};

        @Override
        public ExternalEventSourceDAStatsResult getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ExternalEventSourceDAStatsResult parseResponse(String response) throws APIException {
            return ExternalEventSourceDAStatsResult.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ExternalEventSourceDAStatsResult execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ExternalEventSourceDAStatsResult execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ExternalEventSourceDAStatsResult> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ExternalEventSourceDAStatsResult> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ExternalEventSourceDAStatsResult>(){

                public ExternalEventSourceDAStatsResult apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCountContentIdsField() {
            return this.requestCountContentIdsField(true);
        }

        public APIRequestGet requestCountContentIdsField(boolean value) {
            this.requestField("count_content_ids", value);
            return this;
        }

        public APIRequestGet requestCountContentIdsMatchAnyCatalogField() {
            return this.requestCountContentIdsMatchAnyCatalogField(true);
        }

        public APIRequestGet requestCountContentIdsMatchAnyCatalogField(boolean value) {
            this.requestField("count_content_ids_match_any_catalog", value);
            return this;
        }

        public APIRequestGet requestCountFiresField() {
            return this.requestCountFiresField(true);
        }

        public APIRequestGet requestCountFiresField(boolean value) {
            this.requestField("count_fires", value);
            return this;
        }

        public APIRequestGet requestCountFiresMatchAnyCatalogField() {
            return this.requestCountFiresMatchAnyCatalogField(true);
        }

        public APIRequestGet requestCountFiresMatchAnyCatalogField(boolean value) {
            this.requestField("count_fires_match_any_catalog", value);
            return this;
        }

        public APIRequestGet requestDateField() {
            return this.requestDateField(true);
        }

        public APIRequestGet requestDateField(boolean value) {
            this.requestField("date", value);
            return this;
        }

        public APIRequestGet requestPercentageMissedUsersField() {
            return this.requestPercentageMissedUsersField(true);
        }

        public APIRequestGet requestPercentageMissedUsersField(boolean value) {
            this.requestField("percentage_missed_users", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

