/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomConversionActivities
extends APINode {
    @SerializedName(value="app_id")
    private Object mAppId = null;
    @SerializedName(value="data")
    private String mData = null;
    @SerializedName(value="event_type")
    private String mEventType = null;
    @SerializedName(value="timestamp")
    private String mTimestamp = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    CustomConversionActivities() {
    }

    public CustomConversionActivities(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CustomConversionActivities(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CustomConversionActivities fetch() throws APIException {
        CustomConversionActivities newInstance = CustomConversionActivities.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CustomConversionActivities fetchById(Long id, APIContext context) throws APIException {
        return CustomConversionActivities.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CustomConversionActivities> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CustomConversionActivities.fetchByIdAsync(id.toString(), context);
    }

    public static CustomConversionActivities fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CustomConversionActivities> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CustomConversionActivities> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CustomConversionActivities>(context, "", "/", "GET", CustomConversionActivities.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CustomConversionActivities>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CustomConversionActivities>(context, "", "/", "GET", CustomConversionActivities.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CustomConversionActivities loadJSON(String json, APIContext context) {
        CustomConversionActivities customConversionActivities = (CustomConversionActivities)CustomConversionActivities.getGson().fromJson(json, CustomConversionActivities.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customConversionActivities.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customConversionActivities.context = context;
        customConversionActivities.rawValue = json;
        return customConversionActivities;
    }

    public static APINodeList<CustomConversionActivities> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CustomConversionActivities> customConversionActivitiess = new APINodeList<CustomConversionActivities>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customConversionActivitiess.add(CustomConversionActivities.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return customConversionActivitiess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            customConversionActivitiess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        customConversionActivitiess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            customConversionActivitiess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customConversionActivitiess.add(CustomConversionActivities.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customConversionActivitiess.add(CustomConversionActivities.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customConversionActivitiess.add(CustomConversionActivities.loadJSON(obj.toString(), context));
                        }
                    }
                    return customConversionActivitiess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customConversionActivitiess.add(CustomConversionActivities.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return customConversionActivitiess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customConversionActivitiess.add(CustomConversionActivities.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customConversionActivitiess;
                }
                customConversionActivitiess.clear();
                customConversionActivitiess.add(CustomConversionActivities.loadJSON(json, context));
                return customConversionActivitiess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomConversionActivities.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldAppId() {
        return this.mAppId;
    }

    public String getFieldData() {
        return this.mData;
    }

    public String getFieldEventType() {
        return this.mEventType;
    }

    public String getFieldTimestamp() {
        return this.mTimestamp;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomConversionActivities copyFrom(CustomConversionActivities instance) {
        this.mAppId = instance.mAppId;
        this.mData = instance.mData;
        this.mEventType = instance.mEventType;
        this.mTimestamp = instance.mTimestamp;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomConversionActivities> getParser() {
        return new APIRequest.ResponseParser<CustomConversionActivities>(){

            @Override
            public APINodeList<CustomConversionActivities> parseResponse(String response, APIContext context, APIRequest<CustomConversionActivities> request) throws APIException.MalformedResponseException {
                return CustomConversionActivities.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumEventType {
        VALUE_CONVERSION_CREATE("conversion_create"),
        VALUE_CONVERSION_DELETE("conversion_delete"),
        VALUE_CONVERSION_UPDATE("conversion_update"),
        NULL(null);

        private String value;

        private EnumEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CustomConversionActivities> {
        CustomConversionActivities lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"app_id", "data", "event_type", "timestamp", "id"};

        @Override
        public CustomConversionActivities getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomConversionActivities parseResponse(String response) throws APIException {
            return CustomConversionActivities.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomConversionActivities execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomConversionActivities execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomConversionActivities> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomConversionActivities> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomConversionActivities>(){

                public CustomConversionActivities apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGet requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGet requestDataField() {
            return this.requestDataField(true);
        }

        public APIRequestGet requestDataField(boolean value) {
            this.requestField("data", value);
            return this;
        }

        public APIRequestGet requestEventTypeField() {
            return this.requestEventTypeField(true);
        }

        public APIRequestGet requestEventTypeField(boolean value) {
            this.requestField("event_type", value);
            return this;
        }

        public APIRequestGet requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGet requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

