/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsEventTypes
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="display_name")
    private String mDisplayName = null;
    @SerializedName(value="event_name")
    private String mEventName = null;
    @SerializedName(value="parameters")
    private List<Object> mParameters = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AnalyticsEventTypes() {
    }

    public AnalyticsEventTypes(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AnalyticsEventTypes(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AnalyticsEventTypes fetch() throws APIException {
        AnalyticsEventTypes newInstance = AnalyticsEventTypes.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AnalyticsEventTypes fetchById(Long id, APIContext context) throws APIException {
        return AnalyticsEventTypes.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AnalyticsEventTypes> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AnalyticsEventTypes.fetchByIdAsync(id.toString(), context);
    }

    public static AnalyticsEventTypes fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AnalyticsEventTypes> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AnalyticsEventTypes> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AnalyticsEventTypes>(context, "", "/", "GET", AnalyticsEventTypes.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AnalyticsEventTypes>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AnalyticsEventTypes>(context, "", "/", "GET", AnalyticsEventTypes.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AnalyticsEventTypes loadJSON(String json, APIContext context) {
        AnalyticsEventTypes analyticsEventTypes = (AnalyticsEventTypes)AnalyticsEventTypes.getGson().fromJson(json, AnalyticsEventTypes.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(analyticsEventTypes.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        analyticsEventTypes.context = context;
        analyticsEventTypes.rawValue = json;
        return analyticsEventTypes;
    }

    public static APINodeList<AnalyticsEventTypes> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AnalyticsEventTypes> analyticsEventTypess = new APINodeList<AnalyticsEventTypes>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        analyticsEventTypess.add(AnalyticsEventTypes.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return analyticsEventTypess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            analyticsEventTypess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        analyticsEventTypess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            analyticsEventTypess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            analyticsEventTypess.add(AnalyticsEventTypes.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                analyticsEventTypess.add(AnalyticsEventTypes.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            analyticsEventTypess.add(AnalyticsEventTypes.loadJSON(obj.toString(), context));
                        }
                    }
                    return analyticsEventTypess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        analyticsEventTypess.add(AnalyticsEventTypes.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return analyticsEventTypess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        analyticsEventTypess.add(AnalyticsEventTypes.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return analyticsEventTypess;
                }
                analyticsEventTypess.clear();
                analyticsEventTypess.add(AnalyticsEventTypes.loadJSON(json, context));
                return analyticsEventTypess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AnalyticsEventTypes.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldDisplayName() {
        return this.mDisplayName;
    }

    public String getFieldEventName() {
        return this.mEventName;
    }

    public List<Object> getFieldParameters() {
        return this.mParameters;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AnalyticsEventTypes copyFrom(AnalyticsEventTypes instance) {
        this.mDescription = instance.mDescription;
        this.mDisplayName = instance.mDisplayName;
        this.mEventName = instance.mEventName;
        this.mParameters = instance.mParameters;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AnalyticsEventTypes> getParser() {
        return new APIRequest.ResponseParser<AnalyticsEventTypes>(){

            @Override
            public APINodeList<AnalyticsEventTypes> parseResponse(String response, APIContext context, APIRequest<AnalyticsEventTypes> request) throws APIException.MalformedResponseException {
                return AnalyticsEventTypes.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AnalyticsEventTypes> {
        AnalyticsEventTypes lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"description", "display_name", "event_name", "parameters", "id"};

        @Override
        public AnalyticsEventTypes getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AnalyticsEventTypes parseResponse(String response) throws APIException {
            return AnalyticsEventTypes.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AnalyticsEventTypes execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AnalyticsEventTypes execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AnalyticsEventTypes> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AnalyticsEventTypes> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AnalyticsEventTypes>(){

                public AnalyticsEventTypes apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestDisplayNameField() {
            return this.requestDisplayNameField(true);
        }

        public APIRequestGet requestDisplayNameField(boolean value) {
            this.requestField("display_name", value);
            return this;
        }

        public APIRequestGet requestEventNameField() {
            return this.requestEventNameField(true);
        }

        public APIRequestGet requestEventNameField(boolean value) {
            this.requestField("event_name", value);
            return this;
        }

        public APIRequestGet requestParametersField() {
            return this.requestParametersField(true);
        }

        public APIRequestGet requestParametersField(boolean value) {
            this.requestField("parameters", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

