/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsPixelRealTimeEventLogResult
extends APINode {
    @SerializedName(value="data_json")
    private String mDataJson = null;
    @SerializedName(value="device_type")
    private String mDeviceType = null;
    @SerializedName(value="event")
    private String mEvent = null;
    @SerializedName(value="event_detection_method")
    private String mEventDetectionMethod = null;
    @SerializedName(value="rule_conditions")
    private String mRuleConditions = null;
    @SerializedName(value="timestamp")
    private String mTimestamp = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdsPixelRealTimeEventLogResult() {
    }

    public AdsPixelRealTimeEventLogResult(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsPixelRealTimeEventLogResult(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsPixelRealTimeEventLogResult fetch() throws APIException {
        AdsPixelRealTimeEventLogResult newInstance = AdsPixelRealTimeEventLogResult.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsPixelRealTimeEventLogResult fetchById(Long id, APIContext context) throws APIException {
        return AdsPixelRealTimeEventLogResult.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsPixelRealTimeEventLogResult> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsPixelRealTimeEventLogResult.fetchByIdAsync(id.toString(), context);
    }

    public static AdsPixelRealTimeEventLogResult fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsPixelRealTimeEventLogResult> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsPixelRealTimeEventLogResult> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsPixelRealTimeEventLogResult>(context, "", "/", "GET", AdsPixelRealTimeEventLogResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsPixelRealTimeEventLogResult>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsPixelRealTimeEventLogResult>(context, "", "/", "GET", AdsPixelRealTimeEventLogResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsPixelRealTimeEventLogResult loadJSON(String json, APIContext context) {
        AdsPixelRealTimeEventLogResult adsPixelRealTimeEventLogResult = (AdsPixelRealTimeEventLogResult)AdsPixelRealTimeEventLogResult.getGson().fromJson(json, AdsPixelRealTimeEventLogResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsPixelRealTimeEventLogResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsPixelRealTimeEventLogResult.context = context;
        adsPixelRealTimeEventLogResult.rawValue = json;
        return adsPixelRealTimeEventLogResult;
    }

    public static APINodeList<AdsPixelRealTimeEventLogResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsPixelRealTimeEventLogResult> adsPixelRealTimeEventLogResults = new APINodeList<AdsPixelRealTimeEventLogResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsPixelRealTimeEventLogResults.add(AdsPixelRealTimeEventLogResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adsPixelRealTimeEventLogResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsPixelRealTimeEventLogResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsPixelRealTimeEventLogResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsPixelRealTimeEventLogResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsPixelRealTimeEventLogResults.add(AdsPixelRealTimeEventLogResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsPixelRealTimeEventLogResults.add(AdsPixelRealTimeEventLogResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsPixelRealTimeEventLogResults.add(AdsPixelRealTimeEventLogResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return adsPixelRealTimeEventLogResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsPixelRealTimeEventLogResults.add(AdsPixelRealTimeEventLogResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adsPixelRealTimeEventLogResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsPixelRealTimeEventLogResults.add(AdsPixelRealTimeEventLogResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsPixelRealTimeEventLogResults;
                }
                adsPixelRealTimeEventLogResults.clear();
                adsPixelRealTimeEventLogResults.add(AdsPixelRealTimeEventLogResult.loadJSON(json, context));
                return adsPixelRealTimeEventLogResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsPixelRealTimeEventLogResult.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDataJson() {
        return this.mDataJson;
    }

    public String getFieldDeviceType() {
        return this.mDeviceType;
    }

    public String getFieldEvent() {
        return this.mEvent;
    }

    public String getFieldEventDetectionMethod() {
        return this.mEventDetectionMethod;
    }

    public String getFieldRuleConditions() {
        return this.mRuleConditions;
    }

    public String getFieldTimestamp() {
        return this.mTimestamp;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsPixelRealTimeEventLogResult copyFrom(AdsPixelRealTimeEventLogResult instance) {
        this.mDataJson = instance.mDataJson;
        this.mDeviceType = instance.mDeviceType;
        this.mEvent = instance.mEvent;
        this.mEventDetectionMethod = instance.mEventDetectionMethod;
        this.mRuleConditions = instance.mRuleConditions;
        this.mTimestamp = instance.mTimestamp;
        this.mUrl = instance.mUrl;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsPixelRealTimeEventLogResult> getParser() {
        return new APIRequest.ResponseParser<AdsPixelRealTimeEventLogResult>(){

            @Override
            public APINodeList<AdsPixelRealTimeEventLogResult> parseResponse(String response, APIContext context, APIRequest<AdsPixelRealTimeEventLogResult> request) throws APIException.MalformedResponseException {
                return AdsPixelRealTimeEventLogResult.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdsPixelRealTimeEventLogResult> {
        AdsPixelRealTimeEventLogResult lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"data_json", "device_type", "event", "event_detection_method", "rule_conditions", "timestamp", "url", "id"};

        @Override
        public AdsPixelRealTimeEventLogResult getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsPixelRealTimeEventLogResult parseResponse(String response) throws APIException {
            return AdsPixelRealTimeEventLogResult.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdsPixelRealTimeEventLogResult execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsPixelRealTimeEventLogResult execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdsPixelRealTimeEventLogResult> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsPixelRealTimeEventLogResult> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdsPixelRealTimeEventLogResult>(){

                public AdsPixelRealTimeEventLogResult apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDataJsonField() {
            return this.requestDataJsonField(true);
        }

        public APIRequestGet requestDataJsonField(boolean value) {
            this.requestField("data_json", value);
            return this;
        }

        public APIRequestGet requestDeviceTypeField() {
            return this.requestDeviceTypeField(true);
        }

        public APIRequestGet requestDeviceTypeField(boolean value) {
            this.requestField("device_type", value);
            return this;
        }

        public APIRequestGet requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGet requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGet requestEventDetectionMethodField() {
            return this.requestEventDetectionMethodField(true);
        }

        public APIRequestGet requestEventDetectionMethodField(boolean value) {
            this.requestField("event_detection_method", value);
            return this;
        }

        public APIRequestGet requestRuleConditionsField() {
            return this.requestRuleConditionsField(true);
        }

        public APIRequestGet requestRuleConditionsField(boolean value) {
            this.requestField("rule_conditions", value);
            return this;
        }

        public APIRequestGet requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGet requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

