/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdNetworkAnalyticsSyncQueryResult
extends APINode {
    @SerializedName(value="query_id")
    private String mQueryId = null;
    @SerializedName(value="results")
    private List<Object> mResults = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdNetworkAnalyticsSyncQueryResult() {
    }

    public AdNetworkAnalyticsSyncQueryResult(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdNetworkAnalyticsSyncQueryResult(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdNetworkAnalyticsSyncQueryResult fetch() throws APIException {
        AdNetworkAnalyticsSyncQueryResult newInstance = AdNetworkAnalyticsSyncQueryResult.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdNetworkAnalyticsSyncQueryResult fetchById(Long id, APIContext context) throws APIException {
        return AdNetworkAnalyticsSyncQueryResult.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdNetworkAnalyticsSyncQueryResult> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdNetworkAnalyticsSyncQueryResult.fetchByIdAsync(id.toString(), context);
    }

    public static AdNetworkAnalyticsSyncQueryResult fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdNetworkAnalyticsSyncQueryResult> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdNetworkAnalyticsSyncQueryResult> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdNetworkAnalyticsSyncQueryResult>(context, "", "/", "GET", AdNetworkAnalyticsSyncQueryResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdNetworkAnalyticsSyncQueryResult>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdNetworkAnalyticsSyncQueryResult>(context, "", "/", "GET", AdNetworkAnalyticsSyncQueryResult.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdNetworkAnalyticsSyncQueryResult loadJSON(String json, APIContext context) {
        AdNetworkAnalyticsSyncQueryResult adNetworkAnalyticsSyncQueryResult = (AdNetworkAnalyticsSyncQueryResult)AdNetworkAnalyticsSyncQueryResult.getGson().fromJson(json, AdNetworkAnalyticsSyncQueryResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adNetworkAnalyticsSyncQueryResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adNetworkAnalyticsSyncQueryResult.context = context;
        adNetworkAnalyticsSyncQueryResult.rawValue = json;
        return adNetworkAnalyticsSyncQueryResult;
    }

    public static APINodeList<AdNetworkAnalyticsSyncQueryResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdNetworkAnalyticsSyncQueryResult> adNetworkAnalyticsSyncQueryResults = new APINodeList<AdNetworkAnalyticsSyncQueryResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adNetworkAnalyticsSyncQueryResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adNetworkAnalyticsSyncQueryResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adNetworkAnalyticsSyncQueryResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adNetworkAnalyticsSyncQueryResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return adNetworkAnalyticsSyncQueryResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adNetworkAnalyticsSyncQueryResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adNetworkAnalyticsSyncQueryResults;
                }
                adNetworkAnalyticsSyncQueryResults.clear();
                adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(json, context));
                return adNetworkAnalyticsSyncQueryResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdNetworkAnalyticsSyncQueryResult.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldQueryId() {
        return this.mQueryId;
    }

    public List<Object> getFieldResults() {
        return this.mResults;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdNetworkAnalyticsSyncQueryResult copyFrom(AdNetworkAnalyticsSyncQueryResult instance) {
        this.mQueryId = instance.mQueryId;
        this.mResults = instance.mResults;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdNetworkAnalyticsSyncQueryResult> getParser() {
        return new APIRequest.ResponseParser<AdNetworkAnalyticsSyncQueryResult>(){

            @Override
            public APINodeList<AdNetworkAnalyticsSyncQueryResult> parseResponse(String response, APIContext context, APIRequest<AdNetworkAnalyticsSyncQueryResult> request) throws APIException.MalformedResponseException {
                return AdNetworkAnalyticsSyncQueryResult.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOrderingType {
        VALUE_ASCENDING("ASCENDING"),
        VALUE_DESCENDING("DESCENDING"),
        NULL(null);

        private String value;

        private EnumOrderingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOrderingColumn {
        VALUE_TIME("TIME"),
        VALUE_VALUE("VALUE"),
        VALUE_METRIC("METRIC"),
        NULL(null);

        private String value;

        private EnumOrderingColumn(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumMetrics {
        VALUE_FB_AD_NETWORK_BIDDING_REQUEST("FB_AD_NETWORK_BIDDING_REQUEST"),
        VALUE_FB_AD_NETWORK_BIDDING_RESPONSE("FB_AD_NETWORK_BIDDING_RESPONSE"),
        VALUE_FB_AD_NETWORK_BIDDING_BID_RATE("FB_AD_NETWORK_BIDDING_BID_RATE"),
        VALUE_FB_AD_NETWORK_BIDDING_WIN_RATE("FB_AD_NETWORK_BIDDING_WIN_RATE"),
        VALUE_FB_AD_NETWORK_REQUEST("FB_AD_NETWORK_REQUEST"),
        VALUE_FB_AD_NETWORK_FILLED_REQUEST("FB_AD_NETWORK_FILLED_REQUEST"),
        VALUE_FB_AD_NETWORK_FILL_RATE("FB_AD_NETWORK_FILL_RATE"),
        VALUE_FB_AD_NETWORK_IMP("FB_AD_NETWORK_IMP"),
        VALUE_FB_AD_NETWORK_SHOW_RATE("FB_AD_NETWORK_SHOW_RATE"),
        VALUE_FB_AD_NETWORK_CLICK("FB_AD_NETWORK_CLICK"),
        VALUE_FB_AD_NETWORK_CTR("FB_AD_NETWORK_CTR"),
        VALUE_FB_AD_NETWORK_BIDDING_REVENUE("FB_AD_NETWORK_BIDDING_REVENUE"),
        VALUE_FB_AD_NETWORK_REVENUE("FB_AD_NETWORK_REVENUE"),
        VALUE_FB_AD_NETWORK_CPM("FB_AD_NETWORK_CPM"),
        VALUE_FB_AD_NETWORK_VIDEO_GUARANTEE_REVENUE("FB_AD_NETWORK_VIDEO_GUARANTEE_REVENUE"),
        VALUE_FB_AD_NETWORK_VIDEO_VIEW("FB_AD_NETWORK_VIDEO_VIEW"),
        VALUE_FB_AD_NETWORK_VIDEO_VIEW_RATE("FB_AD_NETWORK_VIDEO_VIEW_RATE"),
        VALUE_FB_AD_NETWORK_VIDEO_MRC("FB_AD_NETWORK_VIDEO_MRC"),
        VALUE_FB_AD_NETWORK_VIDEO_MRC_RATE("FB_AD_NETWORK_VIDEO_MRC_RATE"),
        VALUE_FB_AD_NETWORK_WIN_RATE("FB_AD_NETWORK_WIN_RATE"),
        VALUE_FB_AD_NETWORK_DIRECT_TOTAL_REVENUE("FB_AD_NETWORK_DIRECT_TOTAL_REVENUE"),
        VALUE_FB_AD_NETWORK_DIRECT_PUBLISHER_BILL("FB_AD_NETWORK_DIRECT_PUBLISHER_BILL"),
        VALUE_FB_AD_NETWORK_FAST_CLICK_RATE("FB_AD_NETWORK_FAST_CLICK_RATE"),
        VALUE_FB_AD_NETWORK_FAST_RETURN_RATE("FB_AD_NETWORK_FAST_RETURN_RATE"),
        VALUE_FB_AD_NETWORK_CLICK_VALUE_SCORE("FB_AD_NETWORK_CLICK_VALUE_SCORE"),
        VALUE_FB_AD_NETWORK_FAST_CLICK_NUMERATOR("FB_AD_NETWORK_FAST_CLICK_NUMERATOR"),
        VALUE_FB_AD_NETWORK_FAST_CLICK_DENOMINATOR("FB_AD_NETWORK_FAST_CLICK_DENOMINATOR"),
        VALUE_FB_AD_NETWORK_FAST_RETURN_NUMERATOR("FB_AD_NETWORK_FAST_RETURN_NUMERATOR"),
        VALUE_FB_AD_NETWORK_FAST_RETURN_DENOMINATOR("FB_AD_NETWORK_FAST_RETURN_DENOMINATOR"),
        VALUE_FB_AD_NETWORK_CLICK_VALUE_SCORE_NUMERATOR("FB_AD_NETWORK_CLICK_VALUE_SCORE_NUMERATOR"),
        VALUE_FB_AD_NETWORK_CLICK_VALUE_SCORE_DENOMINATOR("FB_AD_NETWORK_CLICK_VALUE_SCORE_DENOMINATOR"),
        NULL(null);

        private String value;

        private EnumMetrics(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBreakdowns {
        VALUE_AGE("AGE"),
        VALUE_APP("APP"),
        VALUE_COUNTRY("COUNTRY"),
        VALUE_DELIVERY_METHOD("DELIVERY_METHOD"),
        VALUE_DISPLAY_FORMAT("DISPLAY_FORMAT"),
        VALUE_DEAL("DEAL"),
        VALUE_DEAL_AD("DEAL_AD"),
        VALUE_DEAL_PAGE("DEAL_PAGE"),
        VALUE_GENDER("GENDER"),
        VALUE_PLACEMENT("PLACEMENT"),
        VALUE_PLATFORM("PLATFORM"),
        VALUE_PROPERTY("PROPERTY"),
        VALUE_CLICKED_VIEW_TAG("CLICKED_VIEW_TAG"),
        NULL(null);

        private String value;

        private EnumBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAggregationPeriod {
        VALUE_HOUR("HOUR"),
        VALUE_DAY("DAY"),
        VALUE_TOTAL("TOTAL"),
        NULL(null);

        private String value;

        private EnumAggregationPeriod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdNetworkAnalyticsSyncQueryResult> {
        AdNetworkAnalyticsSyncQueryResult lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"query_id", "results", "id"};

        @Override
        public AdNetworkAnalyticsSyncQueryResult getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdNetworkAnalyticsSyncQueryResult parseResponse(String response) throws APIException {
            return AdNetworkAnalyticsSyncQueryResult.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdNetworkAnalyticsSyncQueryResult execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdNetworkAnalyticsSyncQueryResult execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdNetworkAnalyticsSyncQueryResult> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdNetworkAnalyticsSyncQueryResult> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdNetworkAnalyticsSyncQueryResult>(){

                public AdNetworkAnalyticsSyncQueryResult apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestQueryIdField() {
            return this.requestQueryIdField(true);
        }

        public APIRequestGet requestQueryIdField(boolean value) {
            this.requestField("query_id", value);
            return this;
        }

        public APIRequestGet requestResultsField() {
            return this.requestResultsField(true);
        }

        public APIRequestGet requestResultsField(boolean value) {
            this.requestField("results", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

