/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeCollectionThumbnailInfo;
import com.facebook.ads.sdk.AdCreativeLinkDataCallToAction;
import com.facebook.ads.sdk.AdCreativePostClickConfiguration;
import com.facebook.ads.sdk.AdCreativeVideoDataCustomOverlaySpec;
import com.facebook.ads.sdk.Targeting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeVideoData
extends APINode {
    @SerializedName(value="additional_image_index")
    private Long mAdditionalImageIndex = null;
    @SerializedName(value="branded_content_shared_to_sponsor_status")
    private String mBrandedContentSharedToSponsorStatus = null;
    @SerializedName(value="branded_content_sponsor_page_id")
    private String mBrandedContentSponsorPageId = null;
    @SerializedName(value="branded_content_sponsor_relationship")
    private String mBrandedContentSponsorRelationship = null;
    @SerializedName(value="call_to_action")
    private AdCreativeLinkDataCallToAction mCallToAction = null;
    @SerializedName(value="collection_thumbnails")
    private List<AdCreativeCollectionThumbnailInfo> mCollectionThumbnails = null;
    @SerializedName(value="custom_overlay_spec")
    private List<AdCreativeVideoDataCustomOverlaySpec> mCustomOverlaySpec = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="image_hash")
    private String mImageHash = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="link_description")
    private String mLinkDescription = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="offer_id")
    private String mOfferId = null;
    @SerializedName(value="page_welcome_message")
    private String mPageWelcomeMessage = null;
    @SerializedName(value="post_click_configuration")
    private AdCreativePostClickConfiguration mPostClickConfiguration = null;
    @SerializedName(value="retailer_item_ids")
    private List<String> mRetailerItemIds = null;
    @SerializedName(value="targeting")
    private Targeting mTargeting = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCreativeVideoData() {
    }

    public AdCreativeVideoData(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativeVideoData(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativeVideoData fetch() throws APIException {
        AdCreativeVideoData newInstance = AdCreativeVideoData.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativeVideoData fetchById(Long id, APIContext context) throws APIException {
        return AdCreativeVideoData.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativeVideoData> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativeVideoData.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativeVideoData fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativeVideoData> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativeVideoData> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativeVideoData>(context, "", "/", "GET", AdCreativeVideoData.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativeVideoData>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativeVideoData>(context, "", "/", "GET", AdCreativeVideoData.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeVideoData loadJSON(String json, APIContext context) {
        AdCreativeVideoData adCreativeVideoData = (AdCreativeVideoData)AdCreativeVideoData.getGson().fromJson(json, AdCreativeVideoData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeVideoData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeVideoData.context = context;
        adCreativeVideoData.rawValue = json;
        return adCreativeVideoData;
    }

    public static APINodeList<AdCreativeVideoData> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeVideoData> adCreativeVideoDatas = new APINodeList<AdCreativeVideoData>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeVideoDatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeVideoDatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeVideoDatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeVideoDatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeVideoDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeVideoDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeVideoDatas;
                }
                adCreativeVideoDatas.clear();
                adCreativeVideoDatas.add(AdCreativeVideoData.loadJSON(json, context));
                return adCreativeVideoDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeVideoData.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAdditionalImageIndex() {
        return this.mAdditionalImageIndex;
    }

    public String getFieldBrandedContentSharedToSponsorStatus() {
        return this.mBrandedContentSharedToSponsorStatus;
    }

    public String getFieldBrandedContentSponsorPageId() {
        return this.mBrandedContentSponsorPageId;
    }

    public String getFieldBrandedContentSponsorRelationship() {
        return this.mBrandedContentSponsorRelationship;
    }

    public AdCreativeLinkDataCallToAction getFieldCallToAction() {
        if (this.mCallToAction != null) {
            this.mCallToAction.context = this.getContext();
        }
        return this.mCallToAction;
    }

    public List<AdCreativeCollectionThumbnailInfo> getFieldCollectionThumbnails() {
        return this.mCollectionThumbnails;
    }

    public List<AdCreativeVideoDataCustomOverlaySpec> getFieldCustomOverlaySpec() {
        return this.mCustomOverlaySpec;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldImageHash() {
        return this.mImageHash;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public String getFieldLinkDescription() {
        return this.mLinkDescription;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public String getFieldOfferId() {
        return this.mOfferId;
    }

    public String getFieldPageWelcomeMessage() {
        return this.mPageWelcomeMessage;
    }

    public AdCreativePostClickConfiguration getFieldPostClickConfiguration() {
        if (this.mPostClickConfiguration != null) {
            this.mPostClickConfiguration.context = this.getContext();
        }
        return this.mPostClickConfiguration;
    }

    public List<String> getFieldRetailerItemIds() {
        return this.mRetailerItemIds;
    }

    public Targeting getFieldTargeting() {
        if (this.mTargeting != null) {
            this.mTargeting.context = this.getContext();
        }
        return this.mTargeting;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeVideoData copyFrom(AdCreativeVideoData instance) {
        this.mAdditionalImageIndex = instance.mAdditionalImageIndex;
        this.mBrandedContentSharedToSponsorStatus = instance.mBrandedContentSharedToSponsorStatus;
        this.mBrandedContentSponsorPageId = instance.mBrandedContentSponsorPageId;
        this.mBrandedContentSponsorRelationship = instance.mBrandedContentSponsorRelationship;
        this.mCallToAction = instance.mCallToAction;
        this.mCollectionThumbnails = instance.mCollectionThumbnails;
        this.mCustomOverlaySpec = instance.mCustomOverlaySpec;
        this.mDescription = instance.mDescription;
        this.mImageHash = instance.mImageHash;
        this.mImageUrl = instance.mImageUrl;
        this.mLinkDescription = instance.mLinkDescription;
        this.mMessage = instance.mMessage;
        this.mOfferId = instance.mOfferId;
        this.mPageWelcomeMessage = instance.mPageWelcomeMessage;
        this.mPostClickConfiguration = instance.mPostClickConfiguration;
        this.mRetailerItemIds = instance.mRetailerItemIds;
        this.mTargeting = instance.mTargeting;
        this.mTitle = instance.mTitle;
        this.mVideoId = instance.mVideoId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeVideoData> getParser() {
        return new APIRequest.ResponseParser<AdCreativeVideoData>(){

            @Override
            public APINodeList<AdCreativeVideoData> parseResponse(String response, APIContext context, APIRequest<AdCreativeVideoData> request) throws APIException.MalformedResponseException {
                return AdCreativeVideoData.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativeVideoData> {
        AdCreativeVideoData lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"additional_image_index", "branded_content_shared_to_sponsor_status", "branded_content_sponsor_page_id", "branded_content_sponsor_relationship", "call_to_action", "collection_thumbnails", "custom_overlay_spec", "description", "image_hash", "image_url", "link_description", "message", "offer_id", "page_welcome_message", "post_click_configuration", "retailer_item_ids", "targeting", "title", "video_id", "id"};

        @Override
        public AdCreativeVideoData getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativeVideoData parseResponse(String response) throws APIException {
            return AdCreativeVideoData.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativeVideoData execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativeVideoData execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativeVideoData> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativeVideoData> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativeVideoData>(){

                public AdCreativeVideoData apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdditionalImageIndexField() {
            return this.requestAdditionalImageIndexField(true);
        }

        public APIRequestGet requestAdditionalImageIndexField(boolean value) {
            this.requestField("additional_image_index", value);
            return this;
        }

        public APIRequestGet requestBrandedContentSharedToSponsorStatusField() {
            return this.requestBrandedContentSharedToSponsorStatusField(true);
        }

        public APIRequestGet requestBrandedContentSharedToSponsorStatusField(boolean value) {
            this.requestField("branded_content_shared_to_sponsor_status", value);
            return this;
        }

        public APIRequestGet requestBrandedContentSponsorPageIdField() {
            return this.requestBrandedContentSponsorPageIdField(true);
        }

        public APIRequestGet requestBrandedContentSponsorPageIdField(boolean value) {
            this.requestField("branded_content_sponsor_page_id", value);
            return this;
        }

        public APIRequestGet requestBrandedContentSponsorRelationshipField() {
            return this.requestBrandedContentSponsorRelationshipField(true);
        }

        public APIRequestGet requestBrandedContentSponsorRelationshipField(boolean value) {
            this.requestField("branded_content_sponsor_relationship", value);
            return this;
        }

        public APIRequestGet requestCallToActionField() {
            return this.requestCallToActionField(true);
        }

        public APIRequestGet requestCallToActionField(boolean value) {
            this.requestField("call_to_action", value);
            return this;
        }

        public APIRequestGet requestCollectionThumbnailsField() {
            return this.requestCollectionThumbnailsField(true);
        }

        public APIRequestGet requestCollectionThumbnailsField(boolean value) {
            this.requestField("collection_thumbnails", value);
            return this;
        }

        public APIRequestGet requestCustomOverlaySpecField() {
            return this.requestCustomOverlaySpecField(true);
        }

        public APIRequestGet requestCustomOverlaySpecField(boolean value) {
            this.requestField("custom_overlay_spec", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestImageHashField() {
            return this.requestImageHashField(true);
        }

        public APIRequestGet requestImageHashField(boolean value) {
            this.requestField("image_hash", value);
            return this;
        }

        public APIRequestGet requestImageUrlField() {
            return this.requestImageUrlField(true);
        }

        public APIRequestGet requestImageUrlField(boolean value) {
            this.requestField("image_url", value);
            return this;
        }

        public APIRequestGet requestLinkDescriptionField() {
            return this.requestLinkDescriptionField(true);
        }

        public APIRequestGet requestLinkDescriptionField(boolean value) {
            this.requestField("link_description", value);
            return this;
        }

        public APIRequestGet requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGet requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGet requestOfferIdField() {
            return this.requestOfferIdField(true);
        }

        public APIRequestGet requestOfferIdField(boolean value) {
            this.requestField("offer_id", value);
            return this;
        }

        public APIRequestGet requestPageWelcomeMessageField() {
            return this.requestPageWelcomeMessageField(true);
        }

        public APIRequestGet requestPageWelcomeMessageField(boolean value) {
            this.requestField("page_welcome_message", value);
            return this;
        }

        public APIRequestGet requestPostClickConfigurationField() {
            return this.requestPostClickConfigurationField(true);
        }

        public APIRequestGet requestPostClickConfigurationField(boolean value) {
            this.requestField("post_click_configuration", value);
            return this;
        }

        public APIRequestGet requestRetailerItemIdsField() {
            return this.requestRetailerItemIdsField(true);
        }

        public APIRequestGet requestRetailerItemIdsField(boolean value) {
            this.requestField("retailer_item_ids", value);
            return this;
        }

        public APIRequestGet requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGet requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestVideoIdField() {
            return this.requestVideoIdField(true);
        }

        public APIRequestGet requestVideoIdField(boolean value) {
            this.requestField("video_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

