/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeLinkDataCustomOverlaySpec
extends APINode {
    @SerializedName(value="background_color")
    private EnumBackgroundColor mBackgroundColor = null;
    @SerializedName(value="float_with_margin")
    private Boolean mFloatWithMargin = null;
    @SerializedName(value="font")
    private EnumFont mFont = null;
    @SerializedName(value="option")
    private EnumOption mOption = null;
    @SerializedName(value="position")
    private EnumPosition mPosition = null;
    @SerializedName(value="render_with_icon")
    private Boolean mRenderWithIcon = null;
    @SerializedName(value="template")
    private EnumTemplate mTemplate = null;
    @SerializedName(value="text_color")
    private EnumTextColor mTextColor = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCreativeLinkDataCustomOverlaySpec() {
    }

    public AdCreativeLinkDataCustomOverlaySpec(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativeLinkDataCustomOverlaySpec(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativeLinkDataCustomOverlaySpec fetch() throws APIException {
        AdCreativeLinkDataCustomOverlaySpec newInstance = AdCreativeLinkDataCustomOverlaySpec.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativeLinkDataCustomOverlaySpec fetchById(Long id, APIContext context) throws APIException {
        return AdCreativeLinkDataCustomOverlaySpec.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativeLinkDataCustomOverlaySpec> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativeLinkDataCustomOverlaySpec.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativeLinkDataCustomOverlaySpec fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativeLinkDataCustomOverlaySpec> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativeLinkDataCustomOverlaySpec> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativeLinkDataCustomOverlaySpec>(context, "", "/", "GET", AdCreativeLinkDataCustomOverlaySpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativeLinkDataCustomOverlaySpec>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativeLinkDataCustomOverlaySpec>(context, "", "/", "GET", AdCreativeLinkDataCustomOverlaySpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeLinkDataCustomOverlaySpec loadJSON(String json, APIContext context) {
        AdCreativeLinkDataCustomOverlaySpec adCreativeLinkDataCustomOverlaySpec = (AdCreativeLinkDataCustomOverlaySpec)AdCreativeLinkDataCustomOverlaySpec.getGson().fromJson(json, AdCreativeLinkDataCustomOverlaySpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeLinkDataCustomOverlaySpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeLinkDataCustomOverlaySpec.context = context;
        adCreativeLinkDataCustomOverlaySpec.rawValue = json;
        return adCreativeLinkDataCustomOverlaySpec;
    }

    public static APINodeList<AdCreativeLinkDataCustomOverlaySpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeLinkDataCustomOverlaySpec> adCreativeLinkDataCustomOverlaySpecs = new APINodeList<AdCreativeLinkDataCustomOverlaySpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeLinkDataCustomOverlaySpecs.add(AdCreativeLinkDataCustomOverlaySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeLinkDataCustomOverlaySpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeLinkDataCustomOverlaySpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeLinkDataCustomOverlaySpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeLinkDataCustomOverlaySpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeLinkDataCustomOverlaySpecs.add(AdCreativeLinkDataCustomOverlaySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeLinkDataCustomOverlaySpecs.add(AdCreativeLinkDataCustomOverlaySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeLinkDataCustomOverlaySpecs.add(AdCreativeLinkDataCustomOverlaySpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeLinkDataCustomOverlaySpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeLinkDataCustomOverlaySpecs.add(AdCreativeLinkDataCustomOverlaySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeLinkDataCustomOverlaySpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeLinkDataCustomOverlaySpecs.add(AdCreativeLinkDataCustomOverlaySpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeLinkDataCustomOverlaySpecs;
                }
                adCreativeLinkDataCustomOverlaySpecs.clear();
                adCreativeLinkDataCustomOverlaySpecs.add(AdCreativeLinkDataCustomOverlaySpec.loadJSON(json, context));
                return adCreativeLinkDataCustomOverlaySpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeLinkDataCustomOverlaySpec.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public EnumBackgroundColor getFieldBackgroundColor() {
        return this.mBackgroundColor;
    }

    public Boolean getFieldFloatWithMargin() {
        return this.mFloatWithMargin;
    }

    public EnumFont getFieldFont() {
        return this.mFont;
    }

    public EnumOption getFieldOption() {
        return this.mOption;
    }

    public EnumPosition getFieldPosition() {
        return this.mPosition;
    }

    public Boolean getFieldRenderWithIcon() {
        return this.mRenderWithIcon;
    }

    public EnumTemplate getFieldTemplate() {
        return this.mTemplate;
    }

    public EnumTextColor getFieldTextColor() {
        return this.mTextColor;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeLinkDataCustomOverlaySpec copyFrom(AdCreativeLinkDataCustomOverlaySpec instance) {
        this.mBackgroundColor = instance.mBackgroundColor;
        this.mFloatWithMargin = instance.mFloatWithMargin;
        this.mFont = instance.mFont;
        this.mOption = instance.mOption;
        this.mPosition = instance.mPosition;
        this.mRenderWithIcon = instance.mRenderWithIcon;
        this.mTemplate = instance.mTemplate;
        this.mTextColor = instance.mTextColor;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeLinkDataCustomOverlaySpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeLinkDataCustomOverlaySpec>(){

            @Override
            public APINodeList<AdCreativeLinkDataCustomOverlaySpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeLinkDataCustomOverlaySpec> request) throws APIException.MalformedResponseException {
                return AdCreativeLinkDataCustomOverlaySpec.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTextColor {
        VALUE_TEXT_FFFFFF("text_ffffff"),
        VALUE_TEXT_C91B00("text_c91b00"),
        VALUE_TEXT_F78400("text_f78400"),
        VALUE_TEXT_009C2A("text_009c2a"),
        VALUE_TEXT_007AD0("text_007ad0"),
        VALUE_TEXT_755DDE("text_755dde"),
        VALUE_TEXT_F23474("text_f23474"),
        VALUE_TEXT_646464("text_646464"),
        VALUE_TEXT_000000("text_000000"),
        NULL(null);

        private String value;

        private EnumTextColor(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTemplate {
        VALUE_PILL_WITH_TEXT("pill_with_text"),
        NULL(null);

        private String value;

        private EnumTemplate(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPosition {
        VALUE_TOP_LEFT("top_left"),
        VALUE_TOP_RIGHT("top_right"),
        VALUE_BOTTOM_LEFT("bottom_left"),
        VALUE_BOTTOM_RIGHT("bottom_right"),
        NULL(null);

        private String value;

        private EnumPosition(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOption {
        VALUE_BANK_TRANSFER("bank_transfer"),
        VALUE_BOLETO("boleto"),
        VALUE_DISCOUNT_WITH_BOLETO("discount_with_boleto"),
        VALUE_CASH_ON_DELIVERY("cash_on_delivery"),
        VALUE_HOME_DELIVERY("home_delivery"),
        VALUE_FREE_SHIPPING("free_shipping"),
        VALUE_INVENTORY("inventory"),
        VALUE_PAY_ON_ARRIVAL("pay_on_arrival"),
        VALUE_PAY_AT_HOTEL("pay_at_hotel"),
        VALUE_FAST_DELIVERY("fast_delivery"),
        NULL(null);

        private String value;

        private EnumOption(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFont {
        VALUE_DROID_SERIF_REGULAR("droid_serif_regular"),
        VALUE_LATO_REGULAR("lato_regular"),
        VALUE_NUNITO_SANS_BOLD("nunito_sans_bold"),
        VALUE_OPEN_SANS_BOLD("open_sans_bold"),
        VALUE_PT_SERIF_BOLD("pt_serif_bold"),
        VALUE_ROBOTO_MEDIUM("roboto_medium"),
        VALUE_ROBOTO_CONDENSED_REGULAR("roboto_condensed_regular"),
        VALUE_NOTO_SANS_REGULAR("noto_sans_regular"),
        NULL(null);

        private String value;

        private EnumFont(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBackgroundColor {
        VALUE_BACKGROUND_FFFFFF("background_ffffff"),
        VALUE_BACKGROUND_E50900("background_e50900"),
        VALUE_BACKGROUND_F78400("background_f78400"),
        VALUE_BACKGROUND_00AF4C("background_00af4c"),
        VALUE_BACKGROUND_0090FF("background_0090ff"),
        VALUE_BACKGROUND_755DDE("background_755dde"),
        VALUE_BACKGROUND_F23474("background_f23474"),
        VALUE_BACKGROUND_595959("background_595959"),
        VALUE_BACKGROUND_000000("background_000000"),
        NULL(null);

        private String value;

        private EnumBackgroundColor(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativeLinkDataCustomOverlaySpec> {
        AdCreativeLinkDataCustomOverlaySpec lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"background_color", "float_with_margin", "font", "option", "position", "render_with_icon", "template", "text_color", "id"};

        @Override
        public AdCreativeLinkDataCustomOverlaySpec getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativeLinkDataCustomOverlaySpec parseResponse(String response) throws APIException {
            return AdCreativeLinkDataCustomOverlaySpec.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativeLinkDataCustomOverlaySpec execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativeLinkDataCustomOverlaySpec execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativeLinkDataCustomOverlaySpec> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativeLinkDataCustomOverlaySpec> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativeLinkDataCustomOverlaySpec>(){

                public AdCreativeLinkDataCustomOverlaySpec apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBackgroundColorField() {
            return this.requestBackgroundColorField(true);
        }

        public APIRequestGet requestBackgroundColorField(boolean value) {
            this.requestField("background_color", value);
            return this;
        }

        public APIRequestGet requestFloatWithMarginField() {
            return this.requestFloatWithMarginField(true);
        }

        public APIRequestGet requestFloatWithMarginField(boolean value) {
            this.requestField("float_with_margin", value);
            return this;
        }

        public APIRequestGet requestFontField() {
            return this.requestFontField(true);
        }

        public APIRequestGet requestFontField(boolean value) {
            this.requestField("font", value);
            return this;
        }

        public APIRequestGet requestOptionField() {
            return this.requestOptionField(true);
        }

        public APIRequestGet requestOptionField(boolean value) {
            this.requestField("option", value);
            return this;
        }

        public APIRequestGet requestPositionField() {
            return this.requestPositionField(true);
        }

        public APIRequestGet requestPositionField(boolean value) {
            this.requestField("position", value);
            return this;
        }

        public APIRequestGet requestRenderWithIconField() {
            return this.requestRenderWithIconField(true);
        }

        public APIRequestGet requestRenderWithIconField(boolean value) {
            this.requestField("render_with_icon", value);
            return this;
        }

        public APIRequestGet requestTemplateField() {
            return this.requestTemplateField(true);
        }

        public APIRequestGet requestTemplateField(boolean value) {
            this.requestField("template", value);
            return this;
        }

        public APIRequestGet requestTextColorField() {
            return this.requestTextColorField(true);
        }

        public APIRequestGet requestTextColorField(boolean value) {
            this.requestField("text_color", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

