/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAssetFeedSpecAssetLabel;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAssetFeedSpecVideo
extends APINode {
    @SerializedName(value="adlabels")
    private List<AdAssetFeedSpecAssetLabel> mAdlabels = null;
    @SerializedName(value="caption_ids")
    private List<String> mCaptionIds = null;
    @SerializedName(value="thumbnail_hash")
    private String mThumbnailHash = null;
    @SerializedName(value="thumbnail_url")
    private String mThumbnailUrl = null;
    @SerializedName(value="url_tags")
    private String mUrlTags = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdAssetFeedSpecVideo() {
    }

    public AdAssetFeedSpecVideo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAssetFeedSpecVideo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAssetFeedSpecVideo fetch() throws APIException {
        AdAssetFeedSpecVideo newInstance = AdAssetFeedSpecVideo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAssetFeedSpecVideo fetchById(Long id, APIContext context) throws APIException {
        return AdAssetFeedSpecVideo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAssetFeedSpecVideo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAssetFeedSpecVideo.fetchByIdAsync(id.toString(), context);
    }

    public static AdAssetFeedSpecVideo fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAssetFeedSpecVideo> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAssetFeedSpecVideo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAssetFeedSpecVideo>(context, "", "/", "GET", AdAssetFeedSpecVideo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAssetFeedSpecVideo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAssetFeedSpecVideo>(context, "", "/", "GET", AdAssetFeedSpecVideo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAssetFeedSpecVideo loadJSON(String json, APIContext context) {
        AdAssetFeedSpecVideo adAssetFeedSpecVideo = (AdAssetFeedSpecVideo)AdAssetFeedSpecVideo.getGson().fromJson(json, AdAssetFeedSpecVideo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetFeedSpecVideo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetFeedSpecVideo.context = context;
        adAssetFeedSpecVideo.rawValue = json;
        return adAssetFeedSpecVideo;
    }

    public static APINodeList<AdAssetFeedSpecVideo> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAssetFeedSpecVideo> adAssetFeedSpecVideos = new APINodeList<AdAssetFeedSpecVideo>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetFeedSpecVideos.add(AdAssetFeedSpecVideo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAssetFeedSpecVideos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetFeedSpecVideos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetFeedSpecVideos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAssetFeedSpecVideos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetFeedSpecVideos.add(AdAssetFeedSpecVideo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetFeedSpecVideos.add(AdAssetFeedSpecVideo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetFeedSpecVideos.add(AdAssetFeedSpecVideo.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAssetFeedSpecVideos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetFeedSpecVideos.add(AdAssetFeedSpecVideo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAssetFeedSpecVideos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetFeedSpecVideos.add(AdAssetFeedSpecVideo.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetFeedSpecVideos;
                }
                adAssetFeedSpecVideos.clear();
                adAssetFeedSpecVideos.add(AdAssetFeedSpecVideo.loadJSON(json, context));
                return adAssetFeedSpecVideos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetFeedSpecVideo.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<AdAssetFeedSpecAssetLabel> getFieldAdlabels() {
        return this.mAdlabels;
    }

    public List<String> getFieldCaptionIds() {
        return this.mCaptionIds;
    }

    public String getFieldThumbnailHash() {
        return this.mThumbnailHash;
    }

    public String getFieldThumbnailUrl() {
        return this.mThumbnailUrl;
    }

    public String getFieldUrlTags() {
        return this.mUrlTags;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetFeedSpecVideo copyFrom(AdAssetFeedSpecVideo instance) {
        this.mAdlabels = instance.mAdlabels;
        this.mCaptionIds = instance.mCaptionIds;
        this.mThumbnailHash = instance.mThumbnailHash;
        this.mThumbnailUrl = instance.mThumbnailUrl;
        this.mUrlTags = instance.mUrlTags;
        this.mVideoId = instance.mVideoId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetFeedSpecVideo> getParser() {
        return new APIRequest.ResponseParser<AdAssetFeedSpecVideo>(){

            @Override
            public APINodeList<AdAssetFeedSpecVideo> parseResponse(String response, APIContext context, APIRequest<AdAssetFeedSpecVideo> request) throws APIException.MalformedResponseException {
                return AdAssetFeedSpecVideo.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAssetFeedSpecVideo> {
        AdAssetFeedSpecVideo lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"adlabels", "caption_ids", "thumbnail_hash", "thumbnail_url", "url_tags", "video_id", "id"};

        @Override
        public AdAssetFeedSpecVideo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAssetFeedSpecVideo parseResponse(String response) throws APIException {
            return AdAssetFeedSpecVideo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAssetFeedSpecVideo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAssetFeedSpecVideo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAssetFeedSpecVideo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAssetFeedSpecVideo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAssetFeedSpecVideo>(){

                public AdAssetFeedSpecVideo apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGet requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGet requestCaptionIdsField() {
            return this.requestCaptionIdsField(true);
        }

        public APIRequestGet requestCaptionIdsField(boolean value) {
            this.requestField("caption_ids", value);
            return this;
        }

        public APIRequestGet requestThumbnailHashField() {
            return this.requestThumbnailHashField(true);
        }

        public APIRequestGet requestThumbnailHashField(boolean value) {
            this.requestField("thumbnail_hash", value);
            return this;
        }

        public APIRequestGet requestThumbnailUrlField() {
            return this.requestThumbnailUrlField(true);
        }

        public APIRequestGet requestThumbnailUrlField(boolean value) {
            this.requestField("thumbnail_url", value);
            return this;
        }

        public APIRequestGet requestUrlTagsField() {
            return this.requestUrlTagsField(true);
        }

        public APIRequestGet requestUrlTagsField(boolean value) {
            this.requestField("url_tags", value);
            return this;
        }

        public APIRequestGet requestVideoIdField() {
            return this.requestVideoIdField(true);
        }

        public APIRequestGet requestVideoIdField(boolean value) {
            this.requestField("video_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

