/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdRuleEvaluationSpec;
import com.facebook.ads.sdk.AdRuleExecutionSpec;
import com.facebook.ads.sdk.AdRuleHistoryResult;
import com.facebook.ads.sdk.AdRuleScheduleSpec;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAccountAdRulesHistory
extends APINode {
    @SerializedName(value="evaluation_spec")
    private AdRuleEvaluationSpec mEvaluationSpec = null;
    @SerializedName(value="exception_code")
    private Long mExceptionCode = null;
    @SerializedName(value="exception_message")
    private String mExceptionMessage = null;
    @SerializedName(value="execution_spec")
    private AdRuleExecutionSpec mExecutionSpec = null;
    @SerializedName(value="is_manual")
    private Boolean mIsManual = null;
    @SerializedName(value="results")
    private List<AdRuleHistoryResult> mResults = null;
    @SerializedName(value="rule_id")
    private Long mRuleId = null;
    @SerializedName(value="schedule_spec")
    private AdRuleScheduleSpec mScheduleSpec = null;
    @SerializedName(value="timestamp")
    private String mTimestamp = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdAccountAdRulesHistory() {
    }

    public AdAccountAdRulesHistory(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAccountAdRulesHistory(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAccountAdRulesHistory fetch() throws APIException {
        AdAccountAdRulesHistory newInstance = AdAccountAdRulesHistory.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAccountAdRulesHistory fetchById(Long id, APIContext context) throws APIException {
        return AdAccountAdRulesHistory.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAccountAdRulesHistory> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAccountAdRulesHistory.fetchByIdAsync(id.toString(), context);
    }

    public static AdAccountAdRulesHistory fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAccountAdRulesHistory> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAccountAdRulesHistory> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAccountAdRulesHistory>(context, "", "/", "GET", AdAccountAdRulesHistory.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAccountAdRulesHistory>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAccountAdRulesHistory>(context, "", "/", "GET", AdAccountAdRulesHistory.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAccountAdRulesHistory loadJSON(String json, APIContext context) {
        AdAccountAdRulesHistory adAccountAdRulesHistory = (AdAccountAdRulesHistory)AdAccountAdRulesHistory.getGson().fromJson(json, AdAccountAdRulesHistory.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccountAdRulesHistory.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccountAdRulesHistory.context = context;
        adAccountAdRulesHistory.rawValue = json;
        return adAccountAdRulesHistory;
    }

    public static APINodeList<AdAccountAdRulesHistory> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccountAdRulesHistory> adAccountAdRulesHistorys = new APINodeList<AdAccountAdRulesHistory>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccountAdRulesHistorys.add(AdAccountAdRulesHistory.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAccountAdRulesHistorys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccountAdRulesHistorys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccountAdRulesHistorys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccountAdRulesHistorys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccountAdRulesHistorys.add(AdAccountAdRulesHistory.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccountAdRulesHistorys.add(AdAccountAdRulesHistory.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccountAdRulesHistorys.add(AdAccountAdRulesHistory.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAccountAdRulesHistorys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccountAdRulesHistorys.add(AdAccountAdRulesHistory.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAccountAdRulesHistorys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccountAdRulesHistorys.add(AdAccountAdRulesHistory.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccountAdRulesHistorys;
                }
                adAccountAdRulesHistorys.clear();
                adAccountAdRulesHistorys.add(AdAccountAdRulesHistory.loadJSON(json, context));
                return adAccountAdRulesHistorys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccountAdRulesHistory.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdRuleEvaluationSpec getFieldEvaluationSpec() {
        if (this.mEvaluationSpec != null) {
            this.mEvaluationSpec.context = this.getContext();
        }
        return this.mEvaluationSpec;
    }

    public Long getFieldExceptionCode() {
        return this.mExceptionCode;
    }

    public String getFieldExceptionMessage() {
        return this.mExceptionMessage;
    }

    public AdRuleExecutionSpec getFieldExecutionSpec() {
        if (this.mExecutionSpec != null) {
            this.mExecutionSpec.context = this.getContext();
        }
        return this.mExecutionSpec;
    }

    public Boolean getFieldIsManual() {
        return this.mIsManual;
    }

    public List<AdRuleHistoryResult> getFieldResults() {
        return this.mResults;
    }

    public Long getFieldRuleId() {
        return this.mRuleId;
    }

    public AdRuleScheduleSpec getFieldScheduleSpec() {
        if (this.mScheduleSpec != null) {
            this.mScheduleSpec.context = this.getContext();
        }
        return this.mScheduleSpec;
    }

    public String getFieldTimestamp() {
        return this.mTimestamp;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccountAdRulesHistory copyFrom(AdAccountAdRulesHistory instance) {
        this.mEvaluationSpec = instance.mEvaluationSpec;
        this.mExceptionCode = instance.mExceptionCode;
        this.mExceptionMessage = instance.mExceptionMessage;
        this.mExecutionSpec = instance.mExecutionSpec;
        this.mIsManual = instance.mIsManual;
        this.mResults = instance.mResults;
        this.mRuleId = instance.mRuleId;
        this.mScheduleSpec = instance.mScheduleSpec;
        this.mTimestamp = instance.mTimestamp;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccountAdRulesHistory> getParser() {
        return new APIRequest.ResponseParser<AdAccountAdRulesHistory>(){

            @Override
            public APINodeList<AdAccountAdRulesHistory> parseResponse(String response, APIContext context, APIRequest<AdAccountAdRulesHistory> request) throws APIException.MalformedResponseException {
                return AdAccountAdRulesHistory.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAction {
        VALUE_BUDGET_NOT_REDISTRIBUTED("BUDGET_NOT_REDISTRIBUTED"),
        VALUE_CHANGED_BID("CHANGED_BID"),
        VALUE_CHANGED_BUDGET("CHANGED_BUDGET"),
        VALUE_EMAIL("EMAIL"),
        VALUE_ENDPOINT_PINGED("ENDPOINT_PINGED"),
        VALUE_ERROR("ERROR"),
        VALUE_FACEBOOK_NOTIFICATION_SENT("FACEBOOK_NOTIFICATION_SENT"),
        VALUE_MESSAGE_SENT("MESSAGE_SENT"),
        VALUE_NOT_CHANGED("NOT_CHANGED"),
        VALUE_PAUSED("PAUSED"),
        VALUE_UNPAUSED("UNPAUSED"),
        NULL(null);

        private String value;

        private EnumAction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAccountAdRulesHistory> {
        AdAccountAdRulesHistory lastResponse = null;
        public static final String[] PARAMS = new String[]{"action", "hide_no_changes", "object_id"};
        public static final String[] FIELDS = new String[]{"evaluation_spec", "exception_code", "exception_message", "execution_spec", "is_manual", "results", "rule_id", "schedule_spec", "timestamp", "id"};

        @Override
        public AdAccountAdRulesHistory getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccountAdRulesHistory parseResponse(String response) throws APIException {
            return AdAccountAdRulesHistory.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccountAdRulesHistory execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccountAdRulesHistory execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccountAdRulesHistory> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccountAdRulesHistory> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccountAdRulesHistory>(){

                public AdAccountAdRulesHistory apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setAction(EnumAction action) {
            this.setParam("action", (Object)action);
            return this;
        }

        public APIRequestGet setAction(String action) {
            this.setParam("action", action);
            return this;
        }

        public APIRequestGet setHideNoChanges(Boolean hideNoChanges) {
            this.setParam("hide_no_changes", hideNoChanges);
            return this;
        }

        public APIRequestGet setHideNoChanges(String hideNoChanges) {
            this.setParam("hide_no_changes", hideNoChanges);
            return this;
        }

        public APIRequestGet setObjectId(String objectId) {
            this.setParam("object_id", objectId);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestEvaluationSpecField() {
            return this.requestEvaluationSpecField(true);
        }

        public APIRequestGet requestEvaluationSpecField(boolean value) {
            this.requestField("evaluation_spec", value);
            return this;
        }

        public APIRequestGet requestExceptionCodeField() {
            return this.requestExceptionCodeField(true);
        }

        public APIRequestGet requestExceptionCodeField(boolean value) {
            this.requestField("exception_code", value);
            return this;
        }

        public APIRequestGet requestExceptionMessageField() {
            return this.requestExceptionMessageField(true);
        }

        public APIRequestGet requestExceptionMessageField(boolean value) {
            this.requestField("exception_message", value);
            return this;
        }

        public APIRequestGet requestExecutionSpecField() {
            return this.requestExecutionSpecField(true);
        }

        public APIRequestGet requestExecutionSpecField(boolean value) {
            this.requestField("execution_spec", value);
            return this;
        }

        public APIRequestGet requestIsManualField() {
            return this.requestIsManualField(true);
        }

        public APIRequestGet requestIsManualField(boolean value) {
            this.requestField("is_manual", value);
            return this;
        }

        public APIRequestGet requestResultsField() {
            return this.requestResultsField(true);
        }

        public APIRequestGet requestResultsField(boolean value) {
            this.requestField("results", value);
            return this;
        }

        public APIRequestGet requestRuleIdField() {
            return this.requestRuleIdField(true);
        }

        public APIRequestGet requestRuleIdField(boolean value) {
            this.requestField("rule_id", value);
            return this;
        }

        public APIRequestGet requestScheduleSpecField() {
            return this.requestScheduleSpecField(true);
        }

        public APIRequestGet requestScheduleSpecField(boolean value) {
            this.requestField("schedule_spec", value);
            return this;
        }

        public APIRequestGet requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGet requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

