/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoList
extends APINode {
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_modified")
    private String mLastModified = null;
    @SerializedName(value="owner")
    private Object mOwner = null;
    @SerializedName(value="season_number")
    private Long mSeasonNumber = null;
    @SerializedName(value="thumbnail")
    private String mThumbnail = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="videos_count")
    private Long mVideosCount = null;
    protected static Gson gson = null;

    VideoList() {
    }

    public VideoList(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public VideoList(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public VideoList fetch() throws APIException {
        VideoList newInstance = VideoList.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static VideoList fetchById(Long id, APIContext context) throws APIException {
        return VideoList.fetchById(id.toString(), context);
    }

    public static ListenableFuture<VideoList> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return VideoList.fetchByIdAsync(id.toString(), context);
    }

    public static VideoList fetchById(String id, APIContext context) throws APIException {
        VideoList videoList = new APIRequestGet(id, context).requestAllFields().execute();
        return videoList;
    }

    public static ListenableFuture<VideoList> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<VideoList> videoList = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return videoList;
    }

    public static APINodeList<VideoList> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<VideoList>(context, "", "/", "GET", VideoList.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<VideoList>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> videoList = new APIRequest<VideoList>(context, "", "/", "GET", VideoList.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return videoList;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VideoList loadJSON(String json, APIContext context) {
        VideoList videoList = (VideoList)VideoList.getGson().fromJson(json, VideoList.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoList.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoList.context = context;
        videoList.rawValue = json;
        return videoList;
    }

    public static APINodeList<VideoList> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoList> videoLists = new APINodeList<VideoList>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoLists.add(VideoList.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return videoLists;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoLists.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoLists.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoLists.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoLists.add(VideoList.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoLists.add(VideoList.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoLists.add(VideoList.loadJSON(obj.toString(), context));
                        }
                    }
                    return videoLists;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoLists.add(VideoList.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return videoLists;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoLists.add(VideoList.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoLists;
                }
                videoLists.clear();
                videoLists.add(VideoList.loadJSON(json, context));
                return videoLists;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoList.getGson().toJson((Object)this);
    }

    public APIRequestDeleteVideos deleteVideos() {
        return new APIRequestDeleteVideos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateVideo createVideo() {
        return new APIRequestCreateVideo(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLastModified() {
        return this.mLastModified;
    }

    public Object getFieldOwner() {
        return this.mOwner;
    }

    public Long getFieldSeasonNumber() {
        return this.mSeasonNumber;
    }

    public String getFieldThumbnail() {
        return this.mThumbnail;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public Long getFieldVideosCount() {
        return this.mVideosCount;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoList copyFrom(VideoList instance) {
        this.mCreationTime = instance.mCreationTime;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mLastModified = instance.mLastModified;
        this.mOwner = instance.mOwner;
        this.mSeasonNumber = instance.mSeasonNumber;
        this.mThumbnail = instance.mThumbnail;
        this.mTitle = instance.mTitle;
        this.mVideosCount = instance.mVideosCount;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoList> getParser() {
        return new APIRequest.ResponseParser<VideoList>(){

            @Override
            public APINodeList<VideoList> parseResponse(String response, APIContext context, APIRequest<VideoList> request) throws APIException.MalformedResponseException {
                return VideoList.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<VideoList> {
        VideoList lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"creation_time", "description", "id", "last_modified", "owner", "season_number", "thumbnail", "title", "videos_count"};

        @Override
        public VideoList getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoList parseResponse(String response) throws APIException {
            return VideoList.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public VideoList execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoList execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<VideoList> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoList> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, VideoList>(){

                public VideoList apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLastModifiedField() {
            return this.requestLastModifiedField(true);
        }

        public APIRequestGet requestLastModifiedField(boolean value) {
            this.requestField("last_modified", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestSeasonNumberField() {
            return this.requestSeasonNumberField(true);
        }

        public APIRequestGet requestSeasonNumberField(boolean value) {
            this.requestField("season_number", value);
            return this;
        }

        public APIRequestGet requestThumbnailField() {
            return this.requestThumbnailField(true);
        }

        public APIRequestGet requestThumbnailField(boolean value) {
            this.requestField("thumbnail", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestVideosCountField() {
            return this.requestVideosCountField(true);
        }

        public APIRequestGet requestVideosCountField(boolean value) {
            this.requestField("videos_count", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateVideo
    extends APIRequest<VideoList> {
        VideoList lastResponse = null;
        public static final String[] PARAMS = new String[]{"video_ids"};
        public static final String[] FIELDS = new String[0];

        @Override
        public VideoList getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoList parseResponse(String response) throws APIException {
            return VideoList.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public VideoList execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoList execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<VideoList> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoList> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, VideoList>(){

                public VideoList apply(String result) {
                    try {
                        return APIRequestCreateVideo.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateVideo(String nodeId, APIContext context) {
            super(context, nodeId, "/videos", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateVideo setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateVideo setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateVideo setVideoIds(List<String> videoIds) {
            this.setParam("video_ids", videoIds);
            return this;
        }

        public APIRequestCreateVideo setVideoIds(String videoIds) {
            this.setParam("video_ids", videoIds);
            return this;
        }

        public APIRequestCreateVideo requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateVideo requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateVideo requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateVideo requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateVideo requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateVideo requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteVideos
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"video_ids"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteVideos.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteVideos(String nodeId, APIContext context) {
            super(context, nodeId, "/videos", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteVideos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteVideos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteVideos setVideoIds(List<String> videoIds) {
            this.setParam("video_ids", videoIds);
            return this;
        }

        public APIRequestDeleteVideos setVideoIds(String videoIds) {
            this.setParam("video_ids", videoIds);
            return this;
        }

        public APIRequestDeleteVideos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteVideos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteVideos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteVideos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteVideos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteVideos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

