/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsitePixel
extends APINode {
    @SerializedName(value="creator")
    private String mCreator = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="js_pixel")
    private String mJsPixel = null;
    @SerializedName(value="last_firing_time")
    private String mLastFiringTime = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="tag")
    private String mTag = null;
    protected static Gson gson = null;

    OffsitePixel() {
    }

    public OffsitePixel(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public OffsitePixel(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public OffsitePixel fetch() throws APIException {
        OffsitePixel newInstance = OffsitePixel.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static OffsitePixel fetchById(Long id, APIContext context) throws APIException {
        return OffsitePixel.fetchById(id.toString(), context);
    }

    public static ListenableFuture<OffsitePixel> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return OffsitePixel.fetchByIdAsync(id.toString(), context);
    }

    public static OffsitePixel fetchById(String id, APIContext context) throws APIException {
        OffsitePixel offsitePixel = new APIRequestGet(id, context).requestAllFields().execute();
        return offsitePixel;
    }

    public static ListenableFuture<OffsitePixel> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<OffsitePixel> offsitePixel = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return offsitePixel;
    }

    public static APINodeList<OffsitePixel> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<OffsitePixel>(context, "", "/", "GET", OffsitePixel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<OffsitePixel>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> offsitePixel = new APIRequest<OffsitePixel>(context, "", "/", "GET", OffsitePixel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return offsitePixel;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static OffsitePixel loadJSON(String json, APIContext context) {
        OffsitePixel offsitePixel = (OffsitePixel)OffsitePixel.getGson().fromJson(json, OffsitePixel.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(offsitePixel.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        offsitePixel.context = context;
        offsitePixel.rawValue = json;
        return offsitePixel;
    }

    public static APINodeList<OffsitePixel> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<OffsitePixel> offsitePixels = new APINodeList<OffsitePixel>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        offsitePixels.add(OffsitePixel.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return offsitePixels;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            offsitePixels.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        offsitePixels.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            offsitePixels.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            offsitePixels.add(OffsitePixel.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                offsitePixels.add(OffsitePixel.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            offsitePixels.add(OffsitePixel.loadJSON(obj.toString(), context));
                        }
                    }
                    return offsitePixels;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        offsitePixels.add(OffsitePixel.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return offsitePixels;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        offsitePixels.add(OffsitePixel.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return offsitePixels;
                }
                offsitePixels.clear();
                offsitePixels.add(OffsitePixel.loadJSON(json, context));
                return offsitePixels;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return OffsitePixel.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCreator() {
        return this.mCreator;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldJsPixel() {
        return this.mJsPixel;
    }

    public String getFieldLastFiringTime() {
        return this.mLastFiringTime;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldTag() {
        return this.mTag;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public OffsitePixel copyFrom(OffsitePixel instance) {
        this.mCreator = instance.mCreator;
        this.mId = instance.mId;
        this.mJsPixel = instance.mJsPixel;
        this.mLastFiringTime = instance.mLastFiringTime;
        this.mName = instance.mName;
        this.mTag = instance.mTag;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<OffsitePixel> getParser() {
        return new APIRequest.ResponseParser<OffsitePixel>(){

            @Override
            public APINodeList<OffsitePixel> parseResponse(String response, APIContext context, APIRequest<OffsitePixel> request) throws APIException.MalformedResponseException {
                return OffsitePixel.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<OffsitePixel> {
        OffsitePixel lastResponse = null;
        public static final String[] PARAMS = new String[]{"value"};
        public static final String[] FIELDS = new String[]{"creator", "id", "js_pixel", "last_firing_time", "name", "tag"};

        @Override
        public OffsitePixel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OffsitePixel parseResponse(String response) throws APIException {
            return OffsitePixel.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public OffsitePixel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OffsitePixel execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<OffsitePixel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<OffsitePixel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, OffsitePixel>(){

                public OffsitePixel apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setValue(Long value) {
            this.setParam("value", value);
            return this;
        }

        public APIRequestGet setValue(String value) {
            this.setParam("value", value);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestJsPixelField() {
            return this.requestJsPixelField(true);
        }

        public APIRequestGet requestJsPixelField(boolean value) {
            this.requestField("js_pixel", value);
            return this;
        }

        public APIRequestGet requestLastFiringTimeField() {
            return this.requestLastFiringTimeField(true);
        }

        public APIRequestGet requestLastFiringTimeField(boolean value) {
            this.requestField("last_firing_time", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestTagField() {
            return this.requestTagField(true);
        }

        public APIRequestGet requestTagField(boolean value) {
            this.requestField("tag", value);
            return this;
        }
    }
}

