/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.AdsPixel;
import com.facebook.ads.sdk.OfflineConversionDataSet;
import com.facebook.ads.sdk.ProductCatalog;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerIntegrationLinked
extends APINode {
    @SerializedName(value="ads_pixel")
    private AdsPixel mAdsPixel = null;
    @SerializedName(value="application")
    private Object mApplication = null;
    @SerializedName(value="external_id")
    private String mExternalId = null;
    @SerializedName(value="has_oauth_token")
    private Boolean mHasOauthToken = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="offline_conversion_data_set")
    private OfflineConversionDataSet mOfflineConversionDataSet = null;
    @SerializedName(value="partner")
    private String mPartner = null;
    @SerializedName(value="partner_profile")
    private Object mPartnerProfile = null;
    @SerializedName(value="product_catalog")
    private ProductCatalog mProductCatalog = null;
    @SerializedName(value="setup_status")
    private String mSetupStatus = null;
    protected static Gson gson = null;

    PartnerIntegrationLinked() {
    }

    public PartnerIntegrationLinked(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PartnerIntegrationLinked(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PartnerIntegrationLinked fetch() throws APIException {
        PartnerIntegrationLinked newInstance = PartnerIntegrationLinked.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PartnerIntegrationLinked fetchById(Long id, APIContext context) throws APIException {
        return PartnerIntegrationLinked.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PartnerIntegrationLinked> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PartnerIntegrationLinked.fetchByIdAsync(id.toString(), context);
    }

    public static PartnerIntegrationLinked fetchById(String id, APIContext context) throws APIException {
        PartnerIntegrationLinked partnerIntegrationLinked = new APIRequestGet(id, context).requestAllFields().execute();
        return partnerIntegrationLinked;
    }

    public static ListenableFuture<PartnerIntegrationLinked> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<PartnerIntegrationLinked> partnerIntegrationLinked = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return partnerIntegrationLinked;
    }

    public static APINodeList<PartnerIntegrationLinked> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PartnerIntegrationLinked>(context, "", "/", "GET", PartnerIntegrationLinked.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PartnerIntegrationLinked>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> partnerIntegrationLinked = new APIRequest<PartnerIntegrationLinked>(context, "", "/", "GET", PartnerIntegrationLinked.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return partnerIntegrationLinked;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PartnerIntegrationLinked loadJSON(String json, APIContext context) {
        PartnerIntegrationLinked partnerIntegrationLinked = (PartnerIntegrationLinked)PartnerIntegrationLinked.getGson().fromJson(json, PartnerIntegrationLinked.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(partnerIntegrationLinked.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        partnerIntegrationLinked.context = context;
        partnerIntegrationLinked.rawValue = json;
        return partnerIntegrationLinked;
    }

    public static APINodeList<PartnerIntegrationLinked> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PartnerIntegrationLinked> partnerIntegrationLinkeds = new APINodeList<PartnerIntegrationLinked>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        partnerIntegrationLinkeds.add(PartnerIntegrationLinked.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return partnerIntegrationLinkeds;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            partnerIntegrationLinkeds.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        partnerIntegrationLinkeds.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            partnerIntegrationLinkeds.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            partnerIntegrationLinkeds.add(PartnerIntegrationLinked.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                partnerIntegrationLinkeds.add(PartnerIntegrationLinked.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            partnerIntegrationLinkeds.add(PartnerIntegrationLinked.loadJSON(obj.toString(), context));
                        }
                    }
                    return partnerIntegrationLinkeds;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        partnerIntegrationLinkeds.add(PartnerIntegrationLinked.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return partnerIntegrationLinkeds;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        partnerIntegrationLinkeds.add(PartnerIntegrationLinked.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return partnerIntegrationLinkeds;
                }
                partnerIntegrationLinkeds.clear();
                partnerIntegrationLinkeds.add(PartnerIntegrationLinked.loadJSON(json, context));
                return partnerIntegrationLinkeds;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PartnerIntegrationLinked.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public AdsPixel getFieldAdsPixel() {
        if (this.mAdsPixel != null) {
            this.mAdsPixel.context = this.getContext();
        }
        return this.mAdsPixel;
    }

    public Object getFieldApplication() {
        return this.mApplication;
    }

    public String getFieldExternalId() {
        return this.mExternalId;
    }

    public Boolean getFieldHasOauthToken() {
        return this.mHasOauthToken;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public OfflineConversionDataSet getFieldOfflineConversionDataSet() {
        if (this.mOfflineConversionDataSet != null) {
            this.mOfflineConversionDataSet.context = this.getContext();
        }
        return this.mOfflineConversionDataSet;
    }

    public String getFieldPartner() {
        return this.mPartner;
    }

    public Object getFieldPartnerProfile() {
        return this.mPartnerProfile;
    }

    public ProductCatalog getFieldProductCatalog() {
        if (this.mProductCatalog != null) {
            this.mProductCatalog.context = this.getContext();
        }
        return this.mProductCatalog;
    }

    public String getFieldSetupStatus() {
        return this.mSetupStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PartnerIntegrationLinked copyFrom(PartnerIntegrationLinked instance) {
        this.mAdsPixel = instance.mAdsPixel;
        this.mApplication = instance.mApplication;
        this.mExternalId = instance.mExternalId;
        this.mHasOauthToken = instance.mHasOauthToken;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mOfflineConversionDataSet = instance.mOfflineConversionDataSet;
        this.mPartner = instance.mPartner;
        this.mPartnerProfile = instance.mPartnerProfile;
        this.mProductCatalog = instance.mProductCatalog;
        this.mSetupStatus = instance.mSetupStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PartnerIntegrationLinked> getParser() {
        return new APIRequest.ResponseParser<PartnerIntegrationLinked>(){

            @Override
            public APINodeList<PartnerIntegrationLinked> parseResponse(String response, APIContext context, APIRequest<PartnerIntegrationLinked> request) throws APIException.MalformedResponseException {
                return PartnerIntegrationLinked.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PartnerIntegrationLinked> {
        PartnerIntegrationLinked lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ads_pixel", "application", "external_id", "has_oauth_token", "id", "name", "offline_conversion_data_set", "partner", "partner_profile", "product_catalog", "setup_status"};

        @Override
        public PartnerIntegrationLinked getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PartnerIntegrationLinked parseResponse(String response) throws APIException {
            return PartnerIntegrationLinked.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PartnerIntegrationLinked execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PartnerIntegrationLinked execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PartnerIntegrationLinked> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PartnerIntegrationLinked> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PartnerIntegrationLinked>(){

                public PartnerIntegrationLinked apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdsPixelField() {
            return this.requestAdsPixelField(true);
        }

        public APIRequestGet requestAdsPixelField(boolean value) {
            this.requestField("ads_pixel", value);
            return this;
        }

        public APIRequestGet requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGet requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGet requestExternalIdField() {
            return this.requestExternalIdField(true);
        }

        public APIRequestGet requestExternalIdField(boolean value) {
            this.requestField("external_id", value);
            return this;
        }

        public APIRequestGet requestHasOauthTokenField() {
            return this.requestHasOauthTokenField(true);
        }

        public APIRequestGet requestHasOauthTokenField(boolean value) {
            this.requestField("has_oauth_token", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOfflineConversionDataSetField() {
            return this.requestOfflineConversionDataSetField(true);
        }

        public APIRequestGet requestOfflineConversionDataSetField(boolean value) {
            this.requestField("offline_conversion_data_set", value);
            return this;
        }

        public APIRequestGet requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGet requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGet requestPartnerProfileField() {
            return this.requestPartnerProfileField(true);
        }

        public APIRequestGet requestPartnerProfileField(boolean value) {
            this.requestField("partner_profile", value);
            return this;
        }

        public APIRequestGet requestProductCatalogField() {
            return this.requestProductCatalogField(true);
        }

        public APIRequestGet requestProductCatalogField(boolean value) {
            this.requestField("product_catalog", value);
            return this;
        }

        public APIRequestGet requestSetupStatusField() {
            return this.requestSetupStatusField(true);
        }

        public APIRequestGet requestSetupStatusField(boolean value) {
            this.requestField("setup_status", value);
            return this;
        }
    }
}

