/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.PageChangeProposal;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageUpcomingChange
extends APINode {
    @SerializedName(value="change_type")
    private String mChangeType = null;
    @SerializedName(value="effective_time")
    private String mEffectiveTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="page")
    private Page mPage = null;
    @SerializedName(value="proposal")
    private PageChangeProposal mProposal = null;
    @SerializedName(value="timer_status")
    private String mTimerStatus = null;
    protected static Gson gson = null;

    PageUpcomingChange() {
    }

    public PageUpcomingChange(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PageUpcomingChange(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PageUpcomingChange fetch() throws APIException {
        PageUpcomingChange newInstance = PageUpcomingChange.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PageUpcomingChange fetchById(Long id, APIContext context) throws APIException {
        return PageUpcomingChange.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PageUpcomingChange> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PageUpcomingChange.fetchByIdAsync(id.toString(), context);
    }

    public static PageUpcomingChange fetchById(String id, APIContext context) throws APIException {
        PageUpcomingChange pageUpcomingChange = new APIRequestGet(id, context).requestAllFields().execute();
        return pageUpcomingChange;
    }

    public static ListenableFuture<PageUpcomingChange> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<PageUpcomingChange> pageUpcomingChange = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return pageUpcomingChange;
    }

    public static APINodeList<PageUpcomingChange> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PageUpcomingChange>(context, "", "/", "GET", PageUpcomingChange.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PageUpcomingChange>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> pageUpcomingChange = new APIRequest<PageUpcomingChange>(context, "", "/", "GET", PageUpcomingChange.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return pageUpcomingChange;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageUpcomingChange loadJSON(String json, APIContext context) {
        PageUpcomingChange pageUpcomingChange = (PageUpcomingChange)PageUpcomingChange.getGson().fromJson(json, PageUpcomingChange.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageUpcomingChange.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageUpcomingChange.context = context;
        pageUpcomingChange.rawValue = json;
        return pageUpcomingChange;
    }

    public static APINodeList<PageUpcomingChange> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageUpcomingChange> pageUpcomingChanges = new APINodeList<PageUpcomingChange>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageUpcomingChanges.add(PageUpcomingChange.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return pageUpcomingChanges;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageUpcomingChanges.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageUpcomingChanges.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageUpcomingChanges.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageUpcomingChanges.add(PageUpcomingChange.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageUpcomingChanges.add(PageUpcomingChange.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageUpcomingChanges.add(PageUpcomingChange.loadJSON(obj.toString(), context));
                        }
                    }
                    return pageUpcomingChanges;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageUpcomingChanges.add(PageUpcomingChange.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return pageUpcomingChanges;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageUpcomingChanges.add(PageUpcomingChange.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageUpcomingChanges;
                }
                pageUpcomingChanges.clear();
                pageUpcomingChanges.add(PageUpcomingChange.loadJSON(json, context));
                return pageUpcomingChanges;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageUpcomingChange.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldChangeType() {
        return this.mChangeType;
    }

    public String getFieldEffectiveTime() {
        return this.mEffectiveTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Page getFieldPage() {
        if (this.mPage != null) {
            this.mPage.context = this.getContext();
        }
        return this.mPage;
    }

    public PageChangeProposal getFieldProposal() {
        if (this.mProposal != null) {
            this.mProposal.context = this.getContext();
        }
        return this.mProposal;
    }

    public String getFieldTimerStatus() {
        return this.mTimerStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageUpcomingChange copyFrom(PageUpcomingChange instance) {
        this.mChangeType = instance.mChangeType;
        this.mEffectiveTime = instance.mEffectiveTime;
        this.mId = instance.mId;
        this.mPage = instance.mPage;
        this.mProposal = instance.mProposal;
        this.mTimerStatus = instance.mTimerStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageUpcomingChange> getParser() {
        return new APIRequest.ResponseParser<PageUpcomingChange>(){

            @Override
            public APINodeList<PageUpcomingChange> parseResponse(String response, APIContext context, APIRequest<PageUpcomingChange> request) throws APIException.MalformedResponseException {
                return PageUpcomingChange.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<PageUpcomingChange> {
        PageUpcomingChange lastResponse = null;
        public static final String[] PARAMS = new String[]{"accept"};
        public static final String[] FIELDS = new String[0];

        @Override
        public PageUpcomingChange getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageUpcomingChange parseResponse(String response) throws APIException {
            return PageUpcomingChange.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PageUpcomingChange execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageUpcomingChange execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PageUpcomingChange> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageUpcomingChange> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PageUpcomingChange>(){

                public PageUpcomingChange apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAccept(Boolean accept) {
            this.setParam("accept", accept);
            return this;
        }

        public APIRequestUpdate setAccept(String accept) {
            this.setParam("accept", accept);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PageUpcomingChange> {
        PageUpcomingChange lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"change_type", "effective_time", "id", "page", "proposal", "timer_status"};

        @Override
        public PageUpcomingChange getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageUpcomingChange parseResponse(String response) throws APIException {
            return PageUpcomingChange.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PageUpcomingChange execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageUpcomingChange execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PageUpcomingChange> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageUpcomingChange> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PageUpcomingChange>(){

                public PageUpcomingChange apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestChangeTypeField() {
            return this.requestChangeTypeField(true);
        }

        public APIRequestGet requestChangeTypeField(boolean value) {
            this.requestField("change_type", value);
            return this;
        }

        public APIRequestGet requestEffectiveTimeField() {
            return this.requestEffectiveTimeField(true);
        }

        public APIRequestGet requestEffectiveTimeField(boolean value) {
            this.requestField("effective_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGet requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }

        public APIRequestGet requestProposalField() {
            return this.requestProposalField(true);
        }

        public APIRequestGet requestProposalField(boolean value) {
            this.requestField("proposal", value);
            return this;
        }

        public APIRequestGet requestTimerStatusField() {
            return this.requestTimerStatusField(true);
        }

        public APIRequestGet requestTimerStatusField(boolean value) {
            this.requestField("timer_status", value);
            return this;
        }
    }
}

