/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdStudyObjective
extends APINode {
    @SerializedName(value="custom_attributes")
    private List<String> mCustomAttributes = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_primary")
    private Boolean mIsPrimary = null;
    @SerializedName(value="last_updated_results")
    private String mLastUpdatedResults = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="results")
    private List<String> mResults = null;
    @SerializedName(value="type")
    private String mType = null;
    protected static Gson gson = null;

    AdStudyObjective() {
    }

    public AdStudyObjective(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdStudyObjective(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdStudyObjective fetch() throws APIException {
        AdStudyObjective newInstance = AdStudyObjective.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdStudyObjective fetchById(Long id, APIContext context) throws APIException {
        return AdStudyObjective.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdStudyObjective> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdStudyObjective.fetchByIdAsync(id.toString(), context);
    }

    public static AdStudyObjective fetchById(String id, APIContext context) throws APIException {
        AdStudyObjective adStudyObjective = new APIRequestGet(id, context).requestAllFields().execute();
        return adStudyObjective;
    }

    public static ListenableFuture<AdStudyObjective> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<AdStudyObjective> adStudyObjective = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return adStudyObjective;
    }

    public static APINodeList<AdStudyObjective> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdStudyObjective>(context, "", "/", "GET", AdStudyObjective.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdStudyObjective>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> adStudyObjective = new APIRequest<AdStudyObjective>(context, "", "/", "GET", AdStudyObjective.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return adStudyObjective;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdStudyObjective loadJSON(String json, APIContext context) {
        AdStudyObjective adStudyObjective = (AdStudyObjective)AdStudyObjective.getGson().fromJson(json, AdStudyObjective.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adStudyObjective.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adStudyObjective.context = context;
        adStudyObjective.rawValue = json;
        return adStudyObjective;
    }

    public static APINodeList<AdStudyObjective> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdStudyObjective> adStudyObjectives = new APINodeList<AdStudyObjective>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adStudyObjectives.add(AdStudyObjective.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adStudyObjectives;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adStudyObjectives.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adStudyObjectives.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adStudyObjectives.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adStudyObjectives.add(AdStudyObjective.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adStudyObjectives.add(AdStudyObjective.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adStudyObjectives.add(AdStudyObjective.loadJSON(obj.toString(), context));
                        }
                    }
                    return adStudyObjectives;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adStudyObjectives.add(AdStudyObjective.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adStudyObjectives;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adStudyObjectives.add(AdStudyObjective.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adStudyObjectives;
                }
                adStudyObjectives.clear();
                adStudyObjectives.add(AdStudyObjective.loadJSON(json, context));
                return adStudyObjectives;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdStudyObjective.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldCustomAttributes() {
        return this.mCustomAttributes;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsPrimary() {
        return this.mIsPrimary;
    }

    public String getFieldLastUpdatedResults() {
        return this.mLastUpdatedResults;
    }

    public String getFieldName() {
        return this.mName;
    }

    public List<String> getFieldResults() {
        return this.mResults;
    }

    public String getFieldType() {
        return this.mType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdStudyObjective copyFrom(AdStudyObjective instance) {
        this.mCustomAttributes = instance.mCustomAttributes;
        this.mId = instance.mId;
        this.mIsPrimary = instance.mIsPrimary;
        this.mLastUpdatedResults = instance.mLastUpdatedResults;
        this.mName = instance.mName;
        this.mResults = instance.mResults;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdStudyObjective> getParser() {
        return new APIRequest.ResponseParser<AdStudyObjective>(){

            @Override
            public APINodeList<AdStudyObjective> parseResponse(String response, APIContext context, APIRequest<AdStudyObjective> request) throws APIException.MalformedResponseException {
                return AdStudyObjective.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_SALES("SALES"),
        VALUE_NONSALES("NONSALES"),
        VALUE_MAE("MAE"),
        VALUE_TELCO("TELCO"),
        VALUE_FTL("FTL"),
        VALUE_MAI("MAI"),
        VALUE_PARTNER("PARTNER"),
        VALUE_BRANDLIFT("BRANDLIFT"),
        VALUE_BRAND("BRAND"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBreakdowns {
        VALUE_AGE("age"),
        VALUE_CELL_ID("cell_id"),
        VALUE_GENDER("gender"),
        VALUE_COUNTRY("country"),
        NULL(null);

        private String value;

        private EnumBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<AdStudyObjective> {
        AdStudyObjective lastResponse = null;
        public static final String[] PARAMS = new String[]{"adspixels", "applications", "customconversions", "is_primary", "name", "offline_conversion_data_sets", "offsitepixels", "type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudyObjective getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudyObjective parseResponse(String response) throws APIException {
            return AdStudyObjective.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdStudyObjective execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudyObjective execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdStudyObjective> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudyObjective> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdStudyObjective>(){

                public AdStudyObjective apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAdspixels(List<Object> adspixels) {
            this.setParam("adspixels", adspixels);
            return this;
        }

        public APIRequestUpdate setAdspixels(String adspixels) {
            this.setParam("adspixels", adspixels);
            return this;
        }

        public APIRequestUpdate setApplications(List<Object> applications) {
            this.setParam("applications", applications);
            return this;
        }

        public APIRequestUpdate setApplications(String applications) {
            this.setParam("applications", applications);
            return this;
        }

        public APIRequestUpdate setCustomconversions(List<Object> customconversions) {
            this.setParam("customconversions", customconversions);
            return this;
        }

        public APIRequestUpdate setCustomconversions(String customconversions) {
            this.setParam("customconversions", customconversions);
            return this;
        }

        public APIRequestUpdate setIsPrimary(Boolean isPrimary) {
            this.setParam("is_primary", isPrimary);
            return this;
        }

        public APIRequestUpdate setIsPrimary(String isPrimary) {
            this.setParam("is_primary", isPrimary);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setOfflineConversionDataSets(List<Object> offlineConversionDataSets) {
            this.setParam("offline_conversion_data_sets", offlineConversionDataSets);
            return this;
        }

        public APIRequestUpdate setOfflineConversionDataSets(String offlineConversionDataSets) {
            this.setParam("offline_conversion_data_sets", offlineConversionDataSets);
            return this;
        }

        public APIRequestUpdate setOffsitepixels(List<Object> offsitepixels) {
            this.setParam("offsitepixels", offsitepixels);
            return this;
        }

        public APIRequestUpdate setOffsitepixels(String offsitepixels) {
            this.setParam("offsitepixels", offsitepixels);
            return this;
        }

        public APIRequestUpdate setType(EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestUpdate setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdStudyObjective> {
        AdStudyObjective lastResponse = null;
        public static final String[] PARAMS = new String[]{"breakdowns"};
        public static final String[] FIELDS = new String[]{"custom_attributes", "id", "is_primary", "last_updated_results", "name", "results", "type"};

        @Override
        public AdStudyObjective getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudyObjective parseResponse(String response) throws APIException {
            return AdStudyObjective.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdStudyObjective execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudyObjective execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdStudyObjective> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudyObjective> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdStudyObjective>(){

                public AdStudyObjective apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setBreakdowns(List<EnumBreakdowns> breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGet setBreakdowns(String breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCustomAttributesField() {
            return this.requestCustomAttributesField(true);
        }

        public APIRequestGet requestCustomAttributesField(boolean value) {
            this.requestField("custom_attributes", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsPrimaryField() {
            return this.requestIsPrimaryField(true);
        }

        public APIRequestGet requestIsPrimaryField(boolean value) {
            this.requestField("is_primary", value);
            return this;
        }

        public APIRequestGet requestLastUpdatedResultsField() {
            return this.requestLastUpdatedResultsField(true);
        }

        public APIRequestGet requestLastUpdatedResultsField(boolean value) {
            this.requestField("last_updated_results", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestResultsField() {
            return this.requestResultsField(true);
        }

        public APIRequestGet requestResultsField(boolean value) {
            this.requestField("results", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

