/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageSavedFilter
extends APINode {
    @SerializedName(value="display_name")
    private String mDisplayName = null;
    @SerializedName(value="filters")
    private List<Object> mFilters = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="section")
    private String mSection = null;
    @SerializedName(value="time_created")
    private Long mTimeCreated = null;
    @SerializedName(value="time_updated")
    private Long mTimeUpdated = null;
    protected static Gson gson = null;

    PageSavedFilter() {
    }

    public PageSavedFilter(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PageSavedFilter(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PageSavedFilter fetch() throws APIException {
        PageSavedFilter newInstance = PageSavedFilter.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PageSavedFilter fetchById(Long id, APIContext context) throws APIException {
        return PageSavedFilter.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PageSavedFilter> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PageSavedFilter.fetchByIdAsync(id.toString(), context);
    }

    public static PageSavedFilter fetchById(String id, APIContext context) throws APIException {
        PageSavedFilter pageSavedFilter = new APIRequestGet(id, context).requestAllFields().execute();
        return pageSavedFilter;
    }

    public static ListenableFuture<PageSavedFilter> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<PageSavedFilter> pageSavedFilter = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return pageSavedFilter;
    }

    public static APINodeList<PageSavedFilter> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PageSavedFilter>(context, "", "/", "GET", PageSavedFilter.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PageSavedFilter>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> pageSavedFilter = new APIRequest<PageSavedFilter>(context, "", "/", "GET", PageSavedFilter.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return pageSavedFilter;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageSavedFilter loadJSON(String json, APIContext context) {
        PageSavedFilter pageSavedFilter = (PageSavedFilter)PageSavedFilter.getGson().fromJson(json, PageSavedFilter.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageSavedFilter.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageSavedFilter.context = context;
        pageSavedFilter.rawValue = json;
        return pageSavedFilter;
    }

    public static APINodeList<PageSavedFilter> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageSavedFilter> pageSavedFilters = new APINodeList<PageSavedFilter>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageSavedFilters.add(PageSavedFilter.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return pageSavedFilters;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageSavedFilters.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageSavedFilters.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageSavedFilters.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageSavedFilters.add(PageSavedFilter.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageSavedFilters.add(PageSavedFilter.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageSavedFilters.add(PageSavedFilter.loadJSON(obj.toString(), context));
                        }
                    }
                    return pageSavedFilters;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageSavedFilters.add(PageSavedFilter.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return pageSavedFilters;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageSavedFilters.add(PageSavedFilter.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageSavedFilters;
                }
                pageSavedFilters.clear();
                pageSavedFilters.add(PageSavedFilter.loadJSON(json, context));
                return pageSavedFilters;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageSavedFilter.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDisplayName() {
        return this.mDisplayName;
    }

    public List<Object> getFieldFilters() {
        return this.mFilters;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public String getFieldSection() {
        return this.mSection;
    }

    public Long getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public Long getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageSavedFilter copyFrom(PageSavedFilter instance) {
        this.mDisplayName = instance.mDisplayName;
        this.mFilters = instance.mFilters;
        this.mId = instance.mId;
        this.mPageId = instance.mPageId;
        this.mSection = instance.mSection;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageSavedFilter> getParser() {
        return new APIRequest.ResponseParser<PageSavedFilter>(){

            @Override
            public APINodeList<PageSavedFilter> parseResponse(String response, APIContext context, APIRequest<PageSavedFilter> request) throws APIException.MalformedResponseException {
                return PageSavedFilter.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumSection {
        VALUE_AUDIENCE_ALERTS("AUDIENCE_ALERTS"),
        VALUE_CHEX_PENDING_ORDERS("CHEX_PENDING_ORDERS"),
        VALUE_CHEX_COMPLETED_ORDERS("CHEX_COMPLETED_ORDERS"),
        VALUE_COMMERCE_PLATFORM_SETTINGS("COMMERCE_PLATFORM_SETTINGS"),
        VALUE_COMMERCE_PRODUCTS("COMMERCE_PRODUCTS"),
        VALUE_COMMERCE_COLLECTIONS("COMMERCE_COLLECTIONS"),
        VALUE_COMMERCE_PENDING_ORDERS("COMMERCE_PENDING_ORDERS"),
        VALUE_COMMERCE_PAST_ORDERS("COMMERCE_PAST_ORDERS"),
        VALUE_COMMERCE_DISCOUNT_CODES("COMMERCE_DISCOUNT_CODES"),
        VALUE_COMMERCE_MERCHANT_SETTINGS("COMMERCE_MERCHANT_SETTINGS"),
        VALUE_COMMERCE_SHOP_LINK("COMMERCE_SHOP_LINK"),
        VALUE_DONATIONS_SETTINGS("DONATIONS_SETTINGS"),
        VALUE_DRAFTS("DRAFTS"),
        VALUE_REWARD_PROGRAM("REWARD_PROGRAM"),
        VALUE_EXPIRED_POSTS("EXPIRED_POSTS"),
        VALUE_EXPIRING_POSTS("EXPIRING_POSTS"),
        VALUE_INSTANT_ARTICLES("INSTANT_ARTICLES"),
        VALUE_INSTANT_ARTICLES_DEVELOPMENT("INSTANT_ARTICLES_DEVELOPMENT"),
        VALUE_INSTANT_ARTICLES_MONETIZATION("INSTANT_ARTICLES_MONETIZATION"),
        VALUE_INSTANT_ARTICLES_SAMPLE("INSTANT_ARTICLES_SAMPLE"),
        VALUE_INSTANT_ARTICLES_SETTINGS("INSTANT_ARTICLES_SETTINGS"),
        VALUE_INSTANT_ARTICLES_SIGN_UP("INSTANT_ARTICLES_SIGN_UP"),
        VALUE_INSTANT_ARTICLES_CTA_MANAGEMENT("INSTANT_ARTICLES_CTA_MANAGEMENT"),
        VALUE_INSTANT_ARTICLES_TRAFFIC_LIFT("INSTANT_ARTICLES_TRAFFIC_LIFT"),
        VALUE_INVOICES_ACTIVE("INVOICES_ACTIVE"),
        VALUE_INVOICES_HISTORY("INVOICES_HISTORY"),
        VALUE_LEAD_ADS_DRAFT_FORMS("LEAD_ADS_DRAFT_FORMS"),
        VALUE_LEAD_ADS_FORMS("LEAD_ADS_FORMS"),
        VALUE_LEAD_ADS_CRM_SETUP("LEAD_ADS_CRM_SETUP"),
        VALUE_LEAD_ADS_CUSTOM_CRM_SETUP("LEAD_ADS_CUSTOM_CRM_SETUP"),
        VALUE_PUBLISHED_POSTS("PUBLISHED_POSTS"),
        VALUE_SCHEDULED_POSTS("SCHEDULED_POSTS"),
        VALUE_ADS_POSTS("ADS_POSTS"),
        VALUE_VIDEOS("VIDEOS"),
        VALUE_JOB_POSTS("JOB_POSTS"),
        VALUE_NEW_MATCHES("NEW_MATCHES"),
        VALUE_VIDEOS_COPYRIGHT("VIDEOS_COPYRIGHT"),
        VALUE_REPORTED("REPORTED"),
        VALUE_PLAYLISTS("PLAYLISTS"),
        VALUE_PLAYLIST_DETAILS("PLAYLIST_DETAILS"),
        VALUE_POSTS_CONFIG("POSTS_CONFIG"),
        VALUE_SEASONS("SEASONS"),
        VALUE_SEASON_DETAILS("SEASON_DETAILS"),
        VALUE_TAKEDOWNS("TAKEDOWNS"),
        VALUE_UNSENT_REPORTS("UNSENT_REPORTS"),
        VALUE_ALLOWED("ALLOWED"),
        VALUE_TRACKED("TRACKED"),
        VALUE_BLOCKED("BLOCKED"),
        VALUE_CLAIMED("CLAIMED"),
        VALUE_MANUAL_REVIEW("MANUAL_REVIEW"),
        VALUE_MATCH_RULES("MATCH_RULES"),
        VALUE_DISPUTES("DISPUTES"),
        VALUE_ACTIVE_FUNDRAISERS("ACTIVE_FUNDRAISERS"),
        VALUE_DRAFT_FUNDRAISERS("DRAFT_FUNDRAISERS"),
        VALUE_READY_FUNDRAISERS("READY_FUNDRAISERS"),
        VALUE_ENDED_FUNDRAISERS("ENDED_FUNDRAISERS"),
        VALUE_ADS_CANVAS("ADS_CANVAS"),
        VALUE_REFERENCE_FILES("REFERENCE_FILES"),
        VALUE_ALL_REFERENCE_FILES("ALL_REFERENCE_FILES"),
        VALUE_REFERENCE_CONFLICTS("REFERENCE_CONFLICTS"),
        VALUE_REFERENCE_POSSIBLE_CONFLICTS("REFERENCE_POSSIBLE_CONFLICTS"),
        VALUE_REFERENCE_RESOLUTIONS("REFERENCE_RESOLUTIONS"),
        VALUE_SOUND_RECORDINGS("SOUND_RECORDINGS"),
        VALUE_PREMIUM_MUSIC_VIDEOS("PREMIUM_MUSIC_VIDEOS"),
        VALUE_LIVE_BROADCASTS("LIVE_BROADCASTS"),
        VALUE_CROSSPOSTED_VIDEOS("CROSSPOSTED_VIDEOS"),
        VALUE_PUBLISHED_PROFILE_PICTURE_FRAMES("PUBLISHED_PROFILE_PICTURE_FRAMES"),
        VALUE_PENDING_PROFILE_PICTURE_FRAMES("PENDING_PROFILE_PICTURE_FRAMES"),
        VALUE_TAROT_COMPOSER("TAROT_COMPOSER"),
        VALUE_DRAFT_EDITIONS("DRAFT_EDITIONS"),
        VALUE_PUBLISHED_EDITIONS("PUBLISHED_EDITIONS"),
        VALUE_PUBLISHED_EVENTS("PUBLISHED_EVENTS"),
        VALUE_DRAFT_EVENTS("DRAFT_EVENTS"),
        VALUE_SCHEDULED_EVENTS("SCHEDULED_EVENTS"),
        VALUE_ARCHIVED_EVENTS("ARCHIVED_EVENTS"),
        VALUE_TOURS("TOURS"),
        VALUE_POLLS_COMPOSER("POLLS_COMPOSER"),
        VALUE_BRAND_ASSET_LIBRARY("BRAND_ASSET_LIBRARY"),
        VALUE_JOB_APPLICATIONS("JOB_APPLICATIONS"),
        VALUE_SUBSCRIPTIONS("SUBSCRIPTIONS"),
        VALUE_NEWS_SUBSCRIPTIONS_PUBLISHER_TOOLS("NEWS_SUBSCRIPTIONS_PUBLISHER_TOOLS"),
        VALUE_NEWS_SUBSCRIPTIONS_PUBLISHER_ASSET_MANAGEMENT("NEWS_SUBSCRIPTIONS_PUBLISHER_ASSET_MANAGEMENT"),
        VALUE_NEWS_SUBSCRIPTIONS_PUBLISHER_OFFER_MANAGEMENT("NEWS_SUBSCRIPTIONS_PUBLISHER_OFFER_MANAGEMENT"),
        VALUE_QR_CODE("QR_CODE"),
        VALUE_ORGANIC_PIXEL("ORGANIC_PIXEL"),
        VALUE_CREDIBILITY_INDICATORS("CREDIBILITY_INDICATORS"),
        VALUE_ATTRIBUTIONS("ATTRIBUTIONS"),
        VALUE_BROADCASTED_MESSAGES("BROADCASTED_MESSAGES"),
        VALUE_BRANDED_CONTENT("BRANDED_CONTENT"),
        VALUE_BRANDED_CONTENT_CREATOR("BRANDED_CONTENT_CREATOR"),
        VALUE_SOUNDS_COLLECTION("SOUNDS_COLLECTION"),
        VALUE_CONTENT_TESTS("CONTENT_TESTS"),
        VALUE_GEM_PRODUCER_DASHBOARD("GEM_PRODUCER_DASHBOARD"),
        VALUE_MONETIZED_VIDEOS("MONETIZED_VIDEOS"),
        VALUE_AUDIO_RELEASES("AUDIO_RELEASES"),
        VALUE_NEWS_STORYLINES("NEWS_STORYLINES"),
        VALUE_REGISTRATIONS("REGISTRATIONS"),
        VALUE_IA_REGIWALL_SETTINGS("IA_REGIWALL_SETTINGS"),
        NULL(null);

        private String value;

        private EnumSection(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PageSavedFilter> {
        PageSavedFilter lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"display_name", "filters", "id", "page_id", "section", "time_created", "time_updated"};

        @Override
        public PageSavedFilter getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageSavedFilter parseResponse(String response) throws APIException {
            return PageSavedFilter.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PageSavedFilter execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageSavedFilter execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PageSavedFilter> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageSavedFilter> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PageSavedFilter>(){

                public PageSavedFilter apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDisplayNameField() {
            return this.requestDisplayNameField(true);
        }

        public APIRequestGet requestDisplayNameField(boolean value) {
            this.requestField("display_name", value);
            return this;
        }

        public APIRequestGet requestFiltersField() {
            return this.requestFiltersField(true);
        }

        public APIRequestGet requestFiltersField(boolean value) {
            this.requestField("filters", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestPageIdField() {
            return this.requestPageIdField(true);
        }

        public APIRequestGet requestPageIdField(boolean value) {
            this.requestField("page_id", value);
            return this;
        }

        public APIRequestGet requestSectionField() {
            return this.requestSectionField(true);
        }

        public APIRequestGet requestSectionField(boolean value) {
            this.requestField("section", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGet requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }
    }
}

