/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdActivity
extends APINode {
    @SerializedName(value="actor_id")
    private String mActorId = null;
    @SerializedName(value="actor_name")
    private String mActorName = null;
    @SerializedName(value="application_id")
    private String mApplicationId = null;
    @SerializedName(value="application_name")
    private String mApplicationName = null;
    @SerializedName(value="date_time_in_timezone")
    private String mDateTimeInTimezone = null;
    @SerializedName(value="event_time")
    private String mEventTime = null;
    @SerializedName(value="event_type")
    private EnumEventType mEventType = null;
    @SerializedName(value="extra_data")
    private String mExtraData = null;
    @SerializedName(value="object_id")
    private String mObjectId = null;
    @SerializedName(value="object_name")
    private String mObjectName = null;
    @SerializedName(value="translated_event_type")
    private String mTranslatedEventType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdActivity loadJSON(String json, APIContext context) {
        AdActivity adActivity = (AdActivity)AdActivity.getGson().fromJson(json, AdActivity.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adActivity.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adActivity.context = context;
        adActivity.rawValue = json;
        return adActivity;
    }

    public static APINodeList<AdActivity> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdActivity> adActivitys = new APINodeList<AdActivity>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adActivitys.add(AdActivity.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adActivitys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adActivitys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adActivitys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adActivitys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adActivitys.add(AdActivity.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adActivitys.add(AdActivity.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adActivitys.add(AdActivity.loadJSON(obj.toString(), context));
                        }
                    }
                    return adActivitys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adActivitys.add(AdActivity.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adActivitys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adActivitys.add(AdActivity.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adActivitys;
                }
                adActivitys.clear();
                adActivitys.add(AdActivity.loadJSON(json, context));
                return adActivitys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdActivity.getGson().toJson((Object)this);
    }

    public String getFieldActorId() {
        return this.mActorId;
    }

    public AdActivity setFieldActorId(String value) {
        this.mActorId = value;
        return this;
    }

    public String getFieldActorName() {
        return this.mActorName;
    }

    public AdActivity setFieldActorName(String value) {
        this.mActorName = value;
        return this;
    }

    public String getFieldApplicationId() {
        return this.mApplicationId;
    }

    public AdActivity setFieldApplicationId(String value) {
        this.mApplicationId = value;
        return this;
    }

    public String getFieldApplicationName() {
        return this.mApplicationName;
    }

    public AdActivity setFieldApplicationName(String value) {
        this.mApplicationName = value;
        return this;
    }

    public String getFieldDateTimeInTimezone() {
        return this.mDateTimeInTimezone;
    }

    public AdActivity setFieldDateTimeInTimezone(String value) {
        this.mDateTimeInTimezone = value;
        return this;
    }

    public String getFieldEventTime() {
        return this.mEventTime;
    }

    public AdActivity setFieldEventTime(String value) {
        this.mEventTime = value;
        return this;
    }

    public EnumEventType getFieldEventType() {
        return this.mEventType;
    }

    public AdActivity setFieldEventType(EnumEventType value) {
        this.mEventType = value;
        return this;
    }

    public String getFieldExtraData() {
        return this.mExtraData;
    }

    public AdActivity setFieldExtraData(String value) {
        this.mExtraData = value;
        return this;
    }

    public String getFieldObjectId() {
        return this.mObjectId;
    }

    public AdActivity setFieldObjectId(String value) {
        this.mObjectId = value;
        return this;
    }

    public String getFieldObjectName() {
        return this.mObjectName;
    }

    public AdActivity setFieldObjectName(String value) {
        this.mObjectName = value;
        return this;
    }

    public String getFieldTranslatedEventType() {
        return this.mTranslatedEventType;
    }

    public AdActivity setFieldTranslatedEventType(String value) {
        this.mTranslatedEventType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdActivity copyFrom(AdActivity instance) {
        this.mActorId = instance.mActorId;
        this.mActorName = instance.mActorName;
        this.mApplicationId = instance.mApplicationId;
        this.mApplicationName = instance.mApplicationName;
        this.mDateTimeInTimezone = instance.mDateTimeInTimezone;
        this.mEventTime = instance.mEventTime;
        this.mEventType = instance.mEventType;
        this.mExtraData = instance.mExtraData;
        this.mObjectId = instance.mObjectId;
        this.mObjectName = instance.mObjectName;
        this.mTranslatedEventType = instance.mTranslatedEventType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdActivity> getParser() {
        return new APIRequest.ResponseParser<AdActivity>(){

            @Override
            public APINodeList<AdActivity> parseResponse(String response, APIContext context, APIRequest<AdActivity> request) throws APIException.MalformedResponseException {
                return AdActivity.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCategory {
        VALUE_ACCOUNT("ACCOUNT"),
        VALUE_AD("AD"),
        VALUE_AD_SET("AD_SET"),
        VALUE_AUDIENCE("AUDIENCE"),
        VALUE_BID("BID"),
        VALUE_BUDGET("BUDGET"),
        VALUE_CAMPAIGN("CAMPAIGN"),
        VALUE_DATE("DATE"),
        VALUE_STATUS("STATUS"),
        VALUE_TARGETING("TARGETING"),
        NULL(null);

        private String value;

        private EnumCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumEventType {
        VALUE_AD_ACCOUNT_UPDATE_SPEND_LIMIT("ad_account_update_spend_limit"),
        VALUE_AD_ACCOUNT_RESET_SPEND_LIMIT("ad_account_reset_spend_limit"),
        VALUE_AD_ACCOUNT_REMOVE_SPEND_LIMIT("ad_account_remove_spend_limit"),
        VALUE_AD_ACCOUNT_SET_BUSINESS_INFORMATION("ad_account_set_business_information"),
        VALUE_AD_ACCOUNT_UPDATE_STATUS("ad_account_update_status"),
        VALUE_AD_ACCOUNT_ADD_USER_TO_ROLE("ad_account_add_user_to_role"),
        VALUE_AD_ACCOUNT_REMOVE_USER_FROM_ROLE("ad_account_remove_user_from_role"),
        VALUE_ADD_IMAGES("add_images"),
        VALUE_EDIT_IMAGES("edit_images"),
        VALUE_DELETE_IMAGES("delete_images"),
        VALUE_AD_ACCOUNT_BILLING_CHARGE("ad_account_billing_charge"),
        VALUE_AD_ACCOUNT_BILLING_CHARGE_FAILED("ad_account_billing_charge_failed"),
        VALUE_AD_ACCOUNT_BILLING_CHARGEBACK("ad_account_billing_chargeback"),
        VALUE_AD_ACCOUNT_BILLING_CHARGEBACK_REVERSAL("ad_account_billing_chargeback_reversal"),
        VALUE_AD_ACCOUNT_BILLING_DECLINE("ad_account_billing_decline"),
        VALUE_AD_ACCOUNT_BILLING_REFUND("ad_account_billing_refund"),
        VALUE_BILLING_EVENT("billing_event"),
        VALUE_ADD_FUNDING_SOURCE("add_funding_source"),
        VALUE_REMOVE_FUNDING_SOURCE("remove_funding_source"),
        VALUE_CREATE_CAMPAIGN_GROUP("create_campaign_group"),
        VALUE_UPDATE_CAMPAIGN_NAME("update_campaign_name"),
        VALUE_UPDATE_CAMPAIGN_RUN_STATUS("update_campaign_run_status"),
        VALUE_UPDATE_CAMPAIGN_GROUP_SPEND_CAP("update_campaign_group_spend_cap"),
        VALUE_CREATE_CAMPAIGN_LEGACY("create_campaign_legacy"),
        VALUE_UPDATE_CAMPAIGN_BUDGET("update_campaign_budget"),
        VALUE_UPDATE_CAMPAIGN_DURATION("update_campaign_duration"),
        VALUE_CAMPAIGN_ENDED("campaign_ended"),
        VALUE_CREATE_AD_SET("create_ad_set"),
        VALUE_UPDATE_AD_SET_BIDDING("update_ad_set_bidding"),
        VALUE_UPDATE_AD_SET_BID_STRATEGY("update_ad_set_bid_strategy"),
        VALUE_UPDATE_AD_SET_BUDGET("update_ad_set_budget"),
        VALUE_UPDATE_AD_SET_DURATION("update_ad_set_duration"),
        VALUE_UPDATE_AD_SET_RUN_STATUS("update_ad_set_run_status"),
        VALUE_UPDATE_AD_SET_NAME("update_ad_set_name"),
        VALUE_UPDATE_AD_SET_OPTIMIZATION_GOAL("update_ad_set_optimization_goal"),
        VALUE_UPDATE_AD_SET_TARGET_SPEC("update_ad_set_target_spec"),
        VALUE_UPDATE_AD_SET_BID_ADJUSTMENTS("update_ad_set_bid_adjustments"),
        VALUE_CREATE_AD("create_ad"),
        VALUE_AD_REVIEW_APPROVED("ad_review_approved"),
        VALUE_AD_REVIEW_DECLINED("ad_review_declined"),
        VALUE_UPDATE_AD_CREATIVE("update_ad_creative"),
        VALUE_EDIT_AND_UPDATE_AD_CREATIVE("edit_and_update_ad_creative"),
        VALUE_UPDATE_AD_BID_INFO("update_ad_bid_info"),
        VALUE_UPDATE_AD_BID_TYPE("update_ad_bid_type"),
        VALUE_UPDATE_AD_RUN_STATUS("update_ad_run_status"),
        VALUE_UPDATE_AD_FRIENDLY_NAME("update_ad_friendly_name"),
        VALUE_UPDATE_AD_TARGETS_SPEC("update_ad_targets_spec"),
        VALUE_UPDATE_ADGROUP_STOP_DELIVERY("update_adgroup_stop_delivery"),
        VALUE_FIRST_DELIVERY_EVENT("first_delivery_event"),
        VALUE_CREATE_AUDIENCE("create_audience"),
        VALUE_UPDATE_AUDIENCE("update_audience"),
        VALUE_DELETE_AUDIENCE("delete_audience"),
        VALUE_SHARE_AUDIENCE("share_audience"),
        VALUE_RECEIVE_AUDIENCE("receive_audience"),
        VALUE_UNSHARE_AUDIENCE("unshare_audience"),
        VALUE_REMOVE_SHARED_AUDIENCE("remove_shared_audience"),
        VALUE_UNKNOWN("unknown"),
        VALUE_ACCOUNT_SPENDING_LIMIT_REACHED("account_spending_limit_reached"),
        VALUE_CAMPAIGN_SPENDING_LIMIT_REACHED("campaign_spending_limit_reached"),
        VALUE_LIFETIME_BUDGET_SPENT("lifetime_budget_spent"),
        VALUE_FUNDING_EVENT_INITIATED("funding_event_initiated"),
        VALUE_FUNDING_EVENT_SUCCESSFUL("funding_event_successful"),
        VALUE_UPDATE_AD_LABELS("update_ad_labels"),
        VALUE_DI_AD_SET_LEARNING_STAGE_EXIT("di_ad_set_learning_stage_exit"),
        NULL(null);

        private String value;

        private EnumEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

