/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachFrequencySpec
extends APINode {
    @SerializedName(value="countries")
    private List<String> mCountries = null;
    @SerializedName(value="default_creation_data")
    private Object mDefaultCreationData = null;
    @SerializedName(value="max_campaign_duration")
    private Object mMaxCampaignDuration = null;
    @SerializedName(value="max_days_to_finish")
    private Object mMaxDaysToFinish = null;
    @SerializedName(value="max_pause_without_prediction_rerun")
    private Object mMaxPauseWithoutPredictionRerun = null;
    @SerializedName(value="min_campaign_duration")
    private Object mMinCampaignDuration = null;
    @SerializedName(value="min_reach_limits")
    private Object mMinReachLimits = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ReachFrequencySpec loadJSON(String json, APIContext context) {
        ReachFrequencySpec reachFrequencySpec = (ReachFrequencySpec)ReachFrequencySpec.getGson().fromJson(json, ReachFrequencySpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reachFrequencySpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reachFrequencySpec.context = context;
        reachFrequencySpec.rawValue = json;
        return reachFrequencySpec;
    }

    public static APINodeList<ReachFrequencySpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ReachFrequencySpec> reachFrequencySpecs = new APINodeList<ReachFrequencySpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reachFrequencySpecs.add(ReachFrequencySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return reachFrequencySpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reachFrequencySpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reachFrequencySpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            reachFrequencySpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reachFrequencySpecs.add(ReachFrequencySpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reachFrequencySpecs.add(ReachFrequencySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reachFrequencySpecs.add(ReachFrequencySpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return reachFrequencySpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reachFrequencySpecs.add(ReachFrequencySpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return reachFrequencySpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reachFrequencySpecs.add(ReachFrequencySpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reachFrequencySpecs;
                }
                reachFrequencySpecs.clear();
                reachFrequencySpecs.add(ReachFrequencySpec.loadJSON(json, context));
                return reachFrequencySpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReachFrequencySpec.getGson().toJson((Object)this);
    }

    public List<String> getFieldCountries() {
        return this.mCountries;
    }

    public ReachFrequencySpec setFieldCountries(List<String> value) {
        this.mCountries = value;
        return this;
    }

    public Object getFieldDefaultCreationData() {
        return this.mDefaultCreationData;
    }

    public ReachFrequencySpec setFieldDefaultCreationData(Object value) {
        this.mDefaultCreationData = value;
        return this;
    }

    public Object getFieldMaxCampaignDuration() {
        return this.mMaxCampaignDuration;
    }

    public ReachFrequencySpec setFieldMaxCampaignDuration(Object value) {
        this.mMaxCampaignDuration = value;
        return this;
    }

    public Object getFieldMaxDaysToFinish() {
        return this.mMaxDaysToFinish;
    }

    public ReachFrequencySpec setFieldMaxDaysToFinish(Object value) {
        this.mMaxDaysToFinish = value;
        return this;
    }

    public Object getFieldMaxPauseWithoutPredictionRerun() {
        return this.mMaxPauseWithoutPredictionRerun;
    }

    public ReachFrequencySpec setFieldMaxPauseWithoutPredictionRerun(Object value) {
        this.mMaxPauseWithoutPredictionRerun = value;
        return this;
    }

    public Object getFieldMinCampaignDuration() {
        return this.mMinCampaignDuration;
    }

    public ReachFrequencySpec setFieldMinCampaignDuration(Object value) {
        this.mMinCampaignDuration = value;
        return this;
    }

    public Object getFieldMinReachLimits() {
        return this.mMinReachLimits;
    }

    public ReachFrequencySpec setFieldMinReachLimits(Object value) {
        this.mMinReachLimits = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReachFrequencySpec copyFrom(ReachFrequencySpec instance) {
        this.mCountries = instance.mCountries;
        this.mDefaultCreationData = instance.mDefaultCreationData;
        this.mMaxCampaignDuration = instance.mMaxCampaignDuration;
        this.mMaxDaysToFinish = instance.mMaxDaysToFinish;
        this.mMaxPauseWithoutPredictionRerun = instance.mMaxPauseWithoutPredictionRerun;
        this.mMinCampaignDuration = instance.mMinCampaignDuration;
        this.mMinReachLimits = instance.mMinReachLimits;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReachFrequencySpec> getParser() {
        return new APIRequest.ResponseParser<ReachFrequencySpec>(){

            @Override
            public APINodeList<ReachFrequencySpec> parseResponse(String response, APIContext context, APIRequest<ReachFrequencySpec> request) throws APIException.MalformedResponseException {
                return ReachFrequencySpec.parseResponse(response, context, request);
            }
        };
    }
}

