/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.InstagramInsightsResult;
import com.facebook.ads.sdk.ShadowIGComment;
import com.facebook.ads.sdk.ShadowIGMedia;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowIGUser
extends APINode {
    @SerializedName(value="biography")
    private String mBiography = null;
    @SerializedName(value="business_discovery")
    private ShadowIGUser mBusinessDiscovery = null;
    @SerializedName(value="followers_count")
    private Long mFollowersCount = null;
    @SerializedName(value="follows_count")
    private Long mFollowsCount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="ig_id")
    private Long mIgId = null;
    @SerializedName(value="media_count")
    private Long mMediaCount = null;
    @SerializedName(value="mentioned_comment")
    private ShadowIGComment mMentionedComment = null;
    @SerializedName(value="mentioned_media")
    private ShadowIGMedia mMentionedMedia = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="profile_picture_url")
    private String mProfilePictureUrl = null;
    @SerializedName(value="username")
    private String mUsername = null;
    @SerializedName(value="website")
    private String mWebsite = null;
    protected static Gson gson = null;

    ShadowIGUser() {
    }

    public ShadowIGUser(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ShadowIGUser(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ShadowIGUser fetch() throws APIException {
        ShadowIGUser newInstance = ShadowIGUser.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ShadowIGUser fetchById(Long id, APIContext context) throws APIException {
        return ShadowIGUser.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ShadowIGUser> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ShadowIGUser.fetchByIdAsync(id.toString(), context);
    }

    public static ShadowIGUser fetchById(String id, APIContext context) throws APIException {
        ShadowIGUser shadowIGUser = new APIRequestGet(id, context).requestAllFields().execute();
        return shadowIGUser;
    }

    public static ListenableFuture<ShadowIGUser> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<ShadowIGUser> shadowIGUser = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return shadowIGUser;
    }

    public static APINodeList<ShadowIGUser> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ShadowIGUser>(context, "", "/", "GET", ShadowIGUser.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ShadowIGUser>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> shadowIGUser = new APIRequest<ShadowIGUser>(context, "", "/", "GET", ShadowIGUser.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return shadowIGUser;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ShadowIGUser loadJSON(String json, APIContext context) {
        ShadowIGUser shadowIGUser = (ShadowIGUser)ShadowIGUser.getGson().fromJson(json, ShadowIGUser.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(shadowIGUser.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        shadowIGUser.context = context;
        shadowIGUser.rawValue = json;
        return shadowIGUser;
    }

    public static APINodeList<ShadowIGUser> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<ShadowIGUser> shadowIGUsers = new APINodeList<ShadowIGUser>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        shadowIGUsers.add(ShadowIGUser.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return shadowIGUsers;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            shadowIGUsers.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        shadowIGUsers.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            shadowIGUsers.add(ShadowIGUser.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                shadowIGUsers.add(ShadowIGUser.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            shadowIGUsers.add(ShadowIGUser.loadJSON(obj.toString(), context));
                        }
                    }
                    return shadowIGUsers;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        shadowIGUsers.add(ShadowIGUser.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return shadowIGUsers;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        shadowIGUsers.add(ShadowIGUser.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return shadowIGUsers;
                }
                shadowIGUsers.clear();
                shadowIGUsers.add(ShadowIGUser.loadJSON(json, context));
                return shadowIGUsers;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ShadowIGUser.getGson().toJson((Object)this);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMedia createMedia() {
        return new APIRequestCreateMedia(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMedia getMedia() {
        return new APIRequestGetMedia(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMediaPublish createMediaPublish() {
        return new APIRequestCreateMediaPublish(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTags getTags() {
        return new APIRequestGetTags(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBiography() {
        return this.mBiography;
    }

    public ShadowIGUser getFieldBusinessDiscovery() {
        if (this.mBusinessDiscovery != null) {
            this.mBusinessDiscovery.context = this.getContext();
        }
        return this.mBusinessDiscovery;
    }

    public Long getFieldFollowersCount() {
        return this.mFollowersCount;
    }

    public Long getFieldFollowsCount() {
        return this.mFollowsCount;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldIgId() {
        return this.mIgId;
    }

    public Long getFieldMediaCount() {
        return this.mMediaCount;
    }

    public ShadowIGComment getFieldMentionedComment() {
        if (this.mMentionedComment != null) {
            this.mMentionedComment.context = this.getContext();
        }
        return this.mMentionedComment;
    }

    public ShadowIGMedia getFieldMentionedMedia() {
        if (this.mMentionedMedia != null) {
            this.mMentionedMedia.context = this.getContext();
        }
        return this.mMentionedMedia;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldProfilePictureUrl() {
        return this.mProfilePictureUrl;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    public String getFieldWebsite() {
        return this.mWebsite;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ShadowIGUser copyFrom(ShadowIGUser instance) {
        this.mBiography = instance.mBiography;
        this.mBusinessDiscovery = instance.mBusinessDiscovery;
        this.mFollowersCount = instance.mFollowersCount;
        this.mFollowsCount = instance.mFollowsCount;
        this.mId = instance.mId;
        this.mIgId = instance.mIgId;
        this.mMediaCount = instance.mMediaCount;
        this.mMentionedComment = instance.mMentionedComment;
        this.mMentionedMedia = instance.mMentionedMedia;
        this.mName = instance.mName;
        this.mProfilePictureUrl = instance.mProfilePictureUrl;
        this.mUsername = instance.mUsername;
        this.mWebsite = instance.mWebsite;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ShadowIGUser> getParser() {
        return new APIRequest.ResponseParser<ShadowIGUser>(){

            @Override
            public APINodeList<ShadowIGUser> parseResponse(String response, APIContext context, APIRequest<ShadowIGUser> request) throws APIException.MalformedResponseException {
                return ShadowIGUser.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ShadowIGUser> {
        ShadowIGUser lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"biography", "business_discovery", "followers_count", "follows_count", "id", "ig_id", "media_count", "mentioned_comment", "mentioned_media", "name", "profile_picture_url", "username", "website"};

        @Override
        public ShadowIGUser getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ShadowIGUser parseResponse(String response) throws APIException {
            return ShadowIGUser.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ShadowIGUser execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ShadowIGUser execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ShadowIGUser> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ShadowIGUser> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ShadowIGUser>(){

                public ShadowIGUser apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBiographyField() {
            return this.requestBiographyField(true);
        }

        public APIRequestGet requestBiographyField(boolean value) {
            this.requestField("biography", value);
            return this;
        }

        public APIRequestGet requestBusinessDiscoveryField() {
            return this.requestBusinessDiscoveryField(true);
        }

        public APIRequestGet requestBusinessDiscoveryField(boolean value) {
            this.requestField("business_discovery", value);
            return this;
        }

        public APIRequestGet requestFollowersCountField() {
            return this.requestFollowersCountField(true);
        }

        public APIRequestGet requestFollowersCountField(boolean value) {
            this.requestField("followers_count", value);
            return this;
        }

        public APIRequestGet requestFollowsCountField() {
            return this.requestFollowsCountField(true);
        }

        public APIRequestGet requestFollowsCountField(boolean value) {
            this.requestField("follows_count", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIgIdField() {
            return this.requestIgIdField(true);
        }

        public APIRequestGet requestIgIdField(boolean value) {
            this.requestField("ig_id", value);
            return this;
        }

        public APIRequestGet requestMediaCountField() {
            return this.requestMediaCountField(true);
        }

        public APIRequestGet requestMediaCountField(boolean value) {
            this.requestField("media_count", value);
            return this;
        }

        public APIRequestGet requestMentionedCommentField() {
            return this.requestMentionedCommentField(true);
        }

        public APIRequestGet requestMentionedCommentField(boolean value) {
            this.requestField("mentioned_comment", value);
            return this;
        }

        public APIRequestGet requestMentionedMediaField() {
            return this.requestMentionedMediaField(true);
        }

        public APIRequestGet requestMentionedMediaField(boolean value) {
            this.requestField("mentioned_media", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestProfilePictureUrlField() {
            return this.requestProfilePictureUrlField(true);
        }

        public APIRequestGet requestProfilePictureUrlField(boolean value) {
            this.requestField("profile_picture_url", value);
            return this;
        }

        public APIRequestGet requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGet requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGet requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGet requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTags
    extends APIRequest<ShadowIGMedia> {
        APINodeList<ShadowIGMedia> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"caption", "comments_count", "id", "ig_id", "is_comment_enabled", "like_count", "media_type", "media_url", "owner", "permalink", "shortcode", "thumbnail_url", "timestamp", "username"};

        @Override
        public APINodeList<ShadowIGMedia> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ShadowIGMedia> parseResponse(String response) throws APIException {
            return ShadowIGMedia.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ShadowIGMedia> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ShadowIGMedia> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ShadowIGMedia>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ShadowIGMedia>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<ShadowIGMedia>>(){

                public APINodeList<ShadowIGMedia> apply(String result) {
                    try {
                        return APIRequestGetTags.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTags(String nodeId, APIContext context) {
            super(context, nodeId, "/tags", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTags setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTags setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTags requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTags requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTags requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTags requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTags requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTags requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTags requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGetTags requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGetTags requestCommentsCountField() {
            return this.requestCommentsCountField(true);
        }

        public APIRequestGetTags requestCommentsCountField(boolean value) {
            this.requestField("comments_count", value);
            return this;
        }

        public APIRequestGetTags requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTags requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetTags requestIgIdField() {
            return this.requestIgIdField(true);
        }

        public APIRequestGetTags requestIgIdField(boolean value) {
            this.requestField("ig_id", value);
            return this;
        }

        public APIRequestGetTags requestIsCommentEnabledField() {
            return this.requestIsCommentEnabledField(true);
        }

        public APIRequestGetTags requestIsCommentEnabledField(boolean value) {
            this.requestField("is_comment_enabled", value);
            return this;
        }

        public APIRequestGetTags requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGetTags requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGetTags requestMediaTypeField() {
            return this.requestMediaTypeField(true);
        }

        public APIRequestGetTags requestMediaTypeField(boolean value) {
            this.requestField("media_type", value);
            return this;
        }

        public APIRequestGetTags requestMediaUrlField() {
            return this.requestMediaUrlField(true);
        }

        public APIRequestGetTags requestMediaUrlField(boolean value) {
            this.requestField("media_url", value);
            return this;
        }

        public APIRequestGetTags requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetTags requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetTags requestPermalinkField() {
            return this.requestPermalinkField(true);
        }

        public APIRequestGetTags requestPermalinkField(boolean value) {
            this.requestField("permalink", value);
            return this;
        }

        public APIRequestGetTags requestShortcodeField() {
            return this.requestShortcodeField(true);
        }

        public APIRequestGetTags requestShortcodeField(boolean value) {
            this.requestField("shortcode", value);
            return this;
        }

        public APIRequestGetTags requestThumbnailUrlField() {
            return this.requestThumbnailUrlField(true);
        }

        public APIRequestGetTags requestThumbnailUrlField(boolean value) {
            this.requestField("thumbnail_url", value);
            return this;
        }

        public APIRequestGetTags requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGetTags requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGetTags requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetTags requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateMediaPublish
    extends APIRequest<ShadowIGMedia> {
        ShadowIGMedia lastResponse = null;
        public static final String[] PARAMS = new String[]{"creation_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ShadowIGMedia getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ShadowIGMedia parseResponse(String response) throws APIException {
            return ShadowIGMedia.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ShadowIGMedia execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ShadowIGMedia execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ShadowIGMedia> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ShadowIGMedia> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ShadowIGMedia>(){

                public ShadowIGMedia apply(String result) {
                    try {
                        return APIRequestCreateMediaPublish.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateMediaPublish(String nodeId, APIContext context) {
            super(context, nodeId, "/media_publish", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMediaPublish setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMediaPublish setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMediaPublish setCreationId(Long creationId) {
            this.setParam("creation_id", creationId);
            return this;
        }

        public APIRequestCreateMediaPublish setCreationId(String creationId) {
            this.setParam("creation_id", creationId);
            return this;
        }

        public APIRequestCreateMediaPublish requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMediaPublish requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMediaPublish requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMediaPublish requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMediaPublish requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMediaPublish requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetMedia
    extends APIRequest<ShadowIGMedia> {
        APINodeList<ShadowIGMedia> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"caption", "comments_count", "id", "ig_id", "is_comment_enabled", "like_count", "media_type", "media_url", "owner", "permalink", "shortcode", "thumbnail_url", "timestamp", "username"};

        @Override
        public APINodeList<ShadowIGMedia> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ShadowIGMedia> parseResponse(String response) throws APIException {
            return ShadowIGMedia.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ShadowIGMedia> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ShadowIGMedia> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ShadowIGMedia>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ShadowIGMedia>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<ShadowIGMedia>>(){

                public APINodeList<ShadowIGMedia> apply(String result) {
                    try {
                        return APIRequestGetMedia.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetMedia(String nodeId, APIContext context) {
            super(context, nodeId, "/media", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMedia setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMedia setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMedia requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMedia requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMedia requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMedia requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMedia requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMedia requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetMedia requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGetMedia requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGetMedia requestCommentsCountField() {
            return this.requestCommentsCountField(true);
        }

        public APIRequestGetMedia requestCommentsCountField(boolean value) {
            this.requestField("comments_count", value);
            return this;
        }

        public APIRequestGetMedia requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetMedia requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetMedia requestIgIdField() {
            return this.requestIgIdField(true);
        }

        public APIRequestGetMedia requestIgIdField(boolean value) {
            this.requestField("ig_id", value);
            return this;
        }

        public APIRequestGetMedia requestIsCommentEnabledField() {
            return this.requestIsCommentEnabledField(true);
        }

        public APIRequestGetMedia requestIsCommentEnabledField(boolean value) {
            this.requestField("is_comment_enabled", value);
            return this;
        }

        public APIRequestGetMedia requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGetMedia requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGetMedia requestMediaTypeField() {
            return this.requestMediaTypeField(true);
        }

        public APIRequestGetMedia requestMediaTypeField(boolean value) {
            this.requestField("media_type", value);
            return this;
        }

        public APIRequestGetMedia requestMediaUrlField() {
            return this.requestMediaUrlField(true);
        }

        public APIRequestGetMedia requestMediaUrlField(boolean value) {
            this.requestField("media_url", value);
            return this;
        }

        public APIRequestGetMedia requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetMedia requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetMedia requestPermalinkField() {
            return this.requestPermalinkField(true);
        }

        public APIRequestGetMedia requestPermalinkField(boolean value) {
            this.requestField("permalink", value);
            return this;
        }

        public APIRequestGetMedia requestShortcodeField() {
            return this.requestShortcodeField(true);
        }

        public APIRequestGetMedia requestShortcodeField(boolean value) {
            this.requestField("shortcode", value);
            return this;
        }

        public APIRequestGetMedia requestThumbnailUrlField() {
            return this.requestThumbnailUrlField(true);
        }

        public APIRequestGetMedia requestThumbnailUrlField(boolean value) {
            this.requestField("thumbnail_url", value);
            return this;
        }

        public APIRequestGetMedia requestTimestampField() {
            return this.requestTimestampField(true);
        }

        public APIRequestGetMedia requestTimestampField(boolean value) {
            this.requestField("timestamp", value);
            return this;
        }

        public APIRequestGetMedia requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetMedia requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateMedia
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"caption", "image_url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateMedia.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateMedia(String nodeId, APIContext context) {
            super(context, nodeId, "/media", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMedia setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMedia setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMedia setCaption(String caption) {
            this.setParam("caption", caption);
            return this;
        }

        public APIRequestCreateMedia setImageUrl(String imageUrl) {
            this.setParam("image_url", imageUrl);
            return this;
        }

        public APIRequestCreateMedia requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMedia requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMedia requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMedia requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMedia requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMedia requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInsights
    extends APIRequest<InstagramInsightsResult> {
        APINodeList<InstagramInsightsResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"metric", "period", "since", "until"};
        public static final String[] FIELDS = new String[]{"description", "id", "name", "period", "title", "values"};

        @Override
        public APINodeList<InstagramInsightsResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<InstagramInsightsResult> parseResponse(String response) throws APIException {
            return InstagramInsightsResult.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<InstagramInsightsResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<InstagramInsightsResult> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<InstagramInsightsResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<InstagramInsightsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<InstagramInsightsResult>>(){

                public APINodeList<InstagramInsightsResult> apply(String result) {
                    try {
                        return APIRequestGetInsights.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights setMetric(List<InstagramInsightsResult.EnumMetric> metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setMetric(String metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setPeriod(List<InstagramInsightsResult.EnumPeriod> period) {
            this.setParam("period", period);
            return this;
        }

        public APIRequestGetInsights setPeriod(String period) {
            this.setParam("period", period);
            return this;
        }

        public APIRequestGetInsights setSince(String since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestGetInsights setUntil(String until) {
            this.setParam("until", until);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetInsights requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetInsights requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetInsights requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetInsights requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetInsights requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetInsights requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetInsights requestPeriodField() {
            return this.requestPeriodField(true);
        }

        public APIRequestGetInsights requestPeriodField(boolean value) {
            this.requestField("period", value);
            return this;
        }

        public APIRequestGetInsights requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetInsights requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetInsights requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGetInsights requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }
    }
}

