/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.Targeting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachFrequencyPrediction
extends APINode {
    @SerializedName(value="account_id")
    private Long mAccountId = null;
    @SerializedName(value="campaign_group_id")
    private Long mCampaignGroupId = null;
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="campaign_time_start")
    private String mCampaignTimeStart = null;
    @SerializedName(value="campaign_time_stop")
    private String mCampaignTimeStop = null;
    @SerializedName(value="curve_budget_reach")
    private Object mCurveBudgetReach = null;
    @SerializedName(value="daily_impression_curve")
    private List<Double> mDailyImpressionCurve = null;
    @SerializedName(value="destination_id")
    private String mDestinationId = null;
    @SerializedName(value="expiration_time")
    private String mExpirationTime = null;
    @SerializedName(value="external_budget")
    private Long mExternalBudget = null;
    @SerializedName(value="external_impression")
    private Long mExternalImpression = null;
    @SerializedName(value="external_maximum_budget")
    private Long mExternalMaximumBudget = null;
    @SerializedName(value="external_maximum_impression")
    private String mExternalMaximumImpression = null;
    @SerializedName(value="external_maximum_reach")
    private Long mExternalMaximumReach = null;
    @SerializedName(value="external_minimum_budget")
    private Long mExternalMinimumBudget = null;
    @SerializedName(value="external_minimum_impression")
    private Long mExternalMinimumImpression = null;
    @SerializedName(value="external_minimum_reach")
    private Long mExternalMinimumReach = null;
    @SerializedName(value="external_reach")
    private Long mExternalReach = null;
    @SerializedName(value="frequency_cap")
    private Long mFrequencyCap = null;
    @SerializedName(value="frequency_distribution")
    private List<Double> mFrequencyDistribution = null;
    @SerializedName(value="frequency_distribution_map")
    private List<Object> mFrequencyDistributionMap = null;
    @SerializedName(value="frequency_distribution_map_agg")
    private List<Object> mFrequencyDistributionMapAgg = null;
    @SerializedName(value="grp_dmas_audience_size")
    private Double mGrpDmasAudienceSize = null;
    @SerializedName(value="holdout_percentage")
    private Long mHoldoutPercentage = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="instagram_destination_id")
    private String mInstagramDestinationId = null;
    @SerializedName(value="interval_frequency_cap")
    private Long mIntervalFrequencyCap = null;
    @SerializedName(value="interval_frequency_cap_reset_period")
    private Long mIntervalFrequencyCapResetPeriod = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="pause_periods")
    private List<Object> mPausePeriods = null;
    @SerializedName(value="placement_breakdown")
    private Object mPlacementBreakdown = null;
    @SerializedName(value="prediction_mode")
    private Long mPredictionMode = null;
    @SerializedName(value="prediction_progress")
    private Long mPredictionProgress = null;
    @SerializedName(value="reservation_status")
    private Long mReservationStatus = null;
    @SerializedName(value="status")
    private Long mStatus = null;
    @SerializedName(value="story_event_type")
    private Long mStoryEventType = null;
    @SerializedName(value="target_audience_size")
    private Long mTargetAudienceSize = null;
    @SerializedName(value="target_spec")
    private Targeting mTargetSpec = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="time_updated")
    private String mTimeUpdated = null;
    protected static Gson gson = null;

    ReachFrequencyPrediction() {
    }

    public ReachFrequencyPrediction(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ReachFrequencyPrediction(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ReachFrequencyPrediction fetch() throws APIException {
        ReachFrequencyPrediction newInstance = ReachFrequencyPrediction.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ReachFrequencyPrediction fetchById(Long id, APIContext context) throws APIException {
        return ReachFrequencyPrediction.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ReachFrequencyPrediction> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ReachFrequencyPrediction.fetchByIdAsync(id.toString(), context);
    }

    public static ReachFrequencyPrediction fetchById(String id, APIContext context) throws APIException {
        ReachFrequencyPrediction reachFrequencyPrediction = new APIRequestGet(id, context).requestAllFields().execute();
        return reachFrequencyPrediction;
    }

    public static ListenableFuture<ReachFrequencyPrediction> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<ReachFrequencyPrediction> reachFrequencyPrediction = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return reachFrequencyPrediction;
    }

    public static APINodeList<ReachFrequencyPrediction> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ReachFrequencyPrediction>(context, "", "/", "GET", ReachFrequencyPrediction.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ReachFrequencyPrediction>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> reachFrequencyPrediction = new APIRequest<ReachFrequencyPrediction>(context, "", "/", "GET", ReachFrequencyPrediction.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return reachFrequencyPrediction;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ReachFrequencyPrediction loadJSON(String json, APIContext context) {
        ReachFrequencyPrediction reachFrequencyPrediction = (ReachFrequencyPrediction)ReachFrequencyPrediction.getGson().fromJson(json, ReachFrequencyPrediction.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reachFrequencyPrediction.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reachFrequencyPrediction.context = context;
        reachFrequencyPrediction.rawValue = json;
        return reachFrequencyPrediction;
    }

    public static APINodeList<ReachFrequencyPrediction> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<ReachFrequencyPrediction> reachFrequencyPredictions = new APINodeList<ReachFrequencyPrediction>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return reachFrequencyPredictions;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reachFrequencyPredictions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reachFrequencyPredictions.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(obj.toString(), context));
                        }
                    }
                    return reachFrequencyPredictions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return reachFrequencyPredictions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reachFrequencyPredictions;
                }
                reachFrequencyPredictions.clear();
                reachFrequencyPredictions.add(ReachFrequencyPrediction.loadJSON(json, context));
                return reachFrequencyPredictions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReachFrequencyPrediction.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAccountId() {
        return this.mAccountId;
    }

    public Long getFieldCampaignGroupId() {
        return this.mCampaignGroupId;
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public String getFieldCampaignTimeStart() {
        return this.mCampaignTimeStart;
    }

    public String getFieldCampaignTimeStop() {
        return this.mCampaignTimeStop;
    }

    public Object getFieldCurveBudgetReach() {
        return this.mCurveBudgetReach;
    }

    public List<Double> getFieldDailyImpressionCurve() {
        return this.mDailyImpressionCurve;
    }

    public String getFieldDestinationId() {
        return this.mDestinationId;
    }

    public String getFieldExpirationTime() {
        return this.mExpirationTime;
    }

    public Long getFieldExternalBudget() {
        return this.mExternalBudget;
    }

    public Long getFieldExternalImpression() {
        return this.mExternalImpression;
    }

    public Long getFieldExternalMaximumBudget() {
        return this.mExternalMaximumBudget;
    }

    public String getFieldExternalMaximumImpression() {
        return this.mExternalMaximumImpression;
    }

    public Long getFieldExternalMaximumReach() {
        return this.mExternalMaximumReach;
    }

    public Long getFieldExternalMinimumBudget() {
        return this.mExternalMinimumBudget;
    }

    public Long getFieldExternalMinimumImpression() {
        return this.mExternalMinimumImpression;
    }

    public Long getFieldExternalMinimumReach() {
        return this.mExternalMinimumReach;
    }

    public Long getFieldExternalReach() {
        return this.mExternalReach;
    }

    public Long getFieldFrequencyCap() {
        return this.mFrequencyCap;
    }

    public List<Double> getFieldFrequencyDistribution() {
        return this.mFrequencyDistribution;
    }

    public List<Object> getFieldFrequencyDistributionMap() {
        return this.mFrequencyDistributionMap;
    }

    public List<Object> getFieldFrequencyDistributionMapAgg() {
        return this.mFrequencyDistributionMapAgg;
    }

    public Double getFieldGrpDmasAudienceSize() {
        return this.mGrpDmasAudienceSize;
    }

    public Long getFieldHoldoutPercentage() {
        return this.mHoldoutPercentage;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldInstagramDestinationId() {
        return this.mInstagramDestinationId;
    }

    public Long getFieldIntervalFrequencyCap() {
        return this.mIntervalFrequencyCap;
    }

    public Long getFieldIntervalFrequencyCapResetPeriod() {
        return this.mIntervalFrequencyCapResetPeriod;
    }

    public String getFieldName() {
        return this.mName;
    }

    public List<Object> getFieldPausePeriods() {
        return this.mPausePeriods;
    }

    public Object getFieldPlacementBreakdown() {
        return this.mPlacementBreakdown;
    }

    public Long getFieldPredictionMode() {
        return this.mPredictionMode;
    }

    public Long getFieldPredictionProgress() {
        return this.mPredictionProgress;
    }

    public Long getFieldReservationStatus() {
        return this.mReservationStatus;
    }

    public Long getFieldStatus() {
        return this.mStatus;
    }

    public Long getFieldStoryEventType() {
        return this.mStoryEventType;
    }

    public Long getFieldTargetAudienceSize() {
        return this.mTargetAudienceSize;
    }

    public Targeting getFieldTargetSpec() {
        return this.mTargetSpec;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public String getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReachFrequencyPrediction copyFrom(ReachFrequencyPrediction instance) {
        this.mAccountId = instance.mAccountId;
        this.mCampaignGroupId = instance.mCampaignGroupId;
        this.mCampaignId = instance.mCampaignId;
        this.mCampaignTimeStart = instance.mCampaignTimeStart;
        this.mCampaignTimeStop = instance.mCampaignTimeStop;
        this.mCurveBudgetReach = instance.mCurveBudgetReach;
        this.mDailyImpressionCurve = instance.mDailyImpressionCurve;
        this.mDestinationId = instance.mDestinationId;
        this.mExpirationTime = instance.mExpirationTime;
        this.mExternalBudget = instance.mExternalBudget;
        this.mExternalImpression = instance.mExternalImpression;
        this.mExternalMaximumBudget = instance.mExternalMaximumBudget;
        this.mExternalMaximumImpression = instance.mExternalMaximumImpression;
        this.mExternalMaximumReach = instance.mExternalMaximumReach;
        this.mExternalMinimumBudget = instance.mExternalMinimumBudget;
        this.mExternalMinimumImpression = instance.mExternalMinimumImpression;
        this.mExternalMinimumReach = instance.mExternalMinimumReach;
        this.mExternalReach = instance.mExternalReach;
        this.mFrequencyCap = instance.mFrequencyCap;
        this.mFrequencyDistribution = instance.mFrequencyDistribution;
        this.mFrequencyDistributionMap = instance.mFrequencyDistributionMap;
        this.mFrequencyDistributionMapAgg = instance.mFrequencyDistributionMapAgg;
        this.mGrpDmasAudienceSize = instance.mGrpDmasAudienceSize;
        this.mHoldoutPercentage = instance.mHoldoutPercentage;
        this.mId = instance.mId;
        this.mInstagramDestinationId = instance.mInstagramDestinationId;
        this.mIntervalFrequencyCap = instance.mIntervalFrequencyCap;
        this.mIntervalFrequencyCapResetPeriod = instance.mIntervalFrequencyCapResetPeriod;
        this.mName = instance.mName;
        this.mPausePeriods = instance.mPausePeriods;
        this.mPlacementBreakdown = instance.mPlacementBreakdown;
        this.mPredictionMode = instance.mPredictionMode;
        this.mPredictionProgress = instance.mPredictionProgress;
        this.mReservationStatus = instance.mReservationStatus;
        this.mStatus = instance.mStatus;
        this.mStoryEventType = instance.mStoryEventType;
        this.mTargetAudienceSize = instance.mTargetAudienceSize;
        this.mTargetSpec = instance.mTargetSpec;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReachFrequencyPrediction> getParser() {
        return new APIRequest.ResponseParser<ReachFrequencyPrediction>(){

            @Override
            public APINodeList<ReachFrequencyPrediction> parseResponse(String response, APIContext context, APIRequest<ReachFrequencyPrediction> request) throws APIException.MalformedResponseException {
                return ReachFrequencyPrediction.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_EXPIRED("EXPIRED"),
        VALUE_DRAFT("DRAFT"),
        VALUE_PENDING("PENDING"),
        VALUE_ACTIVE("ACTIVE"),
        VALUE_COMPLETED("COMPLETED"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumInstreamPackages {
        VALUE_NORMAL("NORMAL"),
        VALUE_PREMIUM("PREMIUM"),
        VALUE_SPORTS("SPORTS"),
        VALUE_ENTERTAINMENT("ENTERTAINMENT"),
        VALUE_BEAUTY("BEAUTY"),
        NULL(null);

        private String value;

        private EnumInstreamPackages(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ReachFrequencyPrediction> {
        ReachFrequencyPrediction lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "campaign_group_id", "campaign_id", "campaign_time_start", "campaign_time_stop", "curve_budget_reach", "daily_impression_curve", "destination_id", "expiration_time", "external_budget", "external_impression", "external_maximum_budget", "external_maximum_impression", "external_maximum_reach", "external_minimum_budget", "external_minimum_impression", "external_minimum_reach", "external_reach", "frequency_cap", "frequency_distribution", "frequency_distribution_map", "frequency_distribution_map_agg", "grp_dmas_audience_size", "holdout_percentage", "id", "instagram_destination_id", "interval_frequency_cap", "interval_frequency_cap_reset_period", "name", "pause_periods", "placement_breakdown", "prediction_mode", "prediction_progress", "reservation_status", "status", "story_event_type", "target_audience_size", "target_spec", "time_created", "time_updated"};

        @Override
        public ReachFrequencyPrediction getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ReachFrequencyPrediction parseResponse(String response) throws APIException {
            return ReachFrequencyPrediction.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ReachFrequencyPrediction execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ReachFrequencyPrediction execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ReachFrequencyPrediction> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ReachFrequencyPrediction> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ReachFrequencyPrediction>(){

                public ReachFrequencyPrediction apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestCampaignGroupIdField() {
            return this.requestCampaignGroupIdField(true);
        }

        public APIRequestGet requestCampaignGroupIdField(boolean value) {
            this.requestField("campaign_group_id", value);
            return this;
        }

        public APIRequestGet requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGet requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGet requestCampaignTimeStartField() {
            return this.requestCampaignTimeStartField(true);
        }

        public APIRequestGet requestCampaignTimeStartField(boolean value) {
            this.requestField("campaign_time_start", value);
            return this;
        }

        public APIRequestGet requestCampaignTimeStopField() {
            return this.requestCampaignTimeStopField(true);
        }

        public APIRequestGet requestCampaignTimeStopField(boolean value) {
            this.requestField("campaign_time_stop", value);
            return this;
        }

        public APIRequestGet requestCurveBudgetReachField() {
            return this.requestCurveBudgetReachField(true);
        }

        public APIRequestGet requestCurveBudgetReachField(boolean value) {
            this.requestField("curve_budget_reach", value);
            return this;
        }

        public APIRequestGet requestDailyImpressionCurveField() {
            return this.requestDailyImpressionCurveField(true);
        }

        public APIRequestGet requestDailyImpressionCurveField(boolean value) {
            this.requestField("daily_impression_curve", value);
            return this;
        }

        public APIRequestGet requestDestinationIdField() {
            return this.requestDestinationIdField(true);
        }

        public APIRequestGet requestDestinationIdField(boolean value) {
            this.requestField("destination_id", value);
            return this;
        }

        public APIRequestGet requestExpirationTimeField() {
            return this.requestExpirationTimeField(true);
        }

        public APIRequestGet requestExpirationTimeField(boolean value) {
            this.requestField("expiration_time", value);
            return this;
        }

        public APIRequestGet requestExternalBudgetField() {
            return this.requestExternalBudgetField(true);
        }

        public APIRequestGet requestExternalBudgetField(boolean value) {
            this.requestField("external_budget", value);
            return this;
        }

        public APIRequestGet requestExternalImpressionField() {
            return this.requestExternalImpressionField(true);
        }

        public APIRequestGet requestExternalImpressionField(boolean value) {
            this.requestField("external_impression", value);
            return this;
        }

        public APIRequestGet requestExternalMaximumBudgetField() {
            return this.requestExternalMaximumBudgetField(true);
        }

        public APIRequestGet requestExternalMaximumBudgetField(boolean value) {
            this.requestField("external_maximum_budget", value);
            return this;
        }

        public APIRequestGet requestExternalMaximumImpressionField() {
            return this.requestExternalMaximumImpressionField(true);
        }

        public APIRequestGet requestExternalMaximumImpressionField(boolean value) {
            this.requestField("external_maximum_impression", value);
            return this;
        }

        public APIRequestGet requestExternalMaximumReachField() {
            return this.requestExternalMaximumReachField(true);
        }

        public APIRequestGet requestExternalMaximumReachField(boolean value) {
            this.requestField("external_maximum_reach", value);
            return this;
        }

        public APIRequestGet requestExternalMinimumBudgetField() {
            return this.requestExternalMinimumBudgetField(true);
        }

        public APIRequestGet requestExternalMinimumBudgetField(boolean value) {
            this.requestField("external_minimum_budget", value);
            return this;
        }

        public APIRequestGet requestExternalMinimumImpressionField() {
            return this.requestExternalMinimumImpressionField(true);
        }

        public APIRequestGet requestExternalMinimumImpressionField(boolean value) {
            this.requestField("external_minimum_impression", value);
            return this;
        }

        public APIRequestGet requestExternalMinimumReachField() {
            return this.requestExternalMinimumReachField(true);
        }

        public APIRequestGet requestExternalMinimumReachField(boolean value) {
            this.requestField("external_minimum_reach", value);
            return this;
        }

        public APIRequestGet requestExternalReachField() {
            return this.requestExternalReachField(true);
        }

        public APIRequestGet requestExternalReachField(boolean value) {
            this.requestField("external_reach", value);
            return this;
        }

        public APIRequestGet requestFrequencyCapField() {
            return this.requestFrequencyCapField(true);
        }

        public APIRequestGet requestFrequencyCapField(boolean value) {
            this.requestField("frequency_cap", value);
            return this;
        }

        public APIRequestGet requestFrequencyDistributionField() {
            return this.requestFrequencyDistributionField(true);
        }

        public APIRequestGet requestFrequencyDistributionField(boolean value) {
            this.requestField("frequency_distribution", value);
            return this;
        }

        public APIRequestGet requestFrequencyDistributionMapField() {
            return this.requestFrequencyDistributionMapField(true);
        }

        public APIRequestGet requestFrequencyDistributionMapField(boolean value) {
            this.requestField("frequency_distribution_map", value);
            return this;
        }

        public APIRequestGet requestFrequencyDistributionMapAggField() {
            return this.requestFrequencyDistributionMapAggField(true);
        }

        public APIRequestGet requestFrequencyDistributionMapAggField(boolean value) {
            this.requestField("frequency_distribution_map_agg", value);
            return this;
        }

        public APIRequestGet requestGrpDmasAudienceSizeField() {
            return this.requestGrpDmasAudienceSizeField(true);
        }

        public APIRequestGet requestGrpDmasAudienceSizeField(boolean value) {
            this.requestField("grp_dmas_audience_size", value);
            return this;
        }

        public APIRequestGet requestHoldoutPercentageField() {
            return this.requestHoldoutPercentageField(true);
        }

        public APIRequestGet requestHoldoutPercentageField(boolean value) {
            this.requestField("holdout_percentage", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInstagramDestinationIdField() {
            return this.requestInstagramDestinationIdField(true);
        }

        public APIRequestGet requestInstagramDestinationIdField(boolean value) {
            this.requestField("instagram_destination_id", value);
            return this;
        }

        public APIRequestGet requestIntervalFrequencyCapField() {
            return this.requestIntervalFrequencyCapField(true);
        }

        public APIRequestGet requestIntervalFrequencyCapField(boolean value) {
            this.requestField("interval_frequency_cap", value);
            return this;
        }

        public APIRequestGet requestIntervalFrequencyCapResetPeriodField() {
            return this.requestIntervalFrequencyCapResetPeriodField(true);
        }

        public APIRequestGet requestIntervalFrequencyCapResetPeriodField(boolean value) {
            this.requestField("interval_frequency_cap_reset_period", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPausePeriodsField() {
            return this.requestPausePeriodsField(true);
        }

        public APIRequestGet requestPausePeriodsField(boolean value) {
            this.requestField("pause_periods", value);
            return this;
        }

        public APIRequestGet requestPlacementBreakdownField() {
            return this.requestPlacementBreakdownField(true);
        }

        public APIRequestGet requestPlacementBreakdownField(boolean value) {
            this.requestField("placement_breakdown", value);
            return this;
        }

        public APIRequestGet requestPredictionModeField() {
            return this.requestPredictionModeField(true);
        }

        public APIRequestGet requestPredictionModeField(boolean value) {
            this.requestField("prediction_mode", value);
            return this;
        }

        public APIRequestGet requestPredictionProgressField() {
            return this.requestPredictionProgressField(true);
        }

        public APIRequestGet requestPredictionProgressField(boolean value) {
            this.requestField("prediction_progress", value);
            return this;
        }

        public APIRequestGet requestReservationStatusField() {
            return this.requestReservationStatusField(true);
        }

        public APIRequestGet requestReservationStatusField(boolean value) {
            this.requestField("reservation_status", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestStoryEventTypeField() {
            return this.requestStoryEventTypeField(true);
        }

        public APIRequestGet requestStoryEventTypeField(boolean value) {
            this.requestField("story_event_type", value);
            return this;
        }

        public APIRequestGet requestTargetAudienceSizeField() {
            return this.requestTargetAudienceSizeField(true);
        }

        public APIRequestGet requestTargetAudienceSizeField(boolean value) {
            this.requestField("target_audience_size", value);
            return this;
        }

        public APIRequestGet requestTargetSpecField() {
            return this.requestTargetSpecField(true);
        }

        public APIRequestGet requestTargetSpecField(boolean value) {
            this.requestField("target_spec", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGet requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }
    }
}

