/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.Event;
import com.facebook.ads.sdk.Profile;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagePost
extends APINode {
    @SerializedName(value="actions")
    private JsonArray mActions = null;
    @SerializedName(value="admin_creator")
    private Object mAdminCreator = null;
    @SerializedName(value="allowed_advertising_objectives")
    private List<String> mAllowedAdvertisingObjectives = null;
    @SerializedName(value="application")
    private Object mApplication = null;
    @SerializedName(value="backdated_time")
    private String mBackdatedTime = null;
    @SerializedName(value="call_to_action")
    private Object mCallToAction = null;
    @SerializedName(value="can_reply_privately")
    private Boolean mCanReplyPrivately = null;
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="child_attachments")
    private JsonArray mChildAttachments = null;
    @SerializedName(value="comments_mirroring_domain")
    private String mCommentsMirroringDomain = null;
    @SerializedName(value="coordinates")
    private Object mCoordinates = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="event")
    private Event mEvent = null;
    @SerializedName(value="expanded_height")
    private Long mExpandedHeight = null;
    @SerializedName(value="expanded_width")
    private Long mExpandedWidth = null;
    @SerializedName(value="feed_targeting")
    private Object mFeedTargeting = null;
    @SerializedName(value="from")
    private Object mFrom = null;
    @SerializedName(value="full_picture")
    private String mFullPicture = null;
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="icon")
    private String mIcon = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="instagram_eligibility")
    private String mInstagramEligibility = null;
    @SerializedName(value="is_app_share")
    private Boolean mIsAppShare = null;
    @SerializedName(value="is_expired")
    private Boolean mIsExpired = null;
    @SerializedName(value="is_hidden")
    private Boolean mIsHidden = null;
    @SerializedName(value="is_instagram_eligible")
    private Boolean mIsInstagramEligible = null;
    @SerializedName(value="is_popular")
    private Boolean mIsPopular = null;
    @SerializedName(value="is_published")
    private Boolean mIsPublished = null;
    @SerializedName(value="is_spherical")
    private Boolean mIsSpherical = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="message_tags")
    private JsonArray mMessageTags = null;
    @SerializedName(value="multi_share_end_card")
    private Boolean mMultiShareEndCard = null;
    @SerializedName(value="multi_share_optimized")
    private Boolean mMultiShareOptimized = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="object_id")
    private String mObjectId = null;
    @SerializedName(value="parent_id")
    private String mParentId = null;
    @SerializedName(value="permalink_url")
    private Object mPermalinkUrl = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="place")
    private Object mPlace = null;
    @SerializedName(value="privacy")
    private Object mPrivacy = null;
    @SerializedName(value="promotable_id")
    private String mPromotableId = null;
    @SerializedName(value="promotion_status")
    private String mPromotionStatus = null;
    @SerializedName(value="properties")
    private JsonArray mProperties = null;
    @SerializedName(value="scheduled_publish_time")
    private Double mScheduledPublishTime = null;
    @SerializedName(value="shares")
    private Object mShares = null;
    @SerializedName(value="source")
    private String mSource = null;
    @SerializedName(value="status_type")
    private String mStatusType = null;
    @SerializedName(value="story")
    private String mStory = null;
    @SerializedName(value="story_tags")
    private JsonArray mStoryTags = null;
    @SerializedName(value="subscribed")
    private Boolean mSubscribed = null;
    @SerializedName(value="target")
    private Profile mTarget = null;
    @SerializedName(value="targeting")
    private Object mTargeting = null;
    @SerializedName(value="timeline_visibility")
    private String mTimelineVisibility = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="via")
    private Object mVia = null;
    @SerializedName(value="video_buying_eligibility")
    private List<String> mVideoBuyingEligibility = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    protected static Gson gson = null;

    PagePost() {
    }

    public PagePost(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PagePost(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PagePost fetch() throws APIException {
        PagePost newInstance = PagePost.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PagePost fetchById(Long id, APIContext context) throws APIException {
        return PagePost.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PagePost> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PagePost.fetchByIdAsync(id.toString(), context);
    }

    public static PagePost fetchById(String id, APIContext context) throws APIException {
        PagePost pagePost = new APIRequestGet(id, context).requestAllFields().execute();
        return pagePost;
    }

    public static ListenableFuture<PagePost> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<PagePost> pagePost = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return pagePost;
    }

    public static APINodeList<PagePost> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PagePost>(context, "", "/", "GET", PagePost.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PagePost>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> pagePost = new APIRequest<PagePost>(context, "", "/", "GET", PagePost.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return pagePost;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PagePost loadJSON(String json, APIContext context) {
        PagePost pagePost = (PagePost)PagePost.getGson().fromJson(json, PagePost.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pagePost.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pagePost.context = context;
        pagePost.rawValue = json;
        return pagePost;
    }

    public static APINodeList<PagePost> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<PagePost> pagePosts = new APINodeList<PagePost>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pagePosts.add(PagePost.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return pagePosts;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pagePosts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pagePosts.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pagePosts.add(PagePost.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pagePosts.add(PagePost.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pagePosts.add(PagePost.loadJSON(obj.toString(), context));
                        }
                    }
                    return pagePosts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pagePosts.add(PagePost.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return pagePosts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pagePosts.add(PagePost.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pagePosts;
                }
                pagePosts.clear();
                pagePosts.add(PagePost.loadJSON(json, context));
                return pagePosts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PagePost.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public JsonArray getFieldActions() {
        return this.mActions;
    }

    public Object getFieldAdminCreator() {
        return this.mAdminCreator;
    }

    public List<String> getFieldAllowedAdvertisingObjectives() {
        return this.mAllowedAdvertisingObjectives;
    }

    public Object getFieldApplication() {
        return this.mApplication;
    }

    public String getFieldBackdatedTime() {
        return this.mBackdatedTime;
    }

    public Object getFieldCallToAction() {
        return this.mCallToAction;
    }

    public Boolean getFieldCanReplyPrivately() {
        return this.mCanReplyPrivately;
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public JsonArray getFieldChildAttachments() {
        return this.mChildAttachments;
    }

    public String getFieldCommentsMirroringDomain() {
        return this.mCommentsMirroringDomain;
    }

    public Object getFieldCoordinates() {
        return this.mCoordinates;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public Event getFieldEvent() {
        if (this.mEvent != null) {
            this.mEvent.context = this.getContext();
        }
        return this.mEvent;
    }

    public Long getFieldExpandedHeight() {
        return this.mExpandedHeight;
    }

    public Long getFieldExpandedWidth() {
        return this.mExpandedWidth;
    }

    public Object getFieldFeedTargeting() {
        return this.mFeedTargeting;
    }

    public Object getFieldFrom() {
        return this.mFrom;
    }

    public String getFieldFullPicture() {
        return this.mFullPicture;
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public String getFieldIcon() {
        return this.mIcon;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldInstagramEligibility() {
        return this.mInstagramEligibility;
    }

    public Boolean getFieldIsAppShare() {
        return this.mIsAppShare;
    }

    public Boolean getFieldIsExpired() {
        return this.mIsExpired;
    }

    public Boolean getFieldIsHidden() {
        return this.mIsHidden;
    }

    public Boolean getFieldIsInstagramEligible() {
        return this.mIsInstagramEligible;
    }

    public Boolean getFieldIsPopular() {
        return this.mIsPopular;
    }

    public Boolean getFieldIsPublished() {
        return this.mIsPublished;
    }

    public Boolean getFieldIsSpherical() {
        return this.mIsSpherical;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public JsonArray getFieldMessageTags() {
        return this.mMessageTags;
    }

    public Boolean getFieldMultiShareEndCard() {
        return this.mMultiShareEndCard;
    }

    public Boolean getFieldMultiShareOptimized() {
        return this.mMultiShareOptimized;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldObjectId() {
        return this.mObjectId;
    }

    public String getFieldParentId() {
        return this.mParentId;
    }

    public Object getFieldPermalinkUrl() {
        return this.mPermalinkUrl;
    }

    public String getFieldPicture() {
        return this.mPicture;
    }

    public Object getFieldPlace() {
        return this.mPlace;
    }

    public Object getFieldPrivacy() {
        return this.mPrivacy;
    }

    public String getFieldPromotableId() {
        return this.mPromotableId;
    }

    public String getFieldPromotionStatus() {
        return this.mPromotionStatus;
    }

    public JsonArray getFieldProperties() {
        return this.mProperties;
    }

    public Double getFieldScheduledPublishTime() {
        return this.mScheduledPublishTime;
    }

    public Object getFieldShares() {
        return this.mShares;
    }

    public String getFieldSource() {
        return this.mSource;
    }

    public String getFieldStatusType() {
        return this.mStatusType;
    }

    public String getFieldStory() {
        return this.mStory;
    }

    public JsonArray getFieldStoryTags() {
        return this.mStoryTags;
    }

    public Boolean getFieldSubscribed() {
        return this.mSubscribed;
    }

    public Profile getFieldTarget() {
        if (this.mTarget != null) {
            this.mTarget.context = this.getContext();
        }
        return this.mTarget;
    }

    public Object getFieldTargeting() {
        return this.mTargeting;
    }

    public String getFieldTimelineVisibility() {
        return this.mTimelineVisibility;
    }

    public String getFieldType() {
        return this.mType;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public Object getFieldVia() {
        return this.mVia;
    }

    public List<String> getFieldVideoBuyingEligibility() {
        return this.mVideoBuyingEligibility;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PagePost copyFrom(PagePost instance) {
        this.mActions = instance.mActions;
        this.mAdminCreator = instance.mAdminCreator;
        this.mAllowedAdvertisingObjectives = instance.mAllowedAdvertisingObjectives;
        this.mApplication = instance.mApplication;
        this.mBackdatedTime = instance.mBackdatedTime;
        this.mCallToAction = instance.mCallToAction;
        this.mCanReplyPrivately = instance.mCanReplyPrivately;
        this.mCaption = instance.mCaption;
        this.mChildAttachments = instance.mChildAttachments;
        this.mCommentsMirroringDomain = instance.mCommentsMirroringDomain;
        this.mCoordinates = instance.mCoordinates;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mEvent = instance.mEvent;
        this.mExpandedHeight = instance.mExpandedHeight;
        this.mExpandedWidth = instance.mExpandedWidth;
        this.mFeedTargeting = instance.mFeedTargeting;
        this.mFrom = instance.mFrom;
        this.mFullPicture = instance.mFullPicture;
        this.mHeight = instance.mHeight;
        this.mIcon = instance.mIcon;
        this.mId = instance.mId;
        this.mInstagramEligibility = instance.mInstagramEligibility;
        this.mIsAppShare = instance.mIsAppShare;
        this.mIsExpired = instance.mIsExpired;
        this.mIsHidden = instance.mIsHidden;
        this.mIsInstagramEligible = instance.mIsInstagramEligible;
        this.mIsPopular = instance.mIsPopular;
        this.mIsPublished = instance.mIsPublished;
        this.mIsSpherical = instance.mIsSpherical;
        this.mLink = instance.mLink;
        this.mMessage = instance.mMessage;
        this.mMessageTags = instance.mMessageTags;
        this.mMultiShareEndCard = instance.mMultiShareEndCard;
        this.mMultiShareOptimized = instance.mMultiShareOptimized;
        this.mName = instance.mName;
        this.mObjectId = instance.mObjectId;
        this.mParentId = instance.mParentId;
        this.mPermalinkUrl = instance.mPermalinkUrl;
        this.mPicture = instance.mPicture;
        this.mPlace = instance.mPlace;
        this.mPrivacy = instance.mPrivacy;
        this.mPromotableId = instance.mPromotableId;
        this.mPromotionStatus = instance.mPromotionStatus;
        this.mProperties = instance.mProperties;
        this.mScheduledPublishTime = instance.mScheduledPublishTime;
        this.mShares = instance.mShares;
        this.mSource = instance.mSource;
        this.mStatusType = instance.mStatusType;
        this.mStory = instance.mStory;
        this.mStoryTags = instance.mStoryTags;
        this.mSubscribed = instance.mSubscribed;
        this.mTarget = instance.mTarget;
        this.mTargeting = instance.mTargeting;
        this.mTimelineVisibility = instance.mTimelineVisibility;
        this.mType = instance.mType;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mVia = instance.mVia;
        this.mVideoBuyingEligibility = instance.mVideoBuyingEligibility;
        this.mWidth = instance.mWidth;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PagePost> getParser() {
        return new APIRequest.ResponseParser<PagePost>(){

            @Override
            public APINodeList<PagePost> parseResponse(String response, APIContext context, APIRequest<PagePost> request) throws APIException.MalformedResponseException {
                return PagePost.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTimelineVisibility {
        VALUE_HIDDEN("hidden"),
        VALUE_NORMAL("normal"),
        VALUE_FORCED_ALLOW("forced_allow"),
        NULL(null);

        private String value;

        private EnumTimelineVisibility(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFeedStoryVisibility {
        VALUE_HIDDEN("hidden"),
        VALUE_VISIBLE("visible"),
        NULL(null);

        private String value;

        private EnumFeedStoryVisibility(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumWith {
        VALUE_LOCATION("LOCATION"),
        NULL(null);

        private String value;

        private EnumWith(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumUnpublishedContentType {
        VALUE_SCHEDULED("SCHEDULED"),
        VALUE_DRAFT("DRAFT"),
        VALUE_ADS_POST("ADS_POST"),
        VALUE_INLINE_CREATED("INLINE_CREATED"),
        VALUE_PUBLISHED("PUBLISHED"),
        NULL(null);

        private String value;

        private EnumUnpublishedContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTargetSurface {
        VALUE_STORY("STORY"),
        VALUE_TIMELINE("TIMELINE"),
        NULL(null);

        private String value;

        private EnumTargetSurface(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPostingToRedspace {
        VALUE_ENABLED("enabled"),
        VALUE_DISABLED("disabled"),
        NULL(null);

        private String value;

        private EnumPostingToRedspace(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPostSurfacesBlacklist {
        VALUE_1("1"),
        VALUE_2("2"),
        VALUE_3("3"),
        VALUE_4("4"),
        VALUE_5("5"),
        NULL(null);

        private String value;

        private EnumPostSurfacesBlacklist(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPlaceAttachmentSetting {
        VALUE_1("1"),
        VALUE_2("2"),
        NULL(null);

        private String value;

        private EnumPlaceAttachmentSetting(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFormatting {
        VALUE_PLAINTEXT("PLAINTEXT"),
        VALUE_MARKDOWN("MARKDOWN"),
        NULL(null);

        private String value;

        private EnumFormatting(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCheckinEntryPoint {
        VALUE_BRANDING_CHECKIN("BRANDING_CHECKIN"),
        VALUE_BRANDING_STATUS("BRANDING_STATUS"),
        VALUE_BRANDING_PHOTO("BRANDING_PHOTO"),
        VALUE_BRANDING_OTHER("BRANDING_OTHER"),
        NULL(null);

        private String value;

        private EnumCheckinEntryPoint(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBackdatedTimeGranularity {
        VALUE_YEAR("year"),
        VALUE_MONTH("month"),
        VALUE_DAY("day"),
        VALUE_HOUR("hour"),
        VALUE_MIN("min"),
        VALUE_NONE("none"),
        NULL(null);

        private String value;

        private EnumBackdatedTimeGranularity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<PagePost> {
        PagePost lastResponse = null;
        public static final String[] PARAMS = new String[]{"attached_media", "backdated_time", "backdated_time_granularity", "composer_session_id", "direct_share_status", "feed_story_visibility", "is_explicit_location", "is_hidden", "is_pinned", "is_published", "message", "og_action_type_id", "og_hide_object_attachment", "og_icon_id", "og_object_id", "og_phrase", "og_set_profile_badge", "og_suggestion_mechanism", "place", "privacy", "product_item", "scheduled_publish_time", "should_sync_product_edit", "source_type", "sponsor_id", "sponsor_relationship", "tags", "text_format_preset_id", "timeline_visibility", "tracking"};
        public static final String[] FIELDS = new String[0];

        @Override
        public PagePost getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PagePost parseResponse(String response) throws APIException {
            return PagePost.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PagePost execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PagePost execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PagePost> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PagePost> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PagePost>(){

                public PagePost apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAttachedMedia(List<Object> attachedMedia) {
            this.setParam("attached_media", attachedMedia);
            return this;
        }

        public APIRequestUpdate setAttachedMedia(String attachedMedia) {
            this.setParam("attached_media", attachedMedia);
            return this;
        }

        public APIRequestUpdate setBackdatedTime(String backdatedTime) {
            this.setParam("backdated_time", backdatedTime);
            return this;
        }

        public APIRequestUpdate setBackdatedTimeGranularity(EnumBackdatedTimeGranularity backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", (Object)backdatedTimeGranularity);
            return this;
        }

        public APIRequestUpdate setBackdatedTimeGranularity(String backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", backdatedTimeGranularity);
            return this;
        }

        public APIRequestUpdate setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestUpdate setDirectShareStatus(Long directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestUpdate setDirectShareStatus(String directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestUpdate setFeedStoryVisibility(EnumFeedStoryVisibility feedStoryVisibility) {
            this.setParam("feed_story_visibility", (Object)feedStoryVisibility);
            return this;
        }

        public APIRequestUpdate setFeedStoryVisibility(String feedStoryVisibility) {
            this.setParam("feed_story_visibility", feedStoryVisibility);
            return this;
        }

        public APIRequestUpdate setIsExplicitLocation(Boolean isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestUpdate setIsExplicitLocation(String isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestUpdate setIsHidden(Boolean isHidden) {
            this.setParam("is_hidden", isHidden);
            return this;
        }

        public APIRequestUpdate setIsHidden(String isHidden) {
            this.setParam("is_hidden", isHidden);
            return this;
        }

        public APIRequestUpdate setIsPinned(Boolean isPinned) {
            this.setParam("is_pinned", isPinned);
            return this;
        }

        public APIRequestUpdate setIsPinned(String isPinned) {
            this.setParam("is_pinned", isPinned);
            return this;
        }

        public APIRequestUpdate setIsPublished(Boolean isPublished) {
            this.setParam("is_published", isPublished);
            return this;
        }

        public APIRequestUpdate setIsPublished(String isPublished) {
            this.setParam("is_published", isPublished);
            return this;
        }

        public APIRequestUpdate setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestUpdate setOgActionTypeId(String ogActionTypeId) {
            this.setParam("og_action_type_id", ogActionTypeId);
            return this;
        }

        public APIRequestUpdate setOgHideObjectAttachment(Boolean ogHideObjectAttachment) {
            this.setParam("og_hide_object_attachment", ogHideObjectAttachment);
            return this;
        }

        public APIRequestUpdate setOgHideObjectAttachment(String ogHideObjectAttachment) {
            this.setParam("og_hide_object_attachment", ogHideObjectAttachment);
            return this;
        }

        public APIRequestUpdate setOgIconId(String ogIconId) {
            this.setParam("og_icon_id", ogIconId);
            return this;
        }

        public APIRequestUpdate setOgObjectId(String ogObjectId) {
            this.setParam("og_object_id", ogObjectId);
            return this;
        }

        public APIRequestUpdate setOgPhrase(String ogPhrase) {
            this.setParam("og_phrase", ogPhrase);
            return this;
        }

        public APIRequestUpdate setOgSetProfileBadge(Boolean ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestUpdate setOgSetProfileBadge(String ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestUpdate setOgSuggestionMechanism(String ogSuggestionMechanism) {
            this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
            return this;
        }

        public APIRequestUpdate setPlace(Object place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestUpdate setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestUpdate setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestUpdate setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestUpdate setProductItem(Object productItem) {
            this.setParam("product_item", productItem);
            return this;
        }

        public APIRequestUpdate setProductItem(String productItem) {
            this.setParam("product_item", productItem);
            return this;
        }

        public APIRequestUpdate setScheduledPublishTime(Long scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestUpdate setScheduledPublishTime(String scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestUpdate setShouldSyncProductEdit(Boolean shouldSyncProductEdit) {
            this.setParam("should_sync_product_edit", shouldSyncProductEdit);
            return this;
        }

        public APIRequestUpdate setShouldSyncProductEdit(String shouldSyncProductEdit) {
            this.setParam("should_sync_product_edit", shouldSyncProductEdit);
            return this;
        }

        public APIRequestUpdate setSourceType(String sourceType) {
            this.setParam("source_type", sourceType);
            return this;
        }

        public APIRequestUpdate setSponsorId(String sponsorId) {
            this.setParam("sponsor_id", sponsorId);
            return this;
        }

        public APIRequestUpdate setSponsorRelationship(Long sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestUpdate setSponsorRelationship(String sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestUpdate setTags(List<Long> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestUpdate setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestUpdate setTextFormatPresetId(String textFormatPresetId) {
            this.setParam("text_format_preset_id", textFormatPresetId);
            return this;
        }

        public APIRequestUpdate setTimelineVisibility(EnumTimelineVisibility timelineVisibility) {
            this.setParam("timeline_visibility", (Object)timelineVisibility);
            return this;
        }

        public APIRequestUpdate setTimelineVisibility(String timelineVisibility) {
            this.setParam("timeline_visibility", timelineVisibility);
            return this;
        }

        public APIRequestUpdate setTracking(String tracking) {
            this.setParam("tracking", tracking);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PagePost> {
        PagePost lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"actions", "admin_creator", "allowed_advertising_objectives", "application", "backdated_time", "call_to_action", "can_reply_privately", "caption", "child_attachments", "comments_mirroring_domain", "coordinates", "created_time", "description", "event", "expanded_height", "expanded_width", "feed_targeting", "from", "full_picture", "height", "icon", "id", "instagram_eligibility", "is_app_share", "is_expired", "is_hidden", "is_instagram_eligible", "is_popular", "is_published", "is_spherical", "link", "message", "message_tags", "multi_share_end_card", "multi_share_optimized", "name", "object_id", "parent_id", "permalink_url", "picture", "place", "privacy", "promotable_id", "promotion_status", "properties", "scheduled_publish_time", "shares", "source", "status_type", "story", "story_tags", "subscribed", "target", "targeting", "timeline_visibility", "type", "updated_time", "via", "video_buying_eligibility", "width"};

        @Override
        public PagePost getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PagePost parseResponse(String response) throws APIException {
            return PagePost.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PagePost execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PagePost execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PagePost> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PagePost> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PagePost>(){

                public PagePost apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestActionsField() {
            return this.requestActionsField(true);
        }

        public APIRequestGet requestActionsField(boolean value) {
            this.requestField("actions", value);
            return this;
        }

        public APIRequestGet requestAdminCreatorField() {
            return this.requestAdminCreatorField(true);
        }

        public APIRequestGet requestAdminCreatorField(boolean value) {
            this.requestField("admin_creator", value);
            return this;
        }

        public APIRequestGet requestAllowedAdvertisingObjectivesField() {
            return this.requestAllowedAdvertisingObjectivesField(true);
        }

        public APIRequestGet requestAllowedAdvertisingObjectivesField(boolean value) {
            this.requestField("allowed_advertising_objectives", value);
            return this;
        }

        public APIRequestGet requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGet requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGet requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGet requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGet requestCallToActionField() {
            return this.requestCallToActionField(true);
        }

        public APIRequestGet requestCallToActionField(boolean value) {
            this.requestField("call_to_action", value);
            return this;
        }

        public APIRequestGet requestCanReplyPrivatelyField() {
            return this.requestCanReplyPrivatelyField(true);
        }

        public APIRequestGet requestCanReplyPrivatelyField(boolean value) {
            this.requestField("can_reply_privately", value);
            return this;
        }

        public APIRequestGet requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGet requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGet requestChildAttachmentsField() {
            return this.requestChildAttachmentsField(true);
        }

        public APIRequestGet requestChildAttachmentsField(boolean value) {
            this.requestField("child_attachments", value);
            return this;
        }

        public APIRequestGet requestCommentsMirroringDomainField() {
            return this.requestCommentsMirroringDomainField(true);
        }

        public APIRequestGet requestCommentsMirroringDomainField(boolean value) {
            this.requestField("comments_mirroring_domain", value);
            return this;
        }

        public APIRequestGet requestCoordinatesField() {
            return this.requestCoordinatesField(true);
        }

        public APIRequestGet requestCoordinatesField(boolean value) {
            this.requestField("coordinates", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGet requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGet requestExpandedHeightField() {
            return this.requestExpandedHeightField(true);
        }

        public APIRequestGet requestExpandedHeightField(boolean value) {
            this.requestField("expanded_height", value);
            return this;
        }

        public APIRequestGet requestExpandedWidthField() {
            return this.requestExpandedWidthField(true);
        }

        public APIRequestGet requestExpandedWidthField(boolean value) {
            this.requestField("expanded_width", value);
            return this;
        }

        public APIRequestGet requestFeedTargetingField() {
            return this.requestFeedTargetingField(true);
        }

        public APIRequestGet requestFeedTargetingField(boolean value) {
            this.requestField("feed_targeting", value);
            return this;
        }

        public APIRequestGet requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGet requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGet requestFullPictureField() {
            return this.requestFullPictureField(true);
        }

        public APIRequestGet requestFullPictureField(boolean value) {
            this.requestField("full_picture", value);
            return this;
        }

        public APIRequestGet requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGet requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGet requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGet requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInstagramEligibilityField() {
            return this.requestInstagramEligibilityField(true);
        }

        public APIRequestGet requestInstagramEligibilityField(boolean value) {
            this.requestField("instagram_eligibility", value);
            return this;
        }

        public APIRequestGet requestIsAppShareField() {
            return this.requestIsAppShareField(true);
        }

        public APIRequestGet requestIsAppShareField(boolean value) {
            this.requestField("is_app_share", value);
            return this;
        }

        public APIRequestGet requestIsExpiredField() {
            return this.requestIsExpiredField(true);
        }

        public APIRequestGet requestIsExpiredField(boolean value) {
            this.requestField("is_expired", value);
            return this;
        }

        public APIRequestGet requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGet requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGet requestIsInstagramEligibleField() {
            return this.requestIsInstagramEligibleField(true);
        }

        public APIRequestGet requestIsInstagramEligibleField(boolean value) {
            this.requestField("is_instagram_eligible", value);
            return this;
        }

        public APIRequestGet requestIsPopularField() {
            return this.requestIsPopularField(true);
        }

        public APIRequestGet requestIsPopularField(boolean value) {
            this.requestField("is_popular", value);
            return this;
        }

        public APIRequestGet requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGet requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGet requestIsSphericalField() {
            return this.requestIsSphericalField(true);
        }

        public APIRequestGet requestIsSphericalField(boolean value) {
            this.requestField("is_spherical", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGet requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGet requestMessageTagsField() {
            return this.requestMessageTagsField(true);
        }

        public APIRequestGet requestMessageTagsField(boolean value) {
            this.requestField("message_tags", value);
            return this;
        }

        public APIRequestGet requestMultiShareEndCardField() {
            return this.requestMultiShareEndCardField(true);
        }

        public APIRequestGet requestMultiShareEndCardField(boolean value) {
            this.requestField("multi_share_end_card", value);
            return this;
        }

        public APIRequestGet requestMultiShareOptimizedField() {
            return this.requestMultiShareOptimizedField(true);
        }

        public APIRequestGet requestMultiShareOptimizedField(boolean value) {
            this.requestField("multi_share_optimized", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestObjectIdField() {
            return this.requestObjectIdField(true);
        }

        public APIRequestGet requestObjectIdField(boolean value) {
            this.requestField("object_id", value);
            return this;
        }

        public APIRequestGet requestParentIdField() {
            return this.requestParentIdField(true);
        }

        public APIRequestGet requestParentIdField(boolean value) {
            this.requestField("parent_id", value);
            return this;
        }

        public APIRequestGet requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGet requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGet requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGet requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGet requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGet requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGet requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGet requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGet requestPromotableIdField() {
            return this.requestPromotableIdField(true);
        }

        public APIRequestGet requestPromotableIdField(boolean value) {
            this.requestField("promotable_id", value);
            return this;
        }

        public APIRequestGet requestPromotionStatusField() {
            return this.requestPromotionStatusField(true);
        }

        public APIRequestGet requestPromotionStatusField(boolean value) {
            this.requestField("promotion_status", value);
            return this;
        }

        public APIRequestGet requestPropertiesField() {
            return this.requestPropertiesField(true);
        }

        public APIRequestGet requestPropertiesField(boolean value) {
            this.requestField("properties", value);
            return this;
        }

        public APIRequestGet requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGet requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGet requestSharesField() {
            return this.requestSharesField(true);
        }

        public APIRequestGet requestSharesField(boolean value) {
            this.requestField("shares", value);
            return this;
        }

        public APIRequestGet requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGet requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGet requestStatusTypeField() {
            return this.requestStatusTypeField(true);
        }

        public APIRequestGet requestStatusTypeField(boolean value) {
            this.requestField("status_type", value);
            return this;
        }

        public APIRequestGet requestStoryField() {
            return this.requestStoryField(true);
        }

        public APIRequestGet requestStoryField(boolean value) {
            this.requestField("story", value);
            return this;
        }

        public APIRequestGet requestStoryTagsField() {
            return this.requestStoryTagsField(true);
        }

        public APIRequestGet requestStoryTagsField(boolean value) {
            this.requestField("story_tags", value);
            return this;
        }

        public APIRequestGet requestSubscribedField() {
            return this.requestSubscribedField(true);
        }

        public APIRequestGet requestSubscribedField(boolean value) {
            this.requestField("subscribed", value);
            return this;
        }

        public APIRequestGet requestTargetField() {
            return this.requestTargetField(true);
        }

        public APIRequestGet requestTargetField(boolean value) {
            this.requestField("target", value);
            return this;
        }

        public APIRequestGet requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGet requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGet requestTimelineVisibilityField() {
            return this.requestTimelineVisibilityField(true);
        }

        public APIRequestGet requestTimelineVisibilityField(boolean value) {
            this.requestField("timeline_visibility", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestViaField() {
            return this.requestViaField(true);
        }

        public APIRequestGet requestViaField(boolean value) {
            this.requestField("via", value);
            return this;
        }

        public APIRequestGet requestVideoBuyingEligibilityField() {
            return this.requestVideoBuyingEligibilityField(true);
        }

        public APIRequestGet requestVideoBuyingEligibilityField(boolean value) {
            this.requestField("video_buying_eligibility", value);
            return this;
        }

        public APIRequestGet requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGet requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

