/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.Ad;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.AdsPixel;
import com.facebook.ads.sdk.CustomAudienceDataSource;
import com.facebook.ads.sdk.CustomAudiencePermission;
import com.facebook.ads.sdk.CustomAudiencePrefillState;
import com.facebook.ads.sdk.CustomAudienceSession;
import com.facebook.ads.sdk.CustomAudienceStatus;
import com.facebook.ads.sdk.LookalikeSpec;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAudience
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="approximate_count")
    private Long mApproximateCount = null;
    @SerializedName(value="data_source")
    private CustomAudienceDataSource mDataSource = null;
    @SerializedName(value="delivery_status")
    private CustomAudienceStatus mDeliveryStatus = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="external_event_source")
    private AdsPixel mExternalEventSource = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_value_based")
    private Boolean mIsValueBased = null;
    @SerializedName(value="lookalike_audience_ids")
    private List<String> mLookalikeAudienceIds = null;
    @SerializedName(value="lookalike_spec")
    private LookalikeSpec mLookalikeSpec = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="operation_status")
    private CustomAudienceStatus mOperationStatus = null;
    @SerializedName(value="opt_out_link")
    private String mOptOutLink = null;
    @SerializedName(value="permission_for_actions")
    private CustomAudiencePermission mPermissionForActions = null;
    @SerializedName(value="pixel_id")
    private String mPixelId = null;
    @SerializedName(value="retention_days")
    private Long mRetentionDays = null;
    @SerializedName(value="rule")
    private String mRule = null;
    @SerializedName(value="rule_aggregation")
    private String mRuleAggregation = null;
    @SerializedName(value="subtype")
    private String mSubtype = null;
    @SerializedName(value="time_content_updated")
    private Long mTimeContentUpdated = null;
    @SerializedName(value="time_created")
    private Long mTimeCreated = null;
    @SerializedName(value="time_updated")
    private Long mTimeUpdated = null;
    protected static Gson gson = null;

    CustomAudience() {
    }

    public CustomAudience(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CustomAudience(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CustomAudience fetch() throws APIException {
        CustomAudience newInstance = CustomAudience.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CustomAudience fetchById(Long id, APIContext context) throws APIException {
        return CustomAudience.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CustomAudience> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CustomAudience.fetchByIdAsync(id.toString(), context);
    }

    public static CustomAudience fetchById(String id, APIContext context) throws APIException {
        CustomAudience customAudience = new APIRequestGet(id, context).requestAllFields().execute();
        return customAudience;
    }

    public static ListenableFuture<CustomAudience> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<CustomAudience> customAudience = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return customAudience;
    }

    public static APINodeList<CustomAudience> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CustomAudience>(context, "", "/", "GET", CustomAudience.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CustomAudience>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> customAudience = new APIRequest<CustomAudience>(context, "", "/", "GET", CustomAudience.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return customAudience;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CustomAudience loadJSON(String json, APIContext context) {
        CustomAudience customAudience = (CustomAudience)CustomAudience.getGson().fromJson(json, CustomAudience.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customAudience.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customAudience.context = context;
        customAudience.rawValue = json;
        return customAudience;
    }

    public static APINodeList<CustomAudience> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<CustomAudience> customAudiences = new APINodeList<CustomAudience>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customAudiences.add(CustomAudience.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return customAudiences;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            customAudiences.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        customAudiences.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customAudiences.add(CustomAudience.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customAudiences.add(CustomAudience.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customAudiences.add(CustomAudience.loadJSON(obj.toString(), context));
                        }
                    }
                    return customAudiences;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customAudiences.add(CustomAudience.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return customAudiences;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customAudiences.add(CustomAudience.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customAudiences;
                }
                customAudiences.clear();
                customAudiences.add(CustomAudience.loadJSON(json, context));
                return customAudiences;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomAudience.getGson().toJson((Object)this);
    }

    public APIRequestDeleteAdAccounts deleteAdAccounts() {
        return new APIRequestDeleteAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdAccounts getAdAccounts() {
        return new APIRequestGetAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdAccount createAdAccount() {
        return new APIRequestCreateAdAccount(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAds getAds() {
        return new APIRequestGetAds(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPrefills getPrefills() {
        return new APIRequestGetPrefills(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSessions getSessions() {
        return new APIRequestGetSessions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteUsers deleteUsers() {
        return new APIRequestDeleteUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateUser createUser() {
        return new APIRequestCreateUser(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public Long getFieldApproximateCount() {
        return this.mApproximateCount;
    }

    public CustomAudienceDataSource getFieldDataSource() {
        return this.mDataSource;
    }

    public CustomAudienceStatus getFieldDeliveryStatus() {
        return this.mDeliveryStatus;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public AdsPixel getFieldExternalEventSource() {
        if (this.mExternalEventSource != null) {
            this.mExternalEventSource.context = this.getContext();
        }
        return this.mExternalEventSource;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsValueBased() {
        return this.mIsValueBased;
    }

    public List<String> getFieldLookalikeAudienceIds() {
        return this.mLookalikeAudienceIds;
    }

    public LookalikeSpec getFieldLookalikeSpec() {
        return this.mLookalikeSpec;
    }

    public String getFieldName() {
        return this.mName;
    }

    public CustomAudienceStatus getFieldOperationStatus() {
        return this.mOperationStatus;
    }

    public String getFieldOptOutLink() {
        return this.mOptOutLink;
    }

    public CustomAudiencePermission getFieldPermissionForActions() {
        return this.mPermissionForActions;
    }

    public String getFieldPixelId() {
        return this.mPixelId;
    }

    public Long getFieldRetentionDays() {
        return this.mRetentionDays;
    }

    public String getFieldRule() {
        return this.mRule;
    }

    public String getFieldRuleAggregation() {
        return this.mRuleAggregation;
    }

    public String getFieldSubtype() {
        return this.mSubtype;
    }

    public Long getFieldTimeContentUpdated() {
        return this.mTimeContentUpdated;
    }

    public Long getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public Long getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomAudience copyFrom(CustomAudience instance) {
        this.mAccountId = instance.mAccountId;
        this.mApproximateCount = instance.mApproximateCount;
        this.mDataSource = instance.mDataSource;
        this.mDeliveryStatus = instance.mDeliveryStatus;
        this.mDescription = instance.mDescription;
        this.mExternalEventSource = instance.mExternalEventSource;
        this.mId = instance.mId;
        this.mIsValueBased = instance.mIsValueBased;
        this.mLookalikeAudienceIds = instance.mLookalikeAudienceIds;
        this.mLookalikeSpec = instance.mLookalikeSpec;
        this.mName = instance.mName;
        this.mOperationStatus = instance.mOperationStatus;
        this.mOptOutLink = instance.mOptOutLink;
        this.mPermissionForActions = instance.mPermissionForActions;
        this.mPixelId = instance.mPixelId;
        this.mRetentionDays = instance.mRetentionDays;
        this.mRule = instance.mRule;
        this.mRuleAggregation = instance.mRuleAggregation;
        this.mSubtype = instance.mSubtype;
        this.mTimeContentUpdated = instance.mTimeContentUpdated;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomAudience> getParser() {
        return new APIRequest.ResponseParser<CustomAudience>(){

            @Override
            public APINodeList<CustomAudience> parseResponse(String response, APIContext context, APIRequest<CustomAudience> request) throws APIException.MalformedResponseException {
                return CustomAudience.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFields {
        VALUE_ID("id"),
        VALUE_ACCOUNT_ID("account_id"),
        VALUE_APPROXIMATE_COUNT("approximate_count"),
        VALUE_DATA_SOURCE("data_source"),
        VALUE_DELIVERY_STATUS("delivery_status"),
        VALUE_DESCRIPTION("description"),
        VALUE_EXTERNAL_EVENT_SOURCE("external_event_source"),
        VALUE_IS_VALUE_BASED("is_value_based"),
        VALUE_LOOKALIKE_AUDIENCE_IDS("lookalike_audience_ids"),
        VALUE_LOOKALIKE_SPEC("lookalike_spec"),
        VALUE_NAME("name"),
        VALUE_OPERATION_STATUS("operation_status"),
        VALUE_OPT_OUT_LINK("opt_out_link"),
        VALUE_PERMISSION_FOR_ACTIONS("permission_for_actions"),
        VALUE_PIXEL_ID("pixel_id"),
        VALUE_RETENTION_DAYS("retention_days"),
        VALUE_RULE("rule"),
        VALUE_RULE_AGGREGATION("rule_aggregation"),
        VALUE_SUBTYPE("subtype"),
        VALUE_TIME_CONTENT_UPDATED("time_content_updated"),
        VALUE_TIME_CREATED("time_created"),
        VALUE_TIME_UPDATED("time_updated"),
        NULL(null);

        private String value;

        private EnumFields(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumSubtype {
        VALUE_CUSTOM("CUSTOM"),
        VALUE_WEBSITE("WEBSITE"),
        VALUE_APP("APP"),
        VALUE_OFFLINE_CONVERSION("OFFLINE_CONVERSION"),
        VALUE_CLAIM("CLAIM"),
        VALUE_PARTNER("PARTNER"),
        VALUE_MANAGED("MANAGED"),
        VALUE_VIDEO("VIDEO"),
        VALUE_LOOKALIKE("LOOKALIKE"),
        VALUE_ENGAGEMENT("ENGAGEMENT"),
        VALUE_DATA_SET("DATA_SET"),
        VALUE_BAG_OF_ACCOUNTS("BAG_OF_ACCOUNTS"),
        VALUE_STUDY_RULE_AUDIENCE("STUDY_RULE_AUDIENCE"),
        VALUE_FOX("FOX"),
        NULL(null);

        private String value;

        private EnumSubtype(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumContentType {
        VALUE_AUTO_OFFER("AUTO_OFFER"),
        VALUE_DESTINATION("DESTINATION"),
        VALUE_FLIGHT("FLIGHT"),
        VALUE_HOME_LISTING("HOME_LISTING"),
        VALUE_HOTEL("HOTEL"),
        VALUE_VEHICLE("VEHICLE"),
        VALUE_VEHICLE_OFFER("VEHICLE_OFFER"),
        NULL(null);

        private String value;

        private EnumContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumClaimObjective {
        VALUE_AUTO_OFFER("AUTO_OFFER"),
        VALUE_HOME_LISTING("HOME_LISTING"),
        VALUE_PRODUCT("PRODUCT"),
        VALUE_TRAVEL("TRAVEL"),
        VALUE_VEHICLE("VEHICLE"),
        NULL(null);

        private String value;

        private EnumClaimObjective(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<CustomAudience> {
        CustomAudience lastResponse = null;
        public static final String[] PARAMS = new String[]{"allowed_domains", "claim_objective", "content_type", "description", "event_source_group", "lookalike_spec", "name", "opt_out_link", "product_set_id", "retention_days", "rule", "rule_aggregation"};
        public static final String[] FIELDS = new String[0];

        @Override
        public CustomAudience getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomAudience parseResponse(String response) throws APIException {
            return CustomAudience.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomAudience execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomAudience execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomAudience> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomAudience> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomAudience>(){

                public CustomAudience apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAllowedDomains(List<String> allowedDomains) {
            this.setParam("allowed_domains", allowedDomains);
            return this;
        }

        public APIRequestUpdate setAllowedDomains(String allowedDomains) {
            this.setParam("allowed_domains", allowedDomains);
            return this;
        }

        public APIRequestUpdate setClaimObjective(EnumClaimObjective claimObjective) {
            this.setParam("claim_objective", (Object)claimObjective);
            return this;
        }

        public APIRequestUpdate setClaimObjective(String claimObjective) {
            this.setParam("claim_objective", claimObjective);
            return this;
        }

        public APIRequestUpdate setContentType(EnumContentType contentType) {
            this.setParam("content_type", (Object)contentType);
            return this;
        }

        public APIRequestUpdate setContentType(String contentType) {
            this.setParam("content_type", contentType);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setEventSourceGroup(String eventSourceGroup) {
            this.setParam("event_source_group", eventSourceGroup);
            return this;
        }

        public APIRequestUpdate setLookalikeSpec(String lookalikeSpec) {
            this.setParam("lookalike_spec", lookalikeSpec);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setOptOutLink(String optOutLink) {
            this.setParam("opt_out_link", optOutLink);
            return this;
        }

        public APIRequestUpdate setProductSetId(String productSetId) {
            this.setParam("product_set_id", productSetId);
            return this;
        }

        public APIRequestUpdate setRetentionDays(Long retentionDays) {
            this.setParam("retention_days", retentionDays);
            return this;
        }

        public APIRequestUpdate setRetentionDays(String retentionDays) {
            this.setParam("retention_days", retentionDays);
            return this;
        }

        public APIRequestUpdate setRule(String rule) {
            this.setParam("rule", rule);
            return this;
        }

        public APIRequestUpdate setRuleAggregation(String ruleAggregation) {
            this.setParam("rule_aggregation", ruleAggregation);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CustomAudience> {
        CustomAudience lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "approximate_count", "data_source", "delivery_status", "description", "external_event_source", "id", "is_value_based", "lookalike_audience_ids", "lookalike_spec", "name", "operation_status", "opt_out_link", "permission_for_actions", "pixel_id", "retention_days", "rule", "rule_aggregation", "subtype", "time_content_updated", "time_created", "time_updated"};

        @Override
        public CustomAudience getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CustomAudience parseResponse(String response) throws APIException {
            return CustomAudience.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CustomAudience execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CustomAudience execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CustomAudience> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CustomAudience> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CustomAudience>(){

                public CustomAudience apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestApproximateCountField() {
            return this.requestApproximateCountField(true);
        }

        public APIRequestGet requestApproximateCountField(boolean value) {
            this.requestField("approximate_count", value);
            return this;
        }

        public APIRequestGet requestDataSourceField() {
            return this.requestDataSourceField(true);
        }

        public APIRequestGet requestDataSourceField(boolean value) {
            this.requestField("data_source", value);
            return this;
        }

        public APIRequestGet requestDeliveryStatusField() {
            return this.requestDeliveryStatusField(true);
        }

        public APIRequestGet requestDeliveryStatusField(boolean value) {
            this.requestField("delivery_status", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestExternalEventSourceField() {
            return this.requestExternalEventSourceField(true);
        }

        public APIRequestGet requestExternalEventSourceField(boolean value) {
            this.requestField("external_event_source", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsValueBasedField() {
            return this.requestIsValueBasedField(true);
        }

        public APIRequestGet requestIsValueBasedField(boolean value) {
            this.requestField("is_value_based", value);
            return this;
        }

        public APIRequestGet requestLookalikeAudienceIdsField() {
            return this.requestLookalikeAudienceIdsField(true);
        }

        public APIRequestGet requestLookalikeAudienceIdsField(boolean value) {
            this.requestField("lookalike_audience_ids", value);
            return this;
        }

        public APIRequestGet requestLookalikeSpecField() {
            return this.requestLookalikeSpecField(true);
        }

        public APIRequestGet requestLookalikeSpecField(boolean value) {
            this.requestField("lookalike_spec", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOperationStatusField() {
            return this.requestOperationStatusField(true);
        }

        public APIRequestGet requestOperationStatusField(boolean value) {
            this.requestField("operation_status", value);
            return this;
        }

        public APIRequestGet requestOptOutLinkField() {
            return this.requestOptOutLinkField(true);
        }

        public APIRequestGet requestOptOutLinkField(boolean value) {
            this.requestField("opt_out_link", value);
            return this;
        }

        public APIRequestGet requestPermissionForActionsField() {
            return this.requestPermissionForActionsField(true);
        }

        public APIRequestGet requestPermissionForActionsField(boolean value) {
            this.requestField("permission_for_actions", value);
            return this;
        }

        public APIRequestGet requestPixelIdField() {
            return this.requestPixelIdField(true);
        }

        public APIRequestGet requestPixelIdField(boolean value) {
            this.requestField("pixel_id", value);
            return this;
        }

        public APIRequestGet requestRetentionDaysField() {
            return this.requestRetentionDaysField(true);
        }

        public APIRequestGet requestRetentionDaysField(boolean value) {
            this.requestField("retention_days", value);
            return this;
        }

        public APIRequestGet requestRuleField() {
            return this.requestRuleField(true);
        }

        public APIRequestGet requestRuleField(boolean value) {
            this.requestField("rule", value);
            return this;
        }

        public APIRequestGet requestRuleAggregationField() {
            return this.requestRuleAggregationField(true);
        }

        public APIRequestGet requestRuleAggregationField(boolean value) {
            this.requestField("rule_aggregation", value);
            return this;
        }

        public APIRequestGet requestSubtypeField() {
            return this.requestSubtypeField(true);
        }

        public APIRequestGet requestSubtypeField(boolean value) {
            this.requestField("subtype", value);
            return this;
        }

        public APIRequestGet requestTimeContentUpdatedField() {
            return this.requestTimeContentUpdatedField(true);
        }

        public APIRequestGet requestTimeContentUpdatedField(boolean value) {
            this.requestField("time_content_updated", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGet requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateUser
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"namespace", "payload", "session"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestCreateUser.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateUser(String nodeId, APIContext context) {
            super(context, nodeId, "/users", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateUser setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateUser setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateUser setNamespace(String namespace) {
            this.setParam("namespace", namespace);
            return this;
        }

        public APIRequestCreateUser setPayload(Object payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateUser setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestCreateUser setSession(Object session) {
            this.setParam("session", session);
            return this;
        }

        public APIRequestCreateUser setSession(String session) {
            this.setParam("session", session);
            return this;
        }

        public APIRequestCreateUser requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateUser requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUser requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateUser requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUser requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateUser requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteUsers
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"namespace", "payload", "session"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteUsers.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/users", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteUsers setNamespace(String namespace) {
            this.setParam("namespace", namespace);
            return this;
        }

        public APIRequestDeleteUsers setPayload(Object payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestDeleteUsers setPayload(String payload) {
            this.setParam("payload", payload);
            return this;
        }

        public APIRequestDeleteUsers setSession(Object session) {
            this.setParam("session", session);
            return this;
        }

        public APIRequestDeleteUsers setSession(String session) {
            this.setParam("session", session);
            return this;
        }

        public APIRequestDeleteUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetSessions
    extends APIRequest<CustomAudienceSession> {
        APINodeList<CustomAudienceSession> lastResponse = null;
        public static final String[] PARAMS = new String[]{"session_id"};
        public static final String[] FIELDS = new String[]{"end_time", "num_invalid_entries", "num_matched", "num_received", "progress", "session_id", "stage", "start_time"};

        @Override
        public APINodeList<CustomAudienceSession> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CustomAudienceSession> parseResponse(String response) throws APIException {
            return CustomAudienceSession.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<CustomAudienceSession> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CustomAudienceSession> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CustomAudienceSession>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CustomAudienceSession>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<CustomAudienceSession>>(){

                public APINodeList<CustomAudienceSession> apply(String result) {
                    try {
                        return APIRequestGetSessions.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetSessions(String nodeId, APIContext context) {
            super(context, nodeId, "/sessions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSessions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSessions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSessions setSessionId(Long sessionId) {
            this.setParam("session_id", sessionId);
            return this;
        }

        public APIRequestGetSessions setSessionId(String sessionId) {
            this.setParam("session_id", sessionId);
            return this;
        }

        public APIRequestGetSessions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSessions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSessions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSessions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSessions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSessions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSessions requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetSessions requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetSessions requestNumInvalidEntriesField() {
            return this.requestNumInvalidEntriesField(true);
        }

        public APIRequestGetSessions requestNumInvalidEntriesField(boolean value) {
            this.requestField("num_invalid_entries", value);
            return this;
        }

        public APIRequestGetSessions requestNumMatchedField() {
            return this.requestNumMatchedField(true);
        }

        public APIRequestGetSessions requestNumMatchedField(boolean value) {
            this.requestField("num_matched", value);
            return this;
        }

        public APIRequestGetSessions requestNumReceivedField() {
            return this.requestNumReceivedField(true);
        }

        public APIRequestGetSessions requestNumReceivedField(boolean value) {
            this.requestField("num_received", value);
            return this;
        }

        public APIRequestGetSessions requestProgressField() {
            return this.requestProgressField(true);
        }

        public APIRequestGetSessions requestProgressField(boolean value) {
            this.requestField("progress", value);
            return this;
        }

        public APIRequestGetSessions requestSessionIdField() {
            return this.requestSessionIdField(true);
        }

        public APIRequestGetSessions requestSessionIdField(boolean value) {
            this.requestField("session_id", value);
            return this;
        }

        public APIRequestGetSessions requestStageField() {
            return this.requestStageField(true);
        }

        public APIRequestGetSessions requestStageField(boolean value) {
            this.requestField("stage", value);
            return this;
        }

        public APIRequestGetSessions requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetSessions requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPrefills
    extends APIRequest<CustomAudiencePrefillState> {
        APINodeList<CustomAudiencePrefillState> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"description", "num_added", "status"};

        @Override
        public APINodeList<CustomAudiencePrefillState> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CustomAudiencePrefillState> parseResponse(String response) throws APIException {
            return CustomAudiencePrefillState.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<CustomAudiencePrefillState> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CustomAudiencePrefillState> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CustomAudiencePrefillState>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CustomAudiencePrefillState>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<CustomAudiencePrefillState>>(){

                public APINodeList<CustomAudiencePrefillState> apply(String result) {
                    try {
                        return APIRequestGetPrefills.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPrefills(String nodeId, APIContext context) {
            super(context, nodeId, "/prefills", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPrefills setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPrefills setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPrefills requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPrefills requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPrefills requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPrefills requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPrefills requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPrefills requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPrefills requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetPrefills requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetPrefills requestNumAddedField() {
            return this.requestNumAddedField(true);
        }

        public APIRequestGetPrefills requestNumAddedField(boolean value) {
            this.requestField("num_added", value);
            return this;
        }

        public APIRequestGetPrefills requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetPrefills requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAds
    extends APIRequest<Ad> {
        APINodeList<Ad> lastResponse = null;
        public static final String[] PARAMS = new String[]{"effective_status", "status"};
        public static final String[] FIELDS = new String[]{"account_id", "ad_review_feedback", "adlabels", "adset", "adset_id", "bid_amount", "bid_info", "bid_type", "campaign", "campaign_id", "configured_status", "conversion_specs", "created_time", "creative", "effective_status", "id", "last_updated_by_app_id", "name", "recommendations", "source_ad", "source_ad_id", "status", "tracking_specs", "updated_time"};

        @Override
        public APINodeList<Ad> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Ad> parseResponse(String response) throws APIException {
            return Ad.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Ad> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Ad> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Ad>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Ad>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Ad>>(){

                public APINodeList<Ad> apply(String result) {
                    try {
                        return APIRequestGetAds.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAds(String nodeId, APIContext context) {
            super(context, nodeId, "/ads", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAds setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAds setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAds setEffectiveStatus(List<String> effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetAds setEffectiveStatus(String effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetAds setStatus(List<String> status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestGetAds setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestGetAds requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAds requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAds requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAds requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAds requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAds requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAds requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAds requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAds requestAdReviewFeedbackField() {
            return this.requestAdReviewFeedbackField(true);
        }

        public APIRequestGetAds requestAdReviewFeedbackField(boolean value) {
            this.requestField("ad_review_feedback", value);
            return this;
        }

        public APIRequestGetAds requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetAds requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetAds requestAdsetField() {
            return this.requestAdsetField(true);
        }

        public APIRequestGetAds requestAdsetField(boolean value) {
            this.requestField("adset", value);
            return this;
        }

        public APIRequestGetAds requestAdsetIdField() {
            return this.requestAdsetIdField(true);
        }

        public APIRequestGetAds requestAdsetIdField(boolean value) {
            this.requestField("adset_id", value);
            return this;
        }

        public APIRequestGetAds requestBidAmountField() {
            return this.requestBidAmountField(true);
        }

        public APIRequestGetAds requestBidAmountField(boolean value) {
            this.requestField("bid_amount", value);
            return this;
        }

        public APIRequestGetAds requestBidInfoField() {
            return this.requestBidInfoField(true);
        }

        public APIRequestGetAds requestBidInfoField(boolean value) {
            this.requestField("bid_info", value);
            return this;
        }

        public APIRequestGetAds requestBidTypeField() {
            return this.requestBidTypeField(true);
        }

        public APIRequestGetAds requestBidTypeField(boolean value) {
            this.requestField("bid_type", value);
            return this;
        }

        public APIRequestGetAds requestCampaignField() {
            return this.requestCampaignField(true);
        }

        public APIRequestGetAds requestCampaignField(boolean value) {
            this.requestField("campaign", value);
            return this;
        }

        public APIRequestGetAds requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetAds requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetAds requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetAds requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetAds requestConversionSpecsField() {
            return this.requestConversionSpecsField(true);
        }

        public APIRequestGetAds requestConversionSpecsField(boolean value) {
            this.requestField("conversion_specs", value);
            return this;
        }

        public APIRequestGetAds requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAds requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAds requestCreativeField() {
            return this.requestCreativeField(true);
        }

        public APIRequestGetAds requestCreativeField(boolean value) {
            this.requestField("creative", value);
            return this;
        }

        public APIRequestGetAds requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetAds requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetAds requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAds requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAds requestLastUpdatedByAppIdField() {
            return this.requestLastUpdatedByAppIdField(true);
        }

        public APIRequestGetAds requestLastUpdatedByAppIdField(boolean value) {
            this.requestField("last_updated_by_app_id", value);
            return this;
        }

        public APIRequestGetAds requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAds requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAds requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetAds requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetAds requestSourceAdField() {
            return this.requestSourceAdField(true);
        }

        public APIRequestGetAds requestSourceAdField(boolean value) {
            this.requestField("source_ad", value);
            return this;
        }

        public APIRequestGetAds requestSourceAdIdField() {
            return this.requestSourceAdIdField(true);
        }

        public APIRequestGetAds requestSourceAdIdField(boolean value) {
            this.requestField("source_ad_id", value);
            return this;
        }

        public APIRequestGetAds requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAds requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAds requestTrackingSpecsField() {
            return this.requestTrackingSpecsField(true);
        }

        public APIRequestGetAds requestTrackingSpecsField(boolean value) {
            this.requestField("tracking_specs", value);
            return this;
        }

        public APIRequestGetAds requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAds requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdAccount
    extends APIRequest<AdAccount> {
        AdAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"adaccounts", "permissions", "replace"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccount parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccount>(){

                public AdAccount apply(String result) {
                    try {
                        return APIRequestCreateAdAccount.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAdAccount(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdAccount setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdAccount setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdAccount setAdaccounts(List<String> adaccounts) {
            this.setParam("adaccounts", adaccounts);
            return this;
        }

        public APIRequestCreateAdAccount setAdaccounts(String adaccounts) {
            this.setParam("adaccounts", adaccounts);
            return this;
        }

        public APIRequestCreateAdAccount setPermissions(String permissions) {
            this.setParam("permissions", permissions);
            return this;
        }

        public APIRequestCreateAdAccount setReplace(Boolean replace) {
            this.setParam("replace", replace);
            return this;
        }

        public APIRequestCreateAdAccount setReplace(String replace) {
            this.setParam("replace", replace);
            return this;
        }

        public APIRequestCreateAdAccount requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdAccount requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdAccount requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdAccount requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[]{"permissions"};
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "disable_reason", "end_advertiser", "end_advertiser_name", "extended_credit_invoice_group", "failed_delivery_checks", "funding_source", "funding_source_details", "has_migrated_permissions", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "partner", "rf_spec", "show_checkout_experience", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_role"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(String result) {
                    try {
                        return APIRequestGetAdAccounts.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdAccounts setPermissions(String permissions) {
            this.setParam("permissions", permissions);
            return this;
        }

        public APIRequestGetAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserRoleField() {
            return this.requestUserRoleField(true);
        }

        public APIRequestGetAdAccounts requestUserRoleField(boolean value) {
            this.requestField("user_role", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteAdAccounts
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"adaccounts"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteAdAccounts.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAdAccounts setAdaccounts(List<String> adaccounts) {
            this.setParam("adaccounts", adaccounts);
            return this;
        }

        public APIRequestDeleteAdAccounts setAdaccounts(String adaccounts) {
            this.setParam("adaccounts", adaccounts);
            return this;
        }

        public APIRequestDeleteAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

