/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Canvas
extends APINode {
    @SerializedName(value="background_color")
    private String mBackgroundColor = null;
    @SerializedName(value="body_elements")
    private List<Object> mBodyElements = null;
    @SerializedName(value="canvas_link")
    private String mCanvasLink = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_hidden")
    private Boolean mIsHidden = null;
    @SerializedName(value="is_published")
    private Boolean mIsPublished = null;
    @SerializedName(value="last_editor")
    private User mLastEditor = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="owner")
    private Page mOwner = null;
    @SerializedName(value="update_time")
    private Long mUpdateTime = null;
    protected static Gson gson = null;

    Canvas() {
    }

    public Canvas(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Canvas(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Canvas fetch() throws APIException {
        Canvas newInstance = Canvas.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Canvas fetchById(Long id, APIContext context) throws APIException {
        return Canvas.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Canvas> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Canvas.fetchByIdAsync(id.toString(), context);
    }

    public static Canvas fetchById(String id, APIContext context) throws APIException {
        Canvas canvas = new APIRequestGet(id, context).requestAllFields().execute();
        return canvas;
    }

    public static ListenableFuture<Canvas> fetchByIdAsync(String id, APIContext context) throws APIException {
        ListenableFuture<Canvas> canvas = new APIRequestGet(id, context).requestAllFields().executeAsync();
        return canvas;
    }

    public static APINodeList<Canvas> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Canvas>(context, "", "/", "GET", Canvas.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Canvas>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        ListenableFuture<APIResponse> canvas = new APIRequest<Canvas>(context, "", "/", "GET", Canvas.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
        return canvas;
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Canvas loadJSON(String json, APIContext context) {
        Canvas canvas = (Canvas)Canvas.getGson().fromJson(json, Canvas.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(canvas.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        canvas.context = context;
        canvas.rawValue = json;
        return canvas;
    }

    public static APINodeList<Canvas> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<Canvas> canvass = new APINodeList<Canvas>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        canvass.add(Canvas.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return canvass;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            canvass.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        canvass.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            canvass.add(Canvas.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                canvass.add(Canvas.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            canvass.add(Canvas.loadJSON(obj.toString(), context));
                        }
                    }
                    return canvass;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        canvass.add(Canvas.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return canvass;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        canvass.add(Canvas.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return canvass;
                }
                canvass.clear();
                canvass.add(Canvas.loadJSON(json, context));
                return canvass;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Canvas.getGson().toJson((Object)this);
    }

    public APIRequestCreateDuplicateCanva createDuplicateCanva() {
        return new APIRequestCreateDuplicateCanva(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePreviewNotification createPreviewNotification() {
        return new APIRequestCreatePreviewNotification(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBackgroundColor() {
        return this.mBackgroundColor;
    }

    public List<Object> getFieldBodyElements() {
        return this.mBodyElements;
    }

    public String getFieldCanvasLink() {
        return this.mCanvasLink;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsHidden() {
        return this.mIsHidden;
    }

    public Boolean getFieldIsPublished() {
        return this.mIsPublished;
    }

    public User getFieldLastEditor() {
        if (this.mLastEditor != null) {
            this.mLastEditor.context = this.getContext();
        }
        return this.mLastEditor;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Page getFieldOwner() {
        if (this.mOwner != null) {
            this.mOwner.context = this.getContext();
        }
        return this.mOwner;
    }

    public Long getFieldUpdateTime() {
        return this.mUpdateTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Canvas copyFrom(Canvas instance) {
        this.mBackgroundColor = instance.mBackgroundColor;
        this.mBodyElements = instance.mBodyElements;
        this.mCanvasLink = instance.mCanvasLink;
        this.mId = instance.mId;
        this.mIsHidden = instance.mIsHidden;
        this.mIsPublished = instance.mIsPublished;
        this.mLastEditor = instance.mLastEditor;
        this.mName = instance.mName;
        this.mOwner = instance.mOwner;
        this.mUpdateTime = instance.mUpdateTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Canvas> getParser() {
        return new APIRequest.ResponseParser<Canvas>(){

            @Override
            public APINodeList<Canvas> parseResponse(String response, APIContext context, APIRequest<Canvas> request) throws APIException.MalformedResponseException {
                return Canvas.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<Canvas> {
        Canvas lastResponse = null;
        public static final String[] PARAMS = new String[]{"background_color", "body_element_ids", "is_hidden", "is_published", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Canvas getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Canvas parseResponse(String response) throws APIException {
            return Canvas.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Canvas execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Canvas execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Canvas> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Canvas> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Canvas>(){

                public Canvas apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setBackgroundColor(String backgroundColor) {
            this.setParam("background_color", backgroundColor);
            return this;
        }

        public APIRequestUpdate setBodyElementIds(List<String> bodyElementIds) {
            this.setParam("body_element_ids", bodyElementIds);
            return this;
        }

        public APIRequestUpdate setBodyElementIds(String bodyElementIds) {
            this.setParam("body_element_ids", bodyElementIds);
            return this;
        }

        public APIRequestUpdate setIsHidden(Boolean isHidden) {
            this.setParam("is_hidden", isHidden);
            return this;
        }

        public APIRequestUpdate setIsHidden(String isHidden) {
            this.setParam("is_hidden", isHidden);
            return this;
        }

        public APIRequestUpdate setIsPublished(Boolean isPublished) {
            this.setParam("is_published", isPublished);
            return this;
        }

        public APIRequestUpdate setIsPublished(String isPublished) {
            this.setParam("is_published", isPublished);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Canvas> {
        Canvas lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"background_color", "body_elements", "canvas_link", "id", "is_hidden", "is_published", "last_editor", "name", "owner", "update_time"};

        @Override
        public Canvas getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Canvas parseResponse(String response) throws APIException {
            return Canvas.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Canvas execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Canvas execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Canvas> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Canvas> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Canvas>(){

                public Canvas apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBackgroundColorField() {
            return this.requestBackgroundColorField(true);
        }

        public APIRequestGet requestBackgroundColorField(boolean value) {
            this.requestField("background_color", value);
            return this;
        }

        public APIRequestGet requestBodyElementsField() {
            return this.requestBodyElementsField(true);
        }

        public APIRequestGet requestBodyElementsField(boolean value) {
            this.requestField("body_elements", value);
            return this;
        }

        public APIRequestGet requestCanvasLinkField() {
            return this.requestCanvasLinkField(true);
        }

        public APIRequestGet requestCanvasLinkField(boolean value) {
            this.requestField("canvas_link", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGet requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGet requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGet requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGet requestLastEditorField() {
            return this.requestLastEditorField(true);
        }

        public APIRequestGet requestLastEditorField(boolean value) {
            this.requestField("last_editor", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestUpdateTimeField() {
            return this.requestUpdateTimeField(true);
        }

        public APIRequestGet requestUpdateTimeField(boolean value) {
            this.requestField("update_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePreviewNotification
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"user_ids"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreatePreviewNotification.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePreviewNotification(String nodeId, APIContext context) {
            super(context, nodeId, "/preview_notifications", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePreviewNotification setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePreviewNotification setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePreviewNotification setUserIds(List<Long> userIds) {
            this.setParam("user_ids", userIds);
            return this;
        }

        public APIRequestCreatePreviewNotification setUserIds(String userIds) {
            this.setParam("user_ids", userIds);
            return this;
        }

        public APIRequestCreatePreviewNotification requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePreviewNotification requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePreviewNotification requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePreviewNotification requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePreviewNotification requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePreviewNotification requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateDuplicateCanva
    extends APIRequest<Canvas> {
        Canvas lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public Canvas getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Canvas parseResponse(String response) throws APIException {
            return Canvas.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Canvas execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Canvas execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Canvas> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Canvas> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Canvas>(){

                public Canvas apply(String result) {
                    try {
                        return APIRequestCreateDuplicateCanva.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateDuplicateCanva(String nodeId, APIContext context) {
            super(context, nodeId, "/duplicate_canvas", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateDuplicateCanva setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateDuplicateCanva setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateDuplicateCanva requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateDuplicateCanva requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateDuplicateCanva requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateDuplicateCanva requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateDuplicateCanva requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateDuplicateCanva requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

