/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAssetFeedSpecAssetLabel;
import com.facebook.ads.sdk.AdsImageCrops;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAssetFeedSpecImage
extends APINode {
    @SerializedName(value="adlabels")
    private List<AdAssetFeedSpecAssetLabel> mAdlabels = null;
    @SerializedName(value="hash")
    private String mHash = null;
    @SerializedName(value="image_crops")
    private AdsImageCrops mImageCrops = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="url_tags")
    private String mUrlTags = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdAssetFeedSpecImage loadJSON(String json, APIContext context) {
        AdAssetFeedSpecImage adAssetFeedSpecImage = (AdAssetFeedSpecImage)AdAssetFeedSpecImage.getGson().fromJson(json, AdAssetFeedSpecImage.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetFeedSpecImage.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetFeedSpecImage.context = context;
        adAssetFeedSpecImage.rawValue = json;
        return adAssetFeedSpecImage;
    }

    public static APINodeList<AdAssetFeedSpecImage> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<AdAssetFeedSpecImage> adAssetFeedSpecImages = new APINodeList<AdAssetFeedSpecImage>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetFeedSpecImages.add(AdAssetFeedSpecImage.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAssetFeedSpecImages;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetFeedSpecImages.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetFeedSpecImages.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetFeedSpecImages.add(AdAssetFeedSpecImage.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetFeedSpecImages.add(AdAssetFeedSpecImage.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetFeedSpecImages.add(AdAssetFeedSpecImage.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAssetFeedSpecImages;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetFeedSpecImages.add(AdAssetFeedSpecImage.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAssetFeedSpecImages;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetFeedSpecImages.add(AdAssetFeedSpecImage.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetFeedSpecImages;
                }
                adAssetFeedSpecImages.clear();
                adAssetFeedSpecImages.add(AdAssetFeedSpecImage.loadJSON(json, context));
                return adAssetFeedSpecImages;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetFeedSpecImage.getGson().toJson((Object)this);
    }

    public List<AdAssetFeedSpecAssetLabel> getFieldAdlabels() {
        return this.mAdlabels;
    }

    public AdAssetFeedSpecImage setFieldAdlabels(List<AdAssetFeedSpecAssetLabel> value) {
        this.mAdlabels = value;
        return this;
    }

    public AdAssetFeedSpecImage setFieldAdlabels(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecAssetLabel>>(){}.getType();
        this.mAdlabels = (List)AdAssetFeedSpecAssetLabel.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldHash() {
        return this.mHash;
    }

    public AdAssetFeedSpecImage setFieldHash(String value) {
        this.mHash = value;
        return this;
    }

    public AdsImageCrops getFieldImageCrops() {
        return this.mImageCrops;
    }

    public AdAssetFeedSpecImage setFieldImageCrops(AdsImageCrops value) {
        this.mImageCrops = value;
        return this;
    }

    public AdAssetFeedSpecImage setFieldImageCrops(String value) {
        Type type = new TypeToken<AdsImageCrops>(){}.getType();
        this.mImageCrops = (AdsImageCrops)AdsImageCrops.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public AdAssetFeedSpecImage setFieldUrl(String value) {
        this.mUrl = value;
        return this;
    }

    public String getFieldUrlTags() {
        return this.mUrlTags;
    }

    public AdAssetFeedSpecImage setFieldUrlTags(String value) {
        this.mUrlTags = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetFeedSpecImage copyFrom(AdAssetFeedSpecImage instance) {
        this.mAdlabels = instance.mAdlabels;
        this.mHash = instance.mHash;
        this.mImageCrops = instance.mImageCrops;
        this.mUrl = instance.mUrl;
        this.mUrlTags = instance.mUrlTags;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetFeedSpecImage> getParser() {
        return new APIRequest.ResponseParser<AdAssetFeedSpecImage>(){

            @Override
            public APINodeList<AdAssetFeedSpecImage> parseResponse(String response, APIContext context, APIRequest<AdAssetFeedSpecImage> request) throws APIException.MalformedResponseException {
                return AdAssetFeedSpecImage.parseResponse(response, context, request);
            }
        };
    }
}

