/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APINode
implements APIResponse {
    protected APIContext context = null;
    protected String rawValue = null;

    public static APINode loadJSON(String json, APIContext context) {
        APINode result = null;
        result = new APINode();
        result.context = context;
        result.rawValue = json;
        return result;
    }

    public APIContext getContext() {
        return this.context;
    }

    public void setContext(APIContext context) {
        this.context = context;
    }

    public String toString() {
        return this.rawValue;
    }

    public String getId() {
        try {
            JsonParser parser = new JsonParser();
            return parser.parse(this.rawValue).getAsJsonObject().get("id").getAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRawValue() {
        return this.rawValue;
    }

    @Override
    public String getRawResponse() {
        return this.rawValue;
    }

    @Override
    public JsonObject getRawResponseAsJsonObject() {
        JsonParser parser = new JsonParser();
        try {
            return parser.parse(this.rawValue).getAsJsonObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public APINode head() {
        return this;
    }

    public static APINodeList<APINode> parseResponse(String json, APIContext context, APIRequest<APINode> request) throws APIException.MalformedResponseException {
        APINodeList<APINode> nodes = new APINodeList<APINode>(request, json);
        JsonParser parser = new JsonParser();
        Exception exception = null;
        try {
            JsonElement result = parser.parse(json);
            if (result.isJsonArray()) {
                JsonArray arr = result.getAsJsonArray();
                for (int i = 0; i < arr.size(); ++i) {
                    nodes.add(APINode.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                }
                return nodes;
            }
            if (result.isJsonObject()) {
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    JsonObject paging = obj.get("paging").getAsJsonObject();
                    if (paging.has("cursors")) {
                        JsonObject cursors = paging.get("cursors").getAsJsonObject();
                        String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                        String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                        nodes.setCursors(before, after);
                    }
                    String previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                    String next = paging.has("next") ? paging.get("next").getAsString() : null;
                    nodes.setPaging(previous, next);
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            nodes.add(APINode.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        nodes.add(APINode.loadJSON(obj.toString(), context));
                    }
                    return nodes;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        nodes.add(APINode.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return nodes;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        nodes.add(APINode.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return nodes;
                }
                nodes.clear();
                nodes.add(APINode.loadJSON(json, context));
                return nodes;
            }
        }
        catch (Exception e) {
            exception = e;
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIException getException() {
        return null;
    }
}

