/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreative;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class UniqueAdCreative
extends APINode {
    @SerializedName(value="sample_creative")
    private AdCreative mSampleCreative = null;
    @SerializedName(value="visual_hash")
    private Long mVisualHash = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static UniqueAdCreative loadJSON(String json, APIContext context, String header) {
        UniqueAdCreative uniqueAdCreative = (UniqueAdCreative)UniqueAdCreative.getGson().fromJson(json, UniqueAdCreative.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(uniqueAdCreative.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        uniqueAdCreative.context = context;
        uniqueAdCreative.rawValue = json;
        uniqueAdCreative.header = header;
        return uniqueAdCreative;
    }

    public static APINodeList<UniqueAdCreative> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<UniqueAdCreative> uniqueAdCreatives = new APINodeList<UniqueAdCreative>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        uniqueAdCreatives.add(UniqueAdCreative.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return uniqueAdCreatives;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            uniqueAdCreatives.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        uniqueAdCreatives.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            uniqueAdCreatives.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            uniqueAdCreatives.add(UniqueAdCreative.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                uniqueAdCreatives.add(UniqueAdCreative.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            uniqueAdCreatives.add(UniqueAdCreative.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return uniqueAdCreatives;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        uniqueAdCreatives.add(UniqueAdCreative.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return uniqueAdCreatives;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        uniqueAdCreatives.add(UniqueAdCreative.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return uniqueAdCreatives;
                }
                uniqueAdCreatives.clear();
                uniqueAdCreatives.add(UniqueAdCreative.loadJSON(json, context, header));
                return uniqueAdCreatives;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return UniqueAdCreative.getGson().toJson((Object)this);
    }

    public AdCreative getFieldSampleCreative() {
        if (this.mSampleCreative != null) {
            this.mSampleCreative.context = this.getContext();
        }
        return this.mSampleCreative;
    }

    public UniqueAdCreative setFieldSampleCreative(AdCreative value) {
        this.mSampleCreative = value;
        return this;
    }

    public UniqueAdCreative setFieldSampleCreative(String value) {
        Type type = new TypeToken<AdCreative>(){}.getType();
        this.mSampleCreative = (AdCreative)AdCreative.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldVisualHash() {
        return this.mVisualHash;
    }

    public UniqueAdCreative setFieldVisualHash(Long value) {
        this.mVisualHash = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public UniqueAdCreative copyFrom(UniqueAdCreative instance) {
        this.mSampleCreative = instance.mSampleCreative;
        this.mVisualHash = instance.mVisualHash;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<UniqueAdCreative> getParser() {
        return new APIRequest.ResponseParser<UniqueAdCreative>(){

            @Override
            public APINodeList<UniqueAdCreative> parseResponse(String response, APIContext context, APIRequest<UniqueAdCreative> request, String header) throws APIException.MalformedResponseException {
                return UniqueAdCreative.parseResponse(response, context, request, header);
            }
        };
    }
}

