/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ShadowIGScheduledMedia
extends APINode {
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="media_type")
    private String mMediaType = null;
    @SerializedName(value="media_url")
    private String mMediaUrl = null;
    @SerializedName(value="publish_timestamp")
    private Long mPublishTimestamp = null;
    @SerializedName(value="thumbnail_url")
    private String mThumbnailUrl = null;
    protected static Gson gson = null;

    ShadowIGScheduledMedia() {
    }

    public ShadowIGScheduledMedia(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ShadowIGScheduledMedia(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ShadowIGScheduledMedia fetch() throws APIException {
        ShadowIGScheduledMedia newInstance = ShadowIGScheduledMedia.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ShadowIGScheduledMedia fetchById(Long id, APIContext context) throws APIException {
        return ShadowIGScheduledMedia.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ShadowIGScheduledMedia> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ShadowIGScheduledMedia.fetchByIdAsync(id.toString(), context);
    }

    public static ShadowIGScheduledMedia fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ShadowIGScheduledMedia> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ShadowIGScheduledMedia> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ShadowIGScheduledMedia>(context, "", "/", "GET", ShadowIGScheduledMedia.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ShadowIGScheduledMedia>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ShadowIGScheduledMedia>(context, "", "/", "GET", ShadowIGScheduledMedia.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ShadowIGScheduledMedia loadJSON(String json, APIContext context, String header) {
        ShadowIGScheduledMedia shadowIGScheduledMedia = (ShadowIGScheduledMedia)ShadowIGScheduledMedia.getGson().fromJson(json, ShadowIGScheduledMedia.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(shadowIGScheduledMedia.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        shadowIGScheduledMedia.context = context;
        shadowIGScheduledMedia.rawValue = json;
        shadowIGScheduledMedia.header = header;
        return shadowIGScheduledMedia;
    }

    public static APINodeList<ShadowIGScheduledMedia> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ShadowIGScheduledMedia> shadowIGScheduledMedias = new APINodeList<ShadowIGScheduledMedia>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        shadowIGScheduledMedias.add(ShadowIGScheduledMedia.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return shadowIGScheduledMedias;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            shadowIGScheduledMedias.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        shadowIGScheduledMedias.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            shadowIGScheduledMedias.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            shadowIGScheduledMedias.add(ShadowIGScheduledMedia.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                shadowIGScheduledMedias.add(ShadowIGScheduledMedia.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            shadowIGScheduledMedias.add(ShadowIGScheduledMedia.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return shadowIGScheduledMedias;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        shadowIGScheduledMedias.add(ShadowIGScheduledMedia.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return shadowIGScheduledMedias;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        shadowIGScheduledMedias.add(ShadowIGScheduledMedia.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return shadowIGScheduledMedias;
                }
                shadowIGScheduledMedias.clear();
                shadowIGScheduledMedias.add(ShadowIGScheduledMedia.loadJSON(json, context, header));
                return shadowIGScheduledMedias;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ShadowIGScheduledMedia.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldMediaType() {
        return this.mMediaType;
    }

    public String getFieldMediaUrl() {
        return this.mMediaUrl;
    }

    public Long getFieldPublishTimestamp() {
        return this.mPublishTimestamp;
    }

    public String getFieldThumbnailUrl() {
        return this.mThumbnailUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ShadowIGScheduledMedia copyFrom(ShadowIGScheduledMedia instance) {
        this.mCaption = instance.mCaption;
        this.mId = instance.mId;
        this.mMediaType = instance.mMediaType;
        this.mMediaUrl = instance.mMediaUrl;
        this.mPublishTimestamp = instance.mPublishTimestamp;
        this.mThumbnailUrl = instance.mThumbnailUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ShadowIGScheduledMedia> getParser() {
        return new APIRequest.ResponseParser<ShadowIGScheduledMedia>(){

            @Override
            public APINodeList<ShadowIGScheduledMedia> parseResponse(String response, APIContext context, APIRequest<ShadowIGScheduledMedia> request, String header) throws APIException.MalformedResponseException {
                return ShadowIGScheduledMedia.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<ShadowIGScheduledMedia> {
        ShadowIGScheduledMedia lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"caption", "id", "media_type", "media_url", "publish_timestamp", "thumbnail_url"};

        @Override
        public ShadowIGScheduledMedia getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ShadowIGScheduledMedia parseResponse(String response, String header) throws APIException {
            return ShadowIGScheduledMedia.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ShadowIGScheduledMedia execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ShadowIGScheduledMedia execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ShadowIGScheduledMedia> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ShadowIGScheduledMedia> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ShadowIGScheduledMedia>(){

                public ShadowIGScheduledMedia apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGet requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMediaTypeField() {
            return this.requestMediaTypeField(true);
        }

        public APIRequestGet requestMediaTypeField(boolean value) {
            this.requestField("media_type", value);
            return this;
        }

        public APIRequestGet requestMediaUrlField() {
            return this.requestMediaUrlField(true);
        }

        public APIRequestGet requestMediaUrlField(boolean value) {
            this.requestField("media_url", value);
            return this;
        }

        public APIRequestGet requestPublishTimestampField() {
            return this.requestPublishTimestampField(true);
        }

        public APIRequestGet requestPublishTimestampField(boolean value) {
            this.requestField("publish_timestamp", value);
            return this;
        }

        public APIRequestGet requestThumbnailUrlField() {
            return this.requestThumbnailUrlField(true);
        }

        public APIRequestGet requestThumbnailUrlField(boolean value) {
            this.requestField("thumbnail_url", value);
            return this;
        }
    }
}

