/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.AIGeneratedProductImage;
import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CatalogItemAppLinks;
import com.facebook.ads.sdk.CatalogItemChannelsToIntegrityStatus;
import com.facebook.ads.sdk.CatalogSubVerticalList;
import com.facebook.ads.sdk.DynamicVideoMetadata;
import com.facebook.ads.sdk.OverrideDetails;
import com.facebook.ads.sdk.ProductCatalog;
import com.facebook.ads.sdk.ProductFeed;
import com.facebook.ads.sdk.ProductGroup;
import com.facebook.ads.sdk.ProductItemCommerceInsights;
import com.facebook.ads.sdk.ProductItemError;
import com.facebook.ads.sdk.ProductItemImporterAddress;
import com.facebook.ads.sdk.ProductItemInvalidationError;
import com.facebook.ads.sdk.ProductItemLocalInfo;
import com.facebook.ads.sdk.ProductItemVideoData;
import com.facebook.ads.sdk.ProductSet;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ProductItem
extends APINode {
    @SerializedName(value="additional_image_cdn_urls")
    private List<List<Map<String, String>>> mAdditionalImageCdnUrls = null;
    @SerializedName(value="additional_image_urls")
    private List<String> mAdditionalImageUrls = null;
    @SerializedName(value="additional_variant_attributes")
    private List<Map<String, String>> mAdditionalVariantAttributes = null;
    @SerializedName(value="age_group")
    private EnumAgeGroup mAgeGroup = null;
    @SerializedName(value="applinks")
    private CatalogItemAppLinks mApplinks = null;
    @SerializedName(value="availability")
    private EnumAvailability mAvailability = null;
    @SerializedName(value="brand")
    private String mBrand = null;
    @SerializedName(value="bundle_items")
    private List<String> mBundleItems = null;
    @SerializedName(value="bundle_retailer_ids")
    private List<String> mBundleRetailerIds = null;
    @SerializedName(value="capabilities_disabled_by_user")
    private List<String> mCapabilitiesDisabledByUser = null;
    @SerializedName(value="capability_to_review_status")
    private List<Map<String, EnumCapabilityToReviewStatus>> mCapabilityToReviewStatus = null;
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="category_specific_fields")
    private CatalogSubVerticalList mCategorySpecificFields = null;
    @SerializedName(value="color")
    private String mColor = null;
    @SerializedName(value="commerce_insights")
    private ProductItemCommerceInsights mCommerceInsights = null;
    @SerializedName(value="condition")
    private EnumCondition mCondition = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="custom_data")
    private List<Map<String, String>> mCustomData = null;
    @SerializedName(value="custom_label_0")
    private String mCustomLabel0 = null;
    @SerializedName(value="custom_label_1")
    private String mCustomLabel1 = null;
    @SerializedName(value="custom_label_2")
    private String mCustomLabel2 = null;
    @SerializedName(value="custom_label_3")
    private String mCustomLabel3 = null;
    @SerializedName(value="custom_label_4")
    private String mCustomLabel4 = null;
    @SerializedName(value="custom_number_0")
    private String mCustomNumber0 = null;
    @SerializedName(value="custom_number_1")
    private String mCustomNumber1 = null;
    @SerializedName(value="custom_number_2")
    private String mCustomNumber2 = null;
    @SerializedName(value="custom_number_3")
    private String mCustomNumber3 = null;
    @SerializedName(value="custom_number_4")
    private String mCustomNumber4 = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="errors")
    private List<ProductItemError> mErrors = null;
    @SerializedName(value="expiration_date")
    private String mExpirationDate = null;
    @SerializedName(value="fb_product_category")
    private String mFbProductCategory = null;
    @SerializedName(value="gender")
    private EnumGender mGender = null;
    @SerializedName(value="generated_background_images")
    private List<AIGeneratedProductImage> mGeneratedBackgroundImages = null;
    @SerializedName(value="generated_background_images_ad_usage")
    private Boolean mGeneratedBackgroundImagesAdUsage = null;
    @SerializedName(value="gtin")
    private String mGtin = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="image_cdn_urls")
    private List<Map<String, String>> mImageCdnUrls = null;
    @SerializedName(value="image_fetch_status")
    private EnumImageFetchStatus mImageFetchStatus = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="importer_address")
    private ProductItemImporterAddress mImporterAddress = null;
    @SerializedName(value="importer_name")
    private String mImporterName = null;
    @SerializedName(value="invalidation_errors")
    private List<ProductItemInvalidationError> mInvalidationErrors = null;
    @SerializedName(value="inventory")
    private Long mInventory = null;
    @SerializedName(value="is_bundle_hero")
    private Boolean mIsBundleHero = null;
    @SerializedName(value="live_special_price")
    private String mLiveSpecialPrice = null;
    @SerializedName(value="manufacturer_info")
    private String mManufacturerInfo = null;
    @SerializedName(value="manufacturer_part_number")
    private String mManufacturerPartNumber = null;
    @SerializedName(value="marked_for_product_launch")
    private String mMarkedForProductLaunch = null;
    @SerializedName(value="material")
    private String mMaterial = null;
    @SerializedName(value="mobile_link")
    private String mMobileLink = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="ordering_index")
    private Long mOrderingIndex = null;
    @SerializedName(value="origin_country")
    private String mOriginCountry = null;
    @SerializedName(value="parent_product_id")
    private String mParentProductId = null;
    @SerializedName(value="pattern")
    private String mPattern = null;
    @SerializedName(value="post_conversion_signal_based_enforcement_appeal_eligibility")
    private Boolean mPostConversionSignalBasedEnforcementAppealEligibility = null;
    @SerializedName(value="price")
    private String mPrice = null;
    @SerializedName(value="product_catalog")
    private ProductCatalog mProductCatalog = null;
    @SerializedName(value="product_feed")
    private ProductFeed mProductFeed = null;
    @SerializedName(value="product_group")
    private ProductGroup mProductGroup = null;
    @SerializedName(value="product_local_info")
    private ProductItemLocalInfo mProductLocalInfo = null;
    @SerializedName(value="product_relationship")
    private String mProductRelationship = null;
    @SerializedName(value="product_type")
    private String mProductType = null;
    @SerializedName(value="quantity_to_sell_on_facebook")
    private Long mQuantityToSellOnFacebook = null;
    @SerializedName(value="retailer_id")
    private String mRetailerId = null;
    @SerializedName(value="retailer_product_group_id")
    private String mRetailerProductGroupId = null;
    @SerializedName(value="review_rejection_reasons")
    private List<String> mReviewRejectionReasons = null;
    @SerializedName(value="review_status")
    private EnumReviewStatus mReviewStatus = null;
    @SerializedName(value="rich_text_description")
    private String mRichTextDescription = null;
    @SerializedName(value="sale_price")
    private String mSalePrice = null;
    @SerializedName(value="sale_price_end_date")
    private String mSalePriceEndDate = null;
    @SerializedName(value="sale_price_start_date")
    private String mSalePriceStartDate = null;
    @SerializedName(value="shipping_weight_unit")
    private EnumShippingWeightUnit mShippingWeightUnit = null;
    @SerializedName(value="shipping_weight_value")
    private Double mShippingWeightValue = null;
    @SerializedName(value="short_description")
    private String mShortDescription = null;
    @SerializedName(value="size")
    private String mSize = null;
    @SerializedName(value="start_date")
    private String mStartDate = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    @SerializedName(value="tags")
    private List<String> mTags = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="vendor_id")
    private String mVendorId = null;
    @SerializedName(value="video_fetch_status")
    private EnumVideoFetchStatus mVideoFetchStatus = null;
    @SerializedName(value="videos")
    private List<ProductItemVideoData> mVideos = null;
    @SerializedName(value="visibility")
    private EnumVisibility mVisibility = null;
    @SerializedName(value="wa_compliance_category")
    private String mWaComplianceCategory = null;
    protected static Gson gson = null;

    ProductItem() {
    }

    public ProductItem(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductItem(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductItem fetch() throws APIException {
        ProductItem newInstance = ProductItem.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductItem fetchById(Long id, APIContext context) throws APIException {
        return ProductItem.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductItem> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductItem.fetchByIdAsync(id.toString(), context);
    }

    public static ProductItem fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProductItem> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProductItem> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductItem>(context, "", "/", "GET", ProductItem.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductItem>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProductItem>(context, "", "/", "GET", ProductItem.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductItem loadJSON(String json, APIContext context, String header) {
        ProductItem productItem = (ProductItem)ProductItem.getGson().fromJson(json, ProductItem.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productItem.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productItem.context = context;
        productItem.rawValue = json;
        productItem.header = header;
        return productItem;
    }

    public static APINodeList<ProductItem> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductItem> productItems = new APINodeList<ProductItem>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productItems.add(ProductItem.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return productItems;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productItems.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productItems.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productItems.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productItems.add(ProductItem.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productItems.add(ProductItem.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productItems.add(ProductItem.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return productItems;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productItems.add(ProductItem.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return productItems;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productItems.add(ProductItem.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productItems;
                }
                productItems.clear();
                productItems.add(ProductItem.loadJSON(json, context, header));
                return productItems;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductItem.getGson().toJson((Object)this);
    }

    public APIRequestGetChannelsToIntegrityStatus getChannelsToIntegrityStatus() {
        return new APIRequestGetChannelsToIntegrityStatus(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetOverrideDetails getOverrideDetails() {
        return new APIRequestGetOverrideDetails(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetProductSets getProductSets() {
        return new APIRequestGetProductSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideosMetadata getVideosMetadata() {
        return new APIRequestGetVideosMetadata(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public List<List<Map<String, String>>> getFieldAdditionalImageCdnUrls() {
        return this.mAdditionalImageCdnUrls;
    }

    public List<String> getFieldAdditionalImageUrls() {
        return this.mAdditionalImageUrls;
    }

    public List<Map<String, String>> getFieldAdditionalVariantAttributes() {
        return this.mAdditionalVariantAttributes;
    }

    public EnumAgeGroup getFieldAgeGroup() {
        return this.mAgeGroup;
    }

    public CatalogItemAppLinks getFieldApplinks() {
        return this.mApplinks;
    }

    public EnumAvailability getFieldAvailability() {
        return this.mAvailability;
    }

    public String getFieldBrand() {
        return this.mBrand;
    }

    public List<String> getFieldBundleItems() {
        return this.mBundleItems;
    }

    public List<String> getFieldBundleRetailerIds() {
        return this.mBundleRetailerIds;
    }

    public List<String> getFieldCapabilitiesDisabledByUser() {
        return this.mCapabilitiesDisabledByUser;
    }

    public List<Map<String, EnumCapabilityToReviewStatus>> getFieldCapabilityToReviewStatus() {
        return this.mCapabilityToReviewStatus;
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public CatalogSubVerticalList getFieldCategorySpecificFields() {
        return this.mCategorySpecificFields;
    }

    public String getFieldColor() {
        return this.mColor;
    }

    public ProductItemCommerceInsights getFieldCommerceInsights() {
        return this.mCommerceInsights;
    }

    public EnumCondition getFieldCondition() {
        return this.mCondition;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public List<Map<String, String>> getFieldCustomData() {
        return this.mCustomData;
    }

    public String getFieldCustomLabel0() {
        return this.mCustomLabel0;
    }

    public String getFieldCustomLabel1() {
        return this.mCustomLabel1;
    }

    public String getFieldCustomLabel2() {
        return this.mCustomLabel2;
    }

    public String getFieldCustomLabel3() {
        return this.mCustomLabel3;
    }

    public String getFieldCustomLabel4() {
        return this.mCustomLabel4;
    }

    public String getFieldCustomNumber0() {
        return this.mCustomNumber0;
    }

    public String getFieldCustomNumber1() {
        return this.mCustomNumber1;
    }

    public String getFieldCustomNumber2() {
        return this.mCustomNumber2;
    }

    public String getFieldCustomNumber3() {
        return this.mCustomNumber3;
    }

    public String getFieldCustomNumber4() {
        return this.mCustomNumber4;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public List<ProductItemError> getFieldErrors() {
        return this.mErrors;
    }

    public String getFieldExpirationDate() {
        return this.mExpirationDate;
    }

    public String getFieldFbProductCategory() {
        return this.mFbProductCategory;
    }

    public EnumGender getFieldGender() {
        return this.mGender;
    }

    public List<AIGeneratedProductImage> getFieldGeneratedBackgroundImages() {
        return this.mGeneratedBackgroundImages;
    }

    public Boolean getFieldGeneratedBackgroundImagesAdUsage() {
        return this.mGeneratedBackgroundImagesAdUsage;
    }

    public String getFieldGtin() {
        return this.mGtin;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<Map<String, String>> getFieldImageCdnUrls() {
        return this.mImageCdnUrls;
    }

    public EnumImageFetchStatus getFieldImageFetchStatus() {
        return this.mImageFetchStatus;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public ProductItemImporterAddress getFieldImporterAddress() {
        return this.mImporterAddress;
    }

    public String getFieldImporterName() {
        return this.mImporterName;
    }

    public List<ProductItemInvalidationError> getFieldInvalidationErrors() {
        return this.mInvalidationErrors;
    }

    public Long getFieldInventory() {
        return this.mInventory;
    }

    public Boolean getFieldIsBundleHero() {
        return this.mIsBundleHero;
    }

    public String getFieldLiveSpecialPrice() {
        return this.mLiveSpecialPrice;
    }

    public String getFieldManufacturerInfo() {
        return this.mManufacturerInfo;
    }

    public String getFieldManufacturerPartNumber() {
        return this.mManufacturerPartNumber;
    }

    public String getFieldMarkedForProductLaunch() {
        return this.mMarkedForProductLaunch;
    }

    public String getFieldMaterial() {
        return this.mMaterial;
    }

    public String getFieldMobileLink() {
        return this.mMobileLink;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldOrderingIndex() {
        return this.mOrderingIndex;
    }

    public String getFieldOriginCountry() {
        return this.mOriginCountry;
    }

    public String getFieldParentProductId() {
        return this.mParentProductId;
    }

    public String getFieldPattern() {
        return this.mPattern;
    }

    public Boolean getFieldPostConversionSignalBasedEnforcementAppealEligibility() {
        return this.mPostConversionSignalBasedEnforcementAppealEligibility;
    }

    public String getFieldPrice() {
        return this.mPrice;
    }

    public ProductCatalog getFieldProductCatalog() {
        if (this.mProductCatalog != null) {
            this.mProductCatalog.context = this.getContext();
        }
        return this.mProductCatalog;
    }

    public ProductFeed getFieldProductFeed() {
        if (this.mProductFeed != null) {
            this.mProductFeed.context = this.getContext();
        }
        return this.mProductFeed;
    }

    public ProductGroup getFieldProductGroup() {
        if (this.mProductGroup != null) {
            this.mProductGroup.context = this.getContext();
        }
        return this.mProductGroup;
    }

    public ProductItemLocalInfo getFieldProductLocalInfo() {
        if (this.mProductLocalInfo != null) {
            this.mProductLocalInfo.context = this.getContext();
        }
        return this.mProductLocalInfo;
    }

    public String getFieldProductRelationship() {
        return this.mProductRelationship;
    }

    public String getFieldProductType() {
        return this.mProductType;
    }

    public Long getFieldQuantityToSellOnFacebook() {
        return this.mQuantityToSellOnFacebook;
    }

    public String getFieldRetailerId() {
        return this.mRetailerId;
    }

    public String getFieldRetailerProductGroupId() {
        return this.mRetailerProductGroupId;
    }

    public List<String> getFieldReviewRejectionReasons() {
        return this.mReviewRejectionReasons;
    }

    public EnumReviewStatus getFieldReviewStatus() {
        return this.mReviewStatus;
    }

    public String getFieldRichTextDescription() {
        return this.mRichTextDescription;
    }

    public String getFieldSalePrice() {
        return this.mSalePrice;
    }

    public String getFieldSalePriceEndDate() {
        return this.mSalePriceEndDate;
    }

    public String getFieldSalePriceStartDate() {
        return this.mSalePriceStartDate;
    }

    public EnumShippingWeightUnit getFieldShippingWeightUnit() {
        return this.mShippingWeightUnit;
    }

    public Double getFieldShippingWeightValue() {
        return this.mShippingWeightValue;
    }

    public String getFieldShortDescription() {
        return this.mShortDescription;
    }

    public String getFieldSize() {
        return this.mSize;
    }

    public String getFieldStartDate() {
        return this.mStartDate;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    public List<String> getFieldTags() {
        return this.mTags;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public String getFieldVendorId() {
        return this.mVendorId;
    }

    public EnumVideoFetchStatus getFieldVideoFetchStatus() {
        return this.mVideoFetchStatus;
    }

    public List<ProductItemVideoData> getFieldVideos() {
        return this.mVideos;
    }

    public EnumVisibility getFieldVisibility() {
        return this.mVisibility;
    }

    public String getFieldWaComplianceCategory() {
        return this.mWaComplianceCategory;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductItem copyFrom(ProductItem instance) {
        this.mAdditionalImageCdnUrls = instance.mAdditionalImageCdnUrls;
        this.mAdditionalImageUrls = instance.mAdditionalImageUrls;
        this.mAdditionalVariantAttributes = instance.mAdditionalVariantAttributes;
        this.mAgeGroup = instance.mAgeGroup;
        this.mApplinks = instance.mApplinks;
        this.mAvailability = instance.mAvailability;
        this.mBrand = instance.mBrand;
        this.mBundleItems = instance.mBundleItems;
        this.mBundleRetailerIds = instance.mBundleRetailerIds;
        this.mCapabilitiesDisabledByUser = instance.mCapabilitiesDisabledByUser;
        this.mCapabilityToReviewStatus = instance.mCapabilityToReviewStatus;
        this.mCategory = instance.mCategory;
        this.mCategorySpecificFields = instance.mCategorySpecificFields;
        this.mColor = instance.mColor;
        this.mCommerceInsights = instance.mCommerceInsights;
        this.mCondition = instance.mCondition;
        this.mCurrency = instance.mCurrency;
        this.mCustomData = instance.mCustomData;
        this.mCustomLabel0 = instance.mCustomLabel0;
        this.mCustomLabel1 = instance.mCustomLabel1;
        this.mCustomLabel2 = instance.mCustomLabel2;
        this.mCustomLabel3 = instance.mCustomLabel3;
        this.mCustomLabel4 = instance.mCustomLabel4;
        this.mCustomNumber0 = instance.mCustomNumber0;
        this.mCustomNumber1 = instance.mCustomNumber1;
        this.mCustomNumber2 = instance.mCustomNumber2;
        this.mCustomNumber3 = instance.mCustomNumber3;
        this.mCustomNumber4 = instance.mCustomNumber4;
        this.mDescription = instance.mDescription;
        this.mErrors = instance.mErrors;
        this.mExpirationDate = instance.mExpirationDate;
        this.mFbProductCategory = instance.mFbProductCategory;
        this.mGender = instance.mGender;
        this.mGeneratedBackgroundImages = instance.mGeneratedBackgroundImages;
        this.mGeneratedBackgroundImagesAdUsage = instance.mGeneratedBackgroundImagesAdUsage;
        this.mGtin = instance.mGtin;
        this.mId = instance.mId;
        this.mImageCdnUrls = instance.mImageCdnUrls;
        this.mImageFetchStatus = instance.mImageFetchStatus;
        this.mImageUrl = instance.mImageUrl;
        this.mImages = instance.mImages;
        this.mImporterAddress = instance.mImporterAddress;
        this.mImporterName = instance.mImporterName;
        this.mInvalidationErrors = instance.mInvalidationErrors;
        this.mInventory = instance.mInventory;
        this.mIsBundleHero = instance.mIsBundleHero;
        this.mLiveSpecialPrice = instance.mLiveSpecialPrice;
        this.mManufacturerInfo = instance.mManufacturerInfo;
        this.mManufacturerPartNumber = instance.mManufacturerPartNumber;
        this.mMarkedForProductLaunch = instance.mMarkedForProductLaunch;
        this.mMaterial = instance.mMaterial;
        this.mMobileLink = instance.mMobileLink;
        this.mName = instance.mName;
        this.mOrderingIndex = instance.mOrderingIndex;
        this.mOriginCountry = instance.mOriginCountry;
        this.mParentProductId = instance.mParentProductId;
        this.mPattern = instance.mPattern;
        this.mPostConversionSignalBasedEnforcementAppealEligibility = instance.mPostConversionSignalBasedEnforcementAppealEligibility;
        this.mPrice = instance.mPrice;
        this.mProductCatalog = instance.mProductCatalog;
        this.mProductFeed = instance.mProductFeed;
        this.mProductGroup = instance.mProductGroup;
        this.mProductLocalInfo = instance.mProductLocalInfo;
        this.mProductRelationship = instance.mProductRelationship;
        this.mProductType = instance.mProductType;
        this.mQuantityToSellOnFacebook = instance.mQuantityToSellOnFacebook;
        this.mRetailerId = instance.mRetailerId;
        this.mRetailerProductGroupId = instance.mRetailerProductGroupId;
        this.mReviewRejectionReasons = instance.mReviewRejectionReasons;
        this.mReviewStatus = instance.mReviewStatus;
        this.mRichTextDescription = instance.mRichTextDescription;
        this.mSalePrice = instance.mSalePrice;
        this.mSalePriceEndDate = instance.mSalePriceEndDate;
        this.mSalePriceStartDate = instance.mSalePriceStartDate;
        this.mShippingWeightUnit = instance.mShippingWeightUnit;
        this.mShippingWeightValue = instance.mShippingWeightValue;
        this.mShortDescription = instance.mShortDescription;
        this.mSize = instance.mSize;
        this.mStartDate = instance.mStartDate;
        this.mStatus = instance.mStatus;
        this.mTags = instance.mTags;
        this.mUrl = instance.mUrl;
        this.mVendorId = instance.mVendorId;
        this.mVideoFetchStatus = instance.mVideoFetchStatus;
        this.mVideos = instance.mVideos;
        this.mVisibility = instance.mVisibility;
        this.mWaComplianceCategory = instance.mWaComplianceCategory;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductItem> getParser() {
        return new APIRequest.ResponseParser<ProductItem>(){

            @Override
            public APINodeList<ProductItem> parseResponse(String response, APIContext context, APIRequest<ProductItem> request, String header) throws APIException.MalformedResponseException {
                return ProductItem.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumWaComplianceCategory {
        VALUE_COUNTRY_ORIGIN_EXEMPT("COUNTRY_ORIGIN_EXEMPT"),
        VALUE_DEFAULT("DEFAULT");

        private String value;

        private EnumWaComplianceCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumOriginCountry {
        VALUE_AC("AC"),
        VALUE_AD("AD"),
        VALUE_AE("AE"),
        VALUE_AF("AF"),
        VALUE_AG("AG"),
        VALUE_AI("AI"),
        VALUE_AL("AL"),
        VALUE_AM("AM"),
        VALUE_AN("AN"),
        VALUE_AO("AO"),
        VALUE_AQ("AQ"),
        VALUE_AR("AR"),
        VALUE_AS("AS"),
        VALUE_AT("AT"),
        VALUE_AU("AU"),
        VALUE_AW("AW"),
        VALUE_AX("AX"),
        VALUE_AZ("AZ"),
        VALUE_BA("BA"),
        VALUE_BB("BB"),
        VALUE_BD("BD"),
        VALUE_BE("BE"),
        VALUE_BF("BF"),
        VALUE_BG("BG"),
        VALUE_BH("BH"),
        VALUE_BI("BI"),
        VALUE_BJ("BJ"),
        VALUE_BL("BL"),
        VALUE_BM("BM"),
        VALUE_BN("BN"),
        VALUE_BO("BO"),
        VALUE_BQ("BQ"),
        VALUE_BR("BR"),
        VALUE_BS("BS"),
        VALUE_BT("BT"),
        VALUE_BV("BV"),
        VALUE_BW("BW"),
        VALUE_BY("BY"),
        VALUE_BZ("BZ"),
        VALUE_CA("CA"),
        VALUE_CC("CC"),
        VALUE_CD("CD"),
        VALUE_CF("CF"),
        VALUE_CG("CG"),
        VALUE_CH("CH"),
        VALUE_CI("CI"),
        VALUE_CK("CK"),
        VALUE_CL("CL"),
        VALUE_CM("CM"),
        VALUE_CN("CN"),
        VALUE_CO("CO"),
        VALUE_CR("CR"),
        VALUE_CU("CU"),
        VALUE_CV("CV"),
        VALUE_CW("CW"),
        VALUE_CX("CX"),
        VALUE_CY("CY"),
        VALUE_CZ("CZ"),
        VALUE_DE("DE"),
        VALUE_DJ("DJ"),
        VALUE_DK("DK"),
        VALUE_DM("DM"),
        VALUE_DO("DO"),
        VALUE_DZ("DZ"),
        VALUE_EC("EC"),
        VALUE_EE("EE"),
        VALUE_EG("EG"),
        VALUE_EH("EH"),
        VALUE_ER("ER"),
        VALUE_ES("ES"),
        VALUE_ET("ET"),
        VALUE_FI("FI"),
        VALUE_FJ("FJ"),
        VALUE_FK("FK"),
        VALUE_FM("FM"),
        VALUE_FO("FO"),
        VALUE_FR("FR"),
        VALUE_GA("GA"),
        VALUE_GB("GB"),
        VALUE_GD("GD"),
        VALUE_GE("GE"),
        VALUE_GF("GF"),
        VALUE_GG("GG"),
        VALUE_GH("GH"),
        VALUE_GI("GI"),
        VALUE_GL("GL"),
        VALUE_GM("GM"),
        VALUE_GN("GN"),
        VALUE_GP("GP"),
        VALUE_GQ("GQ"),
        VALUE_GR("GR"),
        VALUE_GS("GS"),
        VALUE_GT("GT"),
        VALUE_GU("GU"),
        VALUE_GW("GW"),
        VALUE_GY("GY"),
        VALUE_HK("HK"),
        VALUE_HM("HM"),
        VALUE_HN("HN"),
        VALUE_HR("HR"),
        VALUE_HT("HT"),
        VALUE_HU("HU"),
        VALUE_ID("ID"),
        VALUE_IE("IE"),
        VALUE_IL("IL"),
        VALUE_IM("IM"),
        VALUE_IN("IN"),
        VALUE_IO("IO"),
        VALUE_IQ("IQ"),
        VALUE_IR("IR"),
        VALUE_IS("IS"),
        VALUE_IT("IT"),
        VALUE_JE("JE"),
        VALUE_JM("JM"),
        VALUE_JO("JO"),
        VALUE_JP("JP"),
        VALUE_KE("KE"),
        VALUE_KG("KG"),
        VALUE_KH("KH"),
        VALUE_KI("KI"),
        VALUE_KM("KM"),
        VALUE_KN("KN"),
        VALUE_KP("KP"),
        VALUE_KR("KR"),
        VALUE_KW("KW"),
        VALUE_KY("KY"),
        VALUE_KZ("KZ"),
        VALUE_LA("LA"),
        VALUE_LB("LB"),
        VALUE_LC("LC"),
        VALUE_LI("LI"),
        VALUE_LK("LK"),
        VALUE_LR("LR"),
        VALUE_LS("LS"),
        VALUE_LT("LT"),
        VALUE_LU("LU"),
        VALUE_LV("LV"),
        VALUE_LY("LY"),
        VALUE_MA("MA"),
        VALUE_MC("MC"),
        VALUE_MD("MD"),
        VALUE_ME("ME"),
        VALUE_MF("MF"),
        VALUE_MG("MG"),
        VALUE_MH("MH"),
        VALUE_MK("MK"),
        VALUE_ML("ML"),
        VALUE_MM("MM"),
        VALUE_MN("MN"),
        VALUE_MO("MO"),
        VALUE_MP("MP"),
        VALUE_MQ("MQ"),
        VALUE_MR("MR"),
        VALUE_MS("MS"),
        VALUE_MT("MT"),
        VALUE_MU("MU"),
        VALUE_MV("MV"),
        VALUE_MW("MW"),
        VALUE_MX("MX"),
        VALUE_MY("MY"),
        VALUE_MZ("MZ"),
        VALUE_NA("NA"),
        VALUE_NC("NC"),
        VALUE_NE("NE"),
        VALUE_NF("NF"),
        VALUE_NG("NG"),
        VALUE_NI("NI"),
        VALUE_NL("NL"),
        VALUE_NO("NO"),
        VALUE_NP("NP"),
        VALUE_NR("NR"),
        VALUE_NU("NU"),
        VALUE_NZ("NZ"),
        VALUE_OM("OM"),
        VALUE_PA("PA"),
        VALUE_PE("PE"),
        VALUE_PF("PF"),
        VALUE_PG("PG"),
        VALUE_PH("PH"),
        VALUE_PK("PK"),
        VALUE_PL("PL"),
        VALUE_PM("PM"),
        VALUE_PN("PN"),
        VALUE_PR("PR"),
        VALUE_PS("PS"),
        VALUE_PT("PT"),
        VALUE_PW("PW"),
        VALUE_PY("PY"),
        VALUE_QA("QA"),
        VALUE_RE("RE"),
        VALUE_RO("RO"),
        VALUE_RS("RS"),
        VALUE_RU("RU"),
        VALUE_RW("RW"),
        VALUE_SA("SA"),
        VALUE_SB("SB"),
        VALUE_SC("SC"),
        VALUE_SD("SD"),
        VALUE_SE("SE"),
        VALUE_SG("SG"),
        VALUE_SH("SH"),
        VALUE_SI("SI"),
        VALUE_SJ("SJ"),
        VALUE_SK("SK"),
        VALUE_SL("SL"),
        VALUE_SM("SM"),
        VALUE_SN("SN"),
        VALUE_SO("SO"),
        VALUE_SR("SR"),
        VALUE_SS("SS"),
        VALUE_ST("ST"),
        VALUE_SV("SV"),
        VALUE_SX("SX"),
        VALUE_SY("SY"),
        VALUE_SZ("SZ"),
        VALUE_TC("TC"),
        VALUE_TD("TD"),
        VALUE_TF("TF"),
        VALUE_TG("TG"),
        VALUE_TH("TH"),
        VALUE_TJ("TJ"),
        VALUE_TK("TK"),
        VALUE_TL("TL"),
        VALUE_TM("TM"),
        VALUE_TN("TN"),
        VALUE_TO("TO"),
        VALUE_TR("TR"),
        VALUE_TT("TT"),
        VALUE_TV("TV"),
        VALUE_TW("TW"),
        VALUE_TZ("TZ"),
        VALUE_UA("UA"),
        VALUE_UG("UG"),
        VALUE_UM("UM"),
        VALUE_US("US"),
        VALUE_UY("UY"),
        VALUE_UZ("UZ"),
        VALUE_VA("VA"),
        VALUE_VC("VC"),
        VALUE_VE("VE"),
        VALUE_VG("VG"),
        VALUE_VI("VI"),
        VALUE_VN("VN"),
        VALUE_VU("VU"),
        VALUE_WF("WF"),
        VALUE_WS("WS"),
        VALUE_XK("XK"),
        VALUE_YE("YE"),
        VALUE_YT("YT"),
        VALUE_ZA("ZA"),
        VALUE_ZM("ZM"),
        VALUE_ZW("ZW");

        private String value;

        private EnumOriginCountry(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumMarkedForProductLaunch {
        VALUE_DEFAULT("default"),
        VALUE_MARKED("marked"),
        VALUE_NOT_MARKED("not_marked");

        private String value;

        private EnumMarkedForProductLaunch(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumErrorType {
        VALUE_ADDRESS_BLOCKLISTED_IN_MARKET("ADDRESS_BLOCKLISTED_IN_MARKET"),
        VALUE_AGGREGATED_LOCALIZATION_ISSUES("AGGREGATED_LOCALIZATION_ISSUES"),
        VALUE_APP_HAS_NO_AEM_SETUP("APP_HAS_NO_AEM_SETUP"),
        VALUE_AR_DELETED_DUE_TO_UPDATE("AR_DELETED_DUE_TO_UPDATE"),
        VALUE_AR_POLICY_VIOLATED("AR_POLICY_VIOLATED"),
        VALUE_AVAILABLE("AVAILABLE"),
        VALUE_BAD_QUALITY_IMAGE("BAD_QUALITY_IMAGE"),
        VALUE_BIG_CATALOG_WITH_ALL_ITEMS_IN_STOCK("BIG_CATALOG_WITH_ALL_ITEMS_IN_STOCK"),
        VALUE_BIZ_MSG_AI_AGENT_DISABLED_BY_USER("BIZ_MSG_AI_AGENT_DISABLED_BY_USER"),
        VALUE_BIZ_MSG_GEN_AI_POLICY_VIOLATED("BIZ_MSG_GEN_AI_POLICY_VIOLATED"),
        VALUE_CANNOT_EDIT_SUBSCRIPTION_PRODUCTS("CANNOT_EDIT_SUBSCRIPTION_PRODUCTS"),
        VALUE_CATALOG_NOT_CONNECTED_TO_EVENT_SOURCE("CATALOG_NOT_CONNECTED_TO_EVENT_SOURCE"),
        VALUE_CHECKOUT_DISABLED_BY_USER("CHECKOUT_DISABLED_BY_USER"),
        VALUE_COMMERCE_ACCOUNT_LEGAL_ADDRESS_INVALID("COMMERCE_ACCOUNT_LEGAL_ADDRESS_INVALID"),
        VALUE_COMMERCE_ACCOUNT_NOT_LEGALLY_COMPLIANT("COMMERCE_ACCOUNT_NOT_LEGALLY_COMPLIANT"),
        VALUE_CRAWLED_AVAILABILITY_MISMATCH("CRAWLED_AVAILABILITY_MISMATCH"),
        VALUE_DA_DISABLED_BY_USER("DA_DISABLED_BY_USER"),
        VALUE_DA_POLICY_VIOLATION("DA_POLICY_VIOLATION"),
        VALUE_DELETED_ITEM("DELETED_ITEM"),
        VALUE_DIGITAL_GOODS_NOT_AVAILABLE_FOR_CHECKOUT("DIGITAL_GOODS_NOT_AVAILABLE_FOR_CHECKOUT"),
        VALUE_DUPLICATE_IMAGES("DUPLICATE_IMAGES"),
        VALUE_DUPLICATE_TITLE_AND_DESCRIPTION("DUPLICATE_TITLE_AND_DESCRIPTION"),
        VALUE_EMPTY_AVAILABILITY("EMPTY_AVAILABILITY"),
        VALUE_EMPTY_CONDITION("EMPTY_CONDITION"),
        VALUE_EMPTY_DESCRIPTION("EMPTY_DESCRIPTION"),
        VALUE_EMPTY_IMAGE_URL("EMPTY_IMAGE_URL"),
        VALUE_EMPTY_PRICE("EMPTY_PRICE"),
        VALUE_EMPTY_PRODUCT_URL("EMPTY_PRODUCT_URL"),
        VALUE_EMPTY_SELLER_DESCRIPTION("EMPTY_SELLER_DESCRIPTION"),
        VALUE_EMPTY_TITLE("EMPTY_TITLE"),
        VALUE_EXTERNAL_MERCHANT_ID_MISMATCH("EXTERNAL_MERCHANT_ID_MISMATCH"),
        VALUE_GENERIC_INVALID_FIELD("GENERIC_INVALID_FIELD"),
        VALUE_GROUPS_DISABLED_BY_USER("GROUPS_DISABLED_BY_USER"),
        VALUE_HIDDEN_UNTIL_PRODUCT_LAUNCH("HIDDEN_UNTIL_PRODUCT_LAUNCH"),
        VALUE_ILLEGAL_PRODUCT_CATEGORY("ILLEGAL_PRODUCT_CATEGORY"),
        VALUE_IMAGE_FETCH_FAILED("IMAGE_FETCH_FAILED"),
        VALUE_IMAGE_FETCH_FAILED_BAD_GATEWAY("IMAGE_FETCH_FAILED_BAD_GATEWAY"),
        VALUE_IMAGE_FETCH_FAILED_FILE_SIZE_EXCEEDED("IMAGE_FETCH_FAILED_FILE_SIZE_EXCEEDED"),
        VALUE_IMAGE_FETCH_FAILED_FORBIDDEN("IMAGE_FETCH_FAILED_FORBIDDEN"),
        VALUE_IMAGE_FETCH_FAILED_LINK_BROKEN("IMAGE_FETCH_FAILED_LINK_BROKEN"),
        VALUE_IMAGE_FETCH_FAILED_TIMED_OUT("IMAGE_FETCH_FAILED_TIMED_OUT"),
        VALUE_IMAGE_RESOLUTION_LOW("IMAGE_RESOLUTION_LOW"),
        VALUE_INACTIVE_SHOPIFY_PRODUCT("INACTIVE_SHOPIFY_PRODUCT"),
        VALUE_INVALID_COMMERCE_TAX_CATEGORY("INVALID_COMMERCE_TAX_CATEGORY"),
        VALUE_INVALID_CONSOLIDATED_LOCALITY_INFORMATION("INVALID_CONSOLIDATED_LOCALITY_INFORMATION"),
        VALUE_INVALID_CONTENT_ID("INVALID_CONTENT_ID"),
        VALUE_INVALID_DEALER_COMMUNICATION_PARAMETERS("INVALID_DEALER_COMMUNICATION_PARAMETERS"),
        VALUE_INVALID_DMA_CODES("INVALID_DMA_CODES"),
        VALUE_INVALID_FB_PAGE_ID("INVALID_FB_PAGE_ID"),
        VALUE_INVALID_IMAGES("INVALID_IMAGES"),
        VALUE_INVALID_MONETIZER_RETURN_POLICY("INVALID_MONETIZER_RETURN_POLICY"),
        VALUE_INVALID_OFFER_DISCLAIMER_URL("INVALID_OFFER_DISCLAIMER_URL"),
        VALUE_INVALID_OFFER_END_DATE("INVALID_OFFER_END_DATE"),
        VALUE_INVALID_PRE_ORDER_PARAMS("INVALID_PRE_ORDER_PARAMS"),
        VALUE_INVALID_RANGE_FOR_AREA_SIZE("INVALID_RANGE_FOR_AREA_SIZE"),
        VALUE_INVALID_RANGE_FOR_BUILT_UP_AREA_SIZE("INVALID_RANGE_FOR_BUILT_UP_AREA_SIZE"),
        VALUE_INVALID_RANGE_FOR_NUM_OF_BATHS("INVALID_RANGE_FOR_NUM_OF_BATHS"),
        VALUE_INVALID_RANGE_FOR_NUM_OF_BEDS("INVALID_RANGE_FOR_NUM_OF_BEDS"),
        VALUE_INVALID_RANGE_FOR_NUM_OF_ROOMS("INVALID_RANGE_FOR_NUM_OF_ROOMS"),
        VALUE_INVALID_RANGE_FOR_PARKING_SPACES("INVALID_RANGE_FOR_PARKING_SPACES"),
        VALUE_INVALID_SHELTER_PAGE_ID("INVALID_SHELTER_PAGE_ID"),
        VALUE_INVALID_SHIPPING_PROFILE_PARAMS("INVALID_SHIPPING_PROFILE_PARAMS"),
        VALUE_INVALID_SUBSCRIPTION_DISABLE_PARAMS("INVALID_SUBSCRIPTION_DISABLE_PARAMS"),
        VALUE_INVALID_SUBSCRIPTION_ENABLE_PARAMS("INVALID_SUBSCRIPTION_ENABLE_PARAMS"),
        VALUE_INVALID_SUBSCRIPTION_PARAMS("INVALID_SUBSCRIPTION_PARAMS"),
        VALUE_INVALID_TAX_EXTENSION_STATE("INVALID_TAX_EXTENSION_STATE"),
        VALUE_INVALID_VEHICLE_STATE("INVALID_VEHICLE_STATE"),
        VALUE_INVALID_VIRTUAL_TOUR_URL_DOMAIN("INVALID_VIRTUAL_TOUR_URL_DOMAIN"),
        VALUE_INVENTORY_ZERO_AVAILABILITY_IN_STOCK("INVENTORY_ZERO_AVAILABILITY_IN_STOCK"),
        VALUE_IN_ANOTHER_PRODUCT_LAUNCH("IN_ANOTHER_PRODUCT_LAUNCH"),
        VALUE_ITEM_GROUP_NOT_SPECIFIED("ITEM_GROUP_NOT_SPECIFIED"),
        VALUE_ITEM_NOT_SHIPPABLE_FOR_SCA_SHOP("ITEM_NOT_SHIPPABLE_FOR_SCA_SHOP"),
        VALUE_ITEM_OVERRIDE_EMPTY_AVAILABILITY("ITEM_OVERRIDE_EMPTY_AVAILABILITY"),
        VALUE_ITEM_OVERRIDE_EMPTY_PRICE("ITEM_OVERRIDE_EMPTY_PRICE"),
        VALUE_ITEM_OVERRIDE_NOT_VISIBLE("ITEM_OVERRIDE_NOT_VISIBLE"),
        VALUE_ITEM_PRICE_NOT_POSITIVE("ITEM_PRICE_NOT_POSITIVE"),
        VALUE_ITEM_STALE_OUT_OF_STOCK("ITEM_STALE_OUT_OF_STOCK"),
        VALUE_MARKETPLACE_DISABLED_BY_USER("MARKETPLACE_DISABLED_BY_USER"),
        VALUE_MARKETPLACE_PARTNER_AUCTION_NO_BID_CLOSE_TIME("MARKETPLACE_PARTNER_AUCTION_NO_BID_CLOSE_TIME"),
        VALUE_MARKETPLACE_PARTNER_CURRENCY_NOT_VALID("MARKETPLACE_PARTNER_CURRENCY_NOT_VALID"),
        VALUE_MARKETPLACE_PARTNER_DISTRIBUTION_DISABLED("MARKETPLACE_PARTNER_DISTRIBUTION_DISABLED"),
        VALUE_MARKETPLACE_PARTNER_LISTING_COUNTRY_NOT_MATCH_CATALOG("MARKETPLACE_PARTNER_LISTING_COUNTRY_NOT_MATCH_CATALOG"),
        VALUE_MARKETPLACE_PARTNER_LISTING_LIMIT_EXCEEDED("MARKETPLACE_PARTNER_LISTING_LIMIT_EXCEEDED"),
        VALUE_MARKETPLACE_PARTNER_MISSING_LATLONG("MARKETPLACE_PARTNER_MISSING_LATLONG"),
        VALUE_MARKETPLACE_PARTNER_MISSING_SHIPPING_COST("MARKETPLACE_PARTNER_MISSING_SHIPPING_COST"),
        VALUE_MARKETPLACE_PARTNER_NOT_LOCAL_ITEM("MARKETPLACE_PARTNER_NOT_LOCAL_ITEM"),
        VALUE_MARKETPLACE_PARTNER_NOT_SHIPPED_ITEM("MARKETPLACE_PARTNER_NOT_SHIPPED_ITEM"),
        VALUE_MARKETPLACE_PARTNER_POLICY_VIOLATION("MARKETPLACE_PARTNER_POLICY_VIOLATION"),
        VALUE_MARKETPLACE_PARTNER_RULE_LISTING_LIMIT_EXCEEDED("MARKETPLACE_PARTNER_RULE_LISTING_LIMIT_EXCEEDED"),
        VALUE_MARKETPLACE_PARTNER_SELLER_BANNED("MARKETPLACE_PARTNER_SELLER_BANNED"),
        VALUE_MARKETPLACE_PARTNER_SELLER_NOT_VALID("MARKETPLACE_PARTNER_SELLER_NOT_VALID"),
        VALUE_MINI_SHOPS_DISABLED_BY_USER("MINI_SHOPS_DISABLED_BY_USER"),
        VALUE_MISSING_CHECKOUT("MISSING_CHECKOUT"),
        VALUE_MISSING_CHECKOUT_CURRENCY("MISSING_CHECKOUT_CURRENCY"),
        VALUE_MISSING_COLOR("MISSING_COLOR"),
        VALUE_MISSING_COUNTRY_OVERRIDE_IN_SHIPPING_PROFILE("MISSING_COUNTRY_OVERRIDE_IN_SHIPPING_PROFILE"),
        VALUE_MISSING_EVENT("MISSING_EVENT"),
        VALUE_MISSING_INDIA_COMPLIANCE_FIELDS("MISSING_INDIA_COMPLIANCE_FIELDS"),
        VALUE_MISSING_SHIPPING_PROFILE("MISSING_SHIPPING_PROFILE"),
        VALUE_MISSING_SIZE("MISSING_SIZE"),
        VALUE_MISSING_TAX_CATEGORY("MISSING_TAX_CATEGORY"),
        VALUE_NEGATIVE_COMMUNITY_FEEDBACK("NEGATIVE_COMMUNITY_FEEDBACK"),
        VALUE_NEGATIVE_PRICE("NEGATIVE_PRICE"),
        VALUE_NOT_ENOUGH_IMAGES("NOT_ENOUGH_IMAGES"),
        VALUE_NOT_ENOUGH_UNIQUE_PRODUCTS("NOT_ENOUGH_UNIQUE_PRODUCTS"),
        VALUE_NO_CONTENT_ID("NO_CONTENT_ID"),
        VALUE_OVERLAY_DISCLAIMER_EXCEEDED_MAX_LENGTH("OVERLAY_DISCLAIMER_EXCEEDED_MAX_LENGTH"),
        VALUE_PART_OF_PRODUCT_LAUNCH("PART_OF_PRODUCT_LAUNCH"),
        VALUE_PASSING_MULTIPLE_CONTENT_IDS("PASSING_MULTIPLE_CONTENT_IDS"),
        VALUE_PRODUCT_DOMINANT_CURRENCY_MISMATCH("PRODUCT_DOMINANT_CURRENCY_MISMATCH"),
        VALUE_PRODUCT_EXPIRED("PRODUCT_EXPIRED"),
        VALUE_PRODUCT_ITEM_HIDDEN_FROM_ALL_SHOPS("PRODUCT_ITEM_HIDDEN_FROM_ALL_SHOPS"),
        VALUE_PRODUCT_ITEM_INVALID_PARTNER_TOKENS("PRODUCT_ITEM_INVALID_PARTNER_TOKENS"),
        VALUE_PRODUCT_ITEM_NOT_INCLUDED_IN_ANY_SHOP("PRODUCT_ITEM_NOT_INCLUDED_IN_ANY_SHOP"),
        VALUE_PRODUCT_ITEM_NOT_VISIBLE("PRODUCT_ITEM_NOT_VISIBLE"),
        VALUE_PRODUCT_NOT_APPROVED("PRODUCT_NOT_APPROVED"),
        VALUE_PRODUCT_NOT_DOMINANT_CURRENCY("PRODUCT_NOT_DOMINANT_CURRENCY"),
        VALUE_PRODUCT_OUT_OF_STOCK("PRODUCT_OUT_OF_STOCK"),
        VALUE_PRODUCT_URL_EQUALS_DOMAIN("PRODUCT_URL_EQUALS_DOMAIN"),
        VALUE_PROPERTY_PRICE_CURRENCY_NOT_SUPPORTED("PROPERTY_PRICE_CURRENCY_NOT_SUPPORTED"),
        VALUE_PROPERTY_PRICE_TOO_HIGH("PROPERTY_PRICE_TOO_HIGH"),
        VALUE_PROPERTY_PRICE_TOO_LOW("PROPERTY_PRICE_TOO_LOW"),
        VALUE_PROPERTY_UNIT_PRICE_CURRENCY_MISMATCH_ITEM_PRICE_CURRENCY("PROPERTY_UNIT_PRICE_CURRENCY_MISMATCH_ITEM_PRICE_CURRENCY"),
        VALUE_PROPERTY_VALUE_CONTAINS_HTML_TAGS("PROPERTY_VALUE_CONTAINS_HTML_TAGS"),
        VALUE_PROPERTY_VALUE_DESCRIPTION_CONTAINS_OFF_PLATFORM_LINK("PROPERTY_VALUE_DESCRIPTION_CONTAINS_OFF_PLATFORM_LINK"),
        VALUE_PROPERTY_VALUE_FORMAT("PROPERTY_VALUE_FORMAT"),
        VALUE_PROPERTY_VALUE_MISSING("PROPERTY_VALUE_MISSING"),
        VALUE_PROPERTY_VALUE_MISSING_WARNING("PROPERTY_VALUE_MISSING_WARNING"),
        VALUE_PROPERTY_VALUE_NON_POSITIVE("PROPERTY_VALUE_NON_POSITIVE"),
        VALUE_PROPERTY_VALUE_STRING_EXCEEDS_LENGTH("PROPERTY_VALUE_STRING_EXCEEDS_LENGTH"),
        VALUE_PROPERTY_VALUE_STRING_TOO_SHORT("PROPERTY_VALUE_STRING_TOO_SHORT"),
        VALUE_PROPERTY_VALUE_UPPERCASE("PROPERTY_VALUE_UPPERCASE"),
        VALUE_PROPERTY_VALUE_UPPERCASE_WARNING("PROPERTY_VALUE_UPPERCASE_WARNING"),
        VALUE_PURCHASE_RATE_BELOW_ADDTOCART("PURCHASE_RATE_BELOW_ADDTOCART"),
        VALUE_PURCHASE_RATE_BELOW_VIEWCONTENT("PURCHASE_RATE_BELOW_VIEWCONTENT"),
        VALUE_QUALITY_DUPLICATED_DESCRIPTION("QUALITY_DUPLICATED_DESCRIPTION"),
        VALUE_QUALITY_ITEM_LINK_BROKEN("QUALITY_ITEM_LINK_BROKEN"),
        VALUE_QUALITY_ITEM_LINK_REDIRECTING("QUALITY_ITEM_LINK_REDIRECTING"),
        VALUE_RETAILER_ID_NOT_PROVIDED("RETAILER_ID_NOT_PROVIDED"),
        VALUE_RETAILER_ID_USED_BY_GROUP("RETAILER_ID_USED_BY_GROUP"),
        VALUE_SHOPIFY_INVALID_RETAILER_ID("SHOPIFY_INVALID_RETAILER_ID"),
        VALUE_SHOPIFY_ITEM_MISSING_SHIPPING_PROFILE("SHOPIFY_ITEM_MISSING_SHIPPING_PROFILE"),
        VALUE_SHOPS_POLICY_VIOLATION("SHOPS_POLICY_VIOLATION"),
        VALUE_SUBSCRIPTION_INFO_NOT_ENABLED_FOR_FEED("SUBSCRIPTION_INFO_NOT_ENABLED_FOR_FEED"),
        VALUE_TAX_CATEGORY_NOT_SUPPORTED_IN_UK("TAX_CATEGORY_NOT_SUPPORTED_IN_UK"),
        VALUE_UNIQUE_PRODUCT_IDENTIFIER_MISSING("UNIQUE_PRODUCT_IDENTIFIER_MISSING"),
        VALUE_UNMATCHED_EVENTS("UNMATCHED_EVENTS"),
        VALUE_UNSUPPORTED_PRODUCT_CATEGORY("UNSUPPORTED_PRODUCT_CATEGORY"),
        VALUE_VARIANT_ATTRIBUTE_ISSUE("VARIANT_ATTRIBUTE_ISSUE"),
        VALUE_VIDEO_FETCH_FAILED("VIDEO_FETCH_FAILED"),
        VALUE_VIDEO_FETCH_FAILED_BAD_GATEWAY("VIDEO_FETCH_FAILED_BAD_GATEWAY"),
        VALUE_VIDEO_FETCH_FAILED_FILE_SIZE_EXCEEDED("VIDEO_FETCH_FAILED_FILE_SIZE_EXCEEDED"),
        VALUE_VIDEO_FETCH_FAILED_FORBIDDEN("VIDEO_FETCH_FAILED_FORBIDDEN"),
        VALUE_VIDEO_FETCH_FAILED_LINK_BROKEN("VIDEO_FETCH_FAILED_LINK_BROKEN"),
        VALUE_VIDEO_FETCH_FAILED_TIMED_OUT("VIDEO_FETCH_FAILED_TIMED_OUT"),
        VALUE_VIDEO_ISSUE_GENERIC("VIDEO_ISSUE_GENERIC"),
        VALUE_VIDEO_NOT_DOWNLOADABLE("VIDEO_NOT_DOWNLOADABLE"),
        VALUE_WHATSAPP_DISABLED_BY_USER("WHATSAPP_DISABLED_BY_USER"),
        VALUE_WHATSAPP_MARKETING_MESSAGE_DISABLED_BY_USER("WHATSAPP_MARKETING_MESSAGE_DISABLED_BY_USER"),
        VALUE_WHATSAPP_MARKETING_MESSAGE_POLICY_VIOLATION("WHATSAPP_MARKETING_MESSAGE_POLICY_VIOLATION"),
        VALUE_WHATSAPP_POLICY_VIOLATION("WHATSAPP_POLICY_VIOLATION");

        private String value;

        private EnumErrorType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumErrorPriority {
        VALUE_HIGH("HIGH"),
        VALUE_LOW("LOW"),
        VALUE_MEDIUM("MEDIUM");

        private String value;

        private EnumErrorPriority(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumCommerceTaxCategory {
        VALUE_FB_ANIMAL("FB_ANIMAL"),
        VALUE_FB_ANIMAL_SUPP("FB_ANIMAL_SUPP"),
        VALUE_FB_APRL("FB_APRL"),
        VALUE_FB_APRL_ACCESSORIES("FB_APRL_ACCESSORIES"),
        VALUE_FB_APRL_ATHL_UNIF("FB_APRL_ATHL_UNIF"),
        VALUE_FB_APRL_CASES("FB_APRL_CASES"),
        VALUE_FB_APRL_CLOTHING("FB_APRL_CLOTHING"),
        VALUE_FB_APRL_COSTUME("FB_APRL_COSTUME"),
        VALUE_FB_APRL_CSTM("FB_APRL_CSTM"),
        VALUE_FB_APRL_FORMAL("FB_APRL_FORMAL"),
        VALUE_FB_APRL_HANDBAG("FB_APRL_HANDBAG"),
        VALUE_FB_APRL_JEWELRY("FB_APRL_JEWELRY"),
        VALUE_FB_APRL_SHOE("FB_APRL_SHOE"),
        VALUE_FB_APRL_SHOE_ACC("FB_APRL_SHOE_ACC"),
        VALUE_FB_APRL_SWIM("FB_APRL_SWIM"),
        VALUE_FB_APRL_SWIM_CHIL("FB_APRL_SWIM_CHIL"),
        VALUE_FB_APRL_SWIM_CVR("FB_APRL_SWIM_CVR"),
        VALUE_FB_ARTS("FB_ARTS"),
        VALUE_FB_ARTS_HOBBY("FB_ARTS_HOBBY"),
        VALUE_FB_ARTS_PARTY("FB_ARTS_PARTY"),
        VALUE_FB_ARTS_PARTY_GIFT_CARD("FB_ARTS_PARTY_GIFT_CARD"),
        VALUE_FB_ARTS_TICKET("FB_ARTS_TICKET"),
        VALUE_FB_BABY("FB_BABY"),
        VALUE_FB_BABY_BATH("FB_BABY_BATH"),
        VALUE_FB_BABY_BLANKET("FB_BABY_BLANKET"),
        VALUE_FB_BABY_DIAPER("FB_BABY_DIAPER"),
        VALUE_FB_BABY_GIFT_SET("FB_BABY_GIFT_SET"),
        VALUE_FB_BABY_HEALTH("FB_BABY_HEALTH"),
        VALUE_FB_BABY_NURSING("FB_BABY_NURSING"),
        VALUE_FB_BABY_POTTY_TRN("FB_BABY_POTTY_TRN"),
        VALUE_FB_BABY_SAFE("FB_BABY_SAFE"),
        VALUE_FB_BABY_TOYS("FB_BABY_TOYS"),
        VALUE_FB_BABY_TRANSPORT("FB_BABY_TRANSPORT"),
        VALUE_FB_BABY_TRANSPORT_ACC("FB_BABY_TRANSPORT_ACC"),
        VALUE_FB_BAGS("FB_BAGS"),
        VALUE_FB_BAGS_BKPK("FB_BAGS_BKPK"),
        VALUE_FB_BAGS_BOXES("FB_BAGS_BOXES"),
        VALUE_FB_BAGS_BRFCS("FB_BAGS_BRFCS"),
        VALUE_FB_BAGS_CSMT_BAG("FB_BAGS_CSMT_BAG"),
        VALUE_FB_BAGS_DFFL("FB_BAGS_DFFL"),
        VALUE_FB_BAGS_DIPR("FB_BAGS_DIPR"),
        VALUE_FB_BAGS_FNNY("FB_BAGS_FNNY"),
        VALUE_FB_BAGS_GRMT("FB_BAGS_GRMT"),
        VALUE_FB_BAGS_LUGG("FB_BAGS_LUGG"),
        VALUE_FB_BAGS_LUG_ACC("FB_BAGS_LUG_ACC"),
        VALUE_FB_BAGS_MSGR("FB_BAGS_MSGR"),
        VALUE_FB_BAGS_TOTE("FB_BAGS_TOTE"),
        VALUE_FB_BAGS_TRN_CAS("FB_BAGS_TRN_CAS"),
        VALUE_FB_BLDG("FB_BLDG"),
        VALUE_FB_BLDG_ACC("FB_BLDG_ACC"),
        VALUE_FB_BLDG_CNSMB("FB_BLDG_CNSMB"),
        VALUE_FB_BLDG_FENCE("FB_BLDG_FENCE"),
        VALUE_FB_BLDG_FUEL_TNK("FB_BLDG_FUEL_TNK"),
        VALUE_FB_BLDG_HT_VNT("FB_BLDG_HT_VNT"),
        VALUE_FB_BLDG_LOCK("FB_BLDG_LOCK"),
        VALUE_FB_BLDG_MATRL("FB_BLDG_MATRL"),
        VALUE_FB_BLDG_PLMB("FB_BLDG_PLMB"),
        VALUE_FB_BLDG_PUMP("FB_BLDG_PUMP"),
        VALUE_FB_BLDG_PWRS("FB_BLDG_PWRS"),
        VALUE_FB_BLDG_STR_TANK("FB_BLDG_STR_TANK"),
        VALUE_FB_BLDG_S_ENG("FB_BLDG_S_ENG"),
        VALUE_FB_BLDG_TL_ACC("FB_BLDG_TL_ACC"),
        VALUE_FB_BLDG_TOOL("FB_BLDG_TOOL"),
        VALUE_FB_BUSIND("FB_BUSIND"),
        VALUE_FB_BUSIND_ADVERTISING("FB_BUSIND_ADVERTISING"),
        VALUE_FB_BUSIND_AGRICULTURE("FB_BUSIND_AGRICULTURE"),
        VALUE_FB_BUSIND_AUTOMATION("FB_BUSIND_AUTOMATION"),
        VALUE_FB_BUSIND_HEAVY_MACH("FB_BUSIND_HEAVY_MACH"),
        VALUE_FB_BUSIND_LAB("FB_BUSIND_LAB"),
        VALUE_FB_BUSIND_MEDICAL("FB_BUSIND_MEDICAL"),
        VALUE_FB_BUSIND_RETAIL("FB_BUSIND_RETAIL"),
        VALUE_FB_BUSIND_SANITARY_CT("FB_BUSIND_SANITARY_CT"),
        VALUE_FB_BUSIND_SIGN("FB_BUSIND_SIGN"),
        VALUE_FB_BUSIND_STORAGE("FB_BUSIND_STORAGE"),
        VALUE_FB_BUSIND_STORAGE_ACC("FB_BUSIND_STORAGE_ACC"),
        VALUE_FB_BUSIND_WORK_GEAR("FB_BUSIND_WORK_GEAR"),
        VALUE_FB_CAMERA_ACC("FB_CAMERA_ACC"),
        VALUE_FB_CAMERA_CAMERA("FB_CAMERA_CAMERA"),
        VALUE_FB_CAMERA_OPTIC("FB_CAMERA_OPTIC"),
        VALUE_FB_CAMERA_OPTICS("FB_CAMERA_OPTICS"),
        VALUE_FB_CAMERA_PHOTO("FB_CAMERA_PHOTO"),
        VALUE_FB_ELEC("FB_ELEC"),
        VALUE_FB_ELEC_ACC("FB_ELEC_ACC"),
        VALUE_FB_ELEC_ARCDADE("FB_ELEC_ARCDADE"),
        VALUE_FB_ELEC_AUDIO("FB_ELEC_AUDIO"),
        VALUE_FB_ELEC_CIRCUIT("FB_ELEC_CIRCUIT"),
        VALUE_FB_ELEC_COMM("FB_ELEC_COMM"),
        VALUE_FB_ELEC_COMPUTER("FB_ELEC_COMPUTER"),
        VALUE_FB_ELEC_GPS_ACC("FB_ELEC_GPS_ACC"),
        VALUE_FB_ELEC_GPS_NAV("FB_ELEC_GPS_NAV"),
        VALUE_FB_ELEC_GPS_TRK("FB_ELEC_GPS_TRK"),
        VALUE_FB_ELEC_MARINE("FB_ELEC_MARINE"),
        VALUE_FB_ELEC_NETWORK("FB_ELEC_NETWORK"),
        VALUE_FB_ELEC_PART("FB_ELEC_PART"),
        VALUE_FB_ELEC_PRINT("FB_ELEC_PRINT"),
        VALUE_FB_ELEC_RADAR("FB_ELEC_RADAR"),
        VALUE_FB_ELEC_SFTWR("FB_ELEC_SFTWR"),
        VALUE_FB_ELEC_SPEED_RDR("FB_ELEC_SPEED_RDR"),
        VALUE_FB_ELEC_TELEVISION("FB_ELEC_TELEVISION"),
        VALUE_FB_ELEC_TOLL("FB_ELEC_TOLL"),
        VALUE_FB_ELEC_VIDEO("FB_ELEC_VIDEO"),
        VALUE_FB_ELEC_VID_GM_ACC("FB_ELEC_VID_GM_ACC"),
        VALUE_FB_ELEC_VID_GM_CNSL("FB_ELEC_VID_GM_CNSL"),
        VALUE_FB_FOOD("FB_FOOD"),
        VALUE_FB_FURN("FB_FURN"),
        VALUE_FB_FURN_BABY("FB_FURN_BABY"),
        VALUE_FB_FURN_BENCH("FB_FURN_BENCH"),
        VALUE_FB_FURN_CART("FB_FURN_CART"),
        VALUE_FB_FURN_CHAIR("FB_FURN_CHAIR"),
        VALUE_FB_FURN_CHAIR_ACC("FB_FURN_CHAIR_ACC"),
        VALUE_FB_FURN_DIVIDE("FB_FURN_DIVIDE"),
        VALUE_FB_FURN_DIVIDE_ACC("FB_FURN_DIVIDE_ACC"),
        VALUE_FB_FURN_ENT_CTR("FB_FURN_ENT_CTR"),
        VALUE_FB_FURN_FUTN("FB_FURN_FUTN"),
        VALUE_FB_FURN_FUTN_PAD("FB_FURN_FUTN_PAD"),
        VALUE_FB_FURN_OFFICE("FB_FURN_OFFICE"),
        VALUE_FB_FURN_OFFICE_ACC("FB_FURN_OFFICE_ACC"),
        VALUE_FB_FURN_OTTO("FB_FURN_OTTO"),
        VALUE_FB_FURN_OUTDOOR("FB_FURN_OUTDOOR"),
        VALUE_FB_FURN_OUTDOOR_ACC("FB_FURN_OUTDOOR_ACC"),
        VALUE_FB_FURN_SETS("FB_FURN_SETS"),
        VALUE_FB_FURN_SHELVE_ACC("FB_FURN_SHELVE_ACC"),
        VALUE_FB_FURN_SHLF("FB_FURN_SHLF"),
        VALUE_FB_FURN_SOFA("FB_FURN_SOFA"),
        VALUE_FB_FURN_SOFA_ACC("FB_FURN_SOFA_ACC"),
        VALUE_FB_FURN_STORAGE("FB_FURN_STORAGE"),
        VALUE_FB_FURN_TABL("FB_FURN_TABL"),
        VALUE_FB_FURN_TABL_ACC("FB_FURN_TABL_ACC"),
        VALUE_FB_GENERIC_TAXABLE("FB_GENERIC_TAXABLE"),
        VALUE_FB_HLTH("FB_HLTH"),
        VALUE_FB_HLTH_HLTH("FB_HLTH_HLTH"),
        VALUE_FB_HLTH_JWL_CR("FB_HLTH_JWL_CR"),
        VALUE_FB_HLTH_LILP_BLM("FB_HLTH_LILP_BLM"),
        VALUE_FB_HLTH_LTN_SPF("FB_HLTH_LTN_SPF"),
        VALUE_FB_HLTH_PRSL_CR("FB_HLTH_PRSL_CR"),
        VALUE_FB_HLTH_SKN_CR("FB_HLTH_SKN_CR"),
        VALUE_FB_HMGN("FB_HMGN"),
        VALUE_FB_HMGN_BATH("FB_HMGN_BATH"),
        VALUE_FB_HMGN_DCOR("FB_HMGN_DCOR"),
        VALUE_FB_HMGN_EMGY("FB_HMGN_EMGY"),
        VALUE_FB_HMGN_FPLC("FB_HMGN_FPLC"),
        VALUE_FB_HMGN_FPLC_ACC("FB_HMGN_FPLC_ACC"),
        VALUE_FB_HMGN_GS_SFT("FB_HMGN_GS_SFT"),
        VALUE_FB_HMGN_HS_ACC("FB_HMGN_HS_ACC"),
        VALUE_FB_HMGN_HS_APP("FB_HMGN_HS_APP"),
        VALUE_FB_HMGN_HS_SPL("FB_HMGN_HS_SPL"),
        VALUE_FB_HMGN_KTCN("FB_HMGN_KTCN"),
        VALUE_FB_HMGN_LAWN("FB_HMGN_LAWN"),
        VALUE_FB_HMGN_LGHT("FB_HMGN_LGHT"),
        VALUE_FB_HMGN_LINN("FB_HMGN_LINN"),
        VALUE_FB_HMGN_LT_ACC("FB_HMGN_LT_ACC"),
        VALUE_FB_HMGN_OTDR("FB_HMGN_OTDR"),
        VALUE_FB_HMGN_POOL("FB_HMGN_POOL"),
        VALUE_FB_HMGN_SCTY("FB_HMGN_SCTY"),
        VALUE_FB_HMGN_SMK_ACC("FB_HMGN_SMK_ACC"),
        VALUE_FB_HMGN_UMBR("FB_HMGN_UMBR"),
        VALUE_FB_HMGN_UMBR_ACC("FB_HMGN_UMBR_ACC"),
        VALUE_FB_MDIA("FB_MDIA"),
        VALUE_FB_MDIA_BOOK("FB_MDIA_BOOK"),
        VALUE_FB_MDIA_DVDS("FB_MDIA_DVDS"),
        VALUE_FB_MDIA_MAG("FB_MDIA_MAG"),
        VALUE_FB_MDIA_MANL("FB_MDIA_MANL"),
        VALUE_FB_MDIA_MUSC("FB_MDIA_MUSC"),
        VALUE_FB_MDIA_PRJ_PLN("FB_MDIA_PRJ_PLN"),
        VALUE_FB_MDIA_SHT_MUS("FB_MDIA_SHT_MUS"),
        VALUE_FB_OFFC("FB_OFFC"),
        VALUE_FB_OFFC_BKAC("FB_OFFC_BKAC"),
        VALUE_FB_OFFC_CRTS("FB_OFFC_CRTS"),
        VALUE_FB_OFFC_DSKP("FB_OFFC_DSKP"),
        VALUE_FB_OFFC_EQIP("FB_OFFC_EQIP"),
        VALUE_FB_OFFC_FLNG("FB_OFFC_FLNG"),
        VALUE_FB_OFFC_GNRL("FB_OFFC_GNRL"),
        VALUE_FB_OFFC_INSTM("FB_OFFC_INSTM"),
        VALUE_FB_OFFC_LP_DSK("FB_OFFC_LP_DSK"),
        VALUE_FB_OFFC_MATS("FB_OFFC_MATS"),
        VALUE_FB_OFFC_NM_PLT("FB_OFFC_NM_PLT"),
        VALUE_FB_OFFC_PPR_HNDL("FB_OFFC_PPR_HNDL"),
        VALUE_FB_OFFC_PRSNT_SPL("FB_OFFC_PRSNT_SPL"),
        VALUE_FB_OFFC_SEALR("FB_OFFC_SEALR"),
        VALUE_FB_OFFC_SHIP_SPL("FB_OFFC_SHIP_SPL"),
        VALUE_FB_RLGN("FB_RLGN"),
        VALUE_FB_RLGN_CMNY("FB_RLGN_CMNY"),
        VALUE_FB_RLGN_ITEM("FB_RLGN_ITEM"),
        VALUE_FB_RLGN_WEDD("FB_RLGN_WEDD"),
        VALUE_FB_SFTWR("FB_SFTWR"),
        VALUE_FB_SFWR_CMPTR("FB_SFWR_CMPTR"),
        VALUE_FB_SFWR_DGTL_GD("FB_SFWR_DGTL_GD"),
        VALUE_FB_SFWR_GAME("FB_SFWR_GAME"),
        VALUE_FB_SHIPPING("FB_SHIPPING"),
        VALUE_FB_SPOR("FB_SPOR"),
        VALUE_FB_SPORT_ATHL("FB_SPORT_ATHL"),
        VALUE_FB_SPORT_ATHL_CLTH("FB_SPORT_ATHL_CLTH"),
        VALUE_FB_SPORT_ATHL_SHOE("FB_SPORT_ATHL_SHOE"),
        VALUE_FB_SPORT_ATHL_SPRT("FB_SPORT_ATHL_SPRT"),
        VALUE_FB_SPORT_EXRCS("FB_SPORT_EXRCS"),
        VALUE_FB_SPORT_INDR_GM("FB_SPORT_INDR_GM"),
        VALUE_FB_SPORT_OTDR_GM("FB_SPORT_OTDR_GM"),
        VALUE_FB_TOYS("FB_TOYS"),
        VALUE_FB_TOYS_EQIP("FB_TOYS_EQIP"),
        VALUE_FB_TOYS_GAME("FB_TOYS_GAME"),
        VALUE_FB_TOYS_PZZL("FB_TOYS_PZZL"),
        VALUE_FB_TOYS_TMRS("FB_TOYS_TMRS"),
        VALUE_FB_TOYS_TOYS("FB_TOYS_TOYS"),
        VALUE_FB_VEHI("FB_VEHI"),
        VALUE_FB_VEHI_PART("FB_VEHI_PART");

        private String value;

        private EnumCommerceTaxCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumVisibility {
        VALUE_PUBLISHED("published"),
        VALUE_STAGING("staging");

        private String value;

        private EnumVisibility(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumVideoFetchStatus {
        VALUE_DIRECT_UPLOAD("DIRECT_UPLOAD"),
        VALUE_FETCHED("FETCHED"),
        VALUE_FETCH_FAILED("FETCH_FAILED"),
        VALUE_NO_STATUS("NO_STATUS"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PARTIAL_FETCH("PARTIAL_FETCH");

        private String value;

        private EnumVideoFetchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumStatus {
        VALUE_PUBLISHED("PUBLISHED"),
        VALUE_STAGING("STAGING");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumShippingWeightUnit {
        VALUE_G("g"),
        VALUE_KG("kg"),
        VALUE_LB("lb"),
        VALUE_OZ("oz");

        private String value;

        private EnumShippingWeightUnit(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumReviewStatus {
        VALUE_APPROVED("approved"),
        VALUE_OUTDATED("outdated"),
        VALUE_PENDING("pending"),
        VALUE_REJECTED("rejected");

        private String value;

        private EnumReviewStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumImageFetchStatus {
        VALUE_DIRECT_UPLOAD("DIRECT_UPLOAD"),
        VALUE_FETCHED("FETCHED"),
        VALUE_FETCH_FAILED("FETCH_FAILED"),
        VALUE_NO_STATUS("NO_STATUS"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PARTIAL_FETCH("PARTIAL_FETCH");

        private String value;

        private EnumImageFetchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumGender {
        VALUE_FEMALE("female"),
        VALUE_MALE("male"),
        VALUE_UNISEX("unisex");

        private String value;

        private EnumGender(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumCondition {
        VALUE_CPO("cpo"),
        VALUE_NEW("new"),
        VALUE_OPEN_BOX_NEW("open_box_new"),
        VALUE_REFURBISHED("refurbished"),
        VALUE_USED("used"),
        VALUE_USED_FAIR("used_fair"),
        VALUE_USED_GOOD("used_good"),
        VALUE_USED_LIKE_NEW("used_like_new");

        private String value;

        private EnumCondition(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumCapabilityToReviewStatus {
        VALUE_APPROVED("APPROVED"),
        VALUE_NO_REVIEW("NO_REVIEW"),
        VALUE_OUTDATED("OUTDATED"),
        VALUE_PENDING("PENDING"),
        VALUE_REJECTED("REJECTED");

        private String value;

        private EnumCapabilityToReviewStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAvailability {
        VALUE_AVAILABLE_FOR_ORDER("available for order"),
        VALUE_DISCONTINUED("discontinued"),
        VALUE_IN_STOCK("in stock"),
        VALUE_MARK_AS_SOLD("mark_as_sold"),
        VALUE_OUT_OF_STOCK("out of stock"),
        VALUE_PENDING("pending"),
        VALUE_PREORDER("preorder");

        private String value;

        private EnumAvailability(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumAgeGroup {
        VALUE_ADULT("adult"),
        VALUE_ALL_AGES("all ages"),
        VALUE_INFANT("infant"),
        VALUE_KIDS("kids"),
        VALUE_NEWBORN("newborn"),
        VALUE_TEEN("teen"),
        VALUE_TODDLER("toddler");

        private String value;

        private EnumAgeGroup(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<ProductItem> {
        ProductItem lastResponse = null;
        public static final String[] PARAMS = new String[]{"additional_image_urls", "additional_variant_attributes", "age_group", "android_app_name", "android_class", "android_package", "android_url", "availability", "brand", "category", "category_specific_fields", "checkout_url", "color", "commerce_tax_category", "condition", "currency", "custom_data", "custom_label_0", "custom_label_1", "custom_label_2", "custom_label_3", "custom_label_4", "custom_number_0", "custom_number_1", "custom_number_2", "custom_number_3", "custom_number_4", "description", "expiration_date", "fb_product_category", "gender", "gtin", "image_url", "importer_address", "importer_name", "inventory", "ios_app_name", "ios_app_store_id", "ios_url", "ipad_app_name", "ipad_app_store_id", "ipad_url", "iphone_app_name", "iphone_app_store_id", "iphone_url", "launch_date", "live_special_price", "manufacturer_info", "manufacturer_part_number", "marked_for_product_launch", "material", "mobile_link", "name", "ordering_index", "origin_country", "pattern", "price", "product_priority_0", "product_priority_1", "product_priority_2", "product_priority_3", "product_priority_4", "product_type", "quantity_to_sell_on_facebook", "retailer_id", "return_policy_days", "rich_text_description", "sale_price", "sale_price_end_date", "sale_price_start_date", "short_description", "size", "start_date", "url", "visibility", "wa_compliance_category", "windows_phone_app_id", "windows_phone_app_name", "windows_phone_url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ProductItem getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductItem parseResponse(String response, String header) throws APIException {
            return ProductItem.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ProductItem execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductItem execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ProductItem> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductItem> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ProductItem>(){

                public ProductItem apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAdditionalImageUrls(List<String> additionalImageUrls) {
            this.setParam("additional_image_urls", additionalImageUrls);
            return this;
        }

        public APIRequestUpdate setAdditionalImageUrls(String additionalImageUrls) {
            this.setParam("additional_image_urls", additionalImageUrls);
            return this;
        }

        public APIRequestUpdate setAdditionalVariantAttributes(Map<String, String> additionalVariantAttributes) {
            this.setParam("additional_variant_attributes", additionalVariantAttributes);
            return this;
        }

        public APIRequestUpdate setAdditionalVariantAttributes(String additionalVariantAttributes) {
            this.setParam("additional_variant_attributes", additionalVariantAttributes);
            return this;
        }

        public APIRequestUpdate setAgeGroup(EnumAgeGroup ageGroup) {
            this.setParam("age_group", (Object)ageGroup);
            return this;
        }

        public APIRequestUpdate setAgeGroup(String ageGroup) {
            this.setParam("age_group", ageGroup);
            return this;
        }

        public APIRequestUpdate setAndroidAppName(String androidAppName) {
            this.setParam("android_app_name", androidAppName);
            return this;
        }

        public APIRequestUpdate setAndroidClass(String androidClass) {
            this.setParam("android_class", androidClass);
            return this;
        }

        public APIRequestUpdate setAndroidPackage(String androidPackage) {
            this.setParam("android_package", androidPackage);
            return this;
        }

        public APIRequestUpdate setAndroidUrl(String androidUrl) {
            this.setParam("android_url", androidUrl);
            return this;
        }

        public APIRequestUpdate setAvailability(EnumAvailability availability) {
            this.setParam("availability", (Object)availability);
            return this;
        }

        public APIRequestUpdate setAvailability(String availability) {
            this.setParam("availability", availability);
            return this;
        }

        public APIRequestUpdate setBrand(String brand) {
            this.setParam("brand", brand);
            return this;
        }

        public APIRequestUpdate setCategory(String category) {
            this.setParam("category", category);
            return this;
        }

        public APIRequestUpdate setCategorySpecificFields(Map<String, String> categorySpecificFields) {
            this.setParam("category_specific_fields", categorySpecificFields);
            return this;
        }

        public APIRequestUpdate setCategorySpecificFields(String categorySpecificFields) {
            this.setParam("category_specific_fields", categorySpecificFields);
            return this;
        }

        public APIRequestUpdate setCheckoutUrl(String checkoutUrl) {
            this.setParam("checkout_url", checkoutUrl);
            return this;
        }

        public APIRequestUpdate setColor(String color) {
            this.setParam("color", color);
            return this;
        }

        public APIRequestUpdate setCommerceTaxCategory(EnumCommerceTaxCategory commerceTaxCategory) {
            this.setParam("commerce_tax_category", (Object)commerceTaxCategory);
            return this;
        }

        public APIRequestUpdate setCommerceTaxCategory(String commerceTaxCategory) {
            this.setParam("commerce_tax_category", commerceTaxCategory);
            return this;
        }

        public APIRequestUpdate setCondition(EnumCondition condition) {
            this.setParam("condition", (Object)condition);
            return this;
        }

        public APIRequestUpdate setCondition(String condition) {
            this.setParam("condition", condition);
            return this;
        }

        public APIRequestUpdate setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestUpdate setCustomData(Map<String, String> customData) {
            this.setParam("custom_data", customData);
            return this;
        }

        public APIRequestUpdate setCustomData(String customData) {
            this.setParam("custom_data", customData);
            return this;
        }

        public APIRequestUpdate setCustomLabel0(String customLabel0) {
            this.setParam("custom_label_0", customLabel0);
            return this;
        }

        public APIRequestUpdate setCustomLabel1(String customLabel1) {
            this.setParam("custom_label_1", customLabel1);
            return this;
        }

        public APIRequestUpdate setCustomLabel2(String customLabel2) {
            this.setParam("custom_label_2", customLabel2);
            return this;
        }

        public APIRequestUpdate setCustomLabel3(String customLabel3) {
            this.setParam("custom_label_3", customLabel3);
            return this;
        }

        public APIRequestUpdate setCustomLabel4(String customLabel4) {
            this.setParam("custom_label_4", customLabel4);
            return this;
        }

        public APIRequestUpdate setCustomNumber0(Long customNumber0) {
            this.setParam("custom_number_0", customNumber0);
            return this;
        }

        public APIRequestUpdate setCustomNumber0(String customNumber0) {
            this.setParam("custom_number_0", customNumber0);
            return this;
        }

        public APIRequestUpdate setCustomNumber1(Long customNumber1) {
            this.setParam("custom_number_1", customNumber1);
            return this;
        }

        public APIRequestUpdate setCustomNumber1(String customNumber1) {
            this.setParam("custom_number_1", customNumber1);
            return this;
        }

        public APIRequestUpdate setCustomNumber2(Long customNumber2) {
            this.setParam("custom_number_2", customNumber2);
            return this;
        }

        public APIRequestUpdate setCustomNumber2(String customNumber2) {
            this.setParam("custom_number_2", customNumber2);
            return this;
        }

        public APIRequestUpdate setCustomNumber3(Long customNumber3) {
            this.setParam("custom_number_3", customNumber3);
            return this;
        }

        public APIRequestUpdate setCustomNumber3(String customNumber3) {
            this.setParam("custom_number_3", customNumber3);
            return this;
        }

        public APIRequestUpdate setCustomNumber4(Long customNumber4) {
            this.setParam("custom_number_4", customNumber4);
            return this;
        }

        public APIRequestUpdate setCustomNumber4(String customNumber4) {
            this.setParam("custom_number_4", customNumber4);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setExpirationDate(String expirationDate) {
            this.setParam("expiration_date", expirationDate);
            return this;
        }

        public APIRequestUpdate setFbProductCategory(String fbProductCategory) {
            this.setParam("fb_product_category", fbProductCategory);
            return this;
        }

        public APIRequestUpdate setGender(EnumGender gender) {
            this.setParam("gender", (Object)gender);
            return this;
        }

        public APIRequestUpdate setGender(String gender) {
            this.setParam("gender", gender);
            return this;
        }

        public APIRequestUpdate setGtin(String gtin) {
            this.setParam("gtin", gtin);
            return this;
        }

        public APIRequestUpdate setImageUrl(String imageUrl) {
            this.setParam("image_url", imageUrl);
            return this;
        }

        public APIRequestUpdate setImporterAddress(Map<String, String> importerAddress) {
            this.setParam("importer_address", importerAddress);
            return this;
        }

        public APIRequestUpdate setImporterAddress(String importerAddress) {
            this.setParam("importer_address", importerAddress);
            return this;
        }

        public APIRequestUpdate setImporterName(String importerName) {
            this.setParam("importer_name", importerName);
            return this;
        }

        public APIRequestUpdate setInventory(Long inventory) {
            this.setParam("inventory", inventory);
            return this;
        }

        public APIRequestUpdate setInventory(String inventory) {
            this.setParam("inventory", inventory);
            return this;
        }

        public APIRequestUpdate setIosAppName(String iosAppName) {
            this.setParam("ios_app_name", iosAppName);
            return this;
        }

        public APIRequestUpdate setIosAppStoreId(Long iosAppStoreId) {
            this.setParam("ios_app_store_id", iosAppStoreId);
            return this;
        }

        public APIRequestUpdate setIosAppStoreId(String iosAppStoreId) {
            this.setParam("ios_app_store_id", iosAppStoreId);
            return this;
        }

        public APIRequestUpdate setIosUrl(String iosUrl) {
            this.setParam("ios_url", iosUrl);
            return this;
        }

        public APIRequestUpdate setIpadAppName(String ipadAppName) {
            this.setParam("ipad_app_name", ipadAppName);
            return this;
        }

        public APIRequestUpdate setIpadAppStoreId(Long ipadAppStoreId) {
            this.setParam("ipad_app_store_id", ipadAppStoreId);
            return this;
        }

        public APIRequestUpdate setIpadAppStoreId(String ipadAppStoreId) {
            this.setParam("ipad_app_store_id", ipadAppStoreId);
            return this;
        }

        public APIRequestUpdate setIpadUrl(String ipadUrl) {
            this.setParam("ipad_url", ipadUrl);
            return this;
        }

        public APIRequestUpdate setIphoneAppName(String iphoneAppName) {
            this.setParam("iphone_app_name", iphoneAppName);
            return this;
        }

        public APIRequestUpdate setIphoneAppStoreId(Long iphoneAppStoreId) {
            this.setParam("iphone_app_store_id", iphoneAppStoreId);
            return this;
        }

        public APIRequestUpdate setIphoneAppStoreId(String iphoneAppStoreId) {
            this.setParam("iphone_app_store_id", iphoneAppStoreId);
            return this;
        }

        public APIRequestUpdate setIphoneUrl(String iphoneUrl) {
            this.setParam("iphone_url", iphoneUrl);
            return this;
        }

        public APIRequestUpdate setLaunchDate(String launchDate) {
            this.setParam("launch_date", launchDate);
            return this;
        }

        public APIRequestUpdate setLiveSpecialPrice(String liveSpecialPrice) {
            this.setParam("live_special_price", liveSpecialPrice);
            return this;
        }

        public APIRequestUpdate setManufacturerInfo(String manufacturerInfo) {
            this.setParam("manufacturer_info", manufacturerInfo);
            return this;
        }

        public APIRequestUpdate setManufacturerPartNumber(String manufacturerPartNumber) {
            this.setParam("manufacturer_part_number", manufacturerPartNumber);
            return this;
        }

        public APIRequestUpdate setMarkedForProductLaunch(EnumMarkedForProductLaunch markedForProductLaunch) {
            this.setParam("marked_for_product_launch", (Object)markedForProductLaunch);
            return this;
        }

        public APIRequestUpdate setMarkedForProductLaunch(String markedForProductLaunch) {
            this.setParam("marked_for_product_launch", markedForProductLaunch);
            return this;
        }

        public APIRequestUpdate setMaterial(String material) {
            this.setParam("material", material);
            return this;
        }

        public APIRequestUpdate setMobileLink(String mobileLink) {
            this.setParam("mobile_link", mobileLink);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setOrderingIndex(Long orderingIndex) {
            this.setParam("ordering_index", orderingIndex);
            return this;
        }

        public APIRequestUpdate setOrderingIndex(String orderingIndex) {
            this.setParam("ordering_index", orderingIndex);
            return this;
        }

        public APIRequestUpdate setOriginCountry(EnumOriginCountry originCountry) {
            this.setParam("origin_country", (Object)originCountry);
            return this;
        }

        public APIRequestUpdate setOriginCountry(String originCountry) {
            this.setParam("origin_country", originCountry);
            return this;
        }

        public APIRequestUpdate setPattern(String pattern) {
            this.setParam("pattern", pattern);
            return this;
        }

        public APIRequestUpdate setPrice(Long price) {
            this.setParam("price", price);
            return this;
        }

        public APIRequestUpdate setPrice(String price) {
            this.setParam("price", price);
            return this;
        }

        public APIRequestUpdate setProductPriority0(Double productPriority0) {
            this.setParam("product_priority_0", productPriority0);
            return this;
        }

        public APIRequestUpdate setProductPriority0(String productPriority0) {
            this.setParam("product_priority_0", productPriority0);
            return this;
        }

        public APIRequestUpdate setProductPriority1(Double productPriority1) {
            this.setParam("product_priority_1", productPriority1);
            return this;
        }

        public APIRequestUpdate setProductPriority1(String productPriority1) {
            this.setParam("product_priority_1", productPriority1);
            return this;
        }

        public APIRequestUpdate setProductPriority2(Double productPriority2) {
            this.setParam("product_priority_2", productPriority2);
            return this;
        }

        public APIRequestUpdate setProductPriority2(String productPriority2) {
            this.setParam("product_priority_2", productPriority2);
            return this;
        }

        public APIRequestUpdate setProductPriority3(Double productPriority3) {
            this.setParam("product_priority_3", productPriority3);
            return this;
        }

        public APIRequestUpdate setProductPriority3(String productPriority3) {
            this.setParam("product_priority_3", productPriority3);
            return this;
        }

        public APIRequestUpdate setProductPriority4(Double productPriority4) {
            this.setParam("product_priority_4", productPriority4);
            return this;
        }

        public APIRequestUpdate setProductPriority4(String productPriority4) {
            this.setParam("product_priority_4", productPriority4);
            return this;
        }

        public APIRequestUpdate setProductType(String productType) {
            this.setParam("product_type", productType);
            return this;
        }

        public APIRequestUpdate setQuantityToSellOnFacebook(Long quantityToSellOnFacebook) {
            this.setParam("quantity_to_sell_on_facebook", quantityToSellOnFacebook);
            return this;
        }

        public APIRequestUpdate setQuantityToSellOnFacebook(String quantityToSellOnFacebook) {
            this.setParam("quantity_to_sell_on_facebook", quantityToSellOnFacebook);
            return this;
        }

        public APIRequestUpdate setRetailerId(String retailerId) {
            this.setParam("retailer_id", retailerId);
            return this;
        }

        public APIRequestUpdate setReturnPolicyDays(Long returnPolicyDays) {
            this.setParam("return_policy_days", returnPolicyDays);
            return this;
        }

        public APIRequestUpdate setReturnPolicyDays(String returnPolicyDays) {
            this.setParam("return_policy_days", returnPolicyDays);
            return this;
        }

        public APIRequestUpdate setRichTextDescription(String richTextDescription) {
            this.setParam("rich_text_description", richTextDescription);
            return this;
        }

        public APIRequestUpdate setSalePrice(Long salePrice) {
            this.setParam("sale_price", salePrice);
            return this;
        }

        public APIRequestUpdate setSalePrice(String salePrice) {
            this.setParam("sale_price", salePrice);
            return this;
        }

        public APIRequestUpdate setSalePriceEndDate(String salePriceEndDate) {
            this.setParam("sale_price_end_date", salePriceEndDate);
            return this;
        }

        public APIRequestUpdate setSalePriceStartDate(String salePriceStartDate) {
            this.setParam("sale_price_start_date", salePriceStartDate);
            return this;
        }

        public APIRequestUpdate setShortDescription(String shortDescription) {
            this.setParam("short_description", shortDescription);
            return this;
        }

        public APIRequestUpdate setSize(String size) {
            this.setParam("size", size);
            return this;
        }

        public APIRequestUpdate setStartDate(String startDate) {
            this.setParam("start_date", startDate);
            return this;
        }

        public APIRequestUpdate setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestUpdate setVisibility(EnumVisibility visibility) {
            this.setParam("visibility", (Object)visibility);
            return this;
        }

        public APIRequestUpdate setVisibility(String visibility) {
            this.setParam("visibility", visibility);
            return this;
        }

        public APIRequestUpdate setWaComplianceCategory(EnumWaComplianceCategory waComplianceCategory) {
            this.setParam("wa_compliance_category", (Object)waComplianceCategory);
            return this;
        }

        public APIRequestUpdate setWaComplianceCategory(String waComplianceCategory) {
            this.setParam("wa_compliance_category", waComplianceCategory);
            return this;
        }

        public APIRequestUpdate setWindowsPhoneAppId(String windowsPhoneAppId) {
            this.setParam("windows_phone_app_id", windowsPhoneAppId);
            return this;
        }

        public APIRequestUpdate setWindowsPhoneAppName(String windowsPhoneAppName) {
            this.setParam("windows_phone_app_name", windowsPhoneAppName);
            return this;
        }

        public APIRequestUpdate setWindowsPhoneUrl(String windowsPhoneUrl) {
            this.setParam("windows_phone_url", windowsPhoneUrl);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<ProductItem> {
        ProductItem lastResponse = null;
        public static final String[] PARAMS = new String[]{"catalog_id", "image_height", "image_width", "override_country", "override_language"};
        public static final String[] FIELDS = new String[]{"additional_image_cdn_urls", "additional_image_urls", "additional_variant_attributes", "age_group", "applinks", "availability", "brand", "bundle_items", "bundle_retailer_ids", "capabilities_disabled_by_user", "capability_to_review_status", "category", "category_specific_fields", "color", "commerce_insights", "condition", "currency", "custom_data", "custom_label_0", "custom_label_1", "custom_label_2", "custom_label_3", "custom_label_4", "custom_number_0", "custom_number_1", "custom_number_2", "custom_number_3", "custom_number_4", "description", "errors", "expiration_date", "fb_product_category", "gender", "generated_background_images", "generated_background_images_ad_usage", "gtin", "id", "image_cdn_urls", "image_fetch_status", "image_url", "images", "importer_address", "importer_name", "invalidation_errors", "inventory", "is_bundle_hero", "live_special_price", "manufacturer_info", "manufacturer_part_number", "marked_for_product_launch", "material", "mobile_link", "name", "ordering_index", "origin_country", "parent_product_id", "pattern", "post_conversion_signal_based_enforcement_appeal_eligibility", "price", "product_catalog", "product_feed", "product_group", "product_local_info", "product_relationship", "product_type", "quantity_to_sell_on_facebook", "retailer_id", "retailer_product_group_id", "review_rejection_reasons", "review_status", "rich_text_description", "sale_price", "sale_price_end_date", "sale_price_start_date", "shipping_weight_unit", "shipping_weight_value", "short_description", "size", "start_date", "status", "tags", "url", "vendor_id", "video_fetch_status", "videos", "visibility", "wa_compliance_category"};

        @Override
        public ProductItem getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductItem parseResponse(String response, String header) throws APIException {
            return ProductItem.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ProductItem execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductItem execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ProductItem> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductItem> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ProductItem>(){

                public ProductItem apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setCatalogId(String catalogId) {
            this.setParam("catalog_id", catalogId);
            return this;
        }

        public APIRequestGet setImageHeight(Long imageHeight) {
            this.setParam("image_height", imageHeight);
            return this;
        }

        public APIRequestGet setImageHeight(String imageHeight) {
            this.setParam("image_height", imageHeight);
            return this;
        }

        public APIRequestGet setImageWidth(Long imageWidth) {
            this.setParam("image_width", imageWidth);
            return this;
        }

        public APIRequestGet setImageWidth(String imageWidth) {
            this.setParam("image_width", imageWidth);
            return this;
        }

        public APIRequestGet setOverrideCountry(String overrideCountry) {
            this.setParam("override_country", overrideCountry);
            return this;
        }

        public APIRequestGet setOverrideLanguage(String overrideLanguage) {
            this.setParam("override_language", overrideLanguage);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdditionalImageCdnUrlsField() {
            return this.requestAdditionalImageCdnUrlsField(true);
        }

        public APIRequestGet requestAdditionalImageCdnUrlsField(boolean value) {
            this.requestField("additional_image_cdn_urls", value);
            return this;
        }

        public APIRequestGet requestAdditionalImageUrlsField() {
            return this.requestAdditionalImageUrlsField(true);
        }

        public APIRequestGet requestAdditionalImageUrlsField(boolean value) {
            this.requestField("additional_image_urls", value);
            return this;
        }

        public APIRequestGet requestAdditionalVariantAttributesField() {
            return this.requestAdditionalVariantAttributesField(true);
        }

        public APIRequestGet requestAdditionalVariantAttributesField(boolean value) {
            this.requestField("additional_variant_attributes", value);
            return this;
        }

        public APIRequestGet requestAgeGroupField() {
            return this.requestAgeGroupField(true);
        }

        public APIRequestGet requestAgeGroupField(boolean value) {
            this.requestField("age_group", value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestAvailabilityField() {
            return this.requestAvailabilityField(true);
        }

        public APIRequestGet requestAvailabilityField(boolean value) {
            this.requestField("availability", value);
            return this;
        }

        public APIRequestGet requestBrandField() {
            return this.requestBrandField(true);
        }

        public APIRequestGet requestBrandField(boolean value) {
            this.requestField("brand", value);
            return this;
        }

        public APIRequestGet requestBundleItemsField() {
            return this.requestBundleItemsField(true);
        }

        public APIRequestGet requestBundleItemsField(boolean value) {
            this.requestField("bundle_items", value);
            return this;
        }

        public APIRequestGet requestBundleRetailerIdsField() {
            return this.requestBundleRetailerIdsField(true);
        }

        public APIRequestGet requestBundleRetailerIdsField(boolean value) {
            this.requestField("bundle_retailer_ids", value);
            return this;
        }

        public APIRequestGet requestCapabilitiesDisabledByUserField() {
            return this.requestCapabilitiesDisabledByUserField(true);
        }

        public APIRequestGet requestCapabilitiesDisabledByUserField(boolean value) {
            this.requestField("capabilities_disabled_by_user", value);
            return this;
        }

        public APIRequestGet requestCapabilityToReviewStatusField() {
            return this.requestCapabilityToReviewStatusField(true);
        }

        public APIRequestGet requestCapabilityToReviewStatusField(boolean value) {
            this.requestField("capability_to_review_status", value);
            return this;
        }

        public APIRequestGet requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGet requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGet requestCategorySpecificFieldsField() {
            return this.requestCategorySpecificFieldsField(true);
        }

        public APIRequestGet requestCategorySpecificFieldsField(boolean value) {
            this.requestField("category_specific_fields", value);
            return this;
        }

        public APIRequestGet requestColorField() {
            return this.requestColorField(true);
        }

        public APIRequestGet requestColorField(boolean value) {
            this.requestField("color", value);
            return this;
        }

        public APIRequestGet requestCommerceInsightsField() {
            return this.requestCommerceInsightsField(true);
        }

        public APIRequestGet requestCommerceInsightsField(boolean value) {
            this.requestField("commerce_insights", value);
            return this;
        }

        public APIRequestGet requestConditionField() {
            return this.requestConditionField(true);
        }

        public APIRequestGet requestConditionField(boolean value) {
            this.requestField("condition", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestCustomDataField() {
            return this.requestCustomDataField(true);
        }

        public APIRequestGet requestCustomDataField(boolean value) {
            this.requestField("custom_data", value);
            return this;
        }

        public APIRequestGet requestCustomLabel0Field() {
            return this.requestCustomLabel0Field(true);
        }

        public APIRequestGet requestCustomLabel0Field(boolean value) {
            this.requestField("custom_label_0", value);
            return this;
        }

        public APIRequestGet requestCustomLabel1Field() {
            return this.requestCustomLabel1Field(true);
        }

        public APIRequestGet requestCustomLabel1Field(boolean value) {
            this.requestField("custom_label_1", value);
            return this;
        }

        public APIRequestGet requestCustomLabel2Field() {
            return this.requestCustomLabel2Field(true);
        }

        public APIRequestGet requestCustomLabel2Field(boolean value) {
            this.requestField("custom_label_2", value);
            return this;
        }

        public APIRequestGet requestCustomLabel3Field() {
            return this.requestCustomLabel3Field(true);
        }

        public APIRequestGet requestCustomLabel3Field(boolean value) {
            this.requestField("custom_label_3", value);
            return this;
        }

        public APIRequestGet requestCustomLabel4Field() {
            return this.requestCustomLabel4Field(true);
        }

        public APIRequestGet requestCustomLabel4Field(boolean value) {
            this.requestField("custom_label_4", value);
            return this;
        }

        public APIRequestGet requestCustomNumber0Field() {
            return this.requestCustomNumber0Field(true);
        }

        public APIRequestGet requestCustomNumber0Field(boolean value) {
            this.requestField("custom_number_0", value);
            return this;
        }

        public APIRequestGet requestCustomNumber1Field() {
            return this.requestCustomNumber1Field(true);
        }

        public APIRequestGet requestCustomNumber1Field(boolean value) {
            this.requestField("custom_number_1", value);
            return this;
        }

        public APIRequestGet requestCustomNumber2Field() {
            return this.requestCustomNumber2Field(true);
        }

        public APIRequestGet requestCustomNumber2Field(boolean value) {
            this.requestField("custom_number_2", value);
            return this;
        }

        public APIRequestGet requestCustomNumber3Field() {
            return this.requestCustomNumber3Field(true);
        }

        public APIRequestGet requestCustomNumber3Field(boolean value) {
            this.requestField("custom_number_3", value);
            return this;
        }

        public APIRequestGet requestCustomNumber4Field() {
            return this.requestCustomNumber4Field(true);
        }

        public APIRequestGet requestCustomNumber4Field(boolean value) {
            this.requestField("custom_number_4", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestErrorsField() {
            return this.requestErrorsField(true);
        }

        public APIRequestGet requestErrorsField(boolean value) {
            this.requestField("errors", value);
            return this;
        }

        public APIRequestGet requestExpirationDateField() {
            return this.requestExpirationDateField(true);
        }

        public APIRequestGet requestExpirationDateField(boolean value) {
            this.requestField("expiration_date", value);
            return this;
        }

        public APIRequestGet requestFbProductCategoryField() {
            return this.requestFbProductCategoryField(true);
        }

        public APIRequestGet requestFbProductCategoryField(boolean value) {
            this.requestField("fb_product_category", value);
            return this;
        }

        public APIRequestGet requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGet requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGet requestGeneratedBackgroundImagesField() {
            return this.requestGeneratedBackgroundImagesField(true);
        }

        public APIRequestGet requestGeneratedBackgroundImagesField(boolean value) {
            this.requestField("generated_background_images", value);
            return this;
        }

        public APIRequestGet requestGeneratedBackgroundImagesAdUsageField() {
            return this.requestGeneratedBackgroundImagesAdUsageField(true);
        }

        public APIRequestGet requestGeneratedBackgroundImagesAdUsageField(boolean value) {
            this.requestField("generated_background_images_ad_usage", value);
            return this;
        }

        public APIRequestGet requestGtinField() {
            return this.requestGtinField(true);
        }

        public APIRequestGet requestGtinField(boolean value) {
            this.requestField("gtin", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImageCdnUrlsField() {
            return this.requestImageCdnUrlsField(true);
        }

        public APIRequestGet requestImageCdnUrlsField(boolean value) {
            this.requestField("image_cdn_urls", value);
            return this;
        }

        public APIRequestGet requestImageFetchStatusField() {
            return this.requestImageFetchStatusField(true);
        }

        public APIRequestGet requestImageFetchStatusField(boolean value) {
            this.requestField("image_fetch_status", value);
            return this;
        }

        public APIRequestGet requestImageUrlField() {
            return this.requestImageUrlField(true);
        }

        public APIRequestGet requestImageUrlField(boolean value) {
            this.requestField("image_url", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestImporterAddressField() {
            return this.requestImporterAddressField(true);
        }

        public APIRequestGet requestImporterAddressField(boolean value) {
            this.requestField("importer_address", value);
            return this;
        }

        public APIRequestGet requestImporterNameField() {
            return this.requestImporterNameField(true);
        }

        public APIRequestGet requestImporterNameField(boolean value) {
            this.requestField("importer_name", value);
            return this;
        }

        public APIRequestGet requestInvalidationErrorsField() {
            return this.requestInvalidationErrorsField(true);
        }

        public APIRequestGet requestInvalidationErrorsField(boolean value) {
            this.requestField("invalidation_errors", value);
            return this;
        }

        public APIRequestGet requestInventoryField() {
            return this.requestInventoryField(true);
        }

        public APIRequestGet requestInventoryField(boolean value) {
            this.requestField("inventory", value);
            return this;
        }

        public APIRequestGet requestIsBundleHeroField() {
            return this.requestIsBundleHeroField(true);
        }

        public APIRequestGet requestIsBundleHeroField(boolean value) {
            this.requestField("is_bundle_hero", value);
            return this;
        }

        public APIRequestGet requestLiveSpecialPriceField() {
            return this.requestLiveSpecialPriceField(true);
        }

        public APIRequestGet requestLiveSpecialPriceField(boolean value) {
            this.requestField("live_special_price", value);
            return this;
        }

        public APIRequestGet requestManufacturerInfoField() {
            return this.requestManufacturerInfoField(true);
        }

        public APIRequestGet requestManufacturerInfoField(boolean value) {
            this.requestField("manufacturer_info", value);
            return this;
        }

        public APIRequestGet requestManufacturerPartNumberField() {
            return this.requestManufacturerPartNumberField(true);
        }

        public APIRequestGet requestManufacturerPartNumberField(boolean value) {
            this.requestField("manufacturer_part_number", value);
            return this;
        }

        public APIRequestGet requestMarkedForProductLaunchField() {
            return this.requestMarkedForProductLaunchField(true);
        }

        public APIRequestGet requestMarkedForProductLaunchField(boolean value) {
            this.requestField("marked_for_product_launch", value);
            return this;
        }

        public APIRequestGet requestMaterialField() {
            return this.requestMaterialField(true);
        }

        public APIRequestGet requestMaterialField(boolean value) {
            this.requestField("material", value);
            return this;
        }

        public APIRequestGet requestMobileLinkField() {
            return this.requestMobileLinkField(true);
        }

        public APIRequestGet requestMobileLinkField(boolean value) {
            this.requestField("mobile_link", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOrderingIndexField() {
            return this.requestOrderingIndexField(true);
        }

        public APIRequestGet requestOrderingIndexField(boolean value) {
            this.requestField("ordering_index", value);
            return this;
        }

        public APIRequestGet requestOriginCountryField() {
            return this.requestOriginCountryField(true);
        }

        public APIRequestGet requestOriginCountryField(boolean value) {
            this.requestField("origin_country", value);
            return this;
        }

        public APIRequestGet requestParentProductIdField() {
            return this.requestParentProductIdField(true);
        }

        public APIRequestGet requestParentProductIdField(boolean value) {
            this.requestField("parent_product_id", value);
            return this;
        }

        public APIRequestGet requestPatternField() {
            return this.requestPatternField(true);
        }

        public APIRequestGet requestPatternField(boolean value) {
            this.requestField("pattern", value);
            return this;
        }

        public APIRequestGet requestPostConversionSignalBasedEnforcementAppealEligibilityField() {
            return this.requestPostConversionSignalBasedEnforcementAppealEligibilityField(true);
        }

        public APIRequestGet requestPostConversionSignalBasedEnforcementAppealEligibilityField(boolean value) {
            this.requestField("post_conversion_signal_based_enforcement_appeal_eligibility", value);
            return this;
        }

        public APIRequestGet requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGet requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGet requestProductCatalogField() {
            return this.requestProductCatalogField(true);
        }

        public APIRequestGet requestProductCatalogField(boolean value) {
            this.requestField("product_catalog", value);
            return this;
        }

        public APIRequestGet requestProductFeedField() {
            return this.requestProductFeedField(true);
        }

        public APIRequestGet requestProductFeedField(boolean value) {
            this.requestField("product_feed", value);
            return this;
        }

        public APIRequestGet requestProductGroupField() {
            return this.requestProductGroupField(true);
        }

        public APIRequestGet requestProductGroupField(boolean value) {
            this.requestField("product_group", value);
            return this;
        }

        public APIRequestGet requestProductLocalInfoField() {
            return this.requestProductLocalInfoField(true);
        }

        public APIRequestGet requestProductLocalInfoField(boolean value) {
            this.requestField("product_local_info", value);
            return this;
        }

        public APIRequestGet requestProductRelationshipField() {
            return this.requestProductRelationshipField(true);
        }

        public APIRequestGet requestProductRelationshipField(boolean value) {
            this.requestField("product_relationship", value);
            return this;
        }

        public APIRequestGet requestProductTypeField() {
            return this.requestProductTypeField(true);
        }

        public APIRequestGet requestProductTypeField(boolean value) {
            this.requestField("product_type", value);
            return this;
        }

        public APIRequestGet requestQuantityToSellOnFacebookField() {
            return this.requestQuantityToSellOnFacebookField(true);
        }

        public APIRequestGet requestQuantityToSellOnFacebookField(boolean value) {
            this.requestField("quantity_to_sell_on_facebook", value);
            return this;
        }

        public APIRequestGet requestRetailerIdField() {
            return this.requestRetailerIdField(true);
        }

        public APIRequestGet requestRetailerIdField(boolean value) {
            this.requestField("retailer_id", value);
            return this;
        }

        public APIRequestGet requestRetailerProductGroupIdField() {
            return this.requestRetailerProductGroupIdField(true);
        }

        public APIRequestGet requestRetailerProductGroupIdField(boolean value) {
            this.requestField("retailer_product_group_id", value);
            return this;
        }

        public APIRequestGet requestReviewRejectionReasonsField() {
            return this.requestReviewRejectionReasonsField(true);
        }

        public APIRequestGet requestReviewRejectionReasonsField(boolean value) {
            this.requestField("review_rejection_reasons", value);
            return this;
        }

        public APIRequestGet requestReviewStatusField() {
            return this.requestReviewStatusField(true);
        }

        public APIRequestGet requestReviewStatusField(boolean value) {
            this.requestField("review_status", value);
            return this;
        }

        public APIRequestGet requestRichTextDescriptionField() {
            return this.requestRichTextDescriptionField(true);
        }

        public APIRequestGet requestRichTextDescriptionField(boolean value) {
            this.requestField("rich_text_description", value);
            return this;
        }

        public APIRequestGet requestSalePriceField() {
            return this.requestSalePriceField(true);
        }

        public APIRequestGet requestSalePriceField(boolean value) {
            this.requestField("sale_price", value);
            return this;
        }

        public APIRequestGet requestSalePriceEndDateField() {
            return this.requestSalePriceEndDateField(true);
        }

        public APIRequestGet requestSalePriceEndDateField(boolean value) {
            this.requestField("sale_price_end_date", value);
            return this;
        }

        public APIRequestGet requestSalePriceStartDateField() {
            return this.requestSalePriceStartDateField(true);
        }

        public APIRequestGet requestSalePriceStartDateField(boolean value) {
            this.requestField("sale_price_start_date", value);
            return this;
        }

        public APIRequestGet requestShippingWeightUnitField() {
            return this.requestShippingWeightUnitField(true);
        }

        public APIRequestGet requestShippingWeightUnitField(boolean value) {
            this.requestField("shipping_weight_unit", value);
            return this;
        }

        public APIRequestGet requestShippingWeightValueField() {
            return this.requestShippingWeightValueField(true);
        }

        public APIRequestGet requestShippingWeightValueField(boolean value) {
            this.requestField("shipping_weight_value", value);
            return this;
        }

        public APIRequestGet requestShortDescriptionField() {
            return this.requestShortDescriptionField(true);
        }

        public APIRequestGet requestShortDescriptionField(boolean value) {
            this.requestField("short_description", value);
            return this;
        }

        public APIRequestGet requestSizeField() {
            return this.requestSizeField(true);
        }

        public APIRequestGet requestSizeField(boolean value) {
            this.requestField("size", value);
            return this;
        }

        public APIRequestGet requestStartDateField() {
            return this.requestStartDateField(true);
        }

        public APIRequestGet requestStartDateField(boolean value) {
            this.requestField("start_date", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGet requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestVendorIdField() {
            return this.requestVendorIdField(true);
        }

        public APIRequestGet requestVendorIdField(boolean value) {
            this.requestField("vendor_id", value);
            return this;
        }

        public APIRequestGet requestVideoFetchStatusField() {
            return this.requestVideoFetchStatusField(true);
        }

        public APIRequestGet requestVideoFetchStatusField(boolean value) {
            this.requestField("video_fetch_status", value);
            return this;
        }

        public APIRequestGet requestVideosField() {
            return this.requestVideosField(true);
        }

        public APIRequestGet requestVideosField(boolean value) {
            this.requestField("videos", value);
            return this;
        }

        public APIRequestGet requestVisibilityField() {
            return this.requestVisibilityField(true);
        }

        public APIRequestGet requestVisibilityField(boolean value) {
            this.requestField("visibility", value);
            return this;
        }

        public APIRequestGet requestWaComplianceCategoryField() {
            return this.requestWaComplianceCategoryField(true);
        }

        public APIRequestGet requestWaComplianceCategoryField(boolean value) {
            this.requestField("wa_compliance_category", value);
            return this;
        }
    }

    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetVideosMetadata
    extends APIRequest<DynamicVideoMetadata> {
        APINodeList<DynamicVideoMetadata> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "tags", "url", "video"};

        @Override
        public APINodeList<DynamicVideoMetadata> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<DynamicVideoMetadata> parseResponse(String response, String header) throws APIException {
            return DynamicVideoMetadata.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<DynamicVideoMetadata> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<DynamicVideoMetadata> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<DynamicVideoMetadata>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<DynamicVideoMetadata>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<DynamicVideoMetadata>>(){

                public APINodeList<DynamicVideoMetadata> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetVideosMetadata(String nodeId, APIContext context) {
            super(context, nodeId, "/videos_metadata", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideosMetadata setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideosMetadata requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideosMetadata requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideosMetadata requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideosMetadata requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetVideosMetadata requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetVideosMetadata requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetVideosMetadata requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGetVideosMetadata requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGetVideosMetadata requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetVideosMetadata requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetVideosMetadata requestVideoField() {
            return this.requestVideoField(true);
        }

        public APIRequestGetVideosMetadata requestVideoField(boolean value) {
            this.requestField("video", value);
            return this;
        }
    }

    public static class APIRequestGetProductSets
    extends APIRequest<ProductSet> {
        APINodeList<ProductSet> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"auto_creation_url", "filter", "id", "latest_metadata", "live_metadata", "name", "ordering_info", "product_catalog", "product_count", "retailer_id"};

        @Override
        public APINodeList<ProductSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProductSet> parseResponse(String response, String header) throws APIException {
            return ProductSet.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ProductSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProductSet> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProductSet>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProductSet>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<ProductSet>>(){

                public APINodeList<ProductSet> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetProductSets(String nodeId, APIContext context) {
            super(context, nodeId, "/product_sets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetProductSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetProductSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetProductSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetProductSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetProductSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetProductSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetProductSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetProductSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetProductSets requestAutoCreationUrlField() {
            return this.requestAutoCreationUrlField(true);
        }

        public APIRequestGetProductSets requestAutoCreationUrlField(boolean value) {
            this.requestField("auto_creation_url", value);
            return this;
        }

        public APIRequestGetProductSets requestFilterField() {
            return this.requestFilterField(true);
        }

        public APIRequestGetProductSets requestFilterField(boolean value) {
            this.requestField("filter", value);
            return this;
        }

        public APIRequestGetProductSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetProductSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetProductSets requestLatestMetadataField() {
            return this.requestLatestMetadataField(true);
        }

        public APIRequestGetProductSets requestLatestMetadataField(boolean value) {
            this.requestField("latest_metadata", value);
            return this;
        }

        public APIRequestGetProductSets requestLiveMetadataField() {
            return this.requestLiveMetadataField(true);
        }

        public APIRequestGetProductSets requestLiveMetadataField(boolean value) {
            this.requestField("live_metadata", value);
            return this;
        }

        public APIRequestGetProductSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetProductSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetProductSets requestOrderingInfoField() {
            return this.requestOrderingInfoField(true);
        }

        public APIRequestGetProductSets requestOrderingInfoField(boolean value) {
            this.requestField("ordering_info", value);
            return this;
        }

        public APIRequestGetProductSets requestProductCatalogField() {
            return this.requestProductCatalogField(true);
        }

        public APIRequestGetProductSets requestProductCatalogField(boolean value) {
            this.requestField("product_catalog", value);
            return this;
        }

        public APIRequestGetProductSets requestProductCountField() {
            return this.requestProductCountField(true);
        }

        public APIRequestGetProductSets requestProductCountField(boolean value) {
            this.requestField("product_count", value);
            return this;
        }

        public APIRequestGetProductSets requestRetailerIdField() {
            return this.requestRetailerIdField(true);
        }

        public APIRequestGetProductSets requestRetailerIdField(boolean value) {
            this.requestField("retailer_id", value);
            return this;
        }
    }

    public static class APIRequestGetOverrideDetails
    extends APIRequest<OverrideDetails> {
        APINodeList<OverrideDetails> lastResponse = null;
        public static final String[] PARAMS = new String[]{"keys", "type"};
        public static final String[] FIELDS = new String[]{"key", "type", "values"};

        @Override
        public APINodeList<OverrideDetails> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<OverrideDetails> parseResponse(String response, String header) throws APIException {
            return OverrideDetails.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<OverrideDetails> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<OverrideDetails> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<OverrideDetails>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<OverrideDetails>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<OverrideDetails>>(){

                public APINodeList<OverrideDetails> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetOverrideDetails(String nodeId, APIContext context) {
            super(context, nodeId, "/override_details", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetOverrideDetails setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetOverrideDetails setKeys(List<String> keys) {
            this.setParam("keys", keys);
            return this;
        }

        public APIRequestGetOverrideDetails setKeys(String keys) {
            this.setParam("keys", keys);
            return this;
        }

        public APIRequestGetOverrideDetails setType(OverrideDetails.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetOverrideDetails setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetOverrideDetails requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetOverrideDetails requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetOverrideDetails requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetOverrideDetails requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetOverrideDetails requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGetOverrideDetails requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGetOverrideDetails requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetOverrideDetails requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetOverrideDetails requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGetOverrideDetails requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }
    }

    public static class APIRequestGetChannelsToIntegrityStatus
    extends APIRequest<CatalogItemChannelsToIntegrityStatus> {
        APINodeList<CatalogItemChannelsToIntegrityStatus> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"channels", "rejection_information"};

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> parseResponse(String response, String header) throws APIException {
            return CatalogItemChannelsToIntegrityStatus.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CatalogItemChannelsToIntegrityStatus> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CatalogItemChannelsToIntegrityStatus>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<CatalogItemChannelsToIntegrityStatus>>(){

                public APINodeList<CatalogItemChannelsToIntegrityStatus> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetChannelsToIntegrityStatus(String nodeId, APIContext context) {
            super(context, nodeId, "/channels_to_integrity_status", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetChannelsToIntegrityStatus setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetChannelsToIntegrityStatus requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField() {
            return this.requestChannelsField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestChannelsField(boolean value) {
            this.requestField("channels", value);
            return this;
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField() {
            return this.requestRejectionInformationField(true);
        }

        public APIRequestGetChannelsToIntegrityStatus requestRejectionInformationField(boolean value) {
            this.requestField("rejection_information", value);
            return this;
        }
    }
}

