/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ProductFeedSchedule
extends APINode {
    @SerializedName(value="day_of_month")
    private Long mDayOfMonth = null;
    @SerializedName(value="day_of_week")
    private String mDayOfWeek = null;
    @SerializedName(value="hour")
    private Long mHour = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="interval")
    private EnumInterval mInterval = null;
    @SerializedName(value="interval_count")
    private Long mIntervalCount = null;
    @SerializedName(value="minute")
    private Long mMinute = null;
    @SerializedName(value="timezone")
    private String mTimezone = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="username")
    private String mUsername = null;
    protected static Gson gson = null;

    ProductFeedSchedule() {
    }

    public ProductFeedSchedule(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductFeedSchedule(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductFeedSchedule fetch() throws APIException {
        ProductFeedSchedule newInstance = ProductFeedSchedule.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductFeedSchedule fetchById(Long id, APIContext context) throws APIException {
        return ProductFeedSchedule.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductFeedSchedule> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductFeedSchedule.fetchByIdAsync(id.toString(), context);
    }

    public static ProductFeedSchedule fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProductFeedSchedule> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProductFeedSchedule> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductFeedSchedule>(context, "", "/", "GET", ProductFeedSchedule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductFeedSchedule>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProductFeedSchedule>(context, "", "/", "GET", ProductFeedSchedule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductFeedSchedule loadJSON(String json, APIContext context, String header) {
        ProductFeedSchedule productFeedSchedule = (ProductFeedSchedule)ProductFeedSchedule.getGson().fromJson(json, ProductFeedSchedule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productFeedSchedule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productFeedSchedule.context = context;
        productFeedSchedule.rawValue = json;
        productFeedSchedule.header = header;
        return productFeedSchedule;
    }

    public static APINodeList<ProductFeedSchedule> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductFeedSchedule> productFeedSchedules = new APINodeList<ProductFeedSchedule>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productFeedSchedules.add(ProductFeedSchedule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return productFeedSchedules;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productFeedSchedules.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productFeedSchedules.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productFeedSchedules.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productFeedSchedules.add(ProductFeedSchedule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productFeedSchedules.add(ProductFeedSchedule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productFeedSchedules.add(ProductFeedSchedule.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return productFeedSchedules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productFeedSchedules.add(ProductFeedSchedule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return productFeedSchedules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productFeedSchedules.add(ProductFeedSchedule.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productFeedSchedules;
                }
                productFeedSchedules.clear();
                productFeedSchedules.add(ProductFeedSchedule.loadJSON(json, context, header));
                return productFeedSchedules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductFeedSchedule.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldDayOfMonth() {
        return this.mDayOfMonth;
    }

    public String getFieldDayOfWeek() {
        return this.mDayOfWeek;
    }

    public Long getFieldHour() {
        return this.mHour;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumInterval getFieldInterval() {
        return this.mInterval;
    }

    public Long getFieldIntervalCount() {
        return this.mIntervalCount;
    }

    public Long getFieldMinute() {
        return this.mMinute;
    }

    public String getFieldTimezone() {
        return this.mTimezone;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductFeedSchedule copyFrom(ProductFeedSchedule instance) {
        this.mDayOfMonth = instance.mDayOfMonth;
        this.mDayOfWeek = instance.mDayOfWeek;
        this.mHour = instance.mHour;
        this.mId = instance.mId;
        this.mInterval = instance.mInterval;
        this.mIntervalCount = instance.mIntervalCount;
        this.mMinute = instance.mMinute;
        this.mTimezone = instance.mTimezone;
        this.mUrl = instance.mUrl;
        this.mUsername = instance.mUsername;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductFeedSchedule> getParser() {
        return new APIRequest.ResponseParser<ProductFeedSchedule>(){

            @Override
            public APINodeList<ProductFeedSchedule> parseResponse(String response, APIContext context, APIRequest<ProductFeedSchedule> request, String header) throws APIException.MalformedResponseException {
                return ProductFeedSchedule.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumInterval {
        VALUE_DAILY("DAILY"),
        VALUE_HOURLY("HOURLY"),
        VALUE_MONTHLY("MONTHLY"),
        VALUE_WEEKLY("WEEKLY");

        private String value;

        private EnumInterval(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<ProductFeedSchedule> {
        ProductFeedSchedule lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"day_of_month", "day_of_week", "hour", "id", "interval", "interval_count", "minute", "timezone", "url", "username"};

        @Override
        public ProductFeedSchedule getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductFeedSchedule parseResponse(String response, String header) throws APIException {
            return ProductFeedSchedule.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ProductFeedSchedule execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductFeedSchedule execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ProductFeedSchedule> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductFeedSchedule> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ProductFeedSchedule>(){

                public ProductFeedSchedule apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDayOfMonthField() {
            return this.requestDayOfMonthField(true);
        }

        public APIRequestGet requestDayOfMonthField(boolean value) {
            this.requestField("day_of_month", value);
            return this;
        }

        public APIRequestGet requestDayOfWeekField() {
            return this.requestDayOfWeekField(true);
        }

        public APIRequestGet requestDayOfWeekField(boolean value) {
            this.requestField("day_of_week", value);
            return this;
        }

        public APIRequestGet requestHourField() {
            return this.requestHourField(true);
        }

        public APIRequestGet requestHourField(boolean value) {
            this.requestField("hour", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIntervalField() {
            return this.requestIntervalField(true);
        }

        public APIRequestGet requestIntervalField(boolean value) {
            this.requestField("interval", value);
            return this;
        }

        public APIRequestGet requestIntervalCountField() {
            return this.requestIntervalCountField(true);
        }

        public APIRequestGet requestIntervalCountField(boolean value) {
            this.requestField("interval_count", value);
            return this;
        }

        public APIRequestGet requestMinuteField() {
            return this.requestMinuteField(true);
        }

        public APIRequestGet requestMinuteField(boolean value) {
            this.requestField("minute", value);
            return this;
        }

        public APIRequestGet requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGet requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGet requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }
}

