/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class IGUserExportForCAM
extends APINode {
    @SerializedName(value="age_bucket")
    private String mAgeBucket = null;
    @SerializedName(value="biography")
    private String mBiography = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="email")
    private String mEmail = null;
    @SerializedName(value="gender")
    private String mGender = null;
    @SerializedName(value="has_brand_partnership_experience")
    private Boolean mHasBrandPartnershipExperience = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_account_verified")
    private Boolean mIsAccountVerified = null;
    @SerializedName(value="is_paid_partnership_messages_enabled")
    private Boolean mIsPaidPartnershipMessagesEnabled = null;
    @SerializedName(value="messaging_id")
    private String mMessagingId = null;
    @SerializedName(value="onboarded_status")
    private Boolean mOnboardedStatus = null;
    @SerializedName(value="past_brand_partnership_partners")
    private List<String> mPastBrandPartnershipPartners = null;
    @SerializedName(value="portfolio_url")
    private String mPortfolioUrl = null;
    @SerializedName(value="username")
    private String mUsername = null;
    protected static Gson gson = null;

    IGUserExportForCAM() {
    }

    public IGUserExportForCAM(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public IGUserExportForCAM(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public IGUserExportForCAM fetch() throws APIException {
        IGUserExportForCAM newInstance = IGUserExportForCAM.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static IGUserExportForCAM fetchById(Long id, APIContext context) throws APIException {
        return IGUserExportForCAM.fetchById(id.toString(), context);
    }

    public static ListenableFuture<IGUserExportForCAM> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return IGUserExportForCAM.fetchByIdAsync(id.toString(), context);
    }

    public static IGUserExportForCAM fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<IGUserExportForCAM> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<IGUserExportForCAM> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<IGUserExportForCAM>(context, "", "/", "GET", IGUserExportForCAM.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<IGUserExportForCAM>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<IGUserExportForCAM>(context, "", "/", "GET", IGUserExportForCAM.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static IGUserExportForCAM loadJSON(String json, APIContext context, String header) {
        IGUserExportForCAM igUserExportForCAM = (IGUserExportForCAM)IGUserExportForCAM.getGson().fromJson(json, IGUserExportForCAM.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(igUserExportForCAM.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        igUserExportForCAM.context = context;
        igUserExportForCAM.rawValue = json;
        igUserExportForCAM.header = header;
        return igUserExportForCAM;
    }

    public static APINodeList<IGUserExportForCAM> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<IGUserExportForCAM> igUserExportForCAMs = new APINodeList<IGUserExportForCAM>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return igUserExportForCAMs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            igUserExportForCAMs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        igUserExportForCAMs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            igUserExportForCAMs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return igUserExportForCAMs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return igUserExportForCAMs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return igUserExportForCAMs;
                }
                igUserExportForCAMs.clear();
                igUserExportForCAMs.add(IGUserExportForCAM.loadJSON(json, context, header));
                return igUserExportForCAMs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return IGUserExportForCAM.getGson().toJson((Object)this);
    }

    public APIRequestGetBrandedContentMedia getBrandedContentMedia() {
        return new APIRequestGetBrandedContentMedia(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetRecentMedia getRecentMedia() {
        return new APIRequestGetRecentMedia(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAgeBucket() {
        return this.mAgeBucket;
    }

    public String getFieldBiography() {
        return this.mBiography;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldEmail() {
        return this.mEmail;
    }

    public String getFieldGender() {
        return this.mGender;
    }

    public Boolean getFieldHasBrandPartnershipExperience() {
        return this.mHasBrandPartnershipExperience;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsAccountVerified() {
        return this.mIsAccountVerified;
    }

    public Boolean getFieldIsPaidPartnershipMessagesEnabled() {
        return this.mIsPaidPartnershipMessagesEnabled;
    }

    public String getFieldMessagingId() {
        return this.mMessagingId;
    }

    public Boolean getFieldOnboardedStatus() {
        return this.mOnboardedStatus;
    }

    public List<String> getFieldPastBrandPartnershipPartners() {
        return this.mPastBrandPartnershipPartners;
    }

    public String getFieldPortfolioUrl() {
        return this.mPortfolioUrl;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public IGUserExportForCAM copyFrom(IGUserExportForCAM instance) {
        this.mAgeBucket = instance.mAgeBucket;
        this.mBiography = instance.mBiography;
        this.mCountry = instance.mCountry;
        this.mEmail = instance.mEmail;
        this.mGender = instance.mGender;
        this.mHasBrandPartnershipExperience = instance.mHasBrandPartnershipExperience;
        this.mId = instance.mId;
        this.mIsAccountVerified = instance.mIsAccountVerified;
        this.mIsPaidPartnershipMessagesEnabled = instance.mIsPaidPartnershipMessagesEnabled;
        this.mMessagingId = instance.mMessagingId;
        this.mOnboardedStatus = instance.mOnboardedStatus;
        this.mPastBrandPartnershipPartners = instance.mPastBrandPartnershipPartners;
        this.mPortfolioUrl = instance.mPortfolioUrl;
        this.mUsername = instance.mUsername;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<IGUserExportForCAM> getParser() {
        return new APIRequest.ResponseParser<IGUserExportForCAM>(){

            @Override
            public APINodeList<IGUserExportForCAM> parseResponse(String response, APIContext context, APIRequest<IGUserExportForCAM> request, String header) throws APIException.MalformedResponseException {
                return IGUserExportForCAM.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumTimeRange {
        VALUE_LAST_14_DAYS("LAST_14_DAYS"),
        VALUE_LAST_90_DAYS("LAST_90_DAYS"),
        VALUE_LIFETIME("LIFETIME"),
        VALUE_THIS_MONTH("THIS_MONTH"),
        VALUE_THIS_WEEK("THIS_WEEK");

        private String value;

        private EnumTimeRange(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumPeriod {
        VALUE_DAY("DAY"),
        VALUE_OVERALL("OVERALL");

        private String value;

        private EnumPeriod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumMetrics {
        VALUE_CREATOR_ENGAGED_ACCOUNTS("CREATOR_ENGAGED_ACCOUNTS"),
        VALUE_CREATOR_REACH("CREATOR_REACH"),
        VALUE_REELS_HOOK_RATE("REELS_HOOK_RATE"),
        VALUE_REELS_INTERACTION_RATE("REELS_INTERACTION_RATE"),
        VALUE_TOTAL_FOLLOWERS("TOTAL_FOLLOWERS");

        private String value;

        private EnumMetrics(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumBreakdown {
        VALUE_AGE("AGE"),
        VALUE_FOLLOW_TYPE("FOLLOW_TYPE"),
        VALUE_GENDER("GENDER"),
        VALUE_MEDIA_TYPE("MEDIA_TYPE"),
        VALUE_TOP_CITIES("TOP_CITIES"),
        VALUE_TOP_COUNTRIES("TOP_COUNTRIES");

        private String value;

        private EnumBreakdown(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumMajorAudienceGender {
        VALUE_CUSTOM("custom"),
        VALUE_FEMALE("female"),
        VALUE_MALE("male"),
        VALUE_UNKNOWN("unknown");

        private String value;

        private EnumMajorAudienceGender(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumMajorAudienceCountries {
        VALUE_AC("AC"),
        VALUE_AD("AD"),
        VALUE_AE("AE"),
        VALUE_AF("AF"),
        VALUE_AG("AG"),
        VALUE_AI("AI"),
        VALUE_AL("AL"),
        VALUE_AM("AM"),
        VALUE_AN("AN"),
        VALUE_AO("AO"),
        VALUE_AQ("AQ"),
        VALUE_AR("AR"),
        VALUE_AS("AS"),
        VALUE_AT("AT"),
        VALUE_AU("AU"),
        VALUE_AW("AW"),
        VALUE_AX("AX"),
        VALUE_AZ("AZ"),
        VALUE_BA("BA"),
        VALUE_BB("BB"),
        VALUE_BD("BD"),
        VALUE_BE("BE"),
        VALUE_BF("BF"),
        VALUE_BG("BG"),
        VALUE_BH("BH"),
        VALUE_BI("BI"),
        VALUE_BJ("BJ"),
        VALUE_BL("BL"),
        VALUE_BM("BM"),
        VALUE_BN("BN"),
        VALUE_BO("BO"),
        VALUE_BQ("BQ"),
        VALUE_BR("BR"),
        VALUE_BS("BS"),
        VALUE_BT("BT"),
        VALUE_BV("BV"),
        VALUE_BW("BW"),
        VALUE_BY("BY"),
        VALUE_BZ("BZ"),
        VALUE_CA("CA"),
        VALUE_CC("CC"),
        VALUE_CD("CD"),
        VALUE_CF("CF"),
        VALUE_CG("CG"),
        VALUE_CH("CH"),
        VALUE_CI("CI"),
        VALUE_CK("CK"),
        VALUE_CL("CL"),
        VALUE_CM("CM"),
        VALUE_CN("CN"),
        VALUE_CO("CO"),
        VALUE_CR("CR"),
        VALUE_CU("CU"),
        VALUE_CV("CV"),
        VALUE_CW("CW"),
        VALUE_CX("CX"),
        VALUE_CY("CY"),
        VALUE_CZ("CZ"),
        VALUE_DE("DE"),
        VALUE_DJ("DJ"),
        VALUE_DK("DK"),
        VALUE_DM("DM"),
        VALUE_DO("DO"),
        VALUE_DZ("DZ"),
        VALUE_EC("EC"),
        VALUE_EE("EE"),
        VALUE_EG("EG"),
        VALUE_EH("EH"),
        VALUE_ER("ER"),
        VALUE_ES("ES"),
        VALUE_ET("ET"),
        VALUE_FI("FI"),
        VALUE_FJ("FJ"),
        VALUE_FK("FK"),
        VALUE_FM("FM"),
        VALUE_FO("FO"),
        VALUE_FR("FR"),
        VALUE_GA("GA"),
        VALUE_GB("GB"),
        VALUE_GD("GD"),
        VALUE_GE("GE"),
        VALUE_GF("GF"),
        VALUE_GG("GG"),
        VALUE_GH("GH"),
        VALUE_GI("GI"),
        VALUE_GL("GL"),
        VALUE_GM("GM"),
        VALUE_GN("GN"),
        VALUE_GP("GP"),
        VALUE_GQ("GQ"),
        VALUE_GR("GR"),
        VALUE_GS("GS"),
        VALUE_GT("GT"),
        VALUE_GU("GU"),
        VALUE_GW("GW"),
        VALUE_GY("GY"),
        VALUE_HK("HK"),
        VALUE_HM("HM"),
        VALUE_HN("HN"),
        VALUE_HR("HR"),
        VALUE_HT("HT"),
        VALUE_HU("HU"),
        VALUE_ID("ID"),
        VALUE_IE("IE"),
        VALUE_IL("IL"),
        VALUE_IM("IM"),
        VALUE_IN("IN"),
        VALUE_IO("IO"),
        VALUE_IQ("IQ"),
        VALUE_IR("IR"),
        VALUE_IS("IS"),
        VALUE_IT("IT"),
        VALUE_JE("JE"),
        VALUE_JM("JM"),
        VALUE_JO("JO"),
        VALUE_JP("JP"),
        VALUE_KE("KE"),
        VALUE_KG("KG"),
        VALUE_KH("KH"),
        VALUE_KI("KI"),
        VALUE_KM("KM"),
        VALUE_KN("KN"),
        VALUE_KP("KP"),
        VALUE_KR("KR"),
        VALUE_KW("KW"),
        VALUE_KY("KY"),
        VALUE_KZ("KZ"),
        VALUE_LA("LA"),
        VALUE_LB("LB"),
        VALUE_LC("LC"),
        VALUE_LI("LI"),
        VALUE_LK("LK"),
        VALUE_LR("LR"),
        VALUE_LS("LS"),
        VALUE_LT("LT"),
        VALUE_LU("LU"),
        VALUE_LV("LV"),
        VALUE_LY("LY"),
        VALUE_MA("MA"),
        VALUE_MC("MC"),
        VALUE_MD("MD"),
        VALUE_ME("ME"),
        VALUE_MF("MF"),
        VALUE_MG("MG"),
        VALUE_MH("MH"),
        VALUE_MK("MK"),
        VALUE_ML("ML"),
        VALUE_MM("MM"),
        VALUE_MN("MN"),
        VALUE_MO("MO"),
        VALUE_MP("MP"),
        VALUE_MQ("MQ"),
        VALUE_MR("MR"),
        VALUE_MS("MS"),
        VALUE_MT("MT"),
        VALUE_MU("MU"),
        VALUE_MV("MV"),
        VALUE_MW("MW"),
        VALUE_MX("MX"),
        VALUE_MY("MY"),
        VALUE_MZ("MZ"),
        VALUE_NA("NA"),
        VALUE_NC("NC"),
        VALUE_NE("NE"),
        VALUE_NF("NF"),
        VALUE_NG("NG"),
        VALUE_NI("NI"),
        VALUE_NL("NL"),
        VALUE_NO("NO"),
        VALUE_NP("NP"),
        VALUE_NR("NR"),
        VALUE_NU("NU"),
        VALUE_NZ("NZ"),
        VALUE_OM("OM"),
        VALUE_PA("PA"),
        VALUE_PE("PE"),
        VALUE_PF("PF"),
        VALUE_PG("PG"),
        VALUE_PH("PH"),
        VALUE_PK("PK"),
        VALUE_PL("PL"),
        VALUE_PM("PM"),
        VALUE_PN("PN"),
        VALUE_PR("PR"),
        VALUE_PS("PS"),
        VALUE_PT("PT"),
        VALUE_PW("PW"),
        VALUE_PY("PY"),
        VALUE_QA("QA"),
        VALUE_RE("RE"),
        VALUE_RO("RO"),
        VALUE_RS("RS"),
        VALUE_RU("RU"),
        VALUE_RW("RW"),
        VALUE_SA("SA"),
        VALUE_SB("SB"),
        VALUE_SC("SC"),
        VALUE_SD("SD"),
        VALUE_SE("SE"),
        VALUE_SG("SG"),
        VALUE_SH("SH"),
        VALUE_SI("SI"),
        VALUE_SJ("SJ"),
        VALUE_SK("SK"),
        VALUE_SL("SL"),
        VALUE_SM("SM"),
        VALUE_SN("SN"),
        VALUE_SO("SO"),
        VALUE_SR("SR"),
        VALUE_SS("SS"),
        VALUE_ST("ST"),
        VALUE_SV("SV"),
        VALUE_SX("SX"),
        VALUE_SY("SY"),
        VALUE_SZ("SZ"),
        VALUE_TC("TC"),
        VALUE_TD("TD"),
        VALUE_TF("TF"),
        VALUE_TG("TG"),
        VALUE_TH("TH"),
        VALUE_TJ("TJ"),
        VALUE_TK("TK"),
        VALUE_TL("TL"),
        VALUE_TM("TM"),
        VALUE_TN("TN"),
        VALUE_TO("TO"),
        VALUE_TR("TR"),
        VALUE_TT("TT"),
        VALUE_TV("TV"),
        VALUE_TW("TW"),
        VALUE_TZ("TZ"),
        VALUE_UA("UA"),
        VALUE_UG("UG"),
        VALUE_UM("UM"),
        VALUE_US("US"),
        VALUE_UY("UY"),
        VALUE_UZ("UZ"),
        VALUE_VA("VA"),
        VALUE_VC("VC"),
        VALUE_VE("VE"),
        VALUE_VG("VG"),
        VALUE_VI("VI"),
        VALUE_VN("VN"),
        VALUE_VU("VU"),
        VALUE_WF("WF"),
        VALUE_WS("WS"),
        VALUE_XK("XK"),
        VALUE_YE("YE"),
        VALUE_YT("YT"),
        VALUE_ZA("ZA"),
        VALUE_ZM("ZM"),
        VALUE_ZW("ZW");

        private String value;

        private EnumMajorAudienceCountries(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumCreatorGender {
        VALUE_CUSTOM("custom"),
        VALUE_FEMALE("female"),
        VALUE_MALE("male"),
        VALUE_UNKNOWN("unknown");

        private String value;

        private EnumCreatorGender(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumCreatorCountries {
        VALUE_AC("AC"),
        VALUE_AD("AD"),
        VALUE_AE("AE"),
        VALUE_AF("AF"),
        VALUE_AG("AG"),
        VALUE_AI("AI"),
        VALUE_AL("AL"),
        VALUE_AM("AM"),
        VALUE_AN("AN"),
        VALUE_AO("AO"),
        VALUE_AQ("AQ"),
        VALUE_AR("AR"),
        VALUE_AS("AS"),
        VALUE_AT("AT"),
        VALUE_AU("AU"),
        VALUE_AW("AW"),
        VALUE_AX("AX"),
        VALUE_AZ("AZ"),
        VALUE_BA("BA"),
        VALUE_BB("BB"),
        VALUE_BD("BD"),
        VALUE_BE("BE"),
        VALUE_BF("BF"),
        VALUE_BG("BG"),
        VALUE_BH("BH"),
        VALUE_BI("BI"),
        VALUE_BJ("BJ"),
        VALUE_BL("BL"),
        VALUE_BM("BM"),
        VALUE_BN("BN"),
        VALUE_BO("BO"),
        VALUE_BQ("BQ"),
        VALUE_BR("BR"),
        VALUE_BS("BS"),
        VALUE_BT("BT"),
        VALUE_BV("BV"),
        VALUE_BW("BW"),
        VALUE_BY("BY"),
        VALUE_BZ("BZ"),
        VALUE_CA("CA"),
        VALUE_CC("CC"),
        VALUE_CD("CD"),
        VALUE_CF("CF"),
        VALUE_CG("CG"),
        VALUE_CH("CH"),
        VALUE_CI("CI"),
        VALUE_CK("CK"),
        VALUE_CL("CL"),
        VALUE_CM("CM"),
        VALUE_CN("CN"),
        VALUE_CO("CO"),
        VALUE_CR("CR"),
        VALUE_CU("CU"),
        VALUE_CV("CV"),
        VALUE_CW("CW"),
        VALUE_CX("CX"),
        VALUE_CY("CY"),
        VALUE_CZ("CZ"),
        VALUE_DE("DE"),
        VALUE_DJ("DJ"),
        VALUE_DK("DK"),
        VALUE_DM("DM"),
        VALUE_DO("DO"),
        VALUE_DZ("DZ"),
        VALUE_EC("EC"),
        VALUE_EE("EE"),
        VALUE_EG("EG"),
        VALUE_EH("EH"),
        VALUE_ER("ER"),
        VALUE_ES("ES"),
        VALUE_ET("ET"),
        VALUE_FI("FI"),
        VALUE_FJ("FJ"),
        VALUE_FK("FK"),
        VALUE_FM("FM"),
        VALUE_FO("FO"),
        VALUE_FR("FR"),
        VALUE_GA("GA"),
        VALUE_GB("GB"),
        VALUE_GD("GD"),
        VALUE_GE("GE"),
        VALUE_GF("GF"),
        VALUE_GG("GG"),
        VALUE_GH("GH"),
        VALUE_GI("GI"),
        VALUE_GL("GL"),
        VALUE_GM("GM"),
        VALUE_GN("GN"),
        VALUE_GP("GP"),
        VALUE_GQ("GQ"),
        VALUE_GR("GR"),
        VALUE_GS("GS"),
        VALUE_GT("GT"),
        VALUE_GU("GU"),
        VALUE_GW("GW"),
        VALUE_GY("GY"),
        VALUE_HK("HK"),
        VALUE_HM("HM"),
        VALUE_HN("HN"),
        VALUE_HR("HR"),
        VALUE_HT("HT"),
        VALUE_HU("HU"),
        VALUE_ID("ID"),
        VALUE_IE("IE"),
        VALUE_IL("IL"),
        VALUE_IM("IM"),
        VALUE_IN("IN"),
        VALUE_IO("IO"),
        VALUE_IQ("IQ"),
        VALUE_IR("IR"),
        VALUE_IS("IS"),
        VALUE_IT("IT"),
        VALUE_JE("JE"),
        VALUE_JM("JM"),
        VALUE_JO("JO"),
        VALUE_JP("JP"),
        VALUE_KE("KE"),
        VALUE_KG("KG"),
        VALUE_KH("KH"),
        VALUE_KI("KI"),
        VALUE_KM("KM"),
        VALUE_KN("KN"),
        VALUE_KP("KP"),
        VALUE_KR("KR"),
        VALUE_KW("KW"),
        VALUE_KY("KY"),
        VALUE_KZ("KZ"),
        VALUE_LA("LA"),
        VALUE_LB("LB"),
        VALUE_LC("LC"),
        VALUE_LI("LI"),
        VALUE_LK("LK"),
        VALUE_LR("LR"),
        VALUE_LS("LS"),
        VALUE_LT("LT"),
        VALUE_LU("LU"),
        VALUE_LV("LV"),
        VALUE_LY("LY"),
        VALUE_MA("MA"),
        VALUE_MC("MC"),
        VALUE_MD("MD"),
        VALUE_ME("ME"),
        VALUE_MF("MF"),
        VALUE_MG("MG"),
        VALUE_MH("MH"),
        VALUE_MK("MK"),
        VALUE_ML("ML"),
        VALUE_MM("MM"),
        VALUE_MN("MN"),
        VALUE_MO("MO"),
        VALUE_MP("MP"),
        VALUE_MQ("MQ"),
        VALUE_MR("MR"),
        VALUE_MS("MS"),
        VALUE_MT("MT"),
        VALUE_MU("MU"),
        VALUE_MV("MV"),
        VALUE_MW("MW"),
        VALUE_MX("MX"),
        VALUE_MY("MY"),
        VALUE_MZ("MZ"),
        VALUE_NA("NA"),
        VALUE_NC("NC"),
        VALUE_NE("NE"),
        VALUE_NF("NF"),
        VALUE_NG("NG"),
        VALUE_NI("NI"),
        VALUE_NL("NL"),
        VALUE_NO("NO"),
        VALUE_NP("NP"),
        VALUE_NR("NR"),
        VALUE_NU("NU"),
        VALUE_NZ("NZ"),
        VALUE_OM("OM"),
        VALUE_PA("PA"),
        VALUE_PE("PE"),
        VALUE_PF("PF"),
        VALUE_PG("PG"),
        VALUE_PH("PH"),
        VALUE_PK("PK"),
        VALUE_PL("PL"),
        VALUE_PM("PM"),
        VALUE_PN("PN"),
        VALUE_PR("PR"),
        VALUE_PS("PS"),
        VALUE_PT("PT"),
        VALUE_PW("PW"),
        VALUE_PY("PY"),
        VALUE_QA("QA"),
        VALUE_RE("RE"),
        VALUE_RO("RO"),
        VALUE_RS("RS"),
        VALUE_RU("RU"),
        VALUE_RW("RW"),
        VALUE_SA("SA"),
        VALUE_SB("SB"),
        VALUE_SC("SC"),
        VALUE_SD("SD"),
        VALUE_SE("SE"),
        VALUE_SG("SG"),
        VALUE_SH("SH"),
        VALUE_SI("SI"),
        VALUE_SJ("SJ"),
        VALUE_SK("SK"),
        VALUE_SL("SL"),
        VALUE_SM("SM"),
        VALUE_SN("SN"),
        VALUE_SO("SO"),
        VALUE_SR("SR"),
        VALUE_SS("SS"),
        VALUE_ST("ST"),
        VALUE_SV("SV"),
        VALUE_SX("SX"),
        VALUE_SY("SY"),
        VALUE_SZ("SZ"),
        VALUE_TC("TC"),
        VALUE_TD("TD"),
        VALUE_TF("TF"),
        VALUE_TG("TG"),
        VALUE_TH("TH"),
        VALUE_TJ("TJ"),
        VALUE_TK("TK"),
        VALUE_TL("TL"),
        VALUE_TM("TM"),
        VALUE_TN("TN"),
        VALUE_TO("TO"),
        VALUE_TR("TR"),
        VALUE_TT("TT"),
        VALUE_TV("TV"),
        VALUE_TW("TW"),
        VALUE_TZ("TZ"),
        VALUE_UA("UA"),
        VALUE_UG("UG"),
        VALUE_UM("UM"),
        VALUE_US("US"),
        VALUE_UY("UY"),
        VALUE_UZ("UZ"),
        VALUE_VA("VA"),
        VALUE_VC("VC"),
        VALUE_VE("VE"),
        VALUE_VG("VG"),
        VALUE_VI("VI"),
        VALUE_VN("VN"),
        VALUE_VU("VU"),
        VALUE_WF("WF"),
        VALUE_WS("WS"),
        VALUE_XK("XK"),
        VALUE_YE("YE"),
        VALUE_YT("YT"),
        VALUE_ZA("ZA"),
        VALUE_ZM("ZM"),
        VALUE_ZW("ZW");

        private String value;

        private EnumCreatorCountries(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<IGUserExportForCAM> {
        IGUserExportForCAM lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"age_bucket", "biography", "country", "email", "gender", "has_brand_partnership_experience", "id", "is_account_verified", "is_paid_partnership_messages_enabled", "messaging_id", "onboarded_status", "past_brand_partnership_partners", "portfolio_url", "username"};

        @Override
        public IGUserExportForCAM getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public IGUserExportForCAM parseResponse(String response, String header) throws APIException {
            return IGUserExportForCAM.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public IGUserExportForCAM execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public IGUserExportForCAM execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<IGUserExportForCAM> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<IGUserExportForCAM> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, IGUserExportForCAM>(){

                public IGUserExportForCAM apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAgeBucketField() {
            return this.requestAgeBucketField(true);
        }

        public APIRequestGet requestAgeBucketField(boolean value) {
            this.requestField("age_bucket", value);
            return this;
        }

        public APIRequestGet requestBiographyField() {
            return this.requestBiographyField(true);
        }

        public APIRequestGet requestBiographyField(boolean value) {
            this.requestField("biography", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGet requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGet requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGet requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGet requestHasBrandPartnershipExperienceField() {
            return this.requestHasBrandPartnershipExperienceField(true);
        }

        public APIRequestGet requestHasBrandPartnershipExperienceField(boolean value) {
            this.requestField("has_brand_partnership_experience", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsAccountVerifiedField() {
            return this.requestIsAccountVerifiedField(true);
        }

        public APIRequestGet requestIsAccountVerifiedField(boolean value) {
            this.requestField("is_account_verified", value);
            return this;
        }

        public APIRequestGet requestIsPaidPartnershipMessagesEnabledField() {
            return this.requestIsPaidPartnershipMessagesEnabledField(true);
        }

        public APIRequestGet requestIsPaidPartnershipMessagesEnabledField(boolean value) {
            this.requestField("is_paid_partnership_messages_enabled", value);
            return this;
        }

        public APIRequestGet requestMessagingIdField() {
            return this.requestMessagingIdField(true);
        }

        public APIRequestGet requestMessagingIdField(boolean value) {
            this.requestField("messaging_id", value);
            return this;
        }

        public APIRequestGet requestOnboardedStatusField() {
            return this.requestOnboardedStatusField(true);
        }

        public APIRequestGet requestOnboardedStatusField(boolean value) {
            this.requestField("onboarded_status", value);
            return this;
        }

        public APIRequestGet requestPastBrandPartnershipPartnersField() {
            return this.requestPastBrandPartnershipPartnersField(true);
        }

        public APIRequestGet requestPastBrandPartnershipPartnersField(boolean value) {
            this.requestField("past_brand_partnership_partners", value);
            return this;
        }

        public APIRequestGet requestPortfolioUrlField() {
            return this.requestPortfolioUrlField(true);
        }

        public APIRequestGet requestPortfolioUrlField(boolean value) {
            this.requestField("portfolio_url", value);
            return this;
        }

        public APIRequestGet requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGet requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    public static class APIRequestGetRecentMedia
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetRecentMedia(String nodeId, APIContext context) {
            super(context, nodeId, "/recent_media", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetRecentMedia setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetRecentMedia setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetRecentMedia requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetRecentMedia requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRecentMedia requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetRecentMedia requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRecentMedia requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetRecentMedia requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetInsights
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"breakdown", "metrics", "period", "time_range"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights setBreakdown(EnumBreakdown breakdown) {
            this.setParam("breakdown", (Object)breakdown);
            return this;
        }

        public APIRequestGetInsights setBreakdown(String breakdown) {
            this.setParam("breakdown", breakdown);
            return this;
        }

        public APIRequestGetInsights setMetrics(List<EnumMetrics> metrics) {
            this.setParam("metrics", metrics);
            return this;
        }

        public APIRequestGetInsights setMetrics(String metrics) {
            this.setParam("metrics", metrics);
            return this;
        }

        public APIRequestGetInsights setPeriod(EnumPeriod period) {
            this.setParam("period", (Object)period);
            return this;
        }

        public APIRequestGetInsights setPeriod(String period) {
            this.setParam("period", period);
            return this;
        }

        public APIRequestGetInsights setTimeRange(EnumTimeRange timeRange) {
            this.setParam("time_range", (Object)timeRange);
            return this;
        }

        public APIRequestGetInsights setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetBrandedContentMedia
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetBrandedContentMedia(String nodeId, APIContext context) {
            super(context, nodeId, "/branded_content_media", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBrandedContentMedia setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBrandedContentMedia setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBrandedContentMedia requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBrandedContentMedia requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBrandedContentMedia requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBrandedContentMedia requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBrandedContentMedia requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBrandedContentMedia requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

