/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.BusinessAssetGroup;
import com.facebook.ads.sdk.CustomAudience;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class FranchiseProgram
extends APINode {
    @SerializedName(value="business_asset_group")
    private BusinessAssetGroup mBusinessAssetGroup = null;
    @SerializedName(value="creator_business")
    private Business mCreatorBusiness = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="end_date")
    private String mEndDate = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="program_access_type")
    private String mProgramAccessType = null;
    @SerializedName(value="program_approval_type")
    private String mProgramApprovalType = null;
    @SerializedName(value="program_image_link")
    private String mProgramImageLink = null;
    @SerializedName(value="program_url")
    private String mProgramUrl = null;
    @SerializedName(value="shared_custom_audience")
    private CustomAudience mSharedCustomAudience = null;
    @SerializedName(value="start_date")
    private String mStartDate = null;
    protected static Gson gson = null;

    FranchiseProgram() {
    }

    public FranchiseProgram(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public FranchiseProgram(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public FranchiseProgram fetch() throws APIException {
        FranchiseProgram newInstance = FranchiseProgram.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static FranchiseProgram fetchById(Long id, APIContext context) throws APIException {
        return FranchiseProgram.fetchById(id.toString(), context);
    }

    public static ListenableFuture<FranchiseProgram> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return FranchiseProgram.fetchByIdAsync(id.toString(), context);
    }

    public static FranchiseProgram fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<FranchiseProgram> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<FranchiseProgram> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<FranchiseProgram>(context, "", "/", "GET", FranchiseProgram.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<FranchiseProgram>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<FranchiseProgram>(context, "", "/", "GET", FranchiseProgram.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static FranchiseProgram loadJSON(String json, APIContext context, String header) {
        FranchiseProgram franchiseProgram = (FranchiseProgram)FranchiseProgram.getGson().fromJson(json, FranchiseProgram.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(franchiseProgram.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        franchiseProgram.context = context;
        franchiseProgram.rawValue = json;
        franchiseProgram.header = header;
        return franchiseProgram;
    }

    public static APINodeList<FranchiseProgram> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<FranchiseProgram> franchisePrograms = new APINodeList<FranchiseProgram>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        franchisePrograms.add(FranchiseProgram.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return franchisePrograms;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            franchisePrograms.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        franchisePrograms.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            franchisePrograms.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            franchisePrograms.add(FranchiseProgram.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                franchisePrograms.add(FranchiseProgram.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            franchisePrograms.add(FranchiseProgram.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return franchisePrograms;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        franchisePrograms.add(FranchiseProgram.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return franchisePrograms;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        franchisePrograms.add(FranchiseProgram.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return franchisePrograms;
                }
                franchisePrograms.clear();
                franchisePrograms.add(FranchiseProgram.loadJSON(json, context, header));
                return franchisePrograms;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return FranchiseProgram.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public BusinessAssetGroup getFieldBusinessAssetGroup() {
        if (this.mBusinessAssetGroup != null) {
            this.mBusinessAssetGroup.context = this.getContext();
        }
        return this.mBusinessAssetGroup;
    }

    public Business getFieldCreatorBusiness() {
        if (this.mCreatorBusiness != null) {
            this.mCreatorBusiness.context = this.getContext();
        }
        return this.mCreatorBusiness;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldEndDate() {
        return this.mEndDate;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldProgramAccessType() {
        return this.mProgramAccessType;
    }

    public String getFieldProgramApprovalType() {
        return this.mProgramApprovalType;
    }

    public String getFieldProgramImageLink() {
        return this.mProgramImageLink;
    }

    public String getFieldProgramUrl() {
        return this.mProgramUrl;
    }

    public CustomAudience getFieldSharedCustomAudience() {
        if (this.mSharedCustomAudience != null) {
            this.mSharedCustomAudience.context = this.getContext();
        }
        return this.mSharedCustomAudience;
    }

    public String getFieldStartDate() {
        return this.mStartDate;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public FranchiseProgram copyFrom(FranchiseProgram instance) {
        this.mBusinessAssetGroup = instance.mBusinessAssetGroup;
        this.mCreatorBusiness = instance.mCreatorBusiness;
        this.mDescription = instance.mDescription;
        this.mEndDate = instance.mEndDate;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mProgramAccessType = instance.mProgramAccessType;
        this.mProgramApprovalType = instance.mProgramApprovalType;
        this.mProgramImageLink = instance.mProgramImageLink;
        this.mProgramUrl = instance.mProgramUrl;
        this.mSharedCustomAudience = instance.mSharedCustomAudience;
        this.mStartDate = instance.mStartDate;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<FranchiseProgram> getParser() {
        return new APIRequest.ResponseParser<FranchiseProgram>(){

            @Override
            public APINodeList<FranchiseProgram> parseResponse(String response, APIContext context, APIRequest<FranchiseProgram> request, String header) throws APIException.MalformedResponseException {
                return FranchiseProgram.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<FranchiseProgram> {
        FranchiseProgram lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business_asset_group", "creator_business", "description", "end_date", "id", "name", "program_access_type", "program_approval_type", "program_image_link", "program_url", "shared_custom_audience", "start_date"};

        @Override
        public FranchiseProgram getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public FranchiseProgram parseResponse(String response, String header) throws APIException {
            return FranchiseProgram.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public FranchiseProgram execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public FranchiseProgram execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<FranchiseProgram> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<FranchiseProgram> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, FranchiseProgram>(){

                public FranchiseProgram apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessAssetGroupField() {
            return this.requestBusinessAssetGroupField(true);
        }

        public APIRequestGet requestBusinessAssetGroupField(boolean value) {
            this.requestField("business_asset_group", value);
            return this;
        }

        public APIRequestGet requestCreatorBusinessField() {
            return this.requestCreatorBusinessField(true);
        }

        public APIRequestGet requestCreatorBusinessField(boolean value) {
            this.requestField("creator_business", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEndDateField() {
            return this.requestEndDateField(true);
        }

        public APIRequestGet requestEndDateField(boolean value) {
            this.requestField("end_date", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestProgramAccessTypeField() {
            return this.requestProgramAccessTypeField(true);
        }

        public APIRequestGet requestProgramAccessTypeField(boolean value) {
            this.requestField("program_access_type", value);
            return this;
        }

        public APIRequestGet requestProgramApprovalTypeField() {
            return this.requestProgramApprovalTypeField(true);
        }

        public APIRequestGet requestProgramApprovalTypeField(boolean value) {
            this.requestField("program_approval_type", value);
            return this;
        }

        public APIRequestGet requestProgramImageLinkField() {
            return this.requestProgramImageLinkField(true);
        }

        public APIRequestGet requestProgramImageLinkField(boolean value) {
            this.requestField("program_image_link", value);
            return this;
        }

        public APIRequestGet requestProgramUrlField() {
            return this.requestProgramUrlField(true);
        }

        public APIRequestGet requestProgramUrlField(boolean value) {
            this.requestField("program_url", value);
            return this;
        }

        public APIRequestGet requestSharedCustomAudienceField() {
            return this.requestSharedCustomAudienceField(true);
        }

        public APIRequestGet requestSharedCustomAudienceField(boolean value) {
            this.requestField("shared_custom_audience", value);
            return this;
        }

        public APIRequestGet requestStartDateField() {
            return this.requestStartDateField(true);
        }

        public APIRequestGet requestStartDateField(boolean value) {
            this.requestField("start_date", value);
            return this;
        }
    }
}

