/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class CatalogCollection
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="url")
    private String mUrl = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static CatalogCollection loadJSON(String json, APIContext context, String header) {
        CatalogCollection catalogCollection = (CatalogCollection)CatalogCollection.getGson().fromJson(json, CatalogCollection.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(catalogCollection.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        catalogCollection.context = context;
        catalogCollection.rawValue = json;
        catalogCollection.header = header;
        return catalogCollection;
    }

    public static APINodeList<CatalogCollection> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CatalogCollection> catalogCollections = new APINodeList<CatalogCollection>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        catalogCollections.add(CatalogCollection.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return catalogCollections;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            catalogCollections.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        catalogCollections.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            catalogCollections.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            catalogCollections.add(CatalogCollection.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                catalogCollections.add(CatalogCollection.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            catalogCollections.add(CatalogCollection.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return catalogCollections;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        catalogCollections.add(CatalogCollection.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return catalogCollections;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        catalogCollections.add(CatalogCollection.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return catalogCollections;
                }
                catalogCollections.clear();
                catalogCollections.add(CatalogCollection.loadJSON(json, context, header));
                return catalogCollections;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CatalogCollection.getGson().toJson((Object)this);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public CatalogCollection setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public CatalogCollection setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public CatalogCollection setFieldUrl(String value) {
        this.mUrl = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CatalogCollection copyFrom(CatalogCollection instance) {
        this.mDescription = instance.mDescription;
        this.mTitle = instance.mTitle;
        this.mUrl = instance.mUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CatalogCollection> getParser() {
        return new APIRequest.ResponseParser<CatalogCollection>(){

            @Override
            public APINodeList<CatalogCollection> parseResponse(String response, APIContext context, APIRequest<CatalogCollection> request, String header) throws APIException.MalformedResponseException {
                return CatalogCollection.parseResponse(response, context, request, header);
            }
        };
    }
}

