/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Ad;
import com.facebook.ads.sdk.AdCampaignGroupAdvantageState;
import com.facebook.ads.sdk.AdCampaignIssuesInfo;
import com.facebook.ads.sdk.AdLabel;
import com.facebook.ads.sdk.AdPromotedObject;
import com.facebook.ads.sdk.AdRecommendation;
import com.facebook.ads.sdk.AdReportRun;
import com.facebook.ads.sdk.AdRule;
import com.facebook.ads.sdk.AdSet;
import com.facebook.ads.sdk.AdStudy;
import com.facebook.ads.sdk.AdsInsights;
import com.facebook.ads.sdk.HighDemandPeriod;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class Campaign
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="adlabels")
    private List<AdLabel> mAdlabels = null;
    @SerializedName(value="advantage_state_info")
    private AdCampaignGroupAdvantageState mAdvantageStateInfo = null;
    @SerializedName(value="bid_strategy")
    private EnumBidStrategy mBidStrategy = null;
    @SerializedName(value="boosted_object_id")
    private String mBoostedObjectId = null;
    @SerializedName(value="brand_lift_studies")
    private List<AdStudy> mBrandLiftStudies = null;
    @SerializedName(value="budget_rebalance_flag")
    private Boolean mBudgetRebalanceFlag = null;
    @SerializedName(value="budget_remaining")
    private String mBudgetRemaining = null;
    @SerializedName(value="buying_type")
    private String mBuyingType = null;
    @SerializedName(value="campaign_group_active_time")
    private String mCampaignGroupActiveTime = null;
    @SerializedName(value="can_create_brand_lift_study")
    private Boolean mCanCreateBrandLiftStudy = null;
    @SerializedName(value="can_use_spend_cap")
    private Boolean mCanUseSpendCap = null;
    @SerializedName(value="configured_status")
    private EnumConfiguredStatus mConfiguredStatus = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="daily_budget")
    private String mDailyBudget = null;
    @SerializedName(value="effective_status")
    private EnumEffectiveStatus mEffectiveStatus = null;
    @SerializedName(value="has_secondary_skadnetwork_reporting")
    private Boolean mHasSecondarySkadnetworkReporting = null;
    @SerializedName(value="id", alternate={"copied_campaign_id"})
    private String mId = null;
    @SerializedName(value="is_adset_budget_sharing_enabled")
    private Boolean mIsAdsetBudgetSharingEnabled = null;
    @SerializedName(value="is_budget_schedule_enabled")
    private Boolean mIsBudgetScheduleEnabled = null;
    @SerializedName(value="is_direct_send_campaign")
    private Boolean mIsDirectSendCampaign = null;
    @SerializedName(value="is_message_campaign")
    private Boolean mIsMessageCampaign = null;
    @SerializedName(value="is_skadnetwork_attribution")
    private Boolean mIsSkadnetworkAttribution = null;
    @SerializedName(value="issues_info")
    private List<AdCampaignIssuesInfo> mIssuesInfo = null;
    @SerializedName(value="last_budget_toggling_time")
    private String mLastBudgetTogglingTime = null;
    @SerializedName(value="lifetime_budget")
    private String mLifetimeBudget = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="objective")
    private String mObjective = null;
    @SerializedName(value="pacing_type")
    private List<String> mPacingType = null;
    @SerializedName(value="primary_attribution")
    private String mPrimaryAttribution = null;
    @SerializedName(value="promoted_object")
    private AdPromotedObject mPromotedObject = null;
    @SerializedName(value="recommendations")
    private List<AdRecommendation> mRecommendations = null;
    @SerializedName(value="smart_promotion_type")
    private String mSmartPromotionType = null;
    @SerializedName(value="source_campaign")
    private Campaign mSourceCampaign = null;
    @SerializedName(value="source_campaign_id")
    private String mSourceCampaignId = null;
    @SerializedName(value="source_recommendation_type")
    private String mSourceRecommendationType = null;
    @SerializedName(value="special_ad_categories")
    private List<String> mSpecialAdCategories = null;
    @SerializedName(value="special_ad_category")
    private String mSpecialAdCategory = null;
    @SerializedName(value="special_ad_category_country")
    private List<String> mSpecialAdCategoryCountry = null;
    @SerializedName(value="spend_cap")
    private String mSpendCap = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    @SerializedName(value="stop_time")
    private String mStopTime = null;
    @SerializedName(value="topline_id")
    private String mToplineId = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    Campaign() {
    }

    public Campaign(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Campaign(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Campaign fetch() throws APIException {
        Campaign newInstance = Campaign.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Campaign fetchById(Long id, APIContext context) throws APIException {
        return Campaign.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Campaign> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Campaign.fetchByIdAsync(id.toString(), context);
    }

    public static Campaign fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Campaign> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Campaign> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Campaign>(context, "", "/", "GET", Campaign.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Campaign>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Campaign>(context, "", "/", "GET", Campaign.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Campaign loadJSON(String json, APIContext context, String header) {
        Campaign campaign = (Campaign)Campaign.getGson().fromJson(json, Campaign.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(campaign.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        campaign.context = context;
        campaign.rawValue = json;
        campaign.header = header;
        return campaign;
    }

    public static APINodeList<Campaign> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Campaign> campaigns = new APINodeList<Campaign>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        campaigns.add(Campaign.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return campaigns;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            campaigns.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        campaigns.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            campaigns.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            campaigns.add(Campaign.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                campaigns.add(Campaign.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            campaigns.add(Campaign.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return campaigns;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        campaigns.add(Campaign.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return campaigns;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        campaigns.add(Campaign.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return campaigns;
                }
                campaigns.clear();
                campaigns.add(Campaign.loadJSON(json, context, header));
                return campaigns;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Campaign.getGson().toJson((Object)this);
    }

    public APIRequestGetAdStudies getAdStudies() {
        return new APIRequestGetAdStudies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdLabel createAdLabel() {
        return new APIRequestCreateAdLabel(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdRulesGoverned getAdRulesGoverned() {
        return new APIRequestGetAdRulesGoverned(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAds getAds() {
        return new APIRequestGetAds(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdSets getAdSets() {
        return new APIRequestGetAdSets(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBudgetSchedules getBudgetSchedules() {
        return new APIRequestGetBudgetSchedules(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateBudgetSchedule createBudgetSchedule() {
        return new APIRequestCreateBudgetSchedule(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCopies getCopies() {
        return new APIRequestGetCopies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateCopy createCopy() {
        return new APIRequestCreateCopy(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInsightsAsync getInsightsAsync() {
        return new APIRequestGetInsightsAsync(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public List<AdLabel> getFieldAdlabels() {
        return this.mAdlabels;
    }

    public AdCampaignGroupAdvantageState getFieldAdvantageStateInfo() {
        return this.mAdvantageStateInfo;
    }

    public EnumBidStrategy getFieldBidStrategy() {
        return this.mBidStrategy;
    }

    public String getFieldBoostedObjectId() {
        return this.mBoostedObjectId;
    }

    public List<AdStudy> getFieldBrandLiftStudies() {
        return this.mBrandLiftStudies;
    }

    public Boolean getFieldBudgetRebalanceFlag() {
        return this.mBudgetRebalanceFlag;
    }

    public String getFieldBudgetRemaining() {
        return this.mBudgetRemaining;
    }

    public String getFieldBuyingType() {
        return this.mBuyingType;
    }

    public String getFieldCampaignGroupActiveTime() {
        return this.mCampaignGroupActiveTime;
    }

    public Boolean getFieldCanCreateBrandLiftStudy() {
        return this.mCanCreateBrandLiftStudy;
    }

    public Boolean getFieldCanUseSpendCap() {
        return this.mCanUseSpendCap;
    }

    public EnumConfiguredStatus getFieldConfiguredStatus() {
        return this.mConfiguredStatus;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDailyBudget() {
        return this.mDailyBudget;
    }

    public EnumEffectiveStatus getFieldEffectiveStatus() {
        return this.mEffectiveStatus;
    }

    public Boolean getFieldHasSecondarySkadnetworkReporting() {
        return this.mHasSecondarySkadnetworkReporting;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsAdsetBudgetSharingEnabled() {
        return this.mIsAdsetBudgetSharingEnabled;
    }

    public Boolean getFieldIsBudgetScheduleEnabled() {
        return this.mIsBudgetScheduleEnabled;
    }

    public Boolean getFieldIsDirectSendCampaign() {
        return this.mIsDirectSendCampaign;
    }

    public Boolean getFieldIsMessageCampaign() {
        return this.mIsMessageCampaign;
    }

    public Boolean getFieldIsSkadnetworkAttribution() {
        return this.mIsSkadnetworkAttribution;
    }

    public List<AdCampaignIssuesInfo> getFieldIssuesInfo() {
        return this.mIssuesInfo;
    }

    public String getFieldLastBudgetTogglingTime() {
        return this.mLastBudgetTogglingTime;
    }

    public String getFieldLifetimeBudget() {
        return this.mLifetimeBudget;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldObjective() {
        return this.mObjective;
    }

    public List<String> getFieldPacingType() {
        return this.mPacingType;
    }

    public String getFieldPrimaryAttribution() {
        return this.mPrimaryAttribution;
    }

    public AdPromotedObject getFieldPromotedObject() {
        return this.mPromotedObject;
    }

    public List<AdRecommendation> getFieldRecommendations() {
        return this.mRecommendations;
    }

    public String getFieldSmartPromotionType() {
        return this.mSmartPromotionType;
    }

    public Campaign getFieldSourceCampaign() {
        if (this.mSourceCampaign != null) {
            this.mSourceCampaign.context = this.getContext();
        }
        return this.mSourceCampaign;
    }

    public String getFieldSourceCampaignId() {
        return this.mSourceCampaignId;
    }

    public String getFieldSourceRecommendationType() {
        return this.mSourceRecommendationType;
    }

    public List<String> getFieldSpecialAdCategories() {
        return this.mSpecialAdCategories;
    }

    public String getFieldSpecialAdCategory() {
        return this.mSpecialAdCategory;
    }

    public List<String> getFieldSpecialAdCategoryCountry() {
        return this.mSpecialAdCategoryCountry;
    }

    public String getFieldSpendCap() {
        return this.mSpendCap;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldStopTime() {
        return this.mStopTime;
    }

    public String getFieldToplineId() {
        return this.mToplineId;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Campaign copyFrom(Campaign instance) {
        this.mAccountId = instance.mAccountId;
        this.mAdlabels = instance.mAdlabels;
        this.mAdvantageStateInfo = instance.mAdvantageStateInfo;
        this.mBidStrategy = instance.mBidStrategy;
        this.mBoostedObjectId = instance.mBoostedObjectId;
        this.mBrandLiftStudies = instance.mBrandLiftStudies;
        this.mBudgetRebalanceFlag = instance.mBudgetRebalanceFlag;
        this.mBudgetRemaining = instance.mBudgetRemaining;
        this.mBuyingType = instance.mBuyingType;
        this.mCampaignGroupActiveTime = instance.mCampaignGroupActiveTime;
        this.mCanCreateBrandLiftStudy = instance.mCanCreateBrandLiftStudy;
        this.mCanUseSpendCap = instance.mCanUseSpendCap;
        this.mConfiguredStatus = instance.mConfiguredStatus;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDailyBudget = instance.mDailyBudget;
        this.mEffectiveStatus = instance.mEffectiveStatus;
        this.mHasSecondarySkadnetworkReporting = instance.mHasSecondarySkadnetworkReporting;
        this.mId = instance.mId;
        this.mIsAdsetBudgetSharingEnabled = instance.mIsAdsetBudgetSharingEnabled;
        this.mIsBudgetScheduleEnabled = instance.mIsBudgetScheduleEnabled;
        this.mIsDirectSendCampaign = instance.mIsDirectSendCampaign;
        this.mIsMessageCampaign = instance.mIsMessageCampaign;
        this.mIsSkadnetworkAttribution = instance.mIsSkadnetworkAttribution;
        this.mIssuesInfo = instance.mIssuesInfo;
        this.mLastBudgetTogglingTime = instance.mLastBudgetTogglingTime;
        this.mLifetimeBudget = instance.mLifetimeBudget;
        this.mName = instance.mName;
        this.mObjective = instance.mObjective;
        this.mPacingType = instance.mPacingType;
        this.mPrimaryAttribution = instance.mPrimaryAttribution;
        this.mPromotedObject = instance.mPromotedObject;
        this.mRecommendations = instance.mRecommendations;
        this.mSmartPromotionType = instance.mSmartPromotionType;
        this.mSourceCampaign = instance.mSourceCampaign;
        this.mSourceCampaignId = instance.mSourceCampaignId;
        this.mSourceRecommendationType = instance.mSourceRecommendationType;
        this.mSpecialAdCategories = instance.mSpecialAdCategories;
        this.mSpecialAdCategory = instance.mSpecialAdCategory;
        this.mSpecialAdCategoryCountry = instance.mSpecialAdCategoryCountry;
        this.mSpendCap = instance.mSpendCap;
        this.mStartTime = instance.mStartTime;
        this.mStatus = instance.mStatus;
        this.mStopTime = instance.mStopTime;
        this.mToplineId = instance.mToplineId;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Campaign> getParser() {
        return new APIRequest.ResponseParser<Campaign>(){

            @Override
            public APINodeList<Campaign> parseResponse(String response, APIContext context, APIRequest<Campaign> request, String header) throws APIException.MalformedResponseException {
                return Campaign.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStatusOption {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_INHERITED_FROM_SOURCE("INHERITED_FROM_SOURCE"),
        VALUE_PAUSED("PAUSED");

        private String value;

        private EnumStatusOption(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumSpecialAdCategory {
        VALUE_CREDIT("CREDIT"),
        VALUE_EMPLOYMENT("EMPLOYMENT"),
        VALUE_FINANCIAL_PRODUCTS_SERVICES("FINANCIAL_PRODUCTS_SERVICES"),
        VALUE_HOUSING("HOUSING"),
        VALUE_ISSUES_ELECTIONS_POLITICS("ISSUES_ELECTIONS_POLITICS"),
        VALUE_NONE("NONE"),
        VALUE_ONLINE_GAMBLING_AND_GAMING("ONLINE_GAMBLING_AND_GAMING");

        private String value;

        private EnumSpecialAdCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumOperator {
        VALUE_ALL("ALL"),
        VALUE_ANY("ANY");

        private String value;

        private EnumOperator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumSpecialAdCategoryCountry {
        VALUE_AC("AC"),
        VALUE_AD("AD"),
        VALUE_AE("AE"),
        VALUE_AF("AF"),
        VALUE_AG("AG"),
        VALUE_AI("AI"),
        VALUE_AL("AL"),
        VALUE_AM("AM"),
        VALUE_AN("AN"),
        VALUE_AO("AO"),
        VALUE_AQ("AQ"),
        VALUE_AR("AR"),
        VALUE_AS("AS"),
        VALUE_AT("AT"),
        VALUE_AU("AU"),
        VALUE_AW("AW"),
        VALUE_AX("AX"),
        VALUE_AZ("AZ"),
        VALUE_BA("BA"),
        VALUE_BB("BB"),
        VALUE_BD("BD"),
        VALUE_BE("BE"),
        VALUE_BF("BF"),
        VALUE_BG("BG"),
        VALUE_BH("BH"),
        VALUE_BI("BI"),
        VALUE_BJ("BJ"),
        VALUE_BL("BL"),
        VALUE_BM("BM"),
        VALUE_BN("BN"),
        VALUE_BO("BO"),
        VALUE_BQ("BQ"),
        VALUE_BR("BR"),
        VALUE_BS("BS"),
        VALUE_BT("BT"),
        VALUE_BV("BV"),
        VALUE_BW("BW"),
        VALUE_BY("BY"),
        VALUE_BZ("BZ"),
        VALUE_CA("CA"),
        VALUE_CC("CC"),
        VALUE_CD("CD"),
        VALUE_CF("CF"),
        VALUE_CG("CG"),
        VALUE_CH("CH"),
        VALUE_CI("CI"),
        VALUE_CK("CK"),
        VALUE_CL("CL"),
        VALUE_CM("CM"),
        VALUE_CN("CN"),
        VALUE_CO("CO"),
        VALUE_CR("CR"),
        VALUE_CU("CU"),
        VALUE_CV("CV"),
        VALUE_CW("CW"),
        VALUE_CX("CX"),
        VALUE_CY("CY"),
        VALUE_CZ("CZ"),
        VALUE_DE("DE"),
        VALUE_DJ("DJ"),
        VALUE_DK("DK"),
        VALUE_DM("DM"),
        VALUE_DO("DO"),
        VALUE_DZ("DZ"),
        VALUE_EC("EC"),
        VALUE_EE("EE"),
        VALUE_EG("EG"),
        VALUE_EH("EH"),
        VALUE_ER("ER"),
        VALUE_ES("ES"),
        VALUE_ET("ET"),
        VALUE_FI("FI"),
        VALUE_FJ("FJ"),
        VALUE_FK("FK"),
        VALUE_FM("FM"),
        VALUE_FO("FO"),
        VALUE_FR("FR"),
        VALUE_GA("GA"),
        VALUE_GB("GB"),
        VALUE_GD("GD"),
        VALUE_GE("GE"),
        VALUE_GF("GF"),
        VALUE_GG("GG"),
        VALUE_GH("GH"),
        VALUE_GI("GI"),
        VALUE_GL("GL"),
        VALUE_GM("GM"),
        VALUE_GN("GN"),
        VALUE_GP("GP"),
        VALUE_GQ("GQ"),
        VALUE_GR("GR"),
        VALUE_GS("GS"),
        VALUE_GT("GT"),
        VALUE_GU("GU"),
        VALUE_GW("GW"),
        VALUE_GY("GY"),
        VALUE_HK("HK"),
        VALUE_HM("HM"),
        VALUE_HN("HN"),
        VALUE_HR("HR"),
        VALUE_HT("HT"),
        VALUE_HU("HU"),
        VALUE_ID("ID"),
        VALUE_IE("IE"),
        VALUE_IL("IL"),
        VALUE_IM("IM"),
        VALUE_IN("IN"),
        VALUE_IO("IO"),
        VALUE_IQ("IQ"),
        VALUE_IR("IR"),
        VALUE_IS("IS"),
        VALUE_IT("IT"),
        VALUE_JE("JE"),
        VALUE_JM("JM"),
        VALUE_JO("JO"),
        VALUE_JP("JP"),
        VALUE_KE("KE"),
        VALUE_KG("KG"),
        VALUE_KH("KH"),
        VALUE_KI("KI"),
        VALUE_KM("KM"),
        VALUE_KN("KN"),
        VALUE_KP("KP"),
        VALUE_KR("KR"),
        VALUE_KW("KW"),
        VALUE_KY("KY"),
        VALUE_KZ("KZ"),
        VALUE_LA("LA"),
        VALUE_LB("LB"),
        VALUE_LC("LC"),
        VALUE_LI("LI"),
        VALUE_LK("LK"),
        VALUE_LR("LR"),
        VALUE_LS("LS"),
        VALUE_LT("LT"),
        VALUE_LU("LU"),
        VALUE_LV("LV"),
        VALUE_LY("LY"),
        VALUE_MA("MA"),
        VALUE_MC("MC"),
        VALUE_MD("MD"),
        VALUE_ME("ME"),
        VALUE_MF("MF"),
        VALUE_MG("MG"),
        VALUE_MH("MH"),
        VALUE_MK("MK"),
        VALUE_ML("ML"),
        VALUE_MM("MM"),
        VALUE_MN("MN"),
        VALUE_MO("MO"),
        VALUE_MP("MP"),
        VALUE_MQ("MQ"),
        VALUE_MR("MR"),
        VALUE_MS("MS"),
        VALUE_MT("MT"),
        VALUE_MU("MU"),
        VALUE_MV("MV"),
        VALUE_MW("MW"),
        VALUE_MX("MX"),
        VALUE_MY("MY"),
        VALUE_MZ("MZ"),
        VALUE_NA("NA"),
        VALUE_NC("NC"),
        VALUE_NE("NE"),
        VALUE_NF("NF"),
        VALUE_NG("NG"),
        VALUE_NI("NI"),
        VALUE_NL("NL"),
        VALUE_NO("NO"),
        VALUE_NP("NP"),
        VALUE_NR("NR"),
        VALUE_NU("NU"),
        VALUE_NZ("NZ"),
        VALUE_OM("OM"),
        VALUE_PA("PA"),
        VALUE_PE("PE"),
        VALUE_PF("PF"),
        VALUE_PG("PG"),
        VALUE_PH("PH"),
        VALUE_PK("PK"),
        VALUE_PL("PL"),
        VALUE_PM("PM"),
        VALUE_PN("PN"),
        VALUE_PR("PR"),
        VALUE_PS("PS"),
        VALUE_PT("PT"),
        VALUE_PW("PW"),
        VALUE_PY("PY"),
        VALUE_QA("QA"),
        VALUE_RE("RE"),
        VALUE_RO("RO"),
        VALUE_RS("RS"),
        VALUE_RU("RU"),
        VALUE_RW("RW"),
        VALUE_SA("SA"),
        VALUE_SB("SB"),
        VALUE_SC("SC"),
        VALUE_SD("SD"),
        VALUE_SE("SE"),
        VALUE_SG("SG"),
        VALUE_SH("SH"),
        VALUE_SI("SI"),
        VALUE_SJ("SJ"),
        VALUE_SK("SK"),
        VALUE_SL("SL"),
        VALUE_SM("SM"),
        VALUE_SN("SN"),
        VALUE_SO("SO"),
        VALUE_SR("SR"),
        VALUE_SS("SS"),
        VALUE_ST("ST"),
        VALUE_SV("SV"),
        VALUE_SX("SX"),
        VALUE_SY("SY"),
        VALUE_SZ("SZ"),
        VALUE_TC("TC"),
        VALUE_TD("TD"),
        VALUE_TF("TF"),
        VALUE_TG("TG"),
        VALUE_TH("TH"),
        VALUE_TJ("TJ"),
        VALUE_TK("TK"),
        VALUE_TL("TL"),
        VALUE_TM("TM"),
        VALUE_TN("TN"),
        VALUE_TO("TO"),
        VALUE_TR("TR"),
        VALUE_TT("TT"),
        VALUE_TV("TV"),
        VALUE_TW("TW"),
        VALUE_TZ("TZ"),
        VALUE_UA("UA"),
        VALUE_UG("UG"),
        VALUE_UM("UM"),
        VALUE_US("US"),
        VALUE_UY("UY"),
        VALUE_UZ("UZ"),
        VALUE_VA("VA"),
        VALUE_VC("VC"),
        VALUE_VE("VE"),
        VALUE_VG("VG"),
        VALUE_VI("VI"),
        VALUE_VN("VN"),
        VALUE_VU("VU"),
        VALUE_WF("WF"),
        VALUE_WS("WS"),
        VALUE_XK("XK"),
        VALUE_YE("YE"),
        VALUE_YT("YT"),
        VALUE_ZA("ZA"),
        VALUE_ZM("ZM"),
        VALUE_ZW("ZW");

        private String value;

        private EnumSpecialAdCategoryCountry(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumSpecialAdCategories {
        VALUE_CREDIT("CREDIT"),
        VALUE_EMPLOYMENT("EMPLOYMENT"),
        VALUE_FINANCIAL_PRODUCTS_SERVICES("FINANCIAL_PRODUCTS_SERVICES"),
        VALUE_HOUSING("HOUSING"),
        VALUE_ISSUES_ELECTIONS_POLITICS("ISSUES_ELECTIONS_POLITICS"),
        VALUE_NONE("NONE"),
        VALUE_ONLINE_GAMBLING_AND_GAMING("ONLINE_GAMBLING_AND_GAMING");

        private String value;

        private EnumSpecialAdCategories(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumSmartPromotionType {
        VALUE_GUIDED_CREATION("GUIDED_CREATION"),
        VALUE_SMART_APP_PROMOTION("SMART_APP_PROMOTION");

        private String value;

        private EnumSmartPromotionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumObjective {
        VALUE_APP_INSTALLS("APP_INSTALLS"),
        VALUE_BRAND_AWARENESS("BRAND_AWARENESS"),
        VALUE_CONVERSIONS("CONVERSIONS"),
        VALUE_EVENT_RESPONSES("EVENT_RESPONSES"),
        VALUE_LEAD_GENERATION("LEAD_GENERATION"),
        VALUE_LINK_CLICKS("LINK_CLICKS"),
        VALUE_LOCAL_AWARENESS("LOCAL_AWARENESS"),
        VALUE_MESSAGES("MESSAGES"),
        VALUE_OFFER_CLAIMS("OFFER_CLAIMS"),
        VALUE_OUTCOME_APP_PROMOTION("OUTCOME_APP_PROMOTION"),
        VALUE_OUTCOME_AWARENESS("OUTCOME_AWARENESS"),
        VALUE_OUTCOME_ENGAGEMENT("OUTCOME_ENGAGEMENT"),
        VALUE_OUTCOME_LEADS("OUTCOME_LEADS"),
        VALUE_OUTCOME_SALES("OUTCOME_SALES"),
        VALUE_OUTCOME_TRAFFIC("OUTCOME_TRAFFIC"),
        VALUE_PAGE_LIKES("PAGE_LIKES"),
        VALUE_POST_ENGAGEMENT("POST_ENGAGEMENT"),
        VALUE_PRODUCT_CATALOG_SALES("PRODUCT_CATALOG_SALES"),
        VALUE_REACH("REACH"),
        VALUE_STORE_VISITS("STORE_VISITS"),
        VALUE_VIDEO_VIEWS("VIDEO_VIEWS");

        private String value;

        private EnumObjective(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumExecutionOptions {
        VALUE_INCLUDE_RECOMMENDATIONS("include_recommendations"),
        VALUE_VALIDATE_ONLY("validate_only");

        private String value;

        private EnumExecutionOptions(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumDatePreset {
        VALUE_DATA_MAXIMUM("data_maximum"),
        VALUE_LAST_14D("last_14d"),
        VALUE_LAST_28D("last_28d"),
        VALUE_LAST_30D("last_30d"),
        VALUE_LAST_3D("last_3d"),
        VALUE_LAST_7D("last_7d"),
        VALUE_LAST_90D("last_90d"),
        VALUE_LAST_MONTH("last_month"),
        VALUE_LAST_QUARTER("last_quarter"),
        VALUE_LAST_WEEK_MON_SUN("last_week_mon_sun"),
        VALUE_LAST_WEEK_SUN_SAT("last_week_sun_sat"),
        VALUE_LAST_YEAR("last_year"),
        VALUE_MAXIMUM("maximum"),
        VALUE_THIS_MONTH("this_month"),
        VALUE_THIS_QUARTER("this_quarter"),
        VALUE_THIS_WEEK_MON_TODAY("this_week_mon_today"),
        VALUE_THIS_WEEK_SUN_TODAY("this_week_sun_today"),
        VALUE_THIS_YEAR("this_year"),
        VALUE_TODAY("today"),
        VALUE_YESTERDAY("yesterday");

        private String value;

        private EnumDatePreset(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_DELETED("DELETED"),
        VALUE_PAUSED("PAUSED");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumEffectiveStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_DELETED("DELETED"),
        VALUE_IN_PROCESS("IN_PROCESS"),
        VALUE_PAUSED("PAUSED"),
        VALUE_WITH_ISSUES("WITH_ISSUES");

        private String value;

        private EnumEffectiveStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumConfiguredStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_DELETED("DELETED"),
        VALUE_PAUSED("PAUSED");

        private String value;

        private EnumConfiguredStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumBidStrategy {
        VALUE_COST_CAP("COST_CAP"),
        VALUE_LOWEST_COST_WITHOUT_CAP("LOWEST_COST_WITHOUT_CAP"),
        VALUE_LOWEST_COST_WITH_BID_CAP("LOWEST_COST_WITH_BID_CAP"),
        VALUE_LOWEST_COST_WITH_MIN_ROAS("LOWEST_COST_WITH_MIN_ROAS");

        private String value;

        private EnumBidStrategy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<Campaign> {
        Campaign lastResponse = null;
        public static final String[] PARAMS = new String[]{"adlabels", "adset_bid_amounts", "adset_budgets", "bid_strategy", "budget_rebalance_flag", "budget_schedule_specs", "daily_budget", "execution_options", "is_adset_budget_sharing_enabled", "is_budget_schedule_enabled", "is_direct_send_campaign", "is_message_campaign", "is_skadnetwork_attribution", "iterative_split_test_configs", "lifetime_budget", "migrate_to_advantage_plus", "name", "objective", "pacing_type", "promoted_object", "smart_promotion_type", "special_ad_categories", "special_ad_category", "special_ad_category_country", "spend_cap", "start_time", "status", "stop_time"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Campaign getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Campaign parseResponse(String response, String header) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Campaign execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Campaign execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Campaign> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Campaign> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Campaign>(){

                public Campaign apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestUpdate setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestUpdate setAdsetBidAmounts(Map<String, String> adsetBidAmounts) {
            this.setParam("adset_bid_amounts", adsetBidAmounts);
            return this;
        }

        public APIRequestUpdate setAdsetBidAmounts(String adsetBidAmounts) {
            this.setParam("adset_bid_amounts", adsetBidAmounts);
            return this;
        }

        public APIRequestUpdate setAdsetBudgets(List<Map<String, String>> adsetBudgets) {
            this.setParam("adset_budgets", adsetBudgets);
            return this;
        }

        public APIRequestUpdate setAdsetBudgets(String adsetBudgets) {
            this.setParam("adset_budgets", adsetBudgets);
            return this;
        }

        public APIRequestUpdate setBidStrategy(EnumBidStrategy bidStrategy) {
            this.setParam("bid_strategy", (Object)bidStrategy);
            return this;
        }

        public APIRequestUpdate setBidStrategy(String bidStrategy) {
            this.setParam("bid_strategy", bidStrategy);
            return this;
        }

        public APIRequestUpdate setBudgetRebalanceFlag(Boolean budgetRebalanceFlag) {
            this.setParam("budget_rebalance_flag", budgetRebalanceFlag);
            return this;
        }

        public APIRequestUpdate setBudgetRebalanceFlag(String budgetRebalanceFlag) {
            this.setParam("budget_rebalance_flag", budgetRebalanceFlag);
            return this;
        }

        public APIRequestUpdate setBudgetScheduleSpecs(List<Object> budgetScheduleSpecs) {
            this.setParam("budget_schedule_specs", budgetScheduleSpecs);
            return this;
        }

        public APIRequestUpdate setBudgetScheduleSpecs(String budgetScheduleSpecs) {
            this.setParam("budget_schedule_specs", budgetScheduleSpecs);
            return this;
        }

        public APIRequestUpdate setDailyBudget(Long dailyBudget) {
            this.setParam("daily_budget", dailyBudget);
            return this;
        }

        public APIRequestUpdate setDailyBudget(String dailyBudget) {
            this.setParam("daily_budget", dailyBudget);
            return this;
        }

        public APIRequestUpdate setExecutionOptions(List<EnumExecutionOptions> executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestUpdate setExecutionOptions(String executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestUpdate setIsAdsetBudgetSharingEnabled(Boolean isAdsetBudgetSharingEnabled) {
            this.setParam("is_adset_budget_sharing_enabled", isAdsetBudgetSharingEnabled);
            return this;
        }

        public APIRequestUpdate setIsAdsetBudgetSharingEnabled(String isAdsetBudgetSharingEnabled) {
            this.setParam("is_adset_budget_sharing_enabled", isAdsetBudgetSharingEnabled);
            return this;
        }

        public APIRequestUpdate setIsBudgetScheduleEnabled(Boolean isBudgetScheduleEnabled) {
            this.setParam("is_budget_schedule_enabled", isBudgetScheduleEnabled);
            return this;
        }

        public APIRequestUpdate setIsBudgetScheduleEnabled(String isBudgetScheduleEnabled) {
            this.setParam("is_budget_schedule_enabled", isBudgetScheduleEnabled);
            return this;
        }

        public APIRequestUpdate setIsDirectSendCampaign(Boolean isDirectSendCampaign) {
            this.setParam("is_direct_send_campaign", isDirectSendCampaign);
            return this;
        }

        public APIRequestUpdate setIsDirectSendCampaign(String isDirectSendCampaign) {
            this.setParam("is_direct_send_campaign", isDirectSendCampaign);
            return this;
        }

        public APIRequestUpdate setIsMessageCampaign(Boolean isMessageCampaign) {
            this.setParam("is_message_campaign", isMessageCampaign);
            return this;
        }

        public APIRequestUpdate setIsMessageCampaign(String isMessageCampaign) {
            this.setParam("is_message_campaign", isMessageCampaign);
            return this;
        }

        public APIRequestUpdate setIsSkadnetworkAttribution(Boolean isSkadnetworkAttribution) {
            this.setParam("is_skadnetwork_attribution", isSkadnetworkAttribution);
            return this;
        }

        public APIRequestUpdate setIsSkadnetworkAttribution(String isSkadnetworkAttribution) {
            this.setParam("is_skadnetwork_attribution", isSkadnetworkAttribution);
            return this;
        }

        public APIRequestUpdate setIterativeSplitTestConfigs(List<Object> iterativeSplitTestConfigs) {
            this.setParam("iterative_split_test_configs", iterativeSplitTestConfigs);
            return this;
        }

        public APIRequestUpdate setIterativeSplitTestConfigs(String iterativeSplitTestConfigs) {
            this.setParam("iterative_split_test_configs", iterativeSplitTestConfigs);
            return this;
        }

        public APIRequestUpdate setLifetimeBudget(Long lifetimeBudget) {
            this.setParam("lifetime_budget", lifetimeBudget);
            return this;
        }

        public APIRequestUpdate setLifetimeBudget(String lifetimeBudget) {
            this.setParam("lifetime_budget", lifetimeBudget);
            return this;
        }

        public APIRequestUpdate setMigrateToAdvantagePlus(Boolean migrateToAdvantagePlus) {
            this.setParam("migrate_to_advantage_plus", migrateToAdvantagePlus);
            return this;
        }

        public APIRequestUpdate setMigrateToAdvantagePlus(String migrateToAdvantagePlus) {
            this.setParam("migrate_to_advantage_plus", migrateToAdvantagePlus);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setObjective(EnumObjective objective) {
            this.setParam("objective", (Object)objective);
            return this;
        }

        public APIRequestUpdate setObjective(String objective) {
            this.setParam("objective", objective);
            return this;
        }

        public APIRequestUpdate setPacingType(List<String> pacingType) {
            this.setParam("pacing_type", pacingType);
            return this;
        }

        public APIRequestUpdate setPacingType(String pacingType) {
            this.setParam("pacing_type", pacingType);
            return this;
        }

        public APIRequestUpdate setPromotedObject(Object promotedObject) {
            this.setParam("promoted_object", promotedObject);
            return this;
        }

        public APIRequestUpdate setPromotedObject(String promotedObject) {
            this.setParam("promoted_object", promotedObject);
            return this;
        }

        public APIRequestUpdate setSmartPromotionType(EnumSmartPromotionType smartPromotionType) {
            this.setParam("smart_promotion_type", (Object)smartPromotionType);
            return this;
        }

        public APIRequestUpdate setSmartPromotionType(String smartPromotionType) {
            this.setParam("smart_promotion_type", smartPromotionType);
            return this;
        }

        public APIRequestUpdate setSpecialAdCategories(List<EnumSpecialAdCategories> specialAdCategories) {
            this.setParam("special_ad_categories", specialAdCategories);
            return this;
        }

        public APIRequestUpdate setSpecialAdCategories(String specialAdCategories) {
            this.setParam("special_ad_categories", specialAdCategories);
            return this;
        }

        public APIRequestUpdate setSpecialAdCategory(EnumSpecialAdCategory specialAdCategory) {
            this.setParam("special_ad_category", (Object)specialAdCategory);
            return this;
        }

        public APIRequestUpdate setSpecialAdCategory(String specialAdCategory) {
            this.setParam("special_ad_category", specialAdCategory);
            return this;
        }

        public APIRequestUpdate setSpecialAdCategoryCountry(List<EnumSpecialAdCategoryCountry> specialAdCategoryCountry) {
            this.setParam("special_ad_category_country", specialAdCategoryCountry);
            return this;
        }

        public APIRequestUpdate setSpecialAdCategoryCountry(String specialAdCategoryCountry) {
            this.setParam("special_ad_category_country", specialAdCategoryCountry);
            return this;
        }

        public APIRequestUpdate setSpendCap(Long spendCap) {
            this.setParam("spend_cap", spendCap);
            return this;
        }

        public APIRequestUpdate setSpendCap(String spendCap) {
            this.setParam("spend_cap", spendCap);
            return this;
        }

        public APIRequestUpdate setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestUpdate setStatus(EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestUpdate setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestUpdate setStopTime(String stopTime) {
            this.setParam("stop_time", stopTime);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<Campaign> {
        Campaign lastResponse = null;
        public static final String[] PARAMS = new String[]{"am_call_tags", "date_preset", "from_adtable", "time_range"};
        public static final String[] FIELDS = new String[]{"account_id", "adlabels", "advantage_state_info", "bid_strategy", "boosted_object_id", "brand_lift_studies", "budget_rebalance_flag", "budget_remaining", "buying_type", "campaign_group_active_time", "can_create_brand_lift_study", "can_use_spend_cap", "configured_status", "created_time", "daily_budget", "effective_status", "has_secondary_skadnetwork_reporting", "id", "is_adset_budget_sharing_enabled", "is_budget_schedule_enabled", "is_direct_send_campaign", "is_message_campaign", "is_skadnetwork_attribution", "issues_info", "last_budget_toggling_time", "lifetime_budget", "name", "objective", "pacing_type", "primary_attribution", "promoted_object", "recommendations", "smart_promotion_type", "source_campaign", "source_campaign_id", "source_recommendation_type", "special_ad_categories", "special_ad_category", "special_ad_category_country", "spend_cap", "start_time", "status", "stop_time", "topline_id", "updated_time"};

        @Override
        public Campaign getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Campaign parseResponse(String response, String header) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Campaign execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Campaign execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Campaign> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Campaign> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Campaign>(){

                public Campaign apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet setAmCallTags(Map<String, String> amCallTags) {
            this.setParam("am_call_tags", amCallTags);
            return this;
        }

        public APIRequestGet setAmCallTags(String amCallTags) {
            this.setParam("am_call_tags", amCallTags);
            return this;
        }

        public APIRequestGet setDatePreset(EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGet setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGet setFromAdtable(Boolean fromAdtable) {
            this.setParam("from_adtable", fromAdtable);
            return this;
        }

        public APIRequestGet setFromAdtable(String fromAdtable) {
            this.setParam("from_adtable", fromAdtable);
            return this;
        }

        public APIRequestGet setTimeRange(Map<String, String> timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGet setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGet requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGet requestAdvantageStateInfoField() {
            return this.requestAdvantageStateInfoField(true);
        }

        public APIRequestGet requestAdvantageStateInfoField(boolean value) {
            this.requestField("advantage_state_info", value);
            return this;
        }

        public APIRequestGet requestBidStrategyField() {
            return this.requestBidStrategyField(true);
        }

        public APIRequestGet requestBidStrategyField(boolean value) {
            this.requestField("bid_strategy", value);
            return this;
        }

        public APIRequestGet requestBoostedObjectIdField() {
            return this.requestBoostedObjectIdField(true);
        }

        public APIRequestGet requestBoostedObjectIdField(boolean value) {
            this.requestField("boosted_object_id", value);
            return this;
        }

        public APIRequestGet requestBrandLiftStudiesField() {
            return this.requestBrandLiftStudiesField(true);
        }

        public APIRequestGet requestBrandLiftStudiesField(boolean value) {
            this.requestField("brand_lift_studies", value);
            return this;
        }

        public APIRequestGet requestBudgetRebalanceFlagField() {
            return this.requestBudgetRebalanceFlagField(true);
        }

        public APIRequestGet requestBudgetRebalanceFlagField(boolean value) {
            this.requestField("budget_rebalance_flag", value);
            return this;
        }

        public APIRequestGet requestBudgetRemainingField() {
            return this.requestBudgetRemainingField(true);
        }

        public APIRequestGet requestBudgetRemainingField(boolean value) {
            this.requestField("budget_remaining", value);
            return this;
        }

        public APIRequestGet requestBuyingTypeField() {
            return this.requestBuyingTypeField(true);
        }

        public APIRequestGet requestBuyingTypeField(boolean value) {
            this.requestField("buying_type", value);
            return this;
        }

        public APIRequestGet requestCampaignGroupActiveTimeField() {
            return this.requestCampaignGroupActiveTimeField(true);
        }

        public APIRequestGet requestCampaignGroupActiveTimeField(boolean value) {
            this.requestField("campaign_group_active_time", value);
            return this;
        }

        public APIRequestGet requestCanCreateBrandLiftStudyField() {
            return this.requestCanCreateBrandLiftStudyField(true);
        }

        public APIRequestGet requestCanCreateBrandLiftStudyField(boolean value) {
            this.requestField("can_create_brand_lift_study", value);
            return this;
        }

        public APIRequestGet requestCanUseSpendCapField() {
            return this.requestCanUseSpendCapField(true);
        }

        public APIRequestGet requestCanUseSpendCapField(boolean value) {
            this.requestField("can_use_spend_cap", value);
            return this;
        }

        public APIRequestGet requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGet requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDailyBudgetField() {
            return this.requestDailyBudgetField(true);
        }

        public APIRequestGet requestDailyBudgetField(boolean value) {
            this.requestField("daily_budget", value);
            return this;
        }

        public APIRequestGet requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGet requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGet requestHasSecondarySkadnetworkReportingField() {
            return this.requestHasSecondarySkadnetworkReportingField(true);
        }

        public APIRequestGet requestHasSecondarySkadnetworkReportingField(boolean value) {
            this.requestField("has_secondary_skadnetwork_reporting", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsAdsetBudgetSharingEnabledField() {
            return this.requestIsAdsetBudgetSharingEnabledField(true);
        }

        public APIRequestGet requestIsAdsetBudgetSharingEnabledField(boolean value) {
            this.requestField("is_adset_budget_sharing_enabled", value);
            return this;
        }

        public APIRequestGet requestIsBudgetScheduleEnabledField() {
            return this.requestIsBudgetScheduleEnabledField(true);
        }

        public APIRequestGet requestIsBudgetScheduleEnabledField(boolean value) {
            this.requestField("is_budget_schedule_enabled", value);
            return this;
        }

        public APIRequestGet requestIsDirectSendCampaignField() {
            return this.requestIsDirectSendCampaignField(true);
        }

        public APIRequestGet requestIsDirectSendCampaignField(boolean value) {
            this.requestField("is_direct_send_campaign", value);
            return this;
        }

        public APIRequestGet requestIsMessageCampaignField() {
            return this.requestIsMessageCampaignField(true);
        }

        public APIRequestGet requestIsMessageCampaignField(boolean value) {
            this.requestField("is_message_campaign", value);
            return this;
        }

        public APIRequestGet requestIsSkadnetworkAttributionField() {
            return this.requestIsSkadnetworkAttributionField(true);
        }

        public APIRequestGet requestIsSkadnetworkAttributionField(boolean value) {
            this.requestField("is_skadnetwork_attribution", value);
            return this;
        }

        public APIRequestGet requestIssuesInfoField() {
            return this.requestIssuesInfoField(true);
        }

        public APIRequestGet requestIssuesInfoField(boolean value) {
            this.requestField("issues_info", value);
            return this;
        }

        public APIRequestGet requestLastBudgetTogglingTimeField() {
            return this.requestLastBudgetTogglingTimeField(true);
        }

        public APIRequestGet requestLastBudgetTogglingTimeField(boolean value) {
            this.requestField("last_budget_toggling_time", value);
            return this;
        }

        public APIRequestGet requestLifetimeBudgetField() {
            return this.requestLifetimeBudgetField(true);
        }

        public APIRequestGet requestLifetimeBudgetField(boolean value) {
            this.requestField("lifetime_budget", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestObjectiveField() {
            return this.requestObjectiveField(true);
        }

        public APIRequestGet requestObjectiveField(boolean value) {
            this.requestField("objective", value);
            return this;
        }

        public APIRequestGet requestPacingTypeField() {
            return this.requestPacingTypeField(true);
        }

        public APIRequestGet requestPacingTypeField(boolean value) {
            this.requestField("pacing_type", value);
            return this;
        }

        public APIRequestGet requestPrimaryAttributionField() {
            return this.requestPrimaryAttributionField(true);
        }

        public APIRequestGet requestPrimaryAttributionField(boolean value) {
            this.requestField("primary_attribution", value);
            return this;
        }

        public APIRequestGet requestPromotedObjectField() {
            return this.requestPromotedObjectField(true);
        }

        public APIRequestGet requestPromotedObjectField(boolean value) {
            this.requestField("promoted_object", value);
            return this;
        }

        public APIRequestGet requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGet requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGet requestSmartPromotionTypeField() {
            return this.requestSmartPromotionTypeField(true);
        }

        public APIRequestGet requestSmartPromotionTypeField(boolean value) {
            this.requestField("smart_promotion_type", value);
            return this;
        }

        public APIRequestGet requestSourceCampaignField() {
            return this.requestSourceCampaignField(true);
        }

        public APIRequestGet requestSourceCampaignField(boolean value) {
            this.requestField("source_campaign", value);
            return this;
        }

        public APIRequestGet requestSourceCampaignIdField() {
            return this.requestSourceCampaignIdField(true);
        }

        public APIRequestGet requestSourceCampaignIdField(boolean value) {
            this.requestField("source_campaign_id", value);
            return this;
        }

        public APIRequestGet requestSourceRecommendationTypeField() {
            return this.requestSourceRecommendationTypeField(true);
        }

        public APIRequestGet requestSourceRecommendationTypeField(boolean value) {
            this.requestField("source_recommendation_type", value);
            return this;
        }

        public APIRequestGet requestSpecialAdCategoriesField() {
            return this.requestSpecialAdCategoriesField(true);
        }

        public APIRequestGet requestSpecialAdCategoriesField(boolean value) {
            this.requestField("special_ad_categories", value);
            return this;
        }

        public APIRequestGet requestSpecialAdCategoryField() {
            return this.requestSpecialAdCategoryField(true);
        }

        public APIRequestGet requestSpecialAdCategoryField(boolean value) {
            this.requestField("special_ad_category", value);
            return this;
        }

        public APIRequestGet requestSpecialAdCategoryCountryField() {
            return this.requestSpecialAdCategoryCountryField(true);
        }

        public APIRequestGet requestSpecialAdCategoryCountryField(boolean value) {
            this.requestField("special_ad_category_country", value);
            return this;
        }

        public APIRequestGet requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGet requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestStopTimeField() {
            return this.requestStopTimeField(true);
        }

        public APIRequestGet requestStopTimeField(boolean value) {
            this.requestField("stop_time", value);
            return this;
        }

        public APIRequestGet requestToplineIdField() {
            return this.requestToplineIdField(true);
        }

        public APIRequestGet requestToplineIdField(boolean value) {
            this.requestField("topline_id", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetInsightsAsync
    extends APIRequest<AdReportRun> {
        AdReportRun lastResponse = null;
        public static final String[] PARAMS = new String[]{"action_attribution_windows", "action_breakdowns", "action_report_time", "breakdowns", "date_preset", "default_summary", "export_columns", "export_format", "export_name", "fields", "filtering", "graph_cache", "level", "limit", "product_id_limit", "sort", "summary", "summary_action_breakdowns", "time_increment", "time_range", "time_ranges", "use_account_attribution_setting", "use_unified_attribution_setting"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdReportRun getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdReportRun parseResponse(String response, String header) throws APIException {
            return AdReportRun.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdReportRun execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdReportRun execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdReportRun> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdReportRun> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdReportRun>(){

                public AdReportRun apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetInsightsAsync(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsightsAsync setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsightsAsync setActionAttributionWindows(List<AdsInsights.EnumActionAttributionWindows> actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsightsAsync setActionAttributionWindows(String actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsightsAsync setActionBreakdowns(List<AdsInsights.EnumActionBreakdowns> actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setActionBreakdowns(String actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setActionReportTime(AdsInsights.EnumActionReportTime actionReportTime) {
            this.setParam("action_report_time", (Object)actionReportTime);
            return this;
        }

        public APIRequestGetInsightsAsync setActionReportTime(String actionReportTime) {
            this.setParam("action_report_time", actionReportTime);
            return this;
        }

        public APIRequestGetInsightsAsync setBreakdowns(List<AdsInsights.EnumBreakdowns> breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setBreakdowns(String breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setDatePreset(AdsInsights.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetInsightsAsync setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetInsightsAsync setDefaultSummary(Boolean defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsightsAsync setDefaultSummary(String defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsightsAsync setExportColumns(List<String> exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsightsAsync setExportColumns(String exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsightsAsync setExportFormat(String exportFormat) {
            this.setParam("export_format", exportFormat);
            return this;
        }

        public APIRequestGetInsightsAsync setExportName(String exportName) {
            this.setParam("export_name", exportName);
            return this;
        }

        public APIRequestGetInsightsAsync setFields(List<String> fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsightsAsync setFields(String fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsightsAsync setFiltering(List<Object> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsightsAsync setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsightsAsync setGraphCache(Boolean graphCache) {
            this.setParam("graph_cache", graphCache);
            return this;
        }

        public APIRequestGetInsightsAsync setGraphCache(String graphCache) {
            this.setParam("graph_cache", graphCache);
            return this;
        }

        public APIRequestGetInsightsAsync setLevel(AdsInsights.EnumLevel level) {
            this.setParam("level", (Object)level);
            return this;
        }

        public APIRequestGetInsightsAsync setLevel(String level) {
            this.setParam("level", level);
            return this;
        }

        public APIRequestGetInsightsAsync setLimit(Long limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestGetInsightsAsync setLimit(String limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestGetInsightsAsync setProductIdLimit(Long productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsightsAsync setProductIdLimit(String productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsightsAsync setSort(List<String> sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsightsAsync setSort(String sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsightsAsync setSummary(List<String> summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsightsAsync setSummary(String summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsightsAsync setSummaryActionBreakdowns(List<AdsInsights.EnumSummaryActionBreakdowns> summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setSummaryActionBreakdowns(String summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeIncrement(String timeIncrement) {
            this.setParam("time_increment", timeIncrement);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRange(Map<String, String> timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRanges(List<Map<String, String>> timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsightsAsync setTimeRanges(String timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsightsAsync setUseAccountAttributionSetting(Boolean useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsightsAsync setUseAccountAttributionSetting(String useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsightsAsync setUseUnifiedAttributionSetting(Boolean useUnifiedAttributionSetting) {
            this.setParam("use_unified_attribution_setting", useUnifiedAttributionSetting);
            return this;
        }

        public APIRequestGetInsightsAsync setUseUnifiedAttributionSetting(String useUnifiedAttributionSetting) {
            this.setParam("use_unified_attribution_setting", useUnifiedAttributionSetting);
            return this;
        }

        public APIRequestGetInsightsAsync requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsightsAsync requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsightsAsync requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsightsAsync requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetInsights
    extends APIRequest<AdsInsights> {
        APINodeList<AdsInsights> lastResponse = null;
        public static final String[] PARAMS = new String[]{"action_attribution_windows", "action_breakdowns", "action_report_time", "breakdowns", "date_preset", "default_summary", "export_columns", "export_format", "export_name", "fields", "filtering", "graph_cache", "level", "limit", "product_id_limit", "sort", "summary", "summary_action_breakdowns", "time_increment", "time_range", "time_ranges", "use_account_attribution_setting", "use_unified_attribution_setting"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<AdsInsights> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsInsights> parseResponse(String response, String header) throws APIException {
            return AdsInsights.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdsInsights> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsInsights> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdsInsights>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdsInsights>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdsInsights>>(){

                public APINodeList<AdsInsights> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights setActionAttributionWindows(List<AdsInsights.EnumActionAttributionWindows> actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsights setActionAttributionWindows(String actionAttributionWindows) {
            this.setParam("action_attribution_windows", actionAttributionWindows);
            return this;
        }

        public APIRequestGetInsights setActionBreakdowns(List<AdsInsights.EnumActionBreakdowns> actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setActionBreakdowns(String actionBreakdowns) {
            this.setParam("action_breakdowns", actionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setActionReportTime(AdsInsights.EnumActionReportTime actionReportTime) {
            this.setParam("action_report_time", (Object)actionReportTime);
            return this;
        }

        public APIRequestGetInsights setActionReportTime(String actionReportTime) {
            this.setParam("action_report_time", actionReportTime);
            return this;
        }

        public APIRequestGetInsights setBreakdowns(List<AdsInsights.EnumBreakdowns> breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsights setBreakdowns(String breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetInsights setDatePreset(AdsInsights.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetInsights setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetInsights setDefaultSummary(Boolean defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsights setDefaultSummary(String defaultSummary) {
            this.setParam("default_summary", defaultSummary);
            return this;
        }

        public APIRequestGetInsights setExportColumns(List<String> exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsights setExportColumns(String exportColumns) {
            this.setParam("export_columns", exportColumns);
            return this;
        }

        public APIRequestGetInsights setExportFormat(String exportFormat) {
            this.setParam("export_format", exportFormat);
            return this;
        }

        public APIRequestGetInsights setExportName(String exportName) {
            this.setParam("export_name", exportName);
            return this;
        }

        public APIRequestGetInsights setFields(List<String> fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsights setFields(String fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestGetInsights setFiltering(List<Object> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsights setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestGetInsights setGraphCache(Boolean graphCache) {
            this.setParam("graph_cache", graphCache);
            return this;
        }

        public APIRequestGetInsights setGraphCache(String graphCache) {
            this.setParam("graph_cache", graphCache);
            return this;
        }

        public APIRequestGetInsights setLevel(AdsInsights.EnumLevel level) {
            this.setParam("level", (Object)level);
            return this;
        }

        public APIRequestGetInsights setLevel(String level) {
            this.setParam("level", level);
            return this;
        }

        public APIRequestGetInsights setLimit(Long limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestGetInsights setLimit(String limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestGetInsights setProductIdLimit(Long productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsights setProductIdLimit(String productIdLimit) {
            this.setParam("product_id_limit", productIdLimit);
            return this;
        }

        public APIRequestGetInsights setSort(List<String> sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsights setSort(String sort) {
            this.setParam("sort", sort);
            return this;
        }

        public APIRequestGetInsights setSummary(List<String> summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsights setSummary(String summary) {
            this.setParam("summary", summary);
            return this;
        }

        public APIRequestGetInsights setSummaryActionBreakdowns(List<AdsInsights.EnumSummaryActionBreakdowns> summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setSummaryActionBreakdowns(String summaryActionBreakdowns) {
            this.setParam("summary_action_breakdowns", summaryActionBreakdowns);
            return this;
        }

        public APIRequestGetInsights setTimeIncrement(String timeIncrement) {
            this.setParam("time_increment", timeIncrement);
            return this;
        }

        public APIRequestGetInsights setTimeRange(Map<String, String> timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsights setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetInsights setTimeRanges(List<Map<String, String>> timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsights setTimeRanges(String timeRanges) {
            this.setParam("time_ranges", timeRanges);
            return this;
        }

        public APIRequestGetInsights setUseAccountAttributionSetting(Boolean useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsights setUseAccountAttributionSetting(String useAccountAttributionSetting) {
            this.setParam("use_account_attribution_setting", useAccountAttributionSetting);
            return this;
        }

        public APIRequestGetInsights setUseUnifiedAttributionSetting(Boolean useUnifiedAttributionSetting) {
            this.setParam("use_unified_attribution_setting", useUnifiedAttributionSetting);
            return this;
        }

        public APIRequestGetInsights setUseUnifiedAttributionSetting(String useUnifiedAttributionSetting) {
            this.setParam("use_unified_attribution_setting", useUnifiedAttributionSetting);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateCopy
    extends APIRequest<Campaign> {
        Campaign lastResponse = null;
        public static final String[] PARAMS = new String[]{"deep_copy", "end_time", "migrate_to_advantage_plus", "parameter_overrides", "rename_options", "start_time", "status_option"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Campaign getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Campaign parseResponse(String response, String header) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Campaign execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Campaign execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Campaign> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Campaign> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Campaign>(){

                public Campaign apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateCopy(String nodeId, APIContext context) {
            super(context, nodeId, "/copies", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateCopy setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateCopy setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateCopy setDeepCopy(Boolean deepCopy) {
            this.setParam("deep_copy", deepCopy);
            return this;
        }

        public APIRequestCreateCopy setDeepCopy(String deepCopy) {
            this.setParam("deep_copy", deepCopy);
            return this;
        }

        public APIRequestCreateCopy setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateCopy setMigrateToAdvantagePlus(Boolean migrateToAdvantagePlus) {
            this.setParam("migrate_to_advantage_plus", migrateToAdvantagePlus);
            return this;
        }

        public APIRequestCreateCopy setMigrateToAdvantagePlus(String migrateToAdvantagePlus) {
            this.setParam("migrate_to_advantage_plus", migrateToAdvantagePlus);
            return this;
        }

        public APIRequestCreateCopy setParameterOverrides(Object parameterOverrides) {
            this.setParam("parameter_overrides", parameterOverrides);
            return this;
        }

        public APIRequestCreateCopy setParameterOverrides(String parameterOverrides) {
            this.setParam("parameter_overrides", parameterOverrides);
            return this;
        }

        public APIRequestCreateCopy setRenameOptions(Object renameOptions) {
            this.setParam("rename_options", renameOptions);
            return this;
        }

        public APIRequestCreateCopy setRenameOptions(String renameOptions) {
            this.setParam("rename_options", renameOptions);
            return this;
        }

        public APIRequestCreateCopy setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestCreateCopy setStatusOption(EnumStatusOption statusOption) {
            this.setParam("status_option", (Object)statusOption);
            return this;
        }

        public APIRequestCreateCopy setStatusOption(String statusOption) {
            this.setParam("status_option", statusOption);
            return this;
        }

        public APIRequestCreateCopy requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateCopy requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCopy requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateCopy requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCopy requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateCopy requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetCopies
    extends APIRequest<Campaign> {
        APINodeList<Campaign> lastResponse = null;
        public static final String[] PARAMS = new String[]{"date_preset", "effective_status", "is_completed", "time_range"};
        public static final String[] FIELDS = new String[]{"account_id", "adlabels", "advantage_state_info", "bid_strategy", "boosted_object_id", "brand_lift_studies", "budget_rebalance_flag", "budget_remaining", "buying_type", "campaign_group_active_time", "can_create_brand_lift_study", "can_use_spend_cap", "configured_status", "created_time", "daily_budget", "effective_status", "has_secondary_skadnetwork_reporting", "id", "is_adset_budget_sharing_enabled", "is_budget_schedule_enabled", "is_direct_send_campaign", "is_message_campaign", "is_skadnetwork_attribution", "issues_info", "last_budget_toggling_time", "lifetime_budget", "name", "objective", "pacing_type", "primary_attribution", "promoted_object", "recommendations", "smart_promotion_type", "source_campaign", "source_campaign_id", "source_recommendation_type", "special_ad_categories", "special_ad_category", "special_ad_category_country", "spend_cap", "start_time", "status", "stop_time", "topline_id", "updated_time"};

        @Override
        public APINodeList<Campaign> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Campaign> parseResponse(String response, String header) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Campaign> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Campaign> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Campaign>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Campaign>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Campaign>>(){

                public APINodeList<Campaign> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetCopies(String nodeId, APIContext context) {
            super(context, nodeId, "/copies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCopies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCopies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCopies setDatePreset(EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetCopies setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetCopies setEffectiveStatus(List<EnumEffectiveStatus> effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetCopies setEffectiveStatus(String effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetCopies setIsCompleted(Boolean isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetCopies setIsCompleted(String isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetCopies setTimeRange(Map<String, String> timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetCopies setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetCopies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCopies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCopies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCopies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCopies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCopies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCopies requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetCopies requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetCopies requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetCopies requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetCopies requestAdvantageStateInfoField() {
            return this.requestAdvantageStateInfoField(true);
        }

        public APIRequestGetCopies requestAdvantageStateInfoField(boolean value) {
            this.requestField("advantage_state_info", value);
            return this;
        }

        public APIRequestGetCopies requestBidStrategyField() {
            return this.requestBidStrategyField(true);
        }

        public APIRequestGetCopies requestBidStrategyField(boolean value) {
            this.requestField("bid_strategy", value);
            return this;
        }

        public APIRequestGetCopies requestBoostedObjectIdField() {
            return this.requestBoostedObjectIdField(true);
        }

        public APIRequestGetCopies requestBoostedObjectIdField(boolean value) {
            this.requestField("boosted_object_id", value);
            return this;
        }

        public APIRequestGetCopies requestBrandLiftStudiesField() {
            return this.requestBrandLiftStudiesField(true);
        }

        public APIRequestGetCopies requestBrandLiftStudiesField(boolean value) {
            this.requestField("brand_lift_studies", value);
            return this;
        }

        public APIRequestGetCopies requestBudgetRebalanceFlagField() {
            return this.requestBudgetRebalanceFlagField(true);
        }

        public APIRequestGetCopies requestBudgetRebalanceFlagField(boolean value) {
            this.requestField("budget_rebalance_flag", value);
            return this;
        }

        public APIRequestGetCopies requestBudgetRemainingField() {
            return this.requestBudgetRemainingField(true);
        }

        public APIRequestGetCopies requestBudgetRemainingField(boolean value) {
            this.requestField("budget_remaining", value);
            return this;
        }

        public APIRequestGetCopies requestBuyingTypeField() {
            return this.requestBuyingTypeField(true);
        }

        public APIRequestGetCopies requestBuyingTypeField(boolean value) {
            this.requestField("buying_type", value);
            return this;
        }

        public APIRequestGetCopies requestCampaignGroupActiveTimeField() {
            return this.requestCampaignGroupActiveTimeField(true);
        }

        public APIRequestGetCopies requestCampaignGroupActiveTimeField(boolean value) {
            this.requestField("campaign_group_active_time", value);
            return this;
        }

        public APIRequestGetCopies requestCanCreateBrandLiftStudyField() {
            return this.requestCanCreateBrandLiftStudyField(true);
        }

        public APIRequestGetCopies requestCanCreateBrandLiftStudyField(boolean value) {
            this.requestField("can_create_brand_lift_study", value);
            return this;
        }

        public APIRequestGetCopies requestCanUseSpendCapField() {
            return this.requestCanUseSpendCapField(true);
        }

        public APIRequestGetCopies requestCanUseSpendCapField(boolean value) {
            this.requestField("can_use_spend_cap", value);
            return this;
        }

        public APIRequestGetCopies requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetCopies requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetCopies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetCopies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetCopies requestDailyBudgetField() {
            return this.requestDailyBudgetField(true);
        }

        public APIRequestGetCopies requestDailyBudgetField(boolean value) {
            this.requestField("daily_budget", value);
            return this;
        }

        public APIRequestGetCopies requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetCopies requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetCopies requestHasSecondarySkadnetworkReportingField() {
            return this.requestHasSecondarySkadnetworkReportingField(true);
        }

        public APIRequestGetCopies requestHasSecondarySkadnetworkReportingField(boolean value) {
            this.requestField("has_secondary_skadnetwork_reporting", value);
            return this;
        }

        public APIRequestGetCopies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCopies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCopies requestIsAdsetBudgetSharingEnabledField() {
            return this.requestIsAdsetBudgetSharingEnabledField(true);
        }

        public APIRequestGetCopies requestIsAdsetBudgetSharingEnabledField(boolean value) {
            this.requestField("is_adset_budget_sharing_enabled", value);
            return this;
        }

        public APIRequestGetCopies requestIsBudgetScheduleEnabledField() {
            return this.requestIsBudgetScheduleEnabledField(true);
        }

        public APIRequestGetCopies requestIsBudgetScheduleEnabledField(boolean value) {
            this.requestField("is_budget_schedule_enabled", value);
            return this;
        }

        public APIRequestGetCopies requestIsDirectSendCampaignField() {
            return this.requestIsDirectSendCampaignField(true);
        }

        public APIRequestGetCopies requestIsDirectSendCampaignField(boolean value) {
            this.requestField("is_direct_send_campaign", value);
            return this;
        }

        public APIRequestGetCopies requestIsMessageCampaignField() {
            return this.requestIsMessageCampaignField(true);
        }

        public APIRequestGetCopies requestIsMessageCampaignField(boolean value) {
            this.requestField("is_message_campaign", value);
            return this;
        }

        public APIRequestGetCopies requestIsSkadnetworkAttributionField() {
            return this.requestIsSkadnetworkAttributionField(true);
        }

        public APIRequestGetCopies requestIsSkadnetworkAttributionField(boolean value) {
            this.requestField("is_skadnetwork_attribution", value);
            return this;
        }

        public APIRequestGetCopies requestIssuesInfoField() {
            return this.requestIssuesInfoField(true);
        }

        public APIRequestGetCopies requestIssuesInfoField(boolean value) {
            this.requestField("issues_info", value);
            return this;
        }

        public APIRequestGetCopies requestLastBudgetTogglingTimeField() {
            return this.requestLastBudgetTogglingTimeField(true);
        }

        public APIRequestGetCopies requestLastBudgetTogglingTimeField(boolean value) {
            this.requestField("last_budget_toggling_time", value);
            return this;
        }

        public APIRequestGetCopies requestLifetimeBudgetField() {
            return this.requestLifetimeBudgetField(true);
        }

        public APIRequestGetCopies requestLifetimeBudgetField(boolean value) {
            this.requestField("lifetime_budget", value);
            return this;
        }

        public APIRequestGetCopies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetCopies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetCopies requestObjectiveField() {
            return this.requestObjectiveField(true);
        }

        public APIRequestGetCopies requestObjectiveField(boolean value) {
            this.requestField("objective", value);
            return this;
        }

        public APIRequestGetCopies requestPacingTypeField() {
            return this.requestPacingTypeField(true);
        }

        public APIRequestGetCopies requestPacingTypeField(boolean value) {
            this.requestField("pacing_type", value);
            return this;
        }

        public APIRequestGetCopies requestPrimaryAttributionField() {
            return this.requestPrimaryAttributionField(true);
        }

        public APIRequestGetCopies requestPrimaryAttributionField(boolean value) {
            this.requestField("primary_attribution", value);
            return this;
        }

        public APIRequestGetCopies requestPromotedObjectField() {
            return this.requestPromotedObjectField(true);
        }

        public APIRequestGetCopies requestPromotedObjectField(boolean value) {
            this.requestField("promoted_object", value);
            return this;
        }

        public APIRequestGetCopies requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetCopies requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetCopies requestSmartPromotionTypeField() {
            return this.requestSmartPromotionTypeField(true);
        }

        public APIRequestGetCopies requestSmartPromotionTypeField(boolean value) {
            this.requestField("smart_promotion_type", value);
            return this;
        }

        public APIRequestGetCopies requestSourceCampaignField() {
            return this.requestSourceCampaignField(true);
        }

        public APIRequestGetCopies requestSourceCampaignField(boolean value) {
            this.requestField("source_campaign", value);
            return this;
        }

        public APIRequestGetCopies requestSourceCampaignIdField() {
            return this.requestSourceCampaignIdField(true);
        }

        public APIRequestGetCopies requestSourceCampaignIdField(boolean value) {
            this.requestField("source_campaign_id", value);
            return this;
        }

        public APIRequestGetCopies requestSourceRecommendationTypeField() {
            return this.requestSourceRecommendationTypeField(true);
        }

        public APIRequestGetCopies requestSourceRecommendationTypeField(boolean value) {
            this.requestField("source_recommendation_type", value);
            return this;
        }

        public APIRequestGetCopies requestSpecialAdCategoriesField() {
            return this.requestSpecialAdCategoriesField(true);
        }

        public APIRequestGetCopies requestSpecialAdCategoriesField(boolean value) {
            this.requestField("special_ad_categories", value);
            return this;
        }

        public APIRequestGetCopies requestSpecialAdCategoryField() {
            return this.requestSpecialAdCategoryField(true);
        }

        public APIRequestGetCopies requestSpecialAdCategoryField(boolean value) {
            this.requestField("special_ad_category", value);
            return this;
        }

        public APIRequestGetCopies requestSpecialAdCategoryCountryField() {
            return this.requestSpecialAdCategoryCountryField(true);
        }

        public APIRequestGetCopies requestSpecialAdCategoryCountryField(boolean value) {
            this.requestField("special_ad_category_country", value);
            return this;
        }

        public APIRequestGetCopies requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetCopies requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetCopies requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetCopies requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetCopies requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetCopies requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetCopies requestStopTimeField() {
            return this.requestStopTimeField(true);
        }

        public APIRequestGetCopies requestStopTimeField(boolean value) {
            this.requestField("stop_time", value);
            return this;
        }

        public APIRequestGetCopies requestToplineIdField() {
            return this.requestToplineIdField(true);
        }

        public APIRequestGetCopies requestToplineIdField(boolean value) {
            this.requestField("topline_id", value);
            return this;
        }

        public APIRequestGetCopies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetCopies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    public static class APIRequestCreateBudgetSchedule
    extends APIRequest<HighDemandPeriod> {
        HighDemandPeriod lastResponse = null;
        public static final String[] PARAMS = new String[]{"budget_value", "budget_value_type", "time_end", "time_start"};
        public static final String[] FIELDS = new String[0];

        @Override
        public HighDemandPeriod getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public HighDemandPeriod parseResponse(String response, String header) throws APIException {
            return HighDemandPeriod.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public HighDemandPeriod execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public HighDemandPeriod execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<HighDemandPeriod> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<HighDemandPeriod> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, HighDemandPeriod>(){

                public HighDemandPeriod apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateBudgetSchedule(String nodeId, APIContext context) {
            super(context, nodeId, "/budget_schedules", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateBudgetSchedule setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateBudgetSchedule setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateBudgetSchedule setBudgetValue(Long budgetValue) {
            this.setParam("budget_value", budgetValue);
            return this;
        }

        public APIRequestCreateBudgetSchedule setBudgetValue(String budgetValue) {
            this.setParam("budget_value", budgetValue);
            return this;
        }

        public APIRequestCreateBudgetSchedule setBudgetValueType(HighDemandPeriod.EnumBudgetValueType budgetValueType) {
            this.setParam("budget_value_type", (Object)budgetValueType);
            return this;
        }

        public APIRequestCreateBudgetSchedule setBudgetValueType(String budgetValueType) {
            this.setParam("budget_value_type", budgetValueType);
            return this;
        }

        public APIRequestCreateBudgetSchedule setTimeEnd(Long timeEnd) {
            this.setParam("time_end", timeEnd);
            return this;
        }

        public APIRequestCreateBudgetSchedule setTimeEnd(String timeEnd) {
            this.setParam("time_end", timeEnd);
            return this;
        }

        public APIRequestCreateBudgetSchedule setTimeStart(Long timeStart) {
            this.setParam("time_start", timeStart);
            return this;
        }

        public APIRequestCreateBudgetSchedule setTimeStart(String timeStart) {
            this.setParam("time_start", timeStart);
            return this;
        }

        public APIRequestCreateBudgetSchedule requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateBudgetSchedule requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBudgetSchedule requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateBudgetSchedule requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateBudgetSchedule requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateBudgetSchedule requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetBudgetSchedules
    extends APIRequest<HighDemandPeriod> {
        APINodeList<HighDemandPeriod> lastResponse = null;
        public static final String[] PARAMS = new String[]{"time_start", "time_stop"};
        public static final String[] FIELDS = new String[]{"ad_object_id", "budget_value", "budget_value_type", "id", "recurrence_type", "time_end", "time_start", "weekly_schedule"};

        @Override
        public APINodeList<HighDemandPeriod> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<HighDemandPeriod> parseResponse(String response, String header) throws APIException {
            return HighDemandPeriod.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<HighDemandPeriod> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<HighDemandPeriod> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<HighDemandPeriod>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<HighDemandPeriod>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<HighDemandPeriod>>(){

                public APINodeList<HighDemandPeriod> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetBudgetSchedules(String nodeId, APIContext context) {
            super(context, nodeId, "/budget_schedules", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBudgetSchedules setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBudgetSchedules setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBudgetSchedules setTimeStart(String timeStart) {
            this.setParam("time_start", timeStart);
            return this;
        }

        public APIRequestGetBudgetSchedules setTimeStop(String timeStop) {
            this.setParam("time_stop", timeStop);
            return this;
        }

        public APIRequestGetBudgetSchedules requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBudgetSchedules requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBudgetSchedules requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBudgetSchedules requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBudgetSchedules requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBudgetSchedules requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBudgetSchedules requestAdObjectIdField() {
            return this.requestAdObjectIdField(true);
        }

        public APIRequestGetBudgetSchedules requestAdObjectIdField(boolean value) {
            this.requestField("ad_object_id", value);
            return this;
        }

        public APIRequestGetBudgetSchedules requestBudgetValueField() {
            return this.requestBudgetValueField(true);
        }

        public APIRequestGetBudgetSchedules requestBudgetValueField(boolean value) {
            this.requestField("budget_value", value);
            return this;
        }

        public APIRequestGetBudgetSchedules requestBudgetValueTypeField() {
            return this.requestBudgetValueTypeField(true);
        }

        public APIRequestGetBudgetSchedules requestBudgetValueTypeField(boolean value) {
            this.requestField("budget_value_type", value);
            return this;
        }

        public APIRequestGetBudgetSchedules requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBudgetSchedules requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetBudgetSchedules requestRecurrenceTypeField() {
            return this.requestRecurrenceTypeField(true);
        }

        public APIRequestGetBudgetSchedules requestRecurrenceTypeField(boolean value) {
            this.requestField("recurrence_type", value);
            return this;
        }

        public APIRequestGetBudgetSchedules requestTimeEndField() {
            return this.requestTimeEndField(true);
        }

        public APIRequestGetBudgetSchedules requestTimeEndField(boolean value) {
            this.requestField("time_end", value);
            return this;
        }

        public APIRequestGetBudgetSchedules requestTimeStartField() {
            return this.requestTimeStartField(true);
        }

        public APIRequestGetBudgetSchedules requestTimeStartField(boolean value) {
            this.requestField("time_start", value);
            return this;
        }

        public APIRequestGetBudgetSchedules requestWeeklyScheduleField() {
            return this.requestWeeklyScheduleField(true);
        }

        public APIRequestGetBudgetSchedules requestWeeklyScheduleField(boolean value) {
            this.requestField("weekly_schedule", value);
            return this;
        }
    }

    public static class APIRequestGetAdSets
    extends APIRequest<AdSet> {
        APINodeList<AdSet> lastResponse = null;
        public static final String[] PARAMS = new String[]{"date_preset", "effective_status", "is_completed", "time_range"};
        public static final String[] FIELDS = new String[]{"account_id", "adlabels", "adset_schedule", "anchor_event_attribution_window_days", "asset_feed_id", "attribution_spec", "automatic_manual_state", "bid_adjustments", "bid_amount", "bid_constraints", "bid_info", "bid_strategy", "billing_event", "brand_safety_config", "budget_remaining", "campaign", "campaign_active_time", "campaign_attribution", "campaign_id", "configured_status", "created_time", "creative_sequence", "creative_sequence_repetition_pattern", "daily_budget", "daily_min_spend_target", "daily_spend_cap", "destination_type", "dsa_beneficiary", "dsa_payor", "effective_status", "end_time", "existing_customer_budget_percentage", "frequency_control_specs", "full_funnel_exploration_mode", "id", "instagram_user_id", "is_ba_skip_delayed_eligible", "is_budget_schedule_enabled", "is_dynamic_creative", "is_incremental_attribution_enabled", "issues_info", "learning_stage_info", "lifetime_budget", "lifetime_imps", "lifetime_min_spend_target", "lifetime_spend_cap", "max_budget_spend_percentage", "min_budget_spend_percentage", "multi_optimization_goal_weight", "name", "optimization_goal", "optimization_sub_event", "pacing_type", "placement_soft_opt_out", "promoted_object", "recommendations", "recurring_budget_semantics", "regional_regulated_categories", "regional_regulation_identities", "review_feedback", "rf_prediction_id", "source_adset", "source_adset_id", "start_time", "status", "targeting", "targeting_optimization_types", "time_based_ad_rotation_id_blocks", "time_based_ad_rotation_intervals", "trending_topics_spec", "updated_time", "use_new_app_click", "value_rule_set_id", "value_rules_applied"};

        @Override
        public APINodeList<AdSet> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdSet> parseResponse(String response, String header) throws APIException {
            return AdSet.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdSet> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdSet> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdSet>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdSet>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdSet>>(){

                public APINodeList<AdSet> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetAdSets(String nodeId, APIContext context) {
            super(context, nodeId, "/adsets", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdSets setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdSets setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdSets setDatePreset(AdSet.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetAdSets setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetAdSets setEffectiveStatus(List<AdSet.EnumEffectiveStatus> effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetAdSets setEffectiveStatus(String effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetAdSets setIsCompleted(Boolean isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetAdSets setIsCompleted(String isCompleted) {
            this.setParam("is_completed", isCompleted);
            return this;
        }

        public APIRequestGetAdSets setTimeRange(Map<String, String> timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetAdSets setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetAdSets requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdSets requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdSets requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdSets requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdSets requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdSets requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdSets requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdSets requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdSets requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetAdSets requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetAdSets requestAdsetScheduleField() {
            return this.requestAdsetScheduleField(true);
        }

        public APIRequestGetAdSets requestAdsetScheduleField(boolean value) {
            this.requestField("adset_schedule", value);
            return this;
        }

        public APIRequestGetAdSets requestAnchorEventAttributionWindowDaysField() {
            return this.requestAnchorEventAttributionWindowDaysField(true);
        }

        public APIRequestGetAdSets requestAnchorEventAttributionWindowDaysField(boolean value) {
            this.requestField("anchor_event_attribution_window_days", value);
            return this;
        }

        public APIRequestGetAdSets requestAssetFeedIdField() {
            return this.requestAssetFeedIdField(true);
        }

        public APIRequestGetAdSets requestAssetFeedIdField(boolean value) {
            this.requestField("asset_feed_id", value);
            return this;
        }

        public APIRequestGetAdSets requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdSets requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdSets requestAutomaticManualStateField() {
            return this.requestAutomaticManualStateField(true);
        }

        public APIRequestGetAdSets requestAutomaticManualStateField(boolean value) {
            this.requestField("automatic_manual_state", value);
            return this;
        }

        public APIRequestGetAdSets requestBidAdjustmentsField() {
            return this.requestBidAdjustmentsField(true);
        }

        public APIRequestGetAdSets requestBidAdjustmentsField(boolean value) {
            this.requestField("bid_adjustments", value);
            return this;
        }

        public APIRequestGetAdSets requestBidAmountField() {
            return this.requestBidAmountField(true);
        }

        public APIRequestGetAdSets requestBidAmountField(boolean value) {
            this.requestField("bid_amount", value);
            return this;
        }

        public APIRequestGetAdSets requestBidConstraintsField() {
            return this.requestBidConstraintsField(true);
        }

        public APIRequestGetAdSets requestBidConstraintsField(boolean value) {
            this.requestField("bid_constraints", value);
            return this;
        }

        public APIRequestGetAdSets requestBidInfoField() {
            return this.requestBidInfoField(true);
        }

        public APIRequestGetAdSets requestBidInfoField(boolean value) {
            this.requestField("bid_info", value);
            return this;
        }

        public APIRequestGetAdSets requestBidStrategyField() {
            return this.requestBidStrategyField(true);
        }

        public APIRequestGetAdSets requestBidStrategyField(boolean value) {
            this.requestField("bid_strategy", value);
            return this;
        }

        public APIRequestGetAdSets requestBillingEventField() {
            return this.requestBillingEventField(true);
        }

        public APIRequestGetAdSets requestBillingEventField(boolean value) {
            this.requestField("billing_event", value);
            return this;
        }

        public APIRequestGetAdSets requestBrandSafetyConfigField() {
            return this.requestBrandSafetyConfigField(true);
        }

        public APIRequestGetAdSets requestBrandSafetyConfigField(boolean value) {
            this.requestField("brand_safety_config", value);
            return this;
        }

        public APIRequestGetAdSets requestBudgetRemainingField() {
            return this.requestBudgetRemainingField(true);
        }

        public APIRequestGetAdSets requestBudgetRemainingField(boolean value) {
            this.requestField("budget_remaining", value);
            return this;
        }

        public APIRequestGetAdSets requestCampaignField() {
            return this.requestCampaignField(true);
        }

        public APIRequestGetAdSets requestCampaignField(boolean value) {
            this.requestField("campaign", value);
            return this;
        }

        public APIRequestGetAdSets requestCampaignActiveTimeField() {
            return this.requestCampaignActiveTimeField(true);
        }

        public APIRequestGetAdSets requestCampaignActiveTimeField(boolean value) {
            this.requestField("campaign_active_time", value);
            return this;
        }

        public APIRequestGetAdSets requestCampaignAttributionField() {
            return this.requestCampaignAttributionField(true);
        }

        public APIRequestGetAdSets requestCampaignAttributionField(boolean value) {
            this.requestField("campaign_attribution", value);
            return this;
        }

        public APIRequestGetAdSets requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetAdSets requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetAdSets requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetAdSets requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetAdSets requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdSets requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdSets requestCreativeSequenceField() {
            return this.requestCreativeSequenceField(true);
        }

        public APIRequestGetAdSets requestCreativeSequenceField(boolean value) {
            this.requestField("creative_sequence", value);
            return this;
        }

        public APIRequestGetAdSets requestCreativeSequenceRepetitionPatternField() {
            return this.requestCreativeSequenceRepetitionPatternField(true);
        }

        public APIRequestGetAdSets requestCreativeSequenceRepetitionPatternField(boolean value) {
            this.requestField("creative_sequence_repetition_pattern", value);
            return this;
        }

        public APIRequestGetAdSets requestDailyBudgetField() {
            return this.requestDailyBudgetField(true);
        }

        public APIRequestGetAdSets requestDailyBudgetField(boolean value) {
            this.requestField("daily_budget", value);
            return this;
        }

        public APIRequestGetAdSets requestDailyMinSpendTargetField() {
            return this.requestDailyMinSpendTargetField(true);
        }

        public APIRequestGetAdSets requestDailyMinSpendTargetField(boolean value) {
            this.requestField("daily_min_spend_target", value);
            return this;
        }

        public APIRequestGetAdSets requestDailySpendCapField() {
            return this.requestDailySpendCapField(true);
        }

        public APIRequestGetAdSets requestDailySpendCapField(boolean value) {
            this.requestField("daily_spend_cap", value);
            return this;
        }

        public APIRequestGetAdSets requestDestinationTypeField() {
            return this.requestDestinationTypeField(true);
        }

        public APIRequestGetAdSets requestDestinationTypeField(boolean value) {
            this.requestField("destination_type", value);
            return this;
        }

        public APIRequestGetAdSets requestDsaBeneficiaryField() {
            return this.requestDsaBeneficiaryField(true);
        }

        public APIRequestGetAdSets requestDsaBeneficiaryField(boolean value) {
            this.requestField("dsa_beneficiary", value);
            return this;
        }

        public APIRequestGetAdSets requestDsaPayorField() {
            return this.requestDsaPayorField(true);
        }

        public APIRequestGetAdSets requestDsaPayorField(boolean value) {
            this.requestField("dsa_payor", value);
            return this;
        }

        public APIRequestGetAdSets requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetAdSets requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetAdSets requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetAdSets requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetAdSets requestExistingCustomerBudgetPercentageField() {
            return this.requestExistingCustomerBudgetPercentageField(true);
        }

        public APIRequestGetAdSets requestExistingCustomerBudgetPercentageField(boolean value) {
            this.requestField("existing_customer_budget_percentage", value);
            return this;
        }

        public APIRequestGetAdSets requestFrequencyControlSpecsField() {
            return this.requestFrequencyControlSpecsField(true);
        }

        public APIRequestGetAdSets requestFrequencyControlSpecsField(boolean value) {
            this.requestField("frequency_control_specs", value);
            return this;
        }

        public APIRequestGetAdSets requestFullFunnelExplorationModeField() {
            return this.requestFullFunnelExplorationModeField(true);
        }

        public APIRequestGetAdSets requestFullFunnelExplorationModeField(boolean value) {
            this.requestField("full_funnel_exploration_mode", value);
            return this;
        }

        public APIRequestGetAdSets requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdSets requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdSets requestInstagramUserIdField() {
            return this.requestInstagramUserIdField(true);
        }

        public APIRequestGetAdSets requestInstagramUserIdField(boolean value) {
            this.requestField("instagram_user_id", value);
            return this;
        }

        public APIRequestGetAdSets requestIsBaSkipDelayedEligibleField() {
            return this.requestIsBaSkipDelayedEligibleField(true);
        }

        public APIRequestGetAdSets requestIsBaSkipDelayedEligibleField(boolean value) {
            this.requestField("is_ba_skip_delayed_eligible", value);
            return this;
        }

        public APIRequestGetAdSets requestIsBudgetScheduleEnabledField() {
            return this.requestIsBudgetScheduleEnabledField(true);
        }

        public APIRequestGetAdSets requestIsBudgetScheduleEnabledField(boolean value) {
            this.requestField("is_budget_schedule_enabled", value);
            return this;
        }

        public APIRequestGetAdSets requestIsDynamicCreativeField() {
            return this.requestIsDynamicCreativeField(true);
        }

        public APIRequestGetAdSets requestIsDynamicCreativeField(boolean value) {
            this.requestField("is_dynamic_creative", value);
            return this;
        }

        public APIRequestGetAdSets requestIsIncrementalAttributionEnabledField() {
            return this.requestIsIncrementalAttributionEnabledField(true);
        }

        public APIRequestGetAdSets requestIsIncrementalAttributionEnabledField(boolean value) {
            this.requestField("is_incremental_attribution_enabled", value);
            return this;
        }

        public APIRequestGetAdSets requestIssuesInfoField() {
            return this.requestIssuesInfoField(true);
        }

        public APIRequestGetAdSets requestIssuesInfoField(boolean value) {
            this.requestField("issues_info", value);
            return this;
        }

        public APIRequestGetAdSets requestLearningStageInfoField() {
            return this.requestLearningStageInfoField(true);
        }

        public APIRequestGetAdSets requestLearningStageInfoField(boolean value) {
            this.requestField("learning_stage_info", value);
            return this;
        }

        public APIRequestGetAdSets requestLifetimeBudgetField() {
            return this.requestLifetimeBudgetField(true);
        }

        public APIRequestGetAdSets requestLifetimeBudgetField(boolean value) {
            this.requestField("lifetime_budget", value);
            return this;
        }

        public APIRequestGetAdSets requestLifetimeImpsField() {
            return this.requestLifetimeImpsField(true);
        }

        public APIRequestGetAdSets requestLifetimeImpsField(boolean value) {
            this.requestField("lifetime_imps", value);
            return this;
        }

        public APIRequestGetAdSets requestLifetimeMinSpendTargetField() {
            return this.requestLifetimeMinSpendTargetField(true);
        }

        public APIRequestGetAdSets requestLifetimeMinSpendTargetField(boolean value) {
            this.requestField("lifetime_min_spend_target", value);
            return this;
        }

        public APIRequestGetAdSets requestLifetimeSpendCapField() {
            return this.requestLifetimeSpendCapField(true);
        }

        public APIRequestGetAdSets requestLifetimeSpendCapField(boolean value) {
            this.requestField("lifetime_spend_cap", value);
            return this;
        }

        public APIRequestGetAdSets requestMaxBudgetSpendPercentageField() {
            return this.requestMaxBudgetSpendPercentageField(true);
        }

        public APIRequestGetAdSets requestMaxBudgetSpendPercentageField(boolean value) {
            this.requestField("max_budget_spend_percentage", value);
            return this;
        }

        public APIRequestGetAdSets requestMinBudgetSpendPercentageField() {
            return this.requestMinBudgetSpendPercentageField(true);
        }

        public APIRequestGetAdSets requestMinBudgetSpendPercentageField(boolean value) {
            this.requestField("min_budget_spend_percentage", value);
            return this;
        }

        public APIRequestGetAdSets requestMultiOptimizationGoalWeightField() {
            return this.requestMultiOptimizationGoalWeightField(true);
        }

        public APIRequestGetAdSets requestMultiOptimizationGoalWeightField(boolean value) {
            this.requestField("multi_optimization_goal_weight", value);
            return this;
        }

        public APIRequestGetAdSets requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdSets requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdSets requestOptimizationGoalField() {
            return this.requestOptimizationGoalField(true);
        }

        public APIRequestGetAdSets requestOptimizationGoalField(boolean value) {
            this.requestField("optimization_goal", value);
            return this;
        }

        public APIRequestGetAdSets requestOptimizationSubEventField() {
            return this.requestOptimizationSubEventField(true);
        }

        public APIRequestGetAdSets requestOptimizationSubEventField(boolean value) {
            this.requestField("optimization_sub_event", value);
            return this;
        }

        public APIRequestGetAdSets requestPacingTypeField() {
            return this.requestPacingTypeField(true);
        }

        public APIRequestGetAdSets requestPacingTypeField(boolean value) {
            this.requestField("pacing_type", value);
            return this;
        }

        public APIRequestGetAdSets requestPlacementSoftOptOutField() {
            return this.requestPlacementSoftOptOutField(true);
        }

        public APIRequestGetAdSets requestPlacementSoftOptOutField(boolean value) {
            this.requestField("placement_soft_opt_out", value);
            return this;
        }

        public APIRequestGetAdSets requestPromotedObjectField() {
            return this.requestPromotedObjectField(true);
        }

        public APIRequestGetAdSets requestPromotedObjectField(boolean value) {
            this.requestField("promoted_object", value);
            return this;
        }

        public APIRequestGetAdSets requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetAdSets requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetAdSets requestRecurringBudgetSemanticsField() {
            return this.requestRecurringBudgetSemanticsField(true);
        }

        public APIRequestGetAdSets requestRecurringBudgetSemanticsField(boolean value) {
            this.requestField("recurring_budget_semantics", value);
            return this;
        }

        public APIRequestGetAdSets requestRegionalRegulatedCategoriesField() {
            return this.requestRegionalRegulatedCategoriesField(true);
        }

        public APIRequestGetAdSets requestRegionalRegulatedCategoriesField(boolean value) {
            this.requestField("regional_regulated_categories", value);
            return this;
        }

        public APIRequestGetAdSets requestRegionalRegulationIdentitiesField() {
            return this.requestRegionalRegulationIdentitiesField(true);
        }

        public APIRequestGetAdSets requestRegionalRegulationIdentitiesField(boolean value) {
            this.requestField("regional_regulation_identities", value);
            return this;
        }

        public APIRequestGetAdSets requestReviewFeedbackField() {
            return this.requestReviewFeedbackField(true);
        }

        public APIRequestGetAdSets requestReviewFeedbackField(boolean value) {
            this.requestField("review_feedback", value);
            return this;
        }

        public APIRequestGetAdSets requestRfPredictionIdField() {
            return this.requestRfPredictionIdField(true);
        }

        public APIRequestGetAdSets requestRfPredictionIdField(boolean value) {
            this.requestField("rf_prediction_id", value);
            return this;
        }

        public APIRequestGetAdSets requestSourceAdsetField() {
            return this.requestSourceAdsetField(true);
        }

        public APIRequestGetAdSets requestSourceAdsetField(boolean value) {
            this.requestField("source_adset", value);
            return this;
        }

        public APIRequestGetAdSets requestSourceAdsetIdField() {
            return this.requestSourceAdsetIdField(true);
        }

        public APIRequestGetAdSets requestSourceAdsetIdField(boolean value) {
            this.requestField("source_adset_id", value);
            return this;
        }

        public APIRequestGetAdSets requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetAdSets requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetAdSets requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAdSets requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAdSets requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetAdSets requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetAdSets requestTargetingOptimizationTypesField() {
            return this.requestTargetingOptimizationTypesField(true);
        }

        public APIRequestGetAdSets requestTargetingOptimizationTypesField(boolean value) {
            this.requestField("targeting_optimization_types", value);
            return this;
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIdBlocksField() {
            return this.requestTimeBasedAdRotationIdBlocksField(true);
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIdBlocksField(boolean value) {
            this.requestField("time_based_ad_rotation_id_blocks", value);
            return this;
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIntervalsField() {
            return this.requestTimeBasedAdRotationIntervalsField(true);
        }

        public APIRequestGetAdSets requestTimeBasedAdRotationIntervalsField(boolean value) {
            this.requestField("time_based_ad_rotation_intervals", value);
            return this;
        }

        public APIRequestGetAdSets requestTrendingTopicsSpecField() {
            return this.requestTrendingTopicsSpecField(true);
        }

        public APIRequestGetAdSets requestTrendingTopicsSpecField(boolean value) {
            this.requestField("trending_topics_spec", value);
            return this;
        }

        public APIRequestGetAdSets requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAdSets requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetAdSets requestUseNewAppClickField() {
            return this.requestUseNewAppClickField(true);
        }

        public APIRequestGetAdSets requestUseNewAppClickField(boolean value) {
            this.requestField("use_new_app_click", value);
            return this;
        }

        public APIRequestGetAdSets requestValueRuleSetIdField() {
            return this.requestValueRuleSetIdField(true);
        }

        public APIRequestGetAdSets requestValueRuleSetIdField(boolean value) {
            this.requestField("value_rule_set_id", value);
            return this;
        }

        public APIRequestGetAdSets requestValueRulesAppliedField() {
            return this.requestValueRulesAppliedField(true);
        }

        public APIRequestGetAdSets requestValueRulesAppliedField(boolean value) {
            this.requestField("value_rules_applied", value);
            return this;
        }
    }

    public static class APIRequestGetAds
    extends APIRequest<Ad> {
        APINodeList<Ad> lastResponse = null;
        public static final String[] PARAMS = new String[]{"date_preset", "effective_status", "time_range", "updated_since"};
        public static final String[] FIELDS = new String[]{"account_id", "ad_active_time", "ad_review_feedback", "ad_schedule_end_time", "ad_schedule_start_time", "adlabels", "adset", "adset_id", "bid_amount", "bid_info", "bid_type", "campaign", "campaign_id", "configured_status", "conversion_domain", "conversion_specs", "created_time", "creative", "creative_asset_groups_spec", "demolink_hash", "display_sequence", "effective_status", "engagement_audience", "failed_delivery_checks", "id", "issues_info", "last_updated_by_app_id", "name", "placement", "preview_shareable_link", "priority", "recommendations", "source_ad", "source_ad_id", "status", "targeting", "tracking_and_conversion_with_defaults", "tracking_specs", "updated_time"};

        @Override
        public APINodeList<Ad> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Ad> parseResponse(String response, String header) throws APIException {
            return Ad.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Ad> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Ad> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Ad>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Ad>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Ad>>(){

                public APINodeList<Ad> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetAds(String nodeId, APIContext context) {
            super(context, nodeId, "/ads", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAds setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAds setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAds setDatePreset(Ad.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetAds setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetAds setEffectiveStatus(List<String> effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetAds setEffectiveStatus(String effectiveStatus) {
            this.setParam("effective_status", effectiveStatus);
            return this;
        }

        public APIRequestGetAds setTimeRange(Map<String, String> timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetAds setTimeRange(String timeRange) {
            this.setParam("time_range", timeRange);
            return this;
        }

        public APIRequestGetAds setUpdatedSince(Long updatedSince) {
            this.setParam("updated_since", updatedSince);
            return this;
        }

        public APIRequestGetAds setUpdatedSince(String updatedSince) {
            this.setParam("updated_since", updatedSince);
            return this;
        }

        public APIRequestGetAds requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAds requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAds requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAds requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAds requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAds requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAds requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAds requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAds requestAdActiveTimeField() {
            return this.requestAdActiveTimeField(true);
        }

        public APIRequestGetAds requestAdActiveTimeField(boolean value) {
            this.requestField("ad_active_time", value);
            return this;
        }

        public APIRequestGetAds requestAdReviewFeedbackField() {
            return this.requestAdReviewFeedbackField(true);
        }

        public APIRequestGetAds requestAdReviewFeedbackField(boolean value) {
            this.requestField("ad_review_feedback", value);
            return this;
        }

        public APIRequestGetAds requestAdScheduleEndTimeField() {
            return this.requestAdScheduleEndTimeField(true);
        }

        public APIRequestGetAds requestAdScheduleEndTimeField(boolean value) {
            this.requestField("ad_schedule_end_time", value);
            return this;
        }

        public APIRequestGetAds requestAdScheduleStartTimeField() {
            return this.requestAdScheduleStartTimeField(true);
        }

        public APIRequestGetAds requestAdScheduleStartTimeField(boolean value) {
            this.requestField("ad_schedule_start_time", value);
            return this;
        }

        public APIRequestGetAds requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGetAds requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGetAds requestAdsetField() {
            return this.requestAdsetField(true);
        }

        public APIRequestGetAds requestAdsetField(boolean value) {
            this.requestField("adset", value);
            return this;
        }

        public APIRequestGetAds requestAdsetIdField() {
            return this.requestAdsetIdField(true);
        }

        public APIRequestGetAds requestAdsetIdField(boolean value) {
            this.requestField("adset_id", value);
            return this;
        }

        public APIRequestGetAds requestBidAmountField() {
            return this.requestBidAmountField(true);
        }

        public APIRequestGetAds requestBidAmountField(boolean value) {
            this.requestField("bid_amount", value);
            return this;
        }

        public APIRequestGetAds requestBidInfoField() {
            return this.requestBidInfoField(true);
        }

        public APIRequestGetAds requestBidInfoField(boolean value) {
            this.requestField("bid_info", value);
            return this;
        }

        public APIRequestGetAds requestBidTypeField() {
            return this.requestBidTypeField(true);
        }

        public APIRequestGetAds requestBidTypeField(boolean value) {
            this.requestField("bid_type", value);
            return this;
        }

        public APIRequestGetAds requestCampaignField() {
            return this.requestCampaignField(true);
        }

        public APIRequestGetAds requestCampaignField(boolean value) {
            this.requestField("campaign", value);
            return this;
        }

        public APIRequestGetAds requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGetAds requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGetAds requestConfiguredStatusField() {
            return this.requestConfiguredStatusField(true);
        }

        public APIRequestGetAds requestConfiguredStatusField(boolean value) {
            this.requestField("configured_status", value);
            return this;
        }

        public APIRequestGetAds requestConversionDomainField() {
            return this.requestConversionDomainField(true);
        }

        public APIRequestGetAds requestConversionDomainField(boolean value) {
            this.requestField("conversion_domain", value);
            return this;
        }

        public APIRequestGetAds requestConversionSpecsField() {
            return this.requestConversionSpecsField(true);
        }

        public APIRequestGetAds requestConversionSpecsField(boolean value) {
            this.requestField("conversion_specs", value);
            return this;
        }

        public APIRequestGetAds requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAds requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAds requestCreativeField() {
            return this.requestCreativeField(true);
        }

        public APIRequestGetAds requestCreativeField(boolean value) {
            this.requestField("creative", value);
            return this;
        }

        public APIRequestGetAds requestCreativeAssetGroupsSpecField() {
            return this.requestCreativeAssetGroupsSpecField(true);
        }

        public APIRequestGetAds requestCreativeAssetGroupsSpecField(boolean value) {
            this.requestField("creative_asset_groups_spec", value);
            return this;
        }

        public APIRequestGetAds requestDemolinkHashField() {
            return this.requestDemolinkHashField(true);
        }

        public APIRequestGetAds requestDemolinkHashField(boolean value) {
            this.requestField("demolink_hash", value);
            return this;
        }

        public APIRequestGetAds requestDisplaySequenceField() {
            return this.requestDisplaySequenceField(true);
        }

        public APIRequestGetAds requestDisplaySequenceField(boolean value) {
            this.requestField("display_sequence", value);
            return this;
        }

        public APIRequestGetAds requestEffectiveStatusField() {
            return this.requestEffectiveStatusField(true);
        }

        public APIRequestGetAds requestEffectiveStatusField(boolean value) {
            this.requestField("effective_status", value);
            return this;
        }

        public APIRequestGetAds requestEngagementAudienceField() {
            return this.requestEngagementAudienceField(true);
        }

        public APIRequestGetAds requestEngagementAudienceField(boolean value) {
            this.requestField("engagement_audience", value);
            return this;
        }

        public APIRequestGetAds requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetAds requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetAds requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAds requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAds requestIssuesInfoField() {
            return this.requestIssuesInfoField(true);
        }

        public APIRequestGetAds requestIssuesInfoField(boolean value) {
            this.requestField("issues_info", value);
            return this;
        }

        public APIRequestGetAds requestLastUpdatedByAppIdField() {
            return this.requestLastUpdatedByAppIdField(true);
        }

        public APIRequestGetAds requestLastUpdatedByAppIdField(boolean value) {
            this.requestField("last_updated_by_app_id", value);
            return this;
        }

        public APIRequestGetAds requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAds requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAds requestPlacementField() {
            return this.requestPlacementField(true);
        }

        public APIRequestGetAds requestPlacementField(boolean value) {
            this.requestField("placement", value);
            return this;
        }

        public APIRequestGetAds requestPreviewShareableLinkField() {
            return this.requestPreviewShareableLinkField(true);
        }

        public APIRequestGetAds requestPreviewShareableLinkField(boolean value) {
            this.requestField("preview_shareable_link", value);
            return this;
        }

        public APIRequestGetAds requestPriorityField() {
            return this.requestPriorityField(true);
        }

        public APIRequestGetAds requestPriorityField(boolean value) {
            this.requestField("priority", value);
            return this;
        }

        public APIRequestGetAds requestRecommendationsField() {
            return this.requestRecommendationsField(true);
        }

        public APIRequestGetAds requestRecommendationsField(boolean value) {
            this.requestField("recommendations", value);
            return this;
        }

        public APIRequestGetAds requestSourceAdField() {
            return this.requestSourceAdField(true);
        }

        public APIRequestGetAds requestSourceAdField(boolean value) {
            this.requestField("source_ad", value);
            return this;
        }

        public APIRequestGetAds requestSourceAdIdField() {
            return this.requestSourceAdIdField(true);
        }

        public APIRequestGetAds requestSourceAdIdField(boolean value) {
            this.requestField("source_ad_id", value);
            return this;
        }

        public APIRequestGetAds requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAds requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAds requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetAds requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetAds requestTrackingAndConversionWithDefaultsField() {
            return this.requestTrackingAndConversionWithDefaultsField(true);
        }

        public APIRequestGetAds requestTrackingAndConversionWithDefaultsField(boolean value) {
            this.requestField("tracking_and_conversion_with_defaults", value);
            return this;
        }

        public APIRequestGetAds requestTrackingSpecsField() {
            return this.requestTrackingSpecsField(true);
        }

        public APIRequestGetAds requestTrackingSpecsField(boolean value) {
            this.requestField("tracking_specs", value);
            return this;
        }

        public APIRequestGetAds requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAds requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    public static class APIRequestGetAdRulesGoverned
    extends APIRequest<AdRule> {
        APINodeList<AdRule> lastResponse = null;
        public static final String[] PARAMS = new String[]{"pass_evaluation"};
        public static final String[] FIELDS = new String[]{"account_id", "created_by", "created_time", "disable_error_code", "evaluation_spec", "execution_spec", "id", "name", "schedule_spec", "status", "updated_time"};

        @Override
        public APINodeList<AdRule> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdRule> parseResponse(String response, String header) throws APIException {
            return AdRule.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdRule> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdRule> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdRule>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdRule>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdRule>>(){

                public APINodeList<AdRule> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetAdRulesGoverned(String nodeId, APIContext context) {
            super(context, nodeId, "/adrules_governed", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdRulesGoverned setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdRulesGoverned setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdRulesGoverned setPassEvaluation(Boolean passEvaluation) {
            this.setParam("pass_evaluation", passEvaluation);
            return this;
        }

        public APIRequestGetAdRulesGoverned setPassEvaluation(String passEvaluation) {
            this.setParam("pass_evaluation", passEvaluation);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdRulesGoverned requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdRulesGoverned requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdRulesGoverned requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdRulesGoverned requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdRulesGoverned requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdRulesGoverned requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetAdRulesGoverned requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdRulesGoverned requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestDisableErrorCodeField() {
            return this.requestDisableErrorCodeField(true);
        }

        public APIRequestGetAdRulesGoverned requestDisableErrorCodeField(boolean value) {
            this.requestField("disable_error_code", value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestEvaluationSpecField() {
            return this.requestEvaluationSpecField(true);
        }

        public APIRequestGetAdRulesGoverned requestEvaluationSpecField(boolean value) {
            this.requestField("evaluation_spec", value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestExecutionSpecField() {
            return this.requestExecutionSpecField(true);
        }

        public APIRequestGetAdRulesGoverned requestExecutionSpecField(boolean value) {
            this.requestField("execution_spec", value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdRulesGoverned requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdRulesGoverned requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestScheduleSpecField() {
            return this.requestScheduleSpecField(true);
        }

        public APIRequestGetAdRulesGoverned requestScheduleSpecField(boolean value) {
            this.requestField("schedule_spec", value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAdRulesGoverned requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAdRulesGoverned requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAdRulesGoverned requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    public static class APIRequestCreateAdLabel
    extends APIRequest<Campaign> {
        Campaign lastResponse = null;
        public static final String[] PARAMS = new String[]{"adlabels", "execution_options"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Campaign getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Campaign parseResponse(String response, String header) throws APIException {
            return Campaign.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Campaign execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Campaign execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Campaign> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Campaign> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Campaign>(){

                public Campaign apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateAdLabel(String nodeId, APIContext context) {
            super(context, nodeId, "/adlabels", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdLabel setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdLabel setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdLabel setAdlabels(List<Object> adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestCreateAdLabel setAdlabels(String adlabels) {
            this.setParam("adlabels", adlabels);
            return this;
        }

        public APIRequestCreateAdLabel setExecutionOptions(List<EnumExecutionOptions> executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestCreateAdLabel setExecutionOptions(String executionOptions) {
            this.setParam("execution_options", executionOptions);
            return this;
        }

        public APIRequestCreateAdLabel requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdLabel requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdLabel requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdLabel requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdLabel requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdLabel requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetAdStudies
    extends APIRequest<AdStudy> {
        APINodeList<AdStudy> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "canceled_time", "client_business", "cooldown_start_time", "created_by", "created_time", "description", "end_time", "id", "measurement_contact", "name", "observation_end_time", "results_first_available_date", "sales_contact", "start_time", "type", "updated_by", "updated_time"};

        @Override
        public APINodeList<AdStudy> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdStudy> parseResponse(String response, String header) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdStudy> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdStudy> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdStudy>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdStudy>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdStudy>>(){

                public APINodeList<AdStudy> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetAdStudies(String nodeId, APIContext context) {
            super(context, nodeId, "/ad_studies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdStudies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdStudies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdStudies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdStudies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdStudies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdStudies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdStudies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdStudies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdStudies requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAdStudies requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAdStudies requestCanceledTimeField() {
            return this.requestCanceledTimeField(true);
        }

        public APIRequestGetAdStudies requestCanceledTimeField(boolean value) {
            this.requestField("canceled_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestClientBusinessField() {
            return this.requestClientBusinessField(true);
        }

        public APIRequestGetAdStudies requestClientBusinessField(boolean value) {
            this.requestField("client_business", value);
            return this;
        }

        public APIRequestGetAdStudies requestCooldownStartTimeField() {
            return this.requestCooldownStartTimeField(true);
        }

        public APIRequestGetAdStudies requestCooldownStartTimeField(boolean value) {
            this.requestField("cooldown_start_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetAdStudies requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetAdStudies requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdStudies requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetAdStudies requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetAdStudies requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetAdStudies requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdStudies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdStudies requestMeasurementContactField() {
            return this.requestMeasurementContactField(true);
        }

        public APIRequestGetAdStudies requestMeasurementContactField(boolean value) {
            this.requestField("measurement_contact", value);
            return this;
        }

        public APIRequestGetAdStudies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdStudies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdStudies requestObservationEndTimeField() {
            return this.requestObservationEndTimeField(true);
        }

        public APIRequestGetAdStudies requestObservationEndTimeField(boolean value) {
            this.requestField("observation_end_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestResultsFirstAvailableDateField() {
            return this.requestResultsFirstAvailableDateField(true);
        }

        public APIRequestGetAdStudies requestResultsFirstAvailableDateField(boolean value) {
            this.requestField("results_first_available_date", value);
            return this;
        }

        public APIRequestGetAdStudies requestSalesContactField() {
            return this.requestSalesContactField(true);
        }

        public APIRequestGetAdStudies requestSalesContactField(boolean value) {
            this.requestField("sales_contact", value);
            return this;
        }

        public APIRequestGetAdStudies requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetAdStudies requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetAdStudies requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetAdStudies requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetAdStudies requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetAdStudies requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetAdStudies requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetAdStudies requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }
}

