/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class BusinessAssetSharingAgreement
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="initiator")
    private Business mInitiator = null;
    @SerializedName(value="recipient")
    private Business mRecipient = null;
    @SerializedName(value="relationship_type")
    private List<String> mRelationshipType = null;
    @SerializedName(value="request_status")
    private String mRequestStatus = null;
    @SerializedName(value="request_type")
    private String mRequestType = null;
    protected static Gson gson = null;

    BusinessAssetSharingAgreement() {
    }

    public BusinessAssetSharingAgreement(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessAssetSharingAgreement(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessAssetSharingAgreement fetch() throws APIException {
        BusinessAssetSharingAgreement newInstance = BusinessAssetSharingAgreement.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessAssetSharingAgreement fetchById(Long id, APIContext context) throws APIException {
        return BusinessAssetSharingAgreement.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessAssetSharingAgreement> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessAssetSharingAgreement.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessAssetSharingAgreement fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BusinessAssetSharingAgreement> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BusinessAssetSharingAgreement> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessAssetSharingAgreement>(context, "", "/", "GET", BusinessAssetSharingAgreement.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessAssetSharingAgreement>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BusinessAssetSharingAgreement>(context, "", "/", "GET", BusinessAssetSharingAgreement.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessAssetSharingAgreement loadJSON(String json, APIContext context, String header) {
        BusinessAssetSharingAgreement businessAssetSharingAgreement = (BusinessAssetSharingAgreement)BusinessAssetSharingAgreement.getGson().fromJson(json, BusinessAssetSharingAgreement.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessAssetSharingAgreement.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessAssetSharingAgreement.context = context;
        businessAssetSharingAgreement.rawValue = json;
        businessAssetSharingAgreement.header = header;
        return businessAssetSharingAgreement;
    }

    public static APINodeList<BusinessAssetSharingAgreement> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessAssetSharingAgreement> businessAssetSharingAgreements = new APINodeList<BusinessAssetSharingAgreement>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessAssetSharingAgreements.add(BusinessAssetSharingAgreement.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessAssetSharingAgreements;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessAssetSharingAgreements.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessAssetSharingAgreements.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessAssetSharingAgreements.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessAssetSharingAgreements.add(BusinessAssetSharingAgreement.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessAssetSharingAgreements.add(BusinessAssetSharingAgreement.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessAssetSharingAgreements.add(BusinessAssetSharingAgreement.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessAssetSharingAgreements;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessAssetSharingAgreements.add(BusinessAssetSharingAgreement.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessAssetSharingAgreements;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessAssetSharingAgreements.add(BusinessAssetSharingAgreement.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessAssetSharingAgreements;
                }
                businessAssetSharingAgreements.clear();
                businessAssetSharingAgreements.add(BusinessAssetSharingAgreement.loadJSON(json, context, header));
                return businessAssetSharingAgreements;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessAssetSharingAgreement.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public Business getFieldInitiator() {
        if (this.mInitiator != null) {
            this.mInitiator.context = this.getContext();
        }
        return this.mInitiator;
    }

    public Business getFieldRecipient() {
        if (this.mRecipient != null) {
            this.mRecipient.context = this.getContext();
        }
        return this.mRecipient;
    }

    public List<String> getFieldRelationshipType() {
        return this.mRelationshipType;
    }

    public String getFieldRequestStatus() {
        return this.mRequestStatus;
    }

    public String getFieldRequestType() {
        return this.mRequestType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessAssetSharingAgreement copyFrom(BusinessAssetSharingAgreement instance) {
        this.mId = instance.mId;
        this.mInitiator = instance.mInitiator;
        this.mRecipient = instance.mRecipient;
        this.mRelationshipType = instance.mRelationshipType;
        this.mRequestStatus = instance.mRequestStatus;
        this.mRequestType = instance.mRequestType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessAssetSharingAgreement> getParser() {
        return new APIRequest.ResponseParser<BusinessAssetSharingAgreement>(){

            @Override
            public APINodeList<BusinessAssetSharingAgreement> parseResponse(String response, APIContext context, APIRequest<BusinessAssetSharingAgreement> request, String header) throws APIException.MalformedResponseException {
                return BusinessAssetSharingAgreement.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumRequestStatus {
        VALUE_APPROVE("APPROVE"),
        VALUE_CANCELED("CANCELED"),
        VALUE_DECLINE("DECLINE"),
        VALUE_EXPIRED("EXPIRED"),
        VALUE_IN_PROGRESS("IN_PROGRESS"),
        VALUE_MMA_DIRECT_ASSETS_APPROVED("MMA_DIRECT_ASSETS_APPROVED"),
        VALUE_MMA_DIRECT_ASSETS_DECLINED("MMA_DIRECT_ASSETS_DECLINED"),
        VALUE_MMA_DIRECT_ASSETS_EXPIRED("MMA_DIRECT_ASSETS_EXPIRED"),
        VALUE_MMA_DIRECT_ASSETS_PENDING("MMA_DIRECT_ASSETS_PENDING"),
        VALUE_PENDING("PENDING"),
        VALUE_PENDING_EMAIL_VERIFICATION("PENDING_EMAIL_VERIFICATION"),
        VALUE_PENDING_INTEGRITY_REVIEW("PENDING_INTEGRITY_REVIEW");

        private String value;

        private EnumRequestStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<BusinessAssetSharingAgreement> {
        BusinessAssetSharingAgreement lastResponse = null;
        public static final String[] PARAMS = new String[]{"request_response"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessAssetSharingAgreement getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessAssetSharingAgreement parseResponse(String response, String header) throws APIException {
            return BusinessAssetSharingAgreement.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessAssetSharingAgreement execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessAssetSharingAgreement execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessAssetSharingAgreement> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessAssetSharingAgreement> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessAssetSharingAgreement>(){

                public BusinessAssetSharingAgreement apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setRequestResponse(String requestResponse) {
            this.setParam("request_response", requestResponse);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<BusinessAssetSharingAgreement> {
        BusinessAssetSharingAgreement lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "initiator", "recipient", "relationship_type", "request_status", "request_type"};

        @Override
        public BusinessAssetSharingAgreement getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessAssetSharingAgreement parseResponse(String response, String header) throws APIException {
            return BusinessAssetSharingAgreement.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessAssetSharingAgreement execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessAssetSharingAgreement execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessAssetSharingAgreement> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessAssetSharingAgreement> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessAssetSharingAgreement>(){

                public BusinessAssetSharingAgreement apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInitiatorField() {
            return this.requestInitiatorField(true);
        }

        public APIRequestGet requestInitiatorField(boolean value) {
            this.requestField("initiator", value);
            return this;
        }

        public APIRequestGet requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGet requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGet requestRelationshipTypeField() {
            return this.requestRelationshipTypeField(true);
        }

        public APIRequestGet requestRelationshipTypeField(boolean value) {
            this.requestField("relationship_type", value);
            return this;
        }

        public APIRequestGet requestRequestStatusField() {
            return this.requestRequestStatusField(true);
        }

        public APIRequestGet requestRequestStatusField(boolean value) {
            this.requestField("request_status", value);
            return this;
        }

        public APIRequestGet requestRequestTypeField() {
            return this.requestRequestTypeField(true);
        }

        public APIRequestGet requestRequestTypeField(boolean value) {
            this.requestField("request_type", value);
            return this;
        }
    }
}

