/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class BlockedUserInfo
extends APINode {
    @SerializedName(value="block_time")
    private String mBlockTime = null;
    @SerializedName(value="block_type")
    private String mBlockType = null;
    @SerializedName(value="fbid")
    private String mFbid = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="username")
    private String mUsername = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static BlockedUserInfo loadJSON(String json, APIContext context, String header) {
        BlockedUserInfo blockedUserInfo = (BlockedUserInfo)BlockedUserInfo.getGson().fromJson(json, BlockedUserInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(blockedUserInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        blockedUserInfo.context = context;
        blockedUserInfo.rawValue = json;
        blockedUserInfo.header = header;
        return blockedUserInfo;
    }

    public static APINodeList<BlockedUserInfo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BlockedUserInfo> blockedUserInfos = new APINodeList<BlockedUserInfo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        blockedUserInfos.add(BlockedUserInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return blockedUserInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            blockedUserInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        blockedUserInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            blockedUserInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            blockedUserInfos.add(BlockedUserInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                blockedUserInfos.add(BlockedUserInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            blockedUserInfos.add(BlockedUserInfo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return blockedUserInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        blockedUserInfos.add(BlockedUserInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return blockedUserInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        blockedUserInfos.add(BlockedUserInfo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return blockedUserInfos;
                }
                blockedUserInfos.clear();
                blockedUserInfos.add(BlockedUserInfo.loadJSON(json, context, header));
                return blockedUserInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BlockedUserInfo.getGson().toJson((Object)this);
    }

    public String getFieldBlockTime() {
        return this.mBlockTime;
    }

    public BlockedUserInfo setFieldBlockTime(String value) {
        this.mBlockTime = value;
        return this;
    }

    public String getFieldBlockType() {
        return this.mBlockType;
    }

    public BlockedUserInfo setFieldBlockType(String value) {
        this.mBlockType = value;
        return this;
    }

    public String getFieldFbid() {
        return this.mFbid;
    }

    public BlockedUserInfo setFieldFbid(String value) {
        this.mFbid = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public BlockedUserInfo setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    public BlockedUserInfo setFieldUsername(String value) {
        this.mUsername = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BlockedUserInfo copyFrom(BlockedUserInfo instance) {
        this.mBlockTime = instance.mBlockTime;
        this.mBlockType = instance.mBlockType;
        this.mFbid = instance.mFbid;
        this.mName = instance.mName;
        this.mUsername = instance.mUsername;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BlockedUserInfo> getParser() {
        return new APIRequest.ResponseParser<BlockedUserInfo>(){

            @Override
            public APINodeList<BlockedUserInfo> parseResponse(String response, APIContext context, APIRequest<BlockedUserInfo> request, String header) throws APIException.MalformedResponseException {
                return BlockedUserInfo.parseResponse(response, context, request, header);
            }
        };
    }
}

