/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class AudioSubLabel
extends APINode {
    @SerializedName(value="expiration_timestamp")
    private String mExpirationTimestamp = null;
    @SerializedName(value="flagged_timestamp")
    private String mFlaggedTimestamp = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="label_name")
    private String mLabelName = null;
    @SerializedName(value="last_update_timestamp")
    private String mLastUpdateTimestamp = null;
    @SerializedName(value="num_audio_tracks")
    private Long mNumAudioTracks = null;
    @SerializedName(value="state")
    private String mState = null;
    protected static Gson gson = null;

    AudioSubLabel() {
    }

    public AudioSubLabel(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AudioSubLabel(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AudioSubLabel fetch() throws APIException {
        AudioSubLabel newInstance = AudioSubLabel.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AudioSubLabel fetchById(Long id, APIContext context) throws APIException {
        return AudioSubLabel.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AudioSubLabel> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AudioSubLabel.fetchByIdAsync(id.toString(), context);
    }

    public static AudioSubLabel fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AudioSubLabel> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AudioSubLabel> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AudioSubLabel>(context, "", "/", "GET", AudioSubLabel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AudioSubLabel>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AudioSubLabel>(context, "", "/", "GET", AudioSubLabel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AudioSubLabel loadJSON(String json, APIContext context, String header) {
        AudioSubLabel audioSubLabel = (AudioSubLabel)AudioSubLabel.getGson().fromJson(json, AudioSubLabel.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(audioSubLabel.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        audioSubLabel.context = context;
        audioSubLabel.rawValue = json;
        audioSubLabel.header = header;
        return audioSubLabel;
    }

    public static APINodeList<AudioSubLabel> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AudioSubLabel> audioSubLabels = new APINodeList<AudioSubLabel>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        audioSubLabels.add(AudioSubLabel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return audioSubLabels;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            audioSubLabels.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        audioSubLabels.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            audioSubLabels.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            audioSubLabels.add(AudioSubLabel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                audioSubLabels.add(AudioSubLabel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            audioSubLabels.add(AudioSubLabel.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return audioSubLabels;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        audioSubLabels.add(AudioSubLabel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return audioSubLabels;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        audioSubLabels.add(AudioSubLabel.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return audioSubLabels;
                }
                audioSubLabels.clear();
                audioSubLabels.add(AudioSubLabel.loadJSON(json, context, header));
                return audioSubLabels;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AudioSubLabel.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldExpirationTimestamp() {
        return this.mExpirationTimestamp;
    }

    public String getFieldFlaggedTimestamp() {
        return this.mFlaggedTimestamp;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLabelName() {
        return this.mLabelName;
    }

    public String getFieldLastUpdateTimestamp() {
        return this.mLastUpdateTimestamp;
    }

    public Long getFieldNumAudioTracks() {
        return this.mNumAudioTracks;
    }

    public String getFieldState() {
        return this.mState;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AudioSubLabel copyFrom(AudioSubLabel instance) {
        this.mExpirationTimestamp = instance.mExpirationTimestamp;
        this.mFlaggedTimestamp = instance.mFlaggedTimestamp;
        this.mId = instance.mId;
        this.mLabelName = instance.mLabelName;
        this.mLastUpdateTimestamp = instance.mLastUpdateTimestamp;
        this.mNumAudioTracks = instance.mNumAudioTracks;
        this.mState = instance.mState;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AudioSubLabel> getParser() {
        return new APIRequest.ResponseParser<AudioSubLabel>(){

            @Override
            public APINodeList<AudioSubLabel> parseResponse(String response, APIContext context, APIRequest<AudioSubLabel> request, String header) throws APIException.MalformedResponseException {
                return AudioSubLabel.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<AudioSubLabel> {
        AudioSubLabel lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"expiration_timestamp", "flagged_timestamp", "id", "label_name", "last_update_timestamp", "num_audio_tracks", "state"};

        @Override
        public AudioSubLabel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AudioSubLabel parseResponse(String response, String header) throws APIException {
            return AudioSubLabel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AudioSubLabel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AudioSubLabel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AudioSubLabel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AudioSubLabel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AudioSubLabel>(){

                public AudioSubLabel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestExpirationTimestampField() {
            return this.requestExpirationTimestampField(true);
        }

        public APIRequestGet requestExpirationTimestampField(boolean value) {
            this.requestField("expiration_timestamp", value);
            return this;
        }

        public APIRequestGet requestFlaggedTimestampField() {
            return this.requestFlaggedTimestampField(true);
        }

        public APIRequestGet requestFlaggedTimestampField(boolean value) {
            this.requestField("flagged_timestamp", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLabelNameField() {
            return this.requestLabelNameField(true);
        }

        public APIRequestGet requestLabelNameField(boolean value) {
            this.requestField("label_name", value);
            return this;
        }

        public APIRequestGet requestLastUpdateTimestampField() {
            return this.requestLastUpdateTimestampField(true);
        }

        public APIRequestGet requestLastUpdateTimestampField(boolean value) {
            this.requestField("last_update_timestamp", value);
            return this;
        }

        public APIRequestGet requestNumAudioTracksField() {
            return this.requestNumAudioTracksField(true);
        }

        public APIRequestGet requestNumAudioTracksField(boolean value) {
            this.requestField("num_audio_tracks", value);
            return this;
        }

        public APIRequestGet requestStateField() {
            return this.requestStateField(true);
        }

        public APIRequestGet requestStateField(boolean value) {
            this.requestField("state", value);
            return this;
        }
    }
}

